<?php

/**
|--------------------------------------------------------------------------
 * 订单扣费
|--------------------------------------------------------------------------
| 派单的时候扣运营商（开店铺的填写订单）的，完成的时候扣经销商（地区代理，施工）
 */

namespace App\Services;

use App\Factory\OrderFactory;
use App\Models\Admin;
use App\Models\AdminInfor;
use App\Models\AdminToken;
use App\Models\AdminCertificate;
use App\Models\Certification;
use App\Models\ScoresSend;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class OrderDeductionFeeService extends Service
{
    public  static $instance;
    public  $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new Admin();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 订单扣费
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-10
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function deductFee($data) {
        $find_recharge_order = DB::table('recharge_order')
            ->where('reo_order_number', $data['order_number'])
            ->where('reo_pay_state', 1)
            ->first();
        if (!empty($find_recharge_order)) {
            return ['code'=>200, 'msg'=>'操作成功'];
        }
        $find_company_info = DB::table('company')
            ->where('com_id', $data['company_id'])
            ->first();
        $find_balance = DB::table('admin_recharge')
            ->where('adre_company_id', $data['company_id'])
            ->first();
        $add_dfee['reo_adm_id'] = $data['adm_id'];
        $add_dfee['reo_company_id'] = $data['company_id'];
        $add_dfee['reo_order_number'] = $data['order_number'];
        $add_dfee['reo_price'] = $data['reo_price'];
        $add_dfee['reo_pay_state'] = 2;
        $add_dfee['reo_state'] = 1;
        $add_dfee['reo_create_time'] = date('Y-m-d H:i:s');
        $add_dfee['reo_pay_time'] = date('Y-m-d H:i:s');
        $add_dfee['reo_pay_way'] = $data['reo_pay_way'];//4派单扣费 5电话通知扣费
        $add_dfee['reo_type'] = 2;
        $add_dfee['reo_client_type'] = $find_company_info['com_type'];//公司类型
        $update['adre_banlance'] = $find_balance['adre_banlance'] + $data['reo_price'];
        if (($update['adre_banlance'] + $find_balance['adre_credit_limit']) <= 0 && (!isset($data['pay_type']) || $data['pay_type']!=1)) {
            return ['code'=>501, 'msg'=>'余额不足，请充值'];
        }

        $add_res = DB::table('recharge_order')->insertGetId($add_dfee);
        $update_res = DB::table('admin_recharge')
            ->where('adre_id', $find_balance['adre_id'])
            ->increment('adre_banlance',$data['reo_price']);
        if ($add_res && $update_res) {
            return ['code'=>200, 'msg'=>'操作成功'];
        }
    }

    /**
     * 插入新的数据获取ID值
     * @param array $adminData
     *
     * @return int $id
     */
    public static function insertData(array $adminData) {

        return Admin::insertGetId($adminData);
    }

    /**
     * 插入新的数据获取ID值
     * @param array $adminData
     *
     * @return int $id
     */
    public static function insertAdminInfo(array $adminData) {

        return AdminInfor::insertGetId($adminData);
    }

    /**
     * 插入新的数据获取ID值
     * @param array $scoresSend
     *
     * @return int $id
     */
    public static function insertScoresSend(array $scoresSend) {

        return ScoresSend::insertGetId($scoresSend);
    }
    /**
     * 插入新的数据获取ID值
     * @param array $scoresSend
     *
     * @return int $id
     */
    public static function insertCertification(array $certification) {

        return Certification::insertGetId($certification);
    }

    /**
     * 获取订单列表
     * @param array $params
     * @param array $columns
     * @return array|mixed
     */
    public static function getAdmins($params, $columns = ['id', 'company_name'])
    {
        $db = new Admin();
        return CommonService::getMysqlData($db, $params,$columns,['id'=>'desc']);
    }

    /**获取admin详细内容
     *
     * @param int $ID ID
     *
     * @return array|mixed
     */
    public function getAdminByID($ID)
    {
        return Admin::where('id',$ID)->first();
    }

    /**获取admin详细内容
     *
     * @param  $key
     * @param  $value
     * @param  $select
     * @param string $type
     *
     * @return mixed
     */
    public static function getAdminBy($key, $value, $select = [] , $type = 'get')
    {
        $db = new Admin();
        if(in_array($key, ['id'])) {
            $type = 'first';
        }
        if($type == 'first') {
            if (count($select) == 1) {
                $type = 'value';
            }
        }
        $list = CommonService::getMysqlData($db,[$key=>$value],$select,[],$type);
        return $list;
    }


}
