<?php

namespace App\Services\Api\MobileWeb;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\DB;
use BlueCity\Core\Inc\ErrorInc;
use App\Models\{Orders, InstallPerson};
use App\Services\{BmmcService, Api\OrderManage\OrdersVehicleService};
use App\Services\Api\Common\{CommonService};

class OrderListService extends Model
{
    // 列表查询
    public static function index($request, $show_count = 10)
    {
        if (!isset($request['user_type'])) {
            $request['user_type'] = 1;
        }
        // 查询列表
        $list_data = DB::table('order_list as ol')
            ->leftJoin('user as u', 'ol.customer_id', '=', 'u.id')
            ->where('ser_id', $request['admin_id']) //服务商id
            ->where('is_delete', 1) //是否删除:1正常2删除
            ->where(function ($query) use ($request) {
                // 安装人员
                if (!empty($request['install_id']) && $request['user_type'] == 1) {
                    $query->where('install_id', $request['install_id']);
                }
                // 状态
                if (!empty($request['stauas'])) {
                    $query->where('stauas', $request['stauas']);
                }
                // 技师服务状态：0未派单1未接单2已接单3已拒单4已检验5安装中5已安装完成
                if (!empty($request['service_state'])) {
                    $query->where('service_state', $request['service_state']);
                }
            })
            ->select('ol.id', 'ol.sys_num', 'order_num', 'serial_number', 'p_id', 'stauas', 'service_state', 'intall_person', 'intall_phone', 'lock_state', 'negotiated_price as orli_actual_price', 'crma_id', 'reminder_count', 'ol.create_time', 'shr_name', 'shr_phone', 'shr_sheng', 'shr_shi', 'shr_xian', 'shr_adress')
            ->orderby('ol.id', 'desc')
            ->paginate($show_count);
        $page['count'] = 0;
        $page['page'] = 0;
        $page['page_size'] = $show_count;
        $page['allPage'] = 0;
        $data['list'] = [];
        $data['page'] = $page;

        // "id" => 268
        // "sys_num" => "L20221109141636789"
        // "order_num" => "L20221109141636789"
        // "serial_number" => "GF20221109141752278"
        // "p_id" => 1
        // "stauas" => 1
        // "service_state" => 1
        // "intall_person" => ""
        // "intall_phone" => ""
        // "lock_state" => 1
        // "orli_actual_price" => "5000.00"  negotiated_price
        // "crma_id" => 6
        // "reminder_count" => 0  //催单次数
        // "create_time" => "2022-11-09 14:17:52"
        // "shr_name" => "121"
        // "shr_phone" => "12711112222"
        // "shr_sheng" => "黑龙江"
        // "shr_shi" => "齐齐哈尔市"
        // "shr_xian" => "铁锋区"
        // "shr_adress" => "22211"

        $list_items = $list_data->items();
        if ($list_items) {
            $list_items = objectToArray($list_items);
            // dd($list_items);
            $p_id = array_unique(array_column($list_items, 'p_id')); //来源id
            $crma_id = array_unique(array_column($list_items, 'crma_id')); //施工工艺id
            $orli_id = array_unique(array_column($list_items, 'id')); //工单id

            // 查询平台信息
            $find_pt_data = DB::table('pt')
                ->whereIn('id', $p_id)
                ->pluck('pt_name', 'id')->toArray();
            // 查询施工工艺信息
            $find_craft_data = DB::table('craft_manage')
                ->whereIn('crma_id', $crma_id)
                ->pluck('crma_name', 'crma_id')->toArray();
            // 查询接单时间数据
            $find_receive_duration = DB::table('order_list_details')
                ->whereIn('orli_id', $orli_id)
                ->pluck('receive_duration', 'orli_id')->toArray();
            foreach ($list_items as $key => $value) {
                // 业务来源
                if (isset($find_pt_data[$value['p_id']])) {
                    $list_items[$key]['pt_name'] = $find_pt_data[$value['p_id']];
                } else {
                    $list_items[$key]['pt_name'] = '';
                }
                if (isset($find_craft_data[$value['crma_id']])) {
                    $list_items[$key]['crma_name'] = $find_craft_data[$value['crma_id']];
                } else {
                    $list_items[$key]['crma_name'] = '';
                }
                if (isset($find_receive_duration[$value['id']])) {
                    $list_items[$key]['time_consuming'] = $find_receive_duration[$value['id']];
                } else {
                    $list_items[$key]['time_consuming'] = '';
                }
                // 获取第一个字符
                $mb_first = mb_substr($value['shr_name'], 0, 1, 'utf-8');
                $list_items[$key]['first_name'] = $mb_first;

                $list_items[$key]['orders_vehicle'] = OrdersVehicleService::getOrderVehicle($value['sys_num']);
            }
            $page['count'] = $list_data->total(); //总数据个数
            $page['page'] = $list_data->currentPage(); //当前页面页码
            $page['page_size'] = $show_count; //一页显示多少个
            $page['allPage'] = $list_data->lastPage(); //表示最后一页的页码
            $data['list'] = $list_items;
            $data['page'] = $page;
        }

        // 查询施工的状态统计数据
        $state_count = DB::table('order_list')
            ->where('is_delete', 1)
            ->where('ser_id', $request['admin_id']) //服务商id
            ->where(function ($query) use ($request) {
                // 安装人员
                if (!empty($request['install_id']) && $request['user_type'] == 1) {
                    $query->where('install_id', $request['install_id']);
                }
            })
            ->select(DB::raw('count(*) as count, service_state as stauas'))
            ->groupBy('service_state')
            ->get()->toArray();
        $data['state_count'] = $state_count;

        // 查询接单的状态统计数据
        $stauas_count = DB::table('order_list')
            ->where('is_delete', 1)
            ->where('ser_id', $request['admin_id']) //服务商id
            ->where(function ($query) use ($request) {
                // 安装人员
                if (!empty($request['install_id']) && $request['user_type'] == 1) {
                    $query->where('install_id', $request['install_id']);
                }
            })
            ->select(DB::raw('count(*) as count, stauas'))
            ->groupBy('stauas')
            ->get()->toArray();
        $data['stauas_count'] = $stauas_count;
        if ($data['list']) {
            return ['ErrorCode' => 1, 'ErrorMessage' => '成功', 'Data' => $data];
        } else {
            return ['ErrorCode' => ErrorInc::DATA_EMPTY, 'ErrorMessage' => '暂无数据', 'Data' => $data];
        }
    }

    // 接单
    public static function receiving($request)
    {
        // 查询服务工单表信息
        $find_order = DB::table('order_list')->where('id', $request['id'])
            ->where('is_delete', 1)
            ->select('id', 'serial_number', 'sys_num', 'order_num', 'ord_id', 'stauas', 'lock_state', 'ser_id', 'p_id', 'seco_id', 'install_id', 'intall_person', 'intall_phone', 'customer_id', 'create_time', 'service_state', 'negotiated_price','company_id')
            ->first();
        // 判断是否已派单
        if (empty($find_order)) {
            return ['ErrorCode' => ErrorInc::DATA_EMPTY, 'ErrorMessage' => '未查询到订单', 'Data' => []];
        }
        $find_order = objectToArray($find_order);
        if ($find_order['service_state'] != 1) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单不是待接单状态！', 'Data' => []];
        }
        if ($find_order['lock_state'] != 1) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单已锁定，无法接单！', 'Data' => []];
        }
        $user_info = CommonService::webgetUserInfo($request['api_token']);
        // 查询安装人员信息
        $find_person = InstallPerson::where('id', $request['receive_install_id'])
            ->where('admin_id', $find_order['ser_id'])
            ->where('delet_y', 1)
            ->select('id', 'install_name', 'install_phone')
            ->first();
        if (empty($find_person)) {
            return ['ErrorCode' => ErrorInc::DATA_EMPTY, 'ErrorMessage' => '未查询到安装人员', 'Data' => []];
        }

        DB::beginTransaction();
        // 更改订单表信息
        $order_data['order_status'] = 7; //订单状态：5施工未接单（服务已派单）6施工已接单7施工中8施工完成
        $order_data['intall_id'] = $find_person['id']; //安装人员id
        $order_data['intall_person'] = $find_person['install_name']; //安装人员姓名
        $order_data['intall_phone'] = $find_person['install_phone']; //安装师傅电话
        $order_data['update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = Orders::where('id', $find_order['ord_id'])
            ->update($order_data);

        // 更改工单信息
        $service_data['stauas'] = 3; //1未接单2已接单【废弃】3安装中4完成待审核
        $service_data['service_state'] = 2; //技师服务状态：0未派单1未接单2已接单
        $service_data['install_id'] = $find_person['id']; //安装人员id
        $service_data['intall_person'] = $find_person['install_name']; //安装人
        $service_data['intall_phone'] = $find_person['install_phone']; //安装师傅电话
        $deor_res = DB::table('order_list')
            ->where('id', $request['id'])
            ->update($service_data);

        // 生成服务工单的结算数据
        $settlement_data['sys_num'] = $find_order['sys_num'];
        $settlement_data['order_num'] = $find_order['order_num'];
        $settlement_data['serial_number'] = $find_order['serial_number'];
        $settlement_data['list_id'] = $find_order['id'];
        // 服务工单结算单号
        // $wat_num = 'JF' . date("YmdHis") . str_pad(rand(0, 999), 3, '0', STR_PAD_LEFT);
        // $settlement_data['wat_num'] = $wat_num;
        $settlement_data['p_id'] = $find_order['p_id'];
        $settlement_data['ser_id'] = $find_order['ser_id'];
        $settlement_data['seco_id'] = $find_order['seco_id'];
        $settlement_data['installperson'] = $find_order['install_id'];
        $settlement_data['intall_person'] = $find_order['intall_person'];
        $settlement_data['intall_phone'] = $find_order['intall_phone'];
        $settlement_data['customer_id'] = $find_order['customer_id'];
        $settlement_data['lock_state'] = $find_order['lock_state'];
        $settlement_data['all_price'] = $find_order['negotiated_price'];
        $settlement_data['order_price'] = $find_order['negotiated_price'];
        $settlement_data['list_service_type'] = $service_data['stauas'];
        $settlement_data['company_id'] = $find_order['company_id'];
        $settlement_res = DB::table('settlement_list')->insertGetId($settlement_data);

        // 生成服务工单详情数据
        $now_time = date('Y-m-d H:i:s');
        $list_details['orli_receive_time'] = $now_time; //工单接单时间
        $diff_time = calculateTimeInterval($find_order['create_time'], $now_time);
        $list_details['receive_duration'] = $diff_time; //接单时长
        $list_details['update_time'] = $now_time;
        $orld_res = DB::table('order_list_details')
            ->where('orli_id', $request['id'])
            ->where('serial_number', $find_order['serial_number'])
            ->update($list_details);

        // 生成结算金额明细表
        $add_semo_data['sem_slid'] = $settlement_res; //结算信息id
        $add_semo_data['sem_synum'] = $find_order['sys_num']; //结算单系统单号
        // 根据单号查询订单的车辆信息表
        // $find_vein_id = DB::table('orders_vehicle')
        //     ->where('ord_id', $find_order['ord_id'])
        //     ->where('sys_num', $find_order['sys_num'])
        //     ->where('is_delete', 1)
        //     ->value('vein_id');
        // $find_ghpr_data = DB::table('gh_price')
        //     ->where('ghpr_vein_id', $find_vein_id)
        //     ->value('supply_price');
        // if ($find_ghpr_data) {
        //     $add_semo_data['sem_price'] = $find_ghpr_data; //结算金额
        // } else {
        //     $add_semo_data['sem_price'] = 0; //结算金额
        // }
        $add_semo_data['sem_price'] = $find_order['negotiated_price']; //结算金额
        $add_semo_data['sem_type'] = 1; //金额类型1：供货价；2接单奖励；3：接单惩罚；4：撤销补助；5：代收金额；6：待付金额；7：完成奖励；8：加急奖励；9：夜间奖励
        $add_semo_data['sem_creacter'] = $user_info->install_name; //金额添加人
        $add_semo_data['add_time'] = $now_time; //添加时间
        $add_semo_res = DB::table('settlement_money')->insert($add_semo_data);
        if ($ord_edit_res && $deor_res && $settlement_res && $orld_res && $add_semo_res) {
            timeLog($find_order['serial_number'], $find_order['order_num'], $user_info->install_name, "接单时间", date('Y-m-d H:i:s'));
            DB::commit();
            czrzLog("接单，", $find_order['serial_number'], "移动端-接单", "订单系统", request::ip(), $user_info->install_name);
            return ['ErrorCode' => 1, 'ErrorMessage' => '接单成功', 'Data' => []];
        } else {
            DB::rollback();
            return ['ErrorCode' => 500, 'ErrorMessage' => '接单失败', 'Data' => []];
        }
    }

    // 拒单
    public static function refuse($request)
    {
        // 查询工单表信息
        $find_design_order = DB::table('order_list')->where('id', $request['id'])
            ->where('is_delete', 1)
            ->select('id', 'serial_number', 'sys_num', 'order_num', 'ord_id', 'service_state', 'lock_state', 'ser_id', 'p_id')
            ->first();
        // 判断是否已派单
        if (empty($find_design_order)) {
            return ['ErrorCode' => ErrorInc::DATA_EMPTY, 'ErrorMessage' => '未查询到订单', 'Data' => []];
        }
        $find_design_order = objectToArray($find_design_order);
        if ($find_design_order['service_state'] == 0) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单未派单！', 'Data' => []];
        }
        if ($find_design_order['service_state'] > 1) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单已接单，无法拒单！', 'Data' => []];
        }
        if ($find_design_order['lock_state'] != 1) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单已锁定，无法拒单！', 'Data' => []];
        }

        // 根据订单id，查询工单是否有完成的
        $find_orli_data = DB::table('order_list')
            ->where('sys_num', $find_design_order['sys_num'])
            ->where('order_num', $find_design_order['order_num'])
            ->where('is_delete', 1)
            ->select('id', 'serial_number', 'sys_num', 'order_num', 'ord_id', 'stauas', 'lock_state', 'p_id', 'ser_id')
            ->get()->toArray();
        $find_orli_data = objectToArray($find_orli_data);
        foreach ($find_orli_data as $key => $value) {
            if ($value['stauas'] == 4) {
                return ['ErrorCode' => 500, 'ErrorMessage' => '有一个工单施工已完成，无法拒单', 'Data' => []];
            }
        }

        $user_info = CommonService::webgetUserInfo($request['api_token']);

        DB::beginTransaction();
        // 更改订单表信息
        $order_data['order_status'] = 4; //订单状态：4设计完成（服务未派单）5施工未接单（服务已派单）6施工已接单
        $order_data['ser_id'] = 0;
        $order_data['seco_id'] = 0;
        $order_data['intall_person'] = '';
        $order_data['intall_phone'] = '';
        $order_data['update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = Orders::where('id', $find_design_order['ord_id'])
            ->update($order_data);

        // 更改工单信息
        $service_data['stauas'] = 8; //工单状态：1未接单2已接单【废弃】3安装中4完成待审核5延期审图6延期结算7已完成8已拒单9已撤销
        $service_data['is_delete'] = 2; //是否删除：1正常2删除
        $service_data['service_state'] = 3; //技师服务状态：0未派单1未接单2已接单3已拒单
        $deor_res = DB::table('order_list')
            // ->where('id', $request['id'])
            ->where('sys_num', $find_design_order['sys_num'])
            ->update($service_data);

        // 新增拒单记录
        $orre_data['ors_order_num'] = $find_design_order['order_num'];
        $orre_data['ors_sys_num'] = $find_design_order['sys_num'];
        $orre_data['ors_serial_number'] = $find_design_order['serial_number'];
        $orre_data['ors_ser_id'] = $find_design_order['ser_id'];
        $orre_data['ors_pid'] = $find_design_order['p_id'];
        $orre_data['ors_year'] = date('Y');
        $orre_data['ors_month'] = date('m');
        $orre_data['ors_day'] = date('d');
        $orre_data['ors_type'] = 2; //拒单类型1设计公司拒单2服务公司拒单
        if ($find_design_order['service_state'] == 1) {
            $orre_data['ors_status'] = 1; //接单状态1接单前拒单2接单后拒单
        } else {
            $orre_data['ors_status'] = 2;

        }
        // 接单后才有结算数据，更改工单结算单数据
        $settlement_data['is_delete'] = 2;
        $settlement_data['update_time'] = date('Y-m-d H:i:s');
        $settlement_res = DB::table('settlement_list')
            ->where('serial_number', $find_design_order['serial_number'])
            ->update($settlement_data);
        $orre_data['ors_remarks'] = $request['remarks'];
        $orre_data['ors_adm_id'] = $request['admin_id'];
        $orre_res = DB::table('order_refused')->insert($orre_data);

        // 备注
        $remarks = '';
        if (Request::filled('remarks')) {
            $remarks = $request['remarks'];
            $rest = CommonService::accMe($find_design_order['sys_num'], '服务工单列表拒单', "拒单：" . $remarks, $find_design_order['serial_number'], '1', $user_info->admin_groupnew, $user_info->install_name, $user_info->admin_id); //添加备注

            if (!$rest) {
                DB::rollback();
                return ['ErrorCode' => 500, 'ErrorMessage' => '备注添加失败', 'Data' => []];
            }
        }

        if ($ord_edit_res && $deor_res && $orre_res) {
            DB::commit();
            czrzLog("拒单，", $find_design_order['serial_number'], "移动端技师拒单", "订单系统", request::ip(), $user_info->install_name);
            return ['ErrorCode' => 1, 'ErrorMessage' => '成功', 'Data' => []];
        } else {
            DB::rollback();
            return ['ErrorCode' => 500, 'ErrorMessage' => '失败', 'Data' => []];
        }
    }

    // 检验
    public static function inspect($request)
    {
        // 查询工单表信息
        $find_design_order = DB::table('order_list')->where('id', $request['id'])
            ->where('is_delete', 1)
            ->select('id', 'serial_number', 'sys_num', 'order_num', 'ord_id', 'service_state', 'lock_state', 'ser_id', 'p_id')
            ->first();
        // 判断是否已派单
        if (empty($find_design_order)) {
            return ['ErrorCode' => ErrorInc::DATA_EMPTY, 'ErrorMessage' => '未查询到订单', 'Data' => []];
        }
        $find_design_order = objectToArray($find_design_order);
        if ($find_design_order['service_state'] != 2) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单未接单，无法检验！', 'Data' => []];
        }
        if ($find_design_order['lock_state'] != 1) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单已锁定，无法拒单！', 'Data' => []];
        }
        $user_info = CommonService::webgetUserInfo($request['api_token']);

        DB::beginTransaction();
        // 更改工单信息
        $service_data['stauas'] = 3; //工单状态：1未接单2已接单3安装中
        $service_data['service_state'] = 4; //技师服务状态：0未派单1未接单2已接单(未检验)3已拒单4已检验5安装中6完成待审核
        $deor_res = DB::table('order_list')
            ->where('id', $request['id'])
            ->update($service_data);

        if ($deor_res) {
            DB::commit();
            // czrzLog("拒单，", $find_design_order['serial_number'], "移动端技师拒单", "订单系统", request::ip(), $user_info->install_name);
            timeLog($find_design_order['serial_number'], $find_design_order['order_num'], $user_info->install_name, "检验时间", date('Y-m-d H:i:s'));
            return ['ErrorCode' => 1, 'ErrorMessage' => '检验成功', 'Data' => []];
        } else {
            DB::rollback();
            return ['ErrorCode' => 500, 'ErrorMessage' => '失败', 'Data' => []];
        }
    }

    // 开始安装
    public static function startInstall($request)
    {
        // 查询工单表信息
        $find_design_order = DB::table('order_list')->where('id', $request['id'])
            ->where('is_delete', 1)
            ->select('id', 'serial_number', 'sys_num', 'order_num', 'ord_id', 'service_state', 'lock_state', 'ser_id', 'p_id')
            ->first();
        // 判断是否已派单
        if (empty($find_design_order)) {
            return ['ErrorCode' => ErrorInc::DATA_EMPTY, 'ErrorMessage' => '未查询到订单', 'Data' => []];
        }
        $find_design_order = objectToArray($find_design_order);
        if ($find_design_order['service_state'] != 4) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单未检验！', 'Data' => []];
        }
        if ($find_design_order['lock_state'] != 1) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单已锁定，无法拒单！', 'Data' => []];
        }
        $user_info = CommonService::webgetUserInfo($request['api_token']);

        DB::beginTransaction();
        // 更改工单信息
        $service_data['stauas'] = 3; //工单状态：1未接单2已接单3安装中
        $service_data['service_state'] = 5; //技师服务状态：0未派单1未接单2已接单3已拒单4已检验5安装中6已安装完成
        $deor_res = DB::table('order_list')
            ->where('id', $request['id'])
            ->update($service_data);
        if ($deor_res) {
            DB::commit();
            // czrzLog("拒单，", $find_design_order['serial_number'], "移动端技师拒单", "订单系统", request::ip(), $user_info->install_name);
            timeLog($find_design_order['serial_number'], $find_design_order['order_num'], $user_info->install_name, "开始安装", date('Y-m-d H:i:s'));
            return ['ErrorCode' => 1, 'ErrorMessage' => '已开始施工', 'Data' => []];
        } else {
            DB::rollback();
            return ['ErrorCode' => 500, 'ErrorMessage' => '开始施工失败', 'Data' => []];
        }
    }

    // 申请完成
    public static function installFeedback($request)
    {
        // 查询工单表信息
        $find_design_order = DB::table('order_list')
            ->where('id', $request['id'])
            ->where('is_delete', 1)
            ->select('id', 'serial_number', 'sys_num', 'order_num', 'ord_id', 'service_state', 'lock_state', 'ser_id', 'p_id')
            ->first();
        // 判断是否已派单
        if (empty($find_design_order)) {
            return ['ErrorCode' => ErrorInc::DATA_EMPTY, 'ErrorMessage' => '未查询到订单', 'Data' => []];
        }
        $find_design_order = objectToArray($find_design_order);
        if ($find_design_order['service_state'] != 5) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单未安装！', 'Data' => []];
        }
        if ($find_design_order['lock_state'] != 1) {
            return ['ErrorCode' => ErrorInc::BUSINESS_FORBID, 'ErrorMessage' => '当前工单已锁定，无法拒单！', 'Data' => []];
        }
        $user_info = CommonService::webgetUserInfo($request['api_token']);

        // 更改工单信息
        $service_data['stauas'] = 4; //工单状态：1未接单2已接单3安装中4待完成5已完成6已拒单7已撤销
        $service_data['service_state'] = 6; //技师服务状态：0未派单1未接单2已接单3已拒单4已检验5安装中6已安装完成
        $service_data['license_plate'] = $request['license_plate']; //车牌号
        $service_data['create_time'] = date('Y-m-d H:i:s');

        DB::beginTransaction();
        $order_data['order_status'] = 8;
        $order_data['update_time'] = date('Y-m-d H:i:s');
        // 更改订单信息
        $ord_res = DB::table('orders')
            ->where('id', $find_design_order['ord_id'])
            ->update($order_data);

        // 更改工单信息
        $deor_res = DB::table('order_list')
            ->where('id', $request['id'])
            ->update($service_data);
        // 查询成员账号信息表
        $find_adm_data = DB::table('admin')
            ->where('id', $request['admin_id'])
            ->select('admin_acc', 'company_name')
            ->first();
        $find_adm_data = objectToArray($find_adm_data);
        // 查询安装人员信息表
        $find_inpe_data = DB::table('install_person')
            ->where('admin_id', $request['admin_id'])
            ->where('delet_y', 1)
            ->select('install_name', 'install_phone')
            ->first();
        $find_inpe_data = objectToArray($find_inpe_data);

        // 如果是驳回重新上传，将之前的改为删除状态
        $feedback_id = DB::table('feedback')->where('gl_id', $request['id'])->value('id');
        if ($feedback_id) {
            $feedback_data['is_delete'] = 2;
            DB::table('feedback')->where('gl_id', $request['id'])->update($feedback_data);
        }
        // 安装反馈信息
        $template_data = json_decode($request['template_data'], true);
        foreach ($template_data as $key => $value) {
            $add_feed_data[$key]['type'] = $value['type']; //图片类型
            $add_feed_data[$key]['gl_id'] = $request['id']; //反馈关联id
            $add_feed_data[$key]['install_name'] = $find_inpe_data['install_name']; //安装人员姓名
            $add_feed_data[$key]['install_phone'] = $find_inpe_data['install_phone']; //安装电话
            $add_feed_data[$key]['install_remark'] = $value['install_remark']; //安装备注
            $add_feed_data[$key]['install_time'] = date('Y-m-d H:i:s'); //安装时间
            $add_feed_data[$key]['admin_id'] = $request['admin_id']; //所属服务中心id
            $add_feed_data[$key]['company_name'] = $find_adm_data['company_name']; //服务中心名称
            $add_feed_data[$key]['feedback_status'] = 2; //是否安装
            $add_feed_data[$key]['feedback_pic'] = $value['my_file']; //凭证图片
            $add_feed_data[$key]['sys_num'] = 'rwfk' . $request['id']; //所属服务中心id
            $add_feed_data[$key]['is_type'] = 2; //1微信2第三方
            $add_feed_data[$key]['type_name'] = $value['type_name']; //类型名称
        }
        $add_feed_id = DB::table('feedback')->insert($add_feed_data);
        // 更改服务工单结算表（gone_settlement_list）
        $seli_edit_data['list_service_type'] = $service_data['stauas']; //派工单状态：1未接单2已接单【废弃】3安装中4完成待审核5已完成6已拒单7已撤销8延期审图9延期结算
        $seli_edit_data['update_time'] = date('Y-m-d H:i:s'); //更新时间
        $seli_edit_res = DB::table('settlement_list')
            ->where('serial_number', $find_design_order['serial_number'])
            ->where('list_id', $request['id'])
            ->update($seli_edit_data);

        if ($deor_res && $add_feed_id && $ord_res) {
            DB::commit();
            // czrzLog("拒单，", $find_design_order['serial_number'], "移动端技师拒单", "订单系统", request::ip(), $user_info->install_name);
            timeLog($find_design_order['serial_number'], $find_design_order['order_num'], $user_info->install_name, "反馈时间", date('Y-m-d H:i:s'));
            return ['ErrorCode' => 1, 'ErrorMessage' => '施工申请完成', 'Data' => []];
        } else {
            DB::rollback();
            return ['ErrorCode' => 500, 'ErrorMessage' => '申请完成失败', 'Data' => []];
        }
    }

    // 获取反馈信息
    public static function getFeedback($request)
    {
        // 查询工单表信息
        $find_design_order = DB::table('order_list')
            ->where('id', $request['id'])
            ->where('is_delete', 1)
            ->select('id', 'serial_number', 'service_state', 'license_plate')
            ->first();
        // 判断是否已派单
        if (empty($find_design_order)) {
            return ['ErrorCode' => ErrorInc::DATA_EMPTY, 'ErrorMessage' => '未查询到订单', 'Data' => []];
        }
        // 查询反馈信息
        $list_data = DB::table('feedback')->where('gl_id', $request['id'])
            ->where('is_delete', 1)
            ->select('gl_id', 'feedback_pic', 'type_name')
            ->get()->toArray();
        if (empty($list_data)) {
            $temp_data['feedback_pic'] = config('apisystem.HTTP_URL') . 'image/icon/webapp_no_pictures.png';
            $temp_data['type_name'] = '暂无图片';
            $list_data[] = $temp_data;
        }
        $data['license_plate'] = $find_design_order->license_plate; //车牌号
        $data['list_data'] = $list_data;
        return ['ErrorCode' => 1, 'ErrorMessage' => '获取信息成功', 'Data' => $data];
    }

    // 详情
    public static function info($request)
    {
        // 查询工单表信息
        $find_orli_data = DB::table('order_list as ol')
            ->leftJoin('order_list_details as old', 'ol.ord_id', '=', 'old.orli_id')
            ->where('ol.id', $request['id'])
            ->where('is_delete', 1)
            ->select('ol.id', 'ol.serial_number', 'ol.sys_num', 'order_num', 'ord_id', 'service_state', 'customer_id', 'p_id', 'install_id', 'intall_person', 'intall_phone', 'crma_id', 'ol.create_time', 'negotiated_price as orli_actual_price', 'receive_duration as time_consuming')
            ->first();
        // 判断是否已派单
        if (empty($find_orli_data)) {
            return ['ErrorCode' => ErrorInc::DATA_EMPTY, 'ErrorMessage' => '未查询到订单', 'Data' => []];
        }
        $find_orli_data = objectToArray($find_orli_data);
        // 查询订单客户信息
        $user = DB::table('user')
            ->where('id', $find_orli_data['customer_id'])
            ->select('shr_name', 'shr_phone', 'shr_sheng', 'shr_shi', 'shr_xian', 'shr_adress')
            ->first();
        $user = objectToArray($user);
        if (isset($user)) {
            $find_orli_data = array_merge($user, $find_orli_data);
        }
        // 查询车辆信息
        $find_vehicle = OrdersVehicleService::getOrderVehicle($find_orli_data['sys_num']);
        $find_orli_data['orders_vehicle'] = $find_vehicle;

        // 查询贴装工艺
        $find_crma_data = DB::table('craft_manage')
            ->where('crma_id', $find_orli_data['crma_id'])
            ->select('crma_name')
            ->first();
        $find_crma_data = objectToArray($find_crma_data);
        if ($find_crma_data) {
            $find_orli_data['crma_name'] = $find_crma_data['crma_name']; //施工工艺名称
        } else {
            $find_orli_data['crma_name'] = ''; //施工工艺名称
        }
        // 查询设计图
        $find_deod_data = DB::table('design_order_detail')
            ->where('sys_num', $find_orli_data['sys_num']) //订单编号
            ->where('ord_id', $find_orli_data['ord_id']) //订单id
            ->where('audit_state', 2) //审核状态：1已提交2已通过3已驳回
            ->where('is_delete', 1) //是否删除：1正常2删除
            ->select('sys_num', 'design_drawing')
            ->get()->toArray();
        $find_orli_data['design_order_detail'] = $find_deod_data;
        // 查询备注
        $find_note = DB::table('note')
            ->where('orders_id', $find_orli_data['sys_num'])
            ->where('is_delet', 1)
            ->select('note_content', 'note_type', 'note_time', 'note_name')
            ->orderBy('note_time', 'desc')
            ->get()->toArray();
        $find_note = objectToArray($find_note);
        $find_orli_data['orders_note'] = $find_note;
        unset($find_orli_data['crma_id']);
        return ['ErrorCode' => 1, 'ErrorMessage' => '获取成功', 'Data' => $find_orli_data];
    }

    // 获取技师
    public static function getInstallPerson($request)
    {
        // 查询工单表信息
        $find_inpe_data = InstallPerson::where('delet_y', 1)
            ->where('admin_id', $request['admin_id'])
            ->where('install_is_type', 1) //状态：1启用2停用
            ->where(function ($query) use ($request) {
                if (!empty($request['install_name'])) {
                    $query->where('check_code', 'like', '%' . $request['install_name'] . '%')
                        ->orWhere('install_name', 'like', '%' . $request['install_name'] . '%');
                }
            })
            ->select('id', 'check_code', 'install_name')
            ->get()->toArray();
        return ['ErrorCode' => 1, 'ErrorMessage' => '获取成功', 'Data' => $find_inpe_data];
    }

    // 获取标签
    public static function getLabel($request)
    {
        // 查询工单表信息
        $find_sety_data = DB::table('setmoney_type')
            ->where('lt_parent_id', 694)
            ->where('lt_statues', 1)
            ->where(function ($query) use ($request) {
                if (!empty($request['sety_name'])) {
                    $query->where('sety_name', 'like', '%' . $request['sety_name'] . '%');
                }
            })
            ->select('sety_id', 'sety_name')
            ->get()->toArray();
        return ['ErrorCode' => 1, 'ErrorMessage' => '获取成功', 'Data' => $find_sety_data];
    }

    // 获取操作记录
    public static function operatingRecord($request)
    {
        // 查询操作表信息
        $find_data = DB::table('order_time')
            ->where('serial_number', $request['serial_number'])
            ->select('create_time', 'is_type')
            ->orderby('id', 'desc')
            ->get()->toArray();
        return ['ErrorCode' => 1, 'ErrorMessage' => '获取成功', 'Data' => $find_data];
    }
}
