<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SettlementList extends Model
{
    //指定表名
    protected $table = 'settlement_list';
    // 拒绝添加的字段
    protected $guarded = [];
    public $timestamps = false;

    public function ordermsg(){
        return $this->hasOne(OrderMsg::class,'id','msg_id')->select('id','goods_price','goods_id','goods_name','goods_number','goods_service','goods_num');
    }
    public function pt(){
        return $this->hasOne(Pt::class,'id','p_id')->select('id','pt_name');
    }
    public function user(){
        return $this->hasOne(User::class,'id','customer_id')->select('id','shr_name','shr_phone','shr_sheng','shr_shi','shr_xian','shr_adress');
    }
    public function admin(){
        return $this->hasOne(Admin::class,'id','ser_id')->select('id','company_name','mouth_pay');
    }
}
