<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
        Commands\GetJdOrder::class,
        Commands\GetJdSelfOrder::class,
        Commands\GetJdSelfRefund::class,
        Commands\GetJdSelfShhOrder::class,
        Commands\DeductionFee::class
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')
        //          ->hourly();
        $schedule->command('getOrder')->everyFiveMinutes();//每五分钟执行一次
        $schedule->command('decJdOrder')->everyFiveMinutes();//每五分钟执行一次
        $schedule->command('getJdSelfOrder')->everyFiveMinutes();//每五分钟执行一次
//        $schedule->command('getJdSelfRefund')->everyFiveMinutes();//每五分钟执行一次
        $schedule->command('GetJdSelfShhOrder')->everyFiveMinutes();//每五分钟执行一次
        $schedule->command('DeductionFee')->everyFiveMinutes();//每三十分钟执行一次  everyThirtyMinutes
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
