<?php

namespace App\Services;
use App\Http\Controllers\BaseController;
use App\Models\AdminInfor;
use App\Models\Orders;
use App\Models\OrderTime;
use App\Models\SerInfor;
use App\Models\SettlementList;
use App\Models\SettlementMoney;
use App\Models\SyncStores;
use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Service\Service;
use DB;
use App\Models\Pt;
use App\Models\SetmoneyType;
use App\Models\OrderList;
use App\Models\Admin;
use PhpParser\Builder\Use_;
use App\Models\User;
use App\Models\OrderMsg;

class SerInforService extends Service
{
    //private static $instance;
    private $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new SerInfor();
    }

    /**
     * 添加催单
     * @param  $sin_type
     * @param  $admin_acc
     * @param  $sin_creactid
     * @param  $sin_ordernum
     * @param  $sin_sysnum
     * @param  $sin_serial
     * @param  $sin_state
     * @param  $sin_urgetype
     * @param  $creact_centent
     * @param  $sin_num
     * @author du 2021年8月7日上午11:15:12
     */
    public static function createSerInfor($sin_type,$admin_acc,$sin_serid = 0,$sin_creactid,$sin_ordernum,$sin_sysnum,$sin_serial = '',$sin_state,$sin_urgetype,$creact_centent,$sin_num = 1,$company_id=1)
    {
        $ser_data['sin_type'] = $sin_type;
        $ser_data['sin_creacter'] = $admin_acc;
        $ser_data['sin_serid'] = $sin_serid;
        $ser_data['sin_creactid'] = $sin_creactid;
        $ser_data['sin_creactime'] = date('Y-m-d H:i:s');
        $ser_data['sin_ordernum'] = $sin_ordernum;
        $ser_data['sin_sysnum'] = $sin_sysnum;
        $ser_data['sin_serial'] = $sin_serial;
        $ser_data['sin_state'] = $sin_state;
        $ser_data['sin_urgetype'] = $sin_urgetype;
        $ser_data['creact_centent'] = $creact_centent;
        $ser_data['sin_num'] = $sin_num;
        $ser_data['company_id'] = $company_id;
        $res = SerInfor::insertGetId($ser_data);
        return $res;
    }
    /**
     * 获取催单信息
     * @param string $key 查询键
     * @param string $value 查询值
     * @param string $select 查询条件
     * @param string $type 查询类型
     * @return unknown|boolean
     * @author du 2021年8月9日上午8:52:39
     */
    public static function getInfoByKeyValue($key , $value , $select = [] , $type = 'get')
    {
        $db = new SerInfor();
        $list = CommonService::getMysqlData($db,[$key=>$value,'sin_type'=>'1'],$select,[],$type);
        if($list && in_array('sin_state', $select)){
            $state = self::getStateName(true);
            foreach($list as $k => $v){
                $list[$k]['statename'] = $state[$v['sin_state']];
            }
        }
        return $list;
    }


    /**
     * 获取催单列表
     * @param array $input
     * @param array $session
     * @return Ambigous <multitype:, unknown, multitype:unknown NULL >
     * @author du 2021年8月7日下午3:39:38
     */
    public static function getSerList($input,$session){
    	$admin_pt_id = $session['admin_pt_id'];//获取当前用户可查看平台权限
    	$where = [];
    	$where['is_delete'] = 2;//默认获取生效订单
        if(!in_array($session['admin_groupnew'],[7,8])){
            $where['p_id_searchin'] = trim($admin_pt_id);
        }
    	//$where['p_id_searchin'] = trim($admin_pt_id);

    	$where['sin_type'] = 1;
    	$where['reminder'] = 1;
    	$where['p_id_notin'] = "50,55";
        if ($session['admin_groupnew'] != 7) {//管理员可以看全部
            $where['gone_orders.company_id'] = $session['company_id'];
        }

    	$Db = SerInfor::join('orders','orders.sys_num','=','ser_infor.sin_sysnum')->leftJoin('user','user.id','=','orders.customer_id');
    	if ($input['sin_state']){
    		$where['sin_state'] = $input['sin_state'];
    		$where['order_status_searchlt'] = 34;
    	}
    	if (isset($input['order_num'])){//平台单号
    		$where['sin_ordernum_like'] = $input['order_num'];
    	}
    	if (isset($input['order_status'])){//订单状态
    		$where['order_status'] = $input['order_status'];
    	}
    	if (isset($input['shr_name'])){//客户姓名
    		$where['shr_name_like'] = $input['shr_name'];
    	}
    	if (isset($input['shr_phone'])){//客户电话
    		$where['shr_phone_like'] = $input['shr_phone'];
    	}

    	if (isset($input['ser_id'])){//服务商id
    		$where['ser_id'] = $input['ser_id'];
    	}

    	if (isset($input['sin_num'])){//催单次数
    		if ($input['sin_num'] == 1 || $input['sin_num'] == 2) {
    			$where['sin_num'] = $input['sin_num'];
    		} elseif ($input['sin_num'] == 3) {
    			$where['sin_num_searcheqgt'] = $input['sin_num'];
    		}
    	}

    	if (isset($input['datatime'])){//开始时间
    		$input['datatime'][1] = date("Y-m-d", strtotime($input['datatime'][1] . " +1 day"));
    		$where['sin_creactime_between'] = $input['datatime'];
    	}
    	$where = CommonService::jointWhere($where);
    	$page_size = $input['page_size']??10;

       /* if($input['is_excel']==1){
            DB::connection()->enableQueryLog();#开启执行日志
        }*/
       // DB::connection()->enableQueryLog();#开启执行日志
    	$paginate = $Db->whereRaw($where)->select('ser_infor.sin_id','ser_infor.sin_num','ser_infor.sin_type','ser_infor.sin_creacter','ser_infor.sin_serid','ser_infor.sin_creactid','ser_infor.sin_creactime','ser_infor.sin_ordernum','ser_infor.sin_sysnum','ser_infor.sin_serial','ser_infor.sin_bid','ser_infor.sin_centent','ser_infor.creact_centent','ser_infor.sin_dealtime','ser_infor.sin_state','ser_infor.sin_lastime','ser_infor.sin_dealer','ser_infor.sin_urgetype','orders.p_id','orders.ser_type','orders.order_status','orders.customer_id','orders.new_customer_id','orders.order_account','orders.new_money','orders.handled_by','orders.reminder','orders.create_time','orders.kef_id','orders.order_type','orders.pay_type','user.shr_name','user.shr_phone','user.shr_sheng','user.shr_shi','user.shr_xian','user.shr_adress')->orderBy('sin_creactime','ASC')->paginate($page_size);
    	//print_r(DB::getQueryLog());

        //导出所需语句
       // $data['sqls'] = DB::getQueryLog()[1];
        $where1['sin_state_searchin'] = [1,2,3];
        if(!in_array($session['admin_groupnew'],[7,8])){
            $where1['p_id_searchin'] = trim($admin_pt_id);
        }

        if($session['admin_groupnew']!=7){
            $where1['gone_orders.company_id'] = $session['company_id'];
        }
        $where1 = CommonService::jointWhere($where1);
    	$countNum = SerInfor::join('orders','orders.sys_num','=','ser_infor.sin_sysnum')->leftJoin('user','user.id','=','orders.customer_id')
			    	//->whereIn('p_id',explode(',',trim($admin_pt_id)))
			    	->where('orders.order_status','<',34)
                    ->whereRaw($where1)
			    	//->whereIn('sin_state',[1,2,3])
			    	->selectRaw("sin_state,count('sin_id') as num")
			    	->groupBy('sin_state')->get()->toArray();
        if($countNum) {
            foreach ($countNum as $k => $v) {
                if ($v['sin_state'] == 1) {
                    $state1 = $v['num'];
                }
                if ($v['sin_state'] == 2) {
                    $state2 = $v['num'];
                }
                if ($v['sin_state'] == 3) {
                    $state3 = $v['num'];
                }
            }
        }

    	$show_Menu = [
    			['show_name'=>"全部",'show_num'=>'--'],
    			['show_name'=>"未处理",'status'=>1,'show_num'=>$state1??0],
    			['show_name'=>"已处理",'status'=>2,'show_num'=>$state2??0],
    			['show_name'=>"已审核",'status'=>3,'show_num'=>$state3??0],
    	];
    	$data['show_Menu'] = $show_Menu;//顶部按钮

    	$all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
    	$export = BmmcService::getTopButton('reminderSort','',$all_button);
    	$data['button_top'] = $export['button_top']??[];//顶部按钮
    	$data['button_search'] = $export['button_search']??[];//搜索栏按钮
    	$list = CommonService::dataToArray($paginate->items());
    	if($list){
    		$list = SerInforService::getButtonDatas($all_button, $list);
    		$data['list'] = $list;
    		$data['page'] = [
    				'count' => $paginate->total(),
    				'page'=>$paginate->currentPage(),
    				'page_size'=>$page_size,
    				'allPage'=>$paginate->lastPage()
    		];
    	}else{
    		$data['list'] = [];
    	}
    	return $data;
    }
    /**
     * 获取按钮和数据
     * @param array $all_button
     * @param array $list
     * @return string
     * @author du 2021年8月7日下午3:40:48
     */
    public static function getButtonDatas($all_button,$list){
    	$kfs = DB::table('kefu')->pluck('kf_name','kf_id');
    	$pt = Pt::pluck('pt_name','id');
    	$sety = SetmoneyType::pluck('sety_name','sety_id');
    	$order_status_name = OrderService::getOrderStatusName();//获取订单状态数组
    	$goodpic = PjBrandsService::getAllPic('name');

    	foreach ($list as $k => $v){
            $buttonData = [];
    		if ($v['sin_state'] == 1 && $v['order_status']<34){
    			$buttonData[] = 'rOrder';
    		}elseif ($v['sin_state'] == 2 && $v['order_status']<34){
    			$buttonData[] = 'reminder';
    		}
    		$buttonData[] = 'AddRemarks,sendSmsSerInfoModel';
    		$button = BmmcService::getListButton($buttonData,$all_button);
    		$list[$k]['button_one'] = $button['button_one']??[];
    		$list[$k]['button_two'] = $button['button_two']??[];
    		$list[$k]['button_three'] = $button['button_three']??[];
    		$list[$k]['order_status_name'] = $order_status_name[$v['order_status']]??'未确认';
    		if (isset($kfs[$v['kef_id']])){
    			$list[$k]['kf_name'] = $kfs[$v['kef_id']];
    		}else{
    			$list[$k]['kf_name'] = " ";
    		}
    		$list[$k]['sys_num'] = $v['sin_sysnum'];
    		$list[$k]['id'] = $v['sin_id'];
    		$creater = OrderList::where('sys_num',$v['sin_sysnum'])->value('creater');
    		if(isset($creater)){
    			$list[$k]['creater'] = $creater;
    		}else{
    			$list[$k]['creater'] = "暂无";
    		}
    		if (isset($pt[$v['p_id']])){
    			$list[$k]['pt_name'] = $pt[$v['p_id']];
    		}else{
    			$list[$k]['pt_name'] = "暂无";
    		}
    		if (isset($sety[$v['sin_urgetype']])){
    			$list[$k]['sety_name'] = $sety[$v['sin_urgetype']];
    		}else{
    			$list[$k]['sety_name'] = '';
    		}
    		$company_name = Admin::where('id',$v['sin_serid'])->value('company_name');
    		$list[$k]['company_name'] = $company_name??'';
    		if($v['new_customer_id']!=$v['customer_id']){
    			//当订单联系人不等于安装联系人
    			$userModel = new User();
    			$userParams = ['id'=>$v['new_customer_id']];
    			$userSelect = ['shr_name','shr_phone','shr_sheng','shr_shi','shr_xian','shr_adress'];
    			$user_lse = CommonService::getMysqlData($userModel, $userParams,$userSelect,[],'first');
    			if(!empty($user_lse)){
    				$list[$k]['shr_name_new'] = $user_lse['shr_name'];
    				//安装联系人
    				$list[$k]['shr_phone_new'] = $user_lse['shr_phone'];
    				//安装联系人手机
    				if($user_lse['shr_sheng']!="省份"){
    					$list[$k]['shr_sheng_new'] = $user_lse['shr_sheng'];
    				}if($user_lse['shr_shi']!="地级市"){
    					$list[$k]['shr_shi_new'] = $user_lse['shr_shi'];
    				}if($user_lse['shr_xian']!="市、县级市"){
    					$list[$k]['shr_xian_new'] = $user_lse['shr_xian'];
    				}
    				$list[$k]['shr_adress_new'] = $user_lse['shr_adress'];
    				$list[$k]['new_address_type'] = 1;
    			}else{
    				$list[$k]['new_address_type'] = 2;//不展示新地址
    			}
    		}else{
    			$list[$k]['new_address_type'] = 2;//不展示新地址
    		}
    		//DB::connection()->enableQueryLog();#
         	$list[$k]['ordermsg'] = OrderService::getOrderMsg($v['sin_sysnum'],$goodpic)['orderMsgArr'];
         	//print_r(DB::getQueryLog());
    		if(substr($v['order_account'],-3)==".00"){
    		}else{
    			$list[$k]['order_account'] = $v['order_account'].".00";
    		}
    		// 实收金额
    		if(substr($v['new_money'],-3)==".00"){
    		}else{
    			$list[$k]['new_money'] = $v['new_money'].".00";
    		}

    		if ($v['sin_num'] == 1) {
    			$list[$k]['reminder_num'] = "一次催单";
    		} elseif ($v['sin_num'] == 2) {
    			$list[$k]['reminder_num'] = "二次催单";
    		} elseif ($v['sin_num'] >= 3) {
    			$list[$k]['reminder_num'] = "多次催单";
    		}

    	}

    	return $list;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取催单状态
     * @retrun /multitype:array
     * @author dou 2021/10/14 16:03
     * |---------------------------------------------------------------------------------
    */
    public static function getStateName ( $key = false ){
        $data = array(array('type'=>'1','name'=>'未处理'),array('type'=>'2','name'=>'已处理'),array('type'=>'3','name'=>'已审核'));
        if($key){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取单条件下的催单信息
     * @param  $key  查询键
     * @param  $value  查询值
     * @param  $select 查询字段
     * @param string $type 查询类型
     * @retrun /multitype:array
     * @author dou 2021/10/19 19:28
     * |---------------------------------------------------------------------------------
    */
    public static function getSerInforBy ( $key , $value , $select = [] , $type = 'get' ){
        $db = new SerInfor();
        if($key == 'sin_id'){
            $type = 'first';
        }
        if($type == 'first') {
            if (count($select) == 1) {
                $type = 'value';
            }
        }
        $list = CommonService::getMysqlData($db,[$key=>$value],$select,[],$type);
        return $list;
    }

    /**
     * @param $input
     * @param $session
     * @return array|int[]
     * @author du
     * @date 2022/1/4
     */
    public static function remind($input,$session,$ip){
        $BaseController = new BaseController();
        $checkKey = CommonService::checkKey(['sys_num', 'order_num', 'ser_id' ,'reminder','content'],$input,self::rules());
        if($checkKey['code']!=1){
            return ['Data' => [], 'ErrorMessage' =>'参数'.$checkKey['data'].'未填写,或值为空', 'ErrorCode' => ErrorInc::INVALID_PARAM];exit;
           // return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);
        }
        $p_id = OrderService::getOrderBy('sys_num', $input['sys_num'],['p_id']);
        $orderListArr = OrderListService::getOrderListBy('sys_num', $input['sys_num'],'first');
        /*--------------------------------------------判定接单时间是否合格开始---------------------------------------------------*/
        $settlement_list = SettlementService::getSettlementListBy('list_id', $orderListArr['serial_number'],['create_time']);
        if (!$settlement_list) {
            if (time() < (strtotime($settlement_list['create_time']) + (60 * 15))) {
                return ['Data' => [], 'ErrorMessage' =>'催单失败！距离接单未超过15分钟', 'ErrorCode' => ErrorInc::REQUEST_FORBIDDEN];exit;
            }
        }
        /*--------------------------------------------判定接单时间是否合格结束---------------------------------------------------*/
        $start = '09:00:00';
        $end = '18:00:00';
        /*--------------------------------------------判定催单时间是否合格开始---------------------------------------------------*/
        $list = SerInforService::getInfoByKeyValue('sin_sysnum', $input['sys_num'] , ['sin_creactime']);
        $count = 0;
        $sin_num = 1;
        if($list) {
            $sin_num = count($list)+1;
            $sin_creactime = [];
            foreach ($list as $key => $value) {
                $time = explode(' ', $value['sin_creactime'])[1];
                if ($time > $start && $time < $end) {
                    $count++;
                }
                $sin_creactime[] = $value['sin_creactime'];
            }
            array_multisort($sin_creactime, SORT_NUMERIC, SORT_DESC, $list);
            if (!empty($list[0]['sin_creactime']) && time() < (strtotime($list[0]['sin_creactime']) + (60 * 15))) {
                return ['Data' => [], 'ErrorMessage' =>'催单失败！距离上次催单未超过15分钟', 'ErrorCode' => ErrorInc::REQUEST_FORBIDDEN];exit;
            }
        }
        /*--------------------------------------------判定催单时间是否合格结束---------------------------------------------------*/
        DB::beginTransaction();//开启事务
        $data['reminder'] = 1;
        $resultOrder = Orders::where('sys_num', $input['sys_num'])->update($data);
        $resultOrderList = OrderList::where('sys_num', $input['sys_num'])->update($data);
        $noteRes = CommonService::accMe($input['sys_num'], '催单备注', $input['content'], $orderListArr['serial_number'], 2, $session['admin_groupnew'], $session['admin_acc'], $session['id']);
        if(!$noteRes){
            DB::rollback();
            return ['Data' => [], 'ErrorMessage' =>'催单备注添加失败，请联系管理员或从新提交', 'ErrorCode' => ErrorInc::MYSQL_FAILED];exit;
        }else{
            /*----------------------------------------判定当前催单次数对应标签开始------------------------------------------------*/
            if ($count == 1) {
                $atype = 23;
            } else if ($count == 2 || $count > 2) {
                $atype = 24;
            } else {
                $count = OrderTime::whereRaw("(`serial_number`='" . $orderListArr['serial_number'] . "' or serial_number='" . $input['sys_num'] . "') and `is_type`='催单时间'")->count();
                if ($count == 1) {
                    $atype = 23;
                } else if ($count == 2 || $count > 2) {
                    $atype = 24;
                } else {
                    $atype = 22;
                }
            }
            /*----------------------------------------判定当前催单次数对应标签结束------------------------------------------------*/
            /*---------------------------------------------判定是否需要添加/编辑催单处罚开始--------------------------------------------*/
//            $time1=date("Y-m-d")." ".$start;
//            $time2=date("Y-m-d")." ".$end;
            $time3 = date("H:i:s");
            if ($orderListArr && $time3>$start && $time3<$end) {
                if ($count <= 2) {
                    $sem_price = SettlementMoney::where(['sem_synum' => $input['sys_num'], 'sem_type' => $atype])->select('sem_slid','sem_id')->first();
                    $setmoneyInfo = SetmoneyType::whereRaw("sety_id=" . $atype)->value('sety_price');
                    if($setmoneyInfo>0){
                        $setmoneyInfo = 0-$setmoneyInfo;
                    }
                    if($sem_price) {
                        $sem_slid = $sem_price['sem_slid'];
                        $poss['sem_price'] = $setmoneyInfo;
                        $res = SettlementMoney::where(['sem_synum' => $input['sys_num'], 'sem_type' => $atype])->update($poss);
                    }else{
                        $sem_slid = SettlementList::where('sys_num', $input['sys_num'])->value('id');
                        if (!empty($sem_slid)) {
                            $poss['sem_slid'] = $sem_slid;
                            $poss['sem_synum'] = $input['sys_num'];
                            $poss['sem_price'] = $setmoneyInfo;
                            $poss['sem_creacter'] = $session['admin_acc'];
                            $poss['sem_type'] = $atype;
                            $poss['add_time'] = date("Y-m-d H:i:s");
                            $res = SettlementMoney::insert($poss);
                        }
                    }
                    if ($res) {
                        $all_price['all_price'] = SettlementMoney::where('sem_slid', $sem_slid)->sum('sem_price');
                        $setRes = SettlementList::where('id', $sem_slid)->update($all_price);
                    }
                }
            }
            /*---------------------------------------------判定是否需要添加/编辑催单处罚结束--------------------------------------------*/

            /*---------------------------------------------添加标签记录开始-------------------------------------------------*/
            $orderinfo['order_num'] = $input['order_num'];
            $orderinfo['serial_number'] = $orderListArr['serial_number']??'';
            $orderinfo['p_id'] = $p_id;
            $orderinfo['ser_id'] = $input['ser_id']??0;
            $lable = array(array('sety_id'=>'21','sublevel'=>array($atype)));
            $aftRes = AfterSaleService::insertData($lable, $orderinfo, $session,$input['content']);
            /*---------------------------------------------添加标签记录结束-------------------------------------------------*/
            /*---------------------------------------------添加催单信息开始----------------------------------------------*/
            $serRes = SerInforService::createSerInfor(1, $session['admin_acc'], $input['ser_id'], $session['id'], $input['order_num'], $input['sys_num'], $orderListArr['serial_number'], 1, $atype, $input['content'],$sin_num,$session['company_id']);
            /*---------------------------------------------添加催单信息结束----------------------------------------------*/
            if ($aftRes && $serRes) {
                $push_type = 1;
                /***************半径推送******************************/
//                $store=SyncStores::where("ser_id",$orderListArr['ser_id'])->where("type",2)->value('id');
                $store = CommonService::getSyncStores($orderListArr['ser_id'], $orderListArr['category']);
                if(!empty($store) && $orderListArr['store_type']=='5'){
                    $pop['ord_order_number'] = $orderListArr['serial_number'];
                    $pop['type'] = 1;
                    $pop['orre_id'] =$serRes;
                    $pop['remark'] =$input['content'];
                    $store = SysStoresService::sysStore($pop, 'sdReminder',$store);
                    if($store['ErrorCode']!=1){
                        DB::rollBack();
                        return $store;
                    }
                    $push_type=2;
                    SerInfor::where('sin_id',$serRes)->update(['store_type'=>5]);
                }
                /***************半径推送******************************/
                DB::commit();
                $serid = Admin::whereRaw("FIND_IN_SET(" . $orderListArr['ser_id'] . ",children_id)")->value('id');
                if (!empty($serid)) {
                    $weixin['ser_id'] = $serid;
                } else {
                    $weixin['ser_id'] = $orderListArr['ser_id'];
                }
                $user = CommonService::getUser('id', $orderListArr['customer_id'],['shr_name','shr_phone','shr_sheng','shr_shi','shr_xian','shr_adress']);
                $weixin['shr_name'] = $user['shr_name'];
                $weixin['serial_number'] = $orderListArr['serial_number'];
                $weixin['num'] = $sin_num??'1';
                $weixin['order_num'] = $orderListArr['order_num'];
                CommonService::requestPost('http://weixin.sudianwang.com/index.php/BindingAccount/urgedPush', $weixin);
                $BaseController->operatingTime($orderListArr['serial_number']??'', '催单时间', date("Y-m-d H:i:s"), $input['order_num'], $session['admin_acc']);//订单操作时间
                $BaseController->insertingLog("催单，", $input['sys_num'], "订单：" . $input['sys_num'], "订单管理", $ip, $session['admin_acc']);
                $bind = AdminInfor::where('admin_id', $input['ser_id'])->select('bind','head_phone')->first();
                // 绑定状态
                //if ($bind['binds'] == 2) {
                //    //include_once('PushAction.class.php');

                //    $Push = new PushController();
                //    $Push->push($input['sys_num'], '催单了', 1);
                //}
                if($push_type=='1'){
                    OrderService::pushApp([], $orderListArr['ser_id'] ,'催单了');
                }
//                if ($bind['head_phone']) {
//                    $tem = DB::table('sms_template')->where('type','催单')->first();
//                    $address = $user['shr_sheng'].$user['shr_shi'].$user['shr_xian'].$user['adress'];
//                    $msg = $tem['content'];
//                    $msg = str_replace("|OrderNum|",$orderListArr['order_num'],$msg);
//                    $msg = str_replace("|Dress|",$address,$msg);
//                    $msg = str_replace("|Phone|",$user['shr_phone'],$msg);
//                    $msg = str_replace("|Name|",$user['shr_name'],$msg);
//                    CommonService::senSms($user['shr_phone'],$msg,'SuDianPaw');
//
//                }

                return ['Data' => [], 'ErrorMessage' =>'操作成功', 'ErrorCode' => 1];
            } else {
                DB::rollback();
                return ['Data' => [], 'ErrorMessage' =>'催单失败', 'ErrorCode' => ErrorInc::MYSQL_FAILED];exit;
            }
        }
    }

    public static function rules(){
        return array(
            'sys_num' => '系统单号',
            'phone' => '联系电话',
            'name' => '客户姓名',
            'sheng' => '省',
            'shi' => '市',
            'xian' => '县',
            'address' => '详细地址',
            'order_type' => '订单类型',
            'company_name' => '门店名称',
            'orders_id' => '订单数据id',
            'ser_id' => '门店id',
            'user_id' => '用户id',
            'content' => '备注',
            'id' => '订单数据id',
            'msg_id' => '订单详情表id',
            'goods_id' => '新商品id',
            'goods_paid' => '应收金额',
            'goods_price' => '实收金额',
            'goods_state' => '差额处理类型',
            'submit_money' => '差额',
            'pt_id' => '平台',
            'goods_name_new' => '新商品名称',
            'goods_name_old' => '被换商品名称',
            'reminder' => '催单类型',
        );
    }

    /**
     * @name 获取催单信息
     * @param $sys_num 系统单号
     * @return array
     * @author du
     * @date 2022/1/4
     */
    public static function remindInfo($sys_num){
        $list = SerInforService::getInfoByKeyValue('sin_sysnum', $sys_num , ['sin_centent', 'sin_creactime', 'sin_state', 'sin_lastime', 'sin_dealer', 'sin_creacter']);
        if ($list) {
            $sin_creactime = [];
            foreach ($list as $key => $value) {
                $sin_creactime[] = $value['sin_creactime'];
                if ($value['sin_state'] = 1) {
                    $list[$key]['sin_stateinfo'] = "未处理";
                } else if ($value['sin_state'] = 2) {
                    $list[$key]['sin_stateinfo'] = "已处理";
                } else if ($value['sin_state'] = 3) {
                    $list[$key]['sin_stateinfo'] = "已审核";
                }
                if (empty($value['sin_lastime']) || $value['sin_lastime'] == "0000-00-00 00:00:00") {
                    $list[$key]['sin_lastime'] = "无";
                }
                if (empty($value['sin_dealer'])) {
                    $list[$key]['sin_dealer'] = "无";
                }
                if (empty($value['sin_centent'])) {
                    $list[$key]['sin_centent'] = "无";
                }
            }
            array_multisort($sin_creactime, SORT_NUMERIC ,SORT_DESC, $list);
            return ['Data' => $list, 'ErrorMessage' =>'操作成功', 'ErrorCode' => 1];
        } else {
            return ['Data' => [], 'ErrorMessage' =>'暂无数据', 'ErrorCode' => 2];exit;
        }
    }


}
