<?php

namespace App\Http\Controllers\DatasBase;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Common\CommonController;
use App\Services\BmmcService;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use App\Models\Admin;
use App\Models\Disareanew;
use Illuminate\Http\Request;
use App\Models\Bserviss;
use App\Models\AdminInfor;
use App\Models\Region;
use DB;
use Excel;


/**
 * @name 自动派单绑定服务商
 * Class BservissController
 * @package App\Http\Controllers\Admin
 */
class BservissController extends BaseController
{
    /**
     * @name列表页
     * @param are_shi 搜索城市
     * @param are_xian 搜索县
     * @param ser_id　服务商ID
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function index (Request $request)
    {
        $page_size = (int)$request->input('page_size',20);
        $page = (int)$request->input('page',1);
        if($page<1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;
        $Db = Bserviss::leftJoin('admin','admin.id','=','bservisnew.bs_serid');

        if ($request->filled('are_shi')){//市
            $Db = $Db->where('bs_sid',$request->input('are_shi'));
        }
        if ($request->filled('are_xian')){//县
            $are_xian = $request->input('are_xian');
            $are_id = Disareanew::where('are_xid',$are_xian)->value('are_id');
            $Db = $Db->whereRaw("FIND_IN_SET(".$are_id.",bs_areid)");
        }
        if ($request->filled('ser_id')){//服务中心名称
            $Db = $Db->where('bs_serid',$request->input('ser_id'));
        }
        if ($request->get('session_token')['admin_groupnew'] != 7) {//管理员可以看全部
            $Db = $Db->where('admin.company_id',$request->get('session_token')['company_id']);
        }
        $count = $Db->count();
        if($request->input('is_excel')==1){
            DB::connection()->enableQueryLog();#开启执行日志
        }
        $list = $Db->select('bservisnew.*','admin.company_name')->offset($offset)->limit($page_size)->get();
        $data['page'] = [
            'count' => $count,
            'allPage' => ceil($count/$page_size),
            'page' => $page,
            'page_size' => $page_size,
        ];
        $session = $request->get('session_token');

        //导出 start
        if ($request->input('is_excel') == 1) {
            $sqls = DB::getQueryLog()[0];
            $excel = new CommonController();
            return $excel->getExcelOut($request->input('Pri_id'), $sqls, $session);
        }
        //导出 end

        $all_button = BmmcService::whereButton($request->input('token'),$request->input('Pri_id'));
        $export = BmmcService::getTopButton('AddEntry,export','',$all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮
        if (!$list->isEmpty()){
            $brand = DB::table('goods_brand')->pluck('brand_name','id')->toArray();
            $list = $list->toArray();
            foreach ($list as $k =>$v){
                $buttonData = [];
                $eng = Disareanew::whereIn('are_id',explode(',',$v['bs_areid']))->select('are_id','are_sheng','are_shi','are_xian')->get()->toArray();
                $area = [];
                foreach ($eng as $ks=>$vs){
                    $area[] = $vs['are_xian'];
                    $list[$k]['are_sheng'] = $vs['are_sheng'];
                    $list[$k]['are_shi'] = $vs['are_shi'];
                    $list[$k]['are_xian'] = implode("、",$area);
                }
                unset($area);
                $buttonData[] = 'EditEntry,set_status,DelEntry';
                $button = BmmcService::getListButton($buttonData,$all_button);
                $list[$k]['button_one'] = $button['button_one']??[];
                $list[$k]['button_two'] = $button['button_two']??[];
                $list[$k]['button_three'] = $button['button_three']??[];
                if ($v['bs_brantype'] == 1){
                    $list[$k]['bs_brantype_mame'] = '代理';
                }elseif ($v['bs_brantype'] == 2){
                    $list[$k]['bs_brantype_mame'] = '经营';
                }
                if (isset($brand[$v['bs_branid']])){
                    $list[$k]['brand_name'] = $brand[$v['bs_branid']];
                }
            }
            $time = DB::table("time_type")->where('t_type',1)->first();
            $data['time'] = $time;
            $data['list'] = $list;
            return $this->success('获取成功',$data);exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }
    /**
     * @name 获取城市
     * @param are_name
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function search_shi (Request $request)
    {
        if ($request->filled('are_name')){
            $are_name = $request->input('are_name');
            $list = DB::table('disareanew')->where(function ($query)use($are_name){
                $query->where('are_shi','like',"%{$are_name}%")->orWhere('are_sheng','like',"%{$are_name}%")->where('are_state',1);
            })->select('are_sid','are_sheng','are_shi')->groupBy('are_shi')->get();
            if (!$list->isEmpty()){
                return $this->success('获取成功',$list);exit;
            }else{
                return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);
        }
    }

    /**
     * @name 获取包含的区域
     * @param type 1：添加；2：编辑
     * @param are_sid  市id
     * @param bs_id    数据id
     * @param bs_serid 服务商id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function search_xian (Request $request)
    {
        if ($request->input('type') == 1){
            if($request->filled('are_sid')){
                $list = DB::table('disareanew')->select('are_id','are_xid','are_xian','are_state')->where('are_sid',$request->input('are_sid'))->where('are_state',1)->get();//
                if (!$list->isEmpty()){
                    $list = $list->toArray();
                    foreach ($list as $k =>$v){
                        $list[$k]['are_type'] = 1;
                    }
                    return $this->success('获取成功',$list);exit;
                }else{
                    return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
                }
            }else {
                return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
            }
        }elseif ($request->input('type') == 2){
            if ($request->filled('bs_id') && $request->filled('bs_sid') && $request->filled('bs_serid')){
                $areas =DB::table('disareanew')->where('are_sid',$request->input('bs_sid'))->select('are_id','are_xid','are_xian','are_sid')->get();
                $bs_areid = Bserviss::where('bs_id',$request->input('bs_id'))->first();
                if (!$areas->isEmpty()){
                    $areas = $areas->toArray();
                    $Olaf = explode(',',$bs_areid['bs_areid']);
                    foreach ($areas as $k=>$v){
                        if (in_array($v['are_id'],$Olaf)){
                            $areas[$k]['are_type'] = 2;
                        }else{
                            $areas[$k]['are_type'] = 1;
                        }
                    }
                    $data['list'] = $areas;
                    $data['part'] = $Olaf;
                    return $this->success('获取成功',$data);exit;
                }else{
                    return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
                }
            }else{
                return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
            }
        }else{
            return $this->error('参数错误type', ErrorInc::FAILED_PARAM);
        }
    }

    /**
     * @name 获取服务商
     * @param are_sheng  省
     * @param are_shi    市
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function search_company (Request $request)
    {
        if ($request->filled('are_sheng') && $request->filled('are_shi')){
            $are_sheng = $request->input('are_sheng');
            $are_shi = $request->input('are_shi');
            $serid = Bserviss::distinct()->pluck('bs_serid')->toArray();
            $adminRes = AdminInfor::where('admin_province','like',"%{$are_sheng}%")->Where('admin_city','like',"%{$are_shi}%")->select('admin_id')->get();
            if (!$adminRes->isEmpty()){
                $list = [];
                $num = -1;
                $adminRes = $adminRes->toArray();
                foreach ($adminRes as $k=>$v){
                    $company_name = Admin::where('id',$v['admin_id'])->where('enable',1)->where('admin_groupnew',2)->value('company_name');
                    if ($company_name){
                        $num++;
                        $list[$num]['admin_id'] = $v['admin_id'];
                        $list[$num]['company_name'] = $company_name;
                    }
                }
                if ($list){
                    foreach ($list as $ks => $vs){
                        if (in_array($vs['admin_id'],$serid)){
                            $list[$ks]['type'] = 2;
                        }else{
                            $list[$ks]['type'] = 1;
                        }
                    }
                    $data['list'] = $list;
                    return $this->success('获取成功',$data);exit;
                }else{
                    return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
                }
            }else{
                return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            return $this->error('参数错误无are_sheng或无are_shi', ErrorInc::FAILED_PARAM);
        }
    }


    /**
     * @name  查找服务商
     * @param company_name 公司名
     * @param are_sid 市ID
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function searchService (Request $request)
    {
        if (!$request->filled('company_name')||!$request->filled('are_sid')){
            return $this->error('参数错误无company_name或无are_sid', ErrorInc::FAILED_PARAM);
        }
        $company_name = $request->input('company_name');
        $are_sid = $request->input('are_sid');
        $serid = Bserviss::distinct()->where('bs_sid',$are_sid)->pluck('bs_serid')->toArray();
        $list = DB::table('admin')->whereNotIn('id',$serid)->where('admin_groupnew',2)->where('company_id',$request->get('session_token')['company_id'])->where('company_name','like','%'.$company_name.'%')->select('id','company_name')->orderBy('id','ASC')->limit('10')->get();
        if (!$list->isEmpty()){
            return $this->success('获取成功',$list);exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }


    /**
     * @name 获取可操作品牌
     * @param serid  服务商id
     * @param areid  绑定地址id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function search_brand (Request $request)
    {
        if ($request->input('type') == 1){
            if ($request->filled('serid') && $request->filled('bs_sid')){
                $serid = $request->input('serid');
                $bs_sid = $request->input('bs_sid');
                $bsArr = Bserviss::where('bs_serid',$serid)->where('bs_sid',$bs_sid)->get();
                if (!$bsArr->isEmpty()){
                    $bsArr = CommonService::dataToArray($bsArr);
                    foreach( $bsArr as $k => $v){
                        $brandid[] = $v['bs_branid'];
                    }
                    $brands = DB::table('goods_brand')->where('company_id',$request->get('session_token')['company_id'])->get()->toArray();
                    if(!$brands){
                        return $this->error('暂无数据1', ErrorInc::DATA_EMPTY);exit;
                    }
                    foreach ($brands as $key=>$value){
                        $brandArr[$key]['id'] = $value['id'];
                        $brandArr[$key]['brand_name'] = $value['brand_name'];
                        $brandArr[$key]['bs_brantype'] = '';
                        $brandArr[$key]['bs_max'] = '';
                        $brandArr[$key]['bs_min'] = '';
                    }
                    $bsArr = CommonService::jointArrayKey($bsArr, 'bs_branid');
                    foreach ($brandArr as $k=>$v){
                        $list[$k]['brand_name'] = $v['brand_name'];
                        $list[$k]['bs_branid'] = $v['id'];//bs_areid
                        if(isset($bsArr[$v['id']])){
                            $list[$k]['bs_brantype'] = $bsArr[$v['id']]['bs_brantype'];
                            $list[$k]['bs_max'] = $bsArr[$v['id']]['bs_max'];
                            $list[$k]['bs_min'] = $bsArr[$v['id']]['bs_min'];
                            $list[$k]['bs_areid'] = explode(',',$bsArr[$v['id']]['bs_areid']);
                        }else{
                            $list[$k]['bs_brantype'] = '';
                            $list[$k]['bs_max'] = '';
                            $list[$k]['bs_min'] = '';
                            $list[$k]['bs_areid'] = [];
                        }
//                        foreach ($bsArr as $ks=>$vs){
//                            if ($vs['bs_branid'] == $v['id']){
//                                $list[$k]['bs_brantype'] = $vs['bs_brantype'];
//                                $list[$k]['bs_max'] = $vs['bs_max'];
//                                $list[$k]['bs_min'] = $vs['bs_min'];
//                                //$list[$k]['bs_id'] = $vs['bs_id'];
//                                break;
//                            }else{
//                                $list[$k]['bs_brantype'] = '';
//                                $list[$k]['bs_max'] = '';
//                                $list[$k]['bs_min'] = '';
//                            }
//                        }
                    }
                    if($list){
                        return $this->success('获取成功',$list);exit;
                    }else{
                        return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
                    }
                }
            }else{
                return $this->error('参数错误', ErrorInc::FAILED_PARAM);
            }

        }else{
            $res = DB::table("goods_brand")->where('company_id',$request->get('session_token')['company_id'])->select('id','brand_name')->get();
            if(!$res->isEmpty()){
                $res = $res->toArray();
                $list = [];
                foreach ($res as $k =>$v){
                    $list[$k]['bs_branid'] = $v['id'];
                    $list[$k]['brand_name'] = $v['brand_name'];
                    $list[$k]['bs_brantype'] = "";
                    $list[$k]['bs_max'] = "";
                    $list[$k]['bs_min'] = "";
                }
                if ($list){
                    return $this->success('获取成功',$list);exit;
                }else{
                    return $this->error('暂无数据1', ErrorInc::DATA_EMPTY);exit;
                }

            }else{
                return $this->error('暂无数据2', ErrorInc::DATA_EMPTY);exit;
            }
        }
    }

    /**
     * @name 删除派单区域
     * @param bs_id 数据id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function DelEntry (Request $request)
    {
        if ($request->filled('bs_id')){
            $del = DB::table('bservisnew')->where('bs_id',$request->input('bs_id'))->delete();
            if ($del){
                $this->insertingLog("删除",$request->input('bs_id'),"删除派单区域","自动派单绑定服务商",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('删除成功');exit;
            }else{
                return $this->error('删除失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);
        }
    }

    /**
     * @name 设置派单时间
     * @param start_time  开始时间
     * @param end_time    结束时间
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function set_time (Request $request)
    {
        return $this->error('功能已下线', ErrorInc::MYSQL_FAILED);exit;
        if ($request->filled('start_time') && $request->filled('end_time')){
            $poss['tstart_time'] = $request->input('start_time');
            $poss['tend_time'] = $request->input('end_time');
            $res = DB::table("time_type")->update($poss);
            if($res){
                $this->insertingLog("设置派单时间","","设置派单时间：".$poss['tstart_time'].'=='.$poss['tend_time'],"自动派单绑定服务商",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');exit;
            }else{
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);
        }
    }

    /**
     * @name 设置数据状态
     * @param bs_id      数据id
     * @param set_areid  区域id
     * @param set_serid  服务商id
     * @param type       操作类型1仅该条记录，2：仅该地区数据，3：该服务上所有数据
     * @param bs_status  数据状态1.启用，2.停用
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|mixed
     * @author du
     * @date 2021/8/30
     */
    public function set_status (Request $request)
    {
        if ($request->filled('bs_id') && $request->filled('set_areid') && $request->filled('set_serid')){
            if (!$request->filled('type')){
                return $this->error('请选择操作方式', ErrorInc::FAILED_PARAM);exit;
            }
            if (!$request->filled('bs_status')){
                return $this->error('请选择操作状态', ErrorInc::FAILED_PARAM);exit;
            }
            $type = intval($request->input('type'));
            $Db = DB::table('bservisnew');
            if ($type == 1) {
                $Db = $Db->where('bs_id',$request->input('bs_id'));
            } elseif ($type == 2) {
                $Db = $Db->where('bs_areid',$request->input('set_areid'))->where('bs_serid',$request->input('set_serid'));
            } elseif ($type == 3) {
                $Db = $Db->where('bs_serid',$request->input('set_serid'));
            }else{
                return $this->error('参数错误', ErrorInc::FAILED_PARAM);
            }
            $poss['bs_status']=$request->input('bs_status');
            $upRes = $Db->update($poss);
            if($upRes){
                $this->insertingLog("设置数据状态","","数据id：".$request->input('bs_id'),"绑定服务商",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');exit;
            }else{
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);
        }
    }

    /**
     * @name 添加绑定数据
     * @param ser_id       服务商id
     * @param are_sid      查询城市id
     * @param xianids      区县id串
     * @param brand_data (list)
     * @param bs_brantype  经营类型：1：代理；2：经营
     * @param bs_max       日最大消化量
     * @param bs_min       日最小需求量
     * @param bs_branid    品牌id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function AddEntry (Request $request)
    {
        if ($request->filled('list')){
            $list = $request->input('list');
            $listArr = [];
            $vv = 0;
            foreach ($list as $k=>$v){
                foreach ($v['brand_data'] as $ks=>$vs){
                    $listArr[$vv]['bs_serid'] = $v['admin_id'];
//                    $listArr[$vv]['bs_areid'] = implode(',',$v['areachech']);
                    $listArr[$vv]['bs_areid'] = implode(',',$vs['areachech']);
                    $listArr[$vv]['bs_sid'] = $request->input('are_sid');
                    $listArr[$vv]['bs_branid'] = $vs['bs_branid'];
                    $listArr[$vv]['bs_brantype'] = $vs['bs_brantype'];
                    $listArr[$vv]['bs_max'] = $vs['bs_max'];
                    $listArr[$vv]['bs_min'] = $vs['bs_min'];
                    $listArr[$vv]['bs_creactime'] = date('Y-m-d H:i:s');
                    $listArr[$vv]['bs_creactid'] = $request->get('session_token')['admin_name'];
                    $vv++;
                }
            }
            $res = DB::table('bservisnew')->insert($listArr);
            if ($res){
                $this->insertingLog("添加","","添加绑定数据","绑定服务商",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('添加成功');exit;
            }else{
                return $this->error('添加失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 编辑
     * @param ser_id       服务商id
     * @param are_sid      查询城市id
     * @param xianids      区县id串
     * @param brand_data
     * @param bs_brantype  经营类型：1：代理；2：经营
     * @param bs_max       日最大消化量
     * @param bs_min       日最小需求量
     * @param bs_branid    品牌id
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function EditEntry (Request $request)
    {
        if ($request->filled('admin_id') && $request->filled('brand_data') && $request->filled('bs_sid') && $request->filled('areachech')){
            try{
                DB::beginTransaction(); //开启事务
                $brand_data = $request->input('brand_data');
                $arr['bs_serid'] = $request->input('admin_id');
                $arr['bs_areid'] = implode(',',$request->input('areachech'));
                $arr['bs_sid'] = $request->input('are_sid');
                $listArr = [];
                foreach ($brand_data as $ks=>$vs){
                    $listArr[$ks]['bs_serid'] = $request->input('admin_id');
//                    $listArr[$ks]['bs_areid'] = implode(',',$request->input('areachech'));
                    $listArr[$ks]['bs_areid'] = implode(',',$vs['areachech']);
                    $listArr[$ks]['bs_sid'] = $request->input('bs_sid');
                    $listArr[$ks]['bs_branid'] = $vs['bs_branid'];
                    $listArr[$ks]['bs_brantype'] = $vs['bs_brantype'];
                    $listArr[$ks]['bs_max'] = $vs['bs_max'];
                    $listArr[$ks]['bs_min'] = $vs['bs_min'];
                    $listArr[$ks]['bs_creactime'] = date('Y-m-d H:i:s');
                    $listArr[$ks]['bs_creactid'] = $request->get('session_token')['admin_name'];
                }
                $delRes = DB::table('bservisnew')->where('bs_serid',$request->input('admin_id'))->where('bs_sid',$request->input('bs_sid'))->delete();
                $inRes = DB::table('bservisnew')->insert($listArr);

                if ($delRes && $inRes){
                    $this->insertingLog("编辑","","编辑","绑定服务商",$request->ip(), $request->get('session_token')['admin_acc']);
                    DB::commit();
                    return $this->success('编辑成功');exit;
                }else{
                    return $this->error('编辑失败', ErrorInc::MYSQL_FAILED);exit;
                }
            }catch(\Exception $e){
                DB::rollback();
                return $this->error($e->getMessage(), ErrorInc::FAILED_PARAM);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);
        }
    }

    /**
     * @name  省市县搜索
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function region (Request $request)
    {
        $region = new Region();
        $param = $request->only('type','reg_id','reg_num','are_sheng','are_shi');
        if ($request->input('type') == 1) {
            $list = $region->get_sheng($param);
        } elseif ($request->input('type') == 2) {
            $list = $region->get_shi($param);
        } elseif ($request->input('type') == 3) {
            $list = $region->get_xian($param);
        }
        if ($list) {
            return $this->success('获取成功',$list);exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }
}
