<?php

namespace App\Http\Controllers\Api\MobileWeb;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Validators\Api\MobileWeb\BillingModuleValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\Api\MobileWeb\BillingModuleService;

// 移动端-账单列表
class BillingModuleController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    public function __construct()
    {
        $this->dataValidator = new BillingModuleValidator();
    }

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        
        $return_data = BillingModuleService::index($request->all(), $this->show_count);
        return $return_data;
    }

    // 查看凭证
    public function checkVoucher(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->checkInfoValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = BillingModuleService::checkVoucher($request->all());
        return response()->json($return_data);
    }

    // 查看详情
    public function checkInfo(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->checkInfoValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = BillingModuleService::checkInfo($request->all());
        return response()->json($return_data);
    }

    // 确认账单
    public function affirmBill(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->affirmBillValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = BillingModuleService::affirmBill($request->all());
        return response()->json($return_data);
    }

    // 上传发票
    public function uploadInvoice(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->uploadInvoiceValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = BillingModuleService::uploadInvoice($request->all());
        return response()->json($return_data);
    }
}
