<?php
/**
 * 任务单管理服务
 * @author dong 2022-2-11 13:52:18
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use BlueCity\Core\Service\Service;
use DB;
class OrdersTaskService extends Service{

    /**|---------------------------------------------------------------------------------
     * @name 获取列表顶部状态
     * @param string $group 操作人权限
     * @param string $admin_pt_id 可操作平台信息
     * @param string $type 是否查询数据量1是
     * @retrun /multitype:array
     * @author dou 2022/2/11 11:25
     * |---------------------------------------------------------------------------------
    */
    public static function getResultStatusBar ( $type = '2' ){
                $showcount = [
                    ['showname' => "全部", 'shownum' => '--','status'=>0],
                    ['showname' => "新导入", 'shownum' => '--','status'=>1],
                    ['showname' => "已同步", 'shownum' => '--','status'=>2],
                    ['showname' => "异常单", 'shownum' => '--','status'=>3],
                    ['showname' => "已解决", 'shownum' => '--','status'=>4],
                    ['showname' => "未匹配到订单", 'shownum' => '--','status'=>5],
                    ['showname' => "派单失败", 'shownum' => '--','status'=>6]
                ];
                if( $type == '1'){
                    foreach( $showcount as $k => $v ){
                        $showcount[$k]['shownum'] = self::getResultStatusNum($v['status']);
                    }
                }
                return $showcount;
            }
            /**|---------------------------------------------------------------------------------
             * @name 获取指定状态订单数量
             * @param string $status 状态栏参数
             * @retrun /multitype:array
             * @author dou 2022/2/11 11:32
             * |---------------------------------------------------------------------------------
            */
            public static function getResultStatusNum ( $status){
                if(in_array($status,[1,3,5,6])){
                    $db = Db::table('orders_task');
                    $num = CommonService::getMysqlData($db,['result_state'=>$status],[],[],'count');
                    $num = $num??'0';
                    return $num;
                }else{
                    return '--';
                }
            }

}
