<?php

namespace App\Http\Requests\Validators\Api\MobileWeb;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 移动端-工单列表
class OrderListValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return false;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '请输入账号id',
            'install_id.integer' => '参数错误',
            'admin_id.required' => '请输入服务商id',
            'admin_id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'deor_id.required' => '请输入设计工单id',
            'deor_id.integer' => '参数错误',
            'sys_num.required' => '请输入订单单号',
            'sys_num.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'deor_id' => 'required|integer|min:1',
            'sys_num' => 'required|string|max:50',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 接单验证器
    public function receivingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'id.required' => '请输入工单id',
            'id.integer' => '参数错误',
            'receive_install_id.required' => '请选择安装人员',
            'receive_install_id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'id' => 'required|integer|min:1',
            'receive_install_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 拒单验证器
    public function refuseValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'id.required' => '请输入服务工单id',
            'id.integer' => '参数错误',
            'remarks.required' => '请输入拒单备注',
            'remarks.max' => '拒单备注长度超出限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'id' => 'required|integer|min:1',
            'remarks' => 'required|string|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 开始安装验证器
    public function startInstallValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'id.required' => '请输入服务工单id',
            'id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 安装反馈验证器
    public function installFeedbackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'id.required' => '请输入服务工单id',
            'type.required' => '请选择完成类型',
            // 'template_data.required' => '请输入图片相关数据',
            // 'license_plate.required' => '请输入车牌号',
            // 'license_plate.max' => '长度超出限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'id' => 'required|integer|min:1',
            'type' => 'required|integer|min:1',
            // 'template_data' => 'required',
            // 'license_plate' => 'required|string|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 操作记录验证器
    public function operatingRecordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'serial_number.required' => '请输入单号',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'serial_number' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 反馈安装图片验证器
    public function imageFeedbackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'image_url.required' => '参数错误',
            'image_id.required' => '参数错误',
            'image_type.required' => '参数错误',
            'id.required' => '请输入服务工单id',
            'id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'image_url' => 'required|min:1',
            'image_type' => 'required|min:1',
            'image_id' => 'required|min:1',
            'id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }


    // 反馈车牌车架号验证器
    public function LicenseFeedbackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'gd_id.required' => '参数错误',
            'id.required' => '请输入服务工单id',
            'id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'gd_id' => 'required|integer|min:1',
            'id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
