<?php
namespace App\Services;
use App\Models\SmsAccount;
use BlueCity\Core\Service\Service;
use DB;
use App\OtherModels\AfterSms;
use App\OtherModels\SmsRecord;
use App\OtherModels\SmsHistory;
use Illuminate\Database\Eloquent\Model;

class SmsService extends Service
{
    /**
     * 获取详细内容
     * @param string $key 查询键
     * @param string $value 查询值
     * @param array $select 待查询参数
     * @return
     * @author du 2021年8月17日上午9:03:06
     */
    public static function getInfoBy($key, $value, $select = [] ,$type = 'get')
    {
        $db = new SmsRecord();
        if($key == 'id') {
            $type = 'first';
        }
    	if(count($select) == 1){
    		$type = 'value';
    	}
    	$list = CommonService::getMysqlData($db,[$key=>$value],$select,[],$type);
    	return $list;
    }

    /**
     * 添加
     * @param  $title
     * @param  $sms_content
     * @param  $creact_id
     * @return
     * @author du 2021年8月17日上午10:57:55
     */
     public static function createAfterSms($title,$sms_content,$creact_id){
    	$poss['title'] = $title;
        $poss['sms_content'] = $sms_content;
        $poss['created_at'] = date("Y-m-d H:i:s");
        $poss['creact_id'] = $creact_id;
    	$res = AfterSms::insert($poss);
    	return $res;
    }

    /**
     *
     * @param  $sms_content
     * @param  $customer_phone
     * @param  $sms_creater
     * @param  $type
     * @return
     * @author du 2021年8月17日上午11:04:46
     */
    public static function createSmsRecord($sms_content,$customer_phone,$sms_creater , $type , $code = ''){
    	$data['sms_content'] = $sms_content;
	    $data['customer_phone'] = $customer_phone;
	    $data['created_at'] = date("Y-m-d H:i:s");
	    $data['sms_creater'] = $sms_creater;
        $data['type'] = $type;
        $data['sms_code'] = $code;
	    $res = SmsRecord::insert($data);
    	return $res;
    }


    /**
     * 回复列表
     * @param array $input
     * @return Ambigous <multitype:, multitype:unknown NULL >
     * @author du 2021年8月17日下午3:04:50
     */
    public static function getList($input){
    	$Db = new SmsHistory();
    	$where = [];
    	$where['1'] = 1;
    	if (isset($input['sh_phone'])) {
    		$where['sh_phone_rlike'] = $input['sh_phone'];
    	}
    	if (isset($input['sh_state'])) {
    		$where['sh_state_rlike'] = $input['sh_state'];
    	}

    	$where = CommonService::jointWhere($where);
    	$page_size = $input['page_size']??10;
    	//DB::connection()->enableQueryLog();#开启执行日志
    	$paginate = $Db->whereRaw($where)->orderBy('sh_id','desc')->paginate($page_size);
    	//print_r(DB::getQueryLog());

    	$result = CommonService::dataToArray($paginate->items());
    	if($result){
    		$list = [];
    		foreach ($result as $k => $v) {
    			$list[$k]['sh_id'] = $v['sh_id'];
    			$list[$k]['sh_phone'] = $v['sh_phone'];
    			$deliver = json_decode($v['sh_data'],true);
    			$list[$k]['sms_content'] = explode('|',$deliver['deliver'])[0];
    			$list[$k]['sh_time'] = $v['sh_time'];
    			$list[$k]['sh_state'] = $v['sh_state'];
    		}


    		$data['list'] = $list;
    		$data['page'] = [
    				'count' => $paginate->total(),
    				'page'=>$paginate->currentPage(),
    				'page_size'=>$page_size,
    				'allPage'=>$paginate->lastPage()
    		];
    	}else{
    		$data['list'] = [];
    	}
    	return $data;
    }

    /**
     * 获取发送列表
     * @param array $input
     * @return Ambigous <multitype:, multitype:unknown NULL >
     * @author du 2021年8月17日下午3:17:24
     */
    public static function getSendList($input){
    	$Db = new SmsRecord();
    	$where = [];
    	$where['1'] = 1;
    	if (isset($input['phone'])) {
    		$where['customer_phone_rlike'] = $input['phone'];
    	}


    	$where = CommonService::jointWhere($where);
    	$page_size = $input['page_size']??10;
    	//DB::connection()->enableQueryLog();#开启执行日志
    	$paginate = $Db->whereRaw($where)->orderBy('created_at','desc')->paginate($page_size);
    	//print_r(DB::getQueryLog());
        $sms_account = SmsAccount::select('sa_id','sms_name','sms_show')->get();
        $sms_account = CommonService::dataToArray($sms_account);
        $data['sms_account'] = $sms_account;
        $sms_account = CommonService::jointArrayKey($sms_account, 'sms_name');
        $all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
    	$result = CommonService::dataToArray($paginate->items());
    	if($result){
            foreach( $result as $k => $v ) {
                $buttonData = [];
                if($v['send_type'] == 1 && $v['type'] != '' ) {
                    $buttonData[] = 'resetSendsms'; //重发短信
                }
                $button = BmmcService::getListButton($buttonData,$all_button);
                $result[$k]['button_one'] = $button['button_one']??[];
                $result[$k]['button_two'] = $button['button_two']??[];
                $result[$k]['button_three'] = $button['button_three']??[];
                $result[$k]['sms_name'] = $sms_account[$v['type']]['sms_show']??'短信账号异常';
            }
    		$data['list'] = $result;
    		$data['page'] = [
    				'count' => $paginate->total(),
    				'page'=>$paginate->currentPage(),
    				'page_size'=>$page_size,
    				'allPage'=>$paginate->lastPage()
    		];
    	}else{
    		$data['list'] = [];
    	}
    	return $data;
    }
    /**
     * 根据电话号获取回复信息
     * @param array $phoneArr
     * @return array
     * @author du 2021年8月17日下午4:26:46
     */
    public static function getReSmsByphone($phoneArr){
    	$list = SmsHistory::whereIn('sh_phone',$phoneArr)->get()->toarray();
    	foreach ($list as $k =>$v){
            $deliver = json_decode($v['sh_data'],true);
            $list[$k]['sms_content'] = explode('|',$deliver['deliver'])[0];
        }
    	$phons = CommonService::jointArrayKey($list,'sh_phone',2);
    	return $phons;
    }


}
