<?php

/**
 * 文件名称（门店账目管理）
 * 文件简单描述（门店结算账目相关展示与处理权限）
 * @author DouBin
 * @Date: 2021/9/8
 * @Time: 11:23
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Http\Controllers\Financial;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Common\CommonController;
use App\Models\Admin;
use App\Models\ServiceCenMoney;
use App\Models\ServiceCenter;
use App\Models\SettlementList;
use App\Models\StatementsList;
use App\Services\AdminsService;
use App\Services\ExceloutService;
use App\Services\FunctionsService;
use App\Services\ServiceCenterService;
use App\Services\ServiceProviderService;
use App\Services\SettlementService;
use Illuminate\Http\Request;
use DB;
use App\Services\CommonService;//通用服务
use BlueCity\Core\Inc\ErrorInc;

class ServiceCenterController extends BaseController{
    /**|---------------------------------------------------------------------------------
     * @name 列表页
     * @param int type 类型   1 申请结款  2 速电付款  3 已完结   4 坏账   5 蓝城付款  6 个人付款
     * @param string wat_num 结算单号
     * @param int invoice 发票类型  1:增票; 2:普票  3 不开票
     * @param int whether_inv 收票状态   1 已收票  2 未收票
     * @param int mouth_pay  结款类型 1:月结 2:零散  3:周结 4:五大区
     * @param int settlement_type  付款类型 5:蓝城付款 6:个人付款 2:速电付款
     * @param int apply_for_name 经手人
     * @param int ser_id  结算对象
     * @param array apply_time  申请时间
     * @param array payment_time    付款开始时间
     * @param accountname   开户公司
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/8 11:25
     * |---------------------------------------------------------------------------------
    */
    public function index ( Request $request ){
        $input = $request->all();
        $session = $request->get('session_token');
        $data = ServiceCenterService::getList($input, $session);

        //导出 start
        if ($input['is_excel'] == 1) {
            $sqls = $data['Data']['sqls'];
            $excel = new CommonController();
            return $excel->getExcelOut($input['Pri_id'], $sqls, $session);
        }
        //导出 end

        if($data['ErrorCode']!=1){
            return $data;
        }else {
            unset($data['Data']['sqls']);
            $list = $data['Data'];
            if ($list['list']) {
                return $this->success('获取成功', $list);
                exit;
            } else {
                return $this->error('暂无数据', ErrorInc::DATA_EMPTY, $list);
                exit;
            }
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取异步加载明细
     * @param array wat_nmu 结算单号
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/8 20:49
     * |---------------------------------------------------------------------------------
    */
    public function getNote ( Request $request ){
        if (!$request->filled('wat_nmu')) {
            return $this->error('缺少参数：wat_nmu', ErrorInc::INVALID_PARAM, []);
        }
        $wat_nmu = $request->input('wat_nmu');
        if(!is_array($wat_nmu)){
            return $this->error('数据格式错误', ErrorInc::INVALID_PARAM, []);
        }
        $noteRes = CommonService::orderRemarks($wat_nmu,'orders_id',$request->get('session_token')['admin_groupnew'],$request->input('Login_id'));//获取备注信息
        $list = [];
        foreach ($wat_nmu as $k => $v){
            $list[$v]['note'] = $noteRes[$v]??[];
        }
        if($list){
            $lists['list'] = $list;
            $lists['showcount'] = ServiceCenterService::getStatusBar($request->get("session_token"),1);
            return $this->success('获取成功', $lists); exit;
        }else{
            return $this->error('暂无数据', ErrorInc::FAILED_PARAM);
        }

    }

    /**|---------------------------------------------------------------------------------
     * @name 退回结算
     * @param int  id  结算单数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 10:06
     * |---------------------------------------------------------------------------------
    */
    public function returnSettle ( Request $request ){
        if( $request->filled('id') && $request->input('id') > 0 ) {
            $id = (int)$request->input('id');
            Db::beginTransaction();
            try {
                $wat_num = ServiceCenter::where(['id' => $id, 'type' => 1])->value('wat_num');
                if (empty($wat_num)) {
                    return $this->error('无符合要求账单', ErrorInc::DATA_EMPTY);exit;
                }
                /*-------------------------------------------修改订单和工单结算单状态开始----------------------------------*/
                $list = SettlementService::getSettlementListBy('wat_num', $wat_num,['list_id', 'sys_num']);
                if ($list) {
                    $list_id = array_column($list, 'list_id');
                    $sys_num = array_column($list, 'sys_num');
                    Db::table('order_list')->whereIn('serial_number', $list_id)->update(['account_status' => 2]);
                    Db::table('orders')->whereIn('sys_num', $sys_num)->update(['account_status' => 2]);
                }
                /*-------------------------------------------修改订单和工单结算单状态开始----------------------------------*/

                $rest = SettlementList::where('wat_num', $wat_num)->update(['sett_status' => 10]);//修改结算单状态
                $res = ServiceCenter::where(['id' => $id, 'type' => 1])->delete();//删除门店账单
                $rea = StatementsList::where('stl_wat', $wat_num)->update(['stl_type' => 1]);//修改账单表状态
                if (!$rest || !$res || !$rea) {
                    Db::rollBack();
                    return $this->error('退回结算失败', ErrorInc::MYSQL_FAILED);exit;
                }
                Db::commit();
                //Db::table('invoice_money')->where('sc_id',$id)->delete();
                $this->insertingLog('退回结算，', $wat_num, '结算单：' . $wat_num."退回结算", '服务中心账目管理', $request->ip(), $request->get('session_token')['admin_acc']);//日志
                return $this->success('操作成功');exit;
            } catch (\Exception $e) {
                Db::rollBack();
                return $this->error($e->getMessage(), ErrorInc::SERVER_FAILED);exit;
            }
        }else{
            return $this->error('参数错误：id', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 申请结款
     * @param int id 数据id
     * @param int jsdx 付款类型
     * @param int is_deduct 是否扣点 1是
     * @param string deductNumber 扣款金额
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 11:23
     * |---------------------------------------------------------------------------------
    */
    public function applyPayment ( Request $request ){
        $input = $request->all();
        $checkKey = CommonService::checkKey(['id', 'jsdx', 'is_deduct'],$input);
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);
        }
        $service = ServiceCenter::where(['id'=>$input['id'],'type'=>1])->select('apply_for_money','ser_id','pay_money','deduct_money','wat_num')->first();
        if(empty($service)){
            return $this->error('无符合要求账单', ErrorInc::DATA_EMPTY);exit;
        }
        // 计算扣点
        $deduct = AdminsService::getAdminsBy('id', $service['ser_id'],['deduct']);
        $bl = 1;  //比例
        if($input['is_deduct'] == 1 ){
            $temp = explode(',',$deduct);
            $kou = $temp[1]??0;
            if($kou>0){
                //$bl=1-(100-$kou)*100;
                $bl = 1-($kou/100);
            }
            if($service['pay_money']!='0' || $service['deduct_money']!='0'){
                $kou_money = $service['pay_money']*$bl;
            }else{
                $kou_money = $service['apply_for_money']*$bl;
            }
            if (number_format($kou_money,2) != number_format($input['deductNumber'],2)) {
                $data = "扣款金额错误:".$kou_money;
                return $this->error($data, ErrorInc::FAILED_PARAM);exit;
            }
        }
        $poss['buckle_point'] = (1-$bl)*100;
        if($service['pay_money']!='0'){
            $poss['apply_for_deduct'] = $service['pay_money']*$bl;
        }else{
            $poss['apply_for_deduct'] = $service['apply_for_money']*$bl;
        }
        $poss['type'] = $input['jsdx'];
        $poss['settlement_type'] = $input['jsdx'];
        $poss['apply_audit_name'] = $request->get('session_token')['admin_acc'];
        //return $service['apply_for_money']*$bl;exit;
        $res = ServiceCenter::where('id',$input['id'])->update($poss);
        if($res){
            $this->insertingLog("申请结款，",$service['wat_num'],"申请结款，结算单号：".$service['wat_num'],"服务中心账目管理",$request->ip(), $request->get('session_token')['admin_acc']);
            return $this->success('操作成功');exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 退回申请
     * @param int id 结算账单数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 16:22
     * |---------------------------------------------------------------------------------
    */
    public function returnApply(Request $request)
    {
        if( $request->filled('id') && $request->input('id') > 0 ) {
            $id = (int)$request->input('id');
            $Service = ServiceCenter::where('id', $id)->whereIn('type', [2, 5, 6,8,9,10])->select('apply_for_money', 'apply_for_deduct', 'wat_num')->first();
            if (!empty($Service)) {
                if ($Service['apply_for_money'] != $Service['apply_for_deduct']) {
                    SettlementList::where('wat_num', $Service['wat_num'])->update(['deduct_list' => 0]);
                }
                $res = ServiceCenter::where('id', $id)->update(['type' => 1, 'apply_for_deduct' => '','settlement_type'=>'']);
                if ($res) {
                    $this->insertingLog("退回申请，",$Service['wat_num'],"退回申请，结算单号：".$Service['wat_num'],"服务中心账目管理",$request->ip(), $request->get('session_token')['admin_acc']);
                    return $this->success('操作成功');exit;
                } else {
                    return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
                }
            }else {
                return $this->error('无对应数据', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            return $this->error('参数错误：id', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 坏账
     * @param int id 结算账单数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 16:43
     * |---------------------------------------------------------------------------------
    */
    public function badebt ( Request $request ){
        if( $request->filled('id') && $request->input('id') > 0 ) {
            $id = (int)$request->input('id');
            $wat_num = ServiceCenter::where('id', $id)->value('wat_num');
            if($wat_num) {
                $res = ServiceCenter::where('id', $id)->update(['type' => 4, 'apply_audit_name' => '']);
                if ($res) {
                    $this->insertingLog("坏账，",$wat_num,"坏账，结算单号：".$wat_num,"服务中心账目管理",$request->ip(), $request->get('session_token')['admin_acc']);
                    return $this->success('操作成功');exit;
                } else {
                    return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
                }
            }else{
                return $this->error('无对应数据', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            return $this->error('参数错误：id', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 驳回至待付款
     * @param int id 结算账单数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 17:12
     * |---------------------------------------------------------------------------------
    */
    public function toPendingPaid(Request $request){
        if( $request->filled('id') && $request->input('id') > 0 ) {
            $id = (int)$request->input('id');
            $settlement_num = $request->input('settlement_num');
            $wat_num = ServiceCenter::where('id', $id)->value('wat_num');
            if($wat_num) {
                $res = ServiceCenter::where('id',$id)->update(['type'=>1]);
                if($res){
                    // Db::table('settlement_list')->where("wat_num",$wat_num)->update(['status'=>1]);
                    if (!empty($settlement_num)){
                        SettlementList::where("id in (".$settlement_num.")")->update(['status'=>1]);
                    }
                    $this->insertingLog("坏账驳回，",$wat_num,"坏账驳回至待付，结算单号：".$wat_num,"服务中心账目管理",$request->ip(), $request->get('session_token')['admin_acc']);
                    return $this->success('操作成功');exit;
                }else{
                    return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
                }
            }else{
                return $this->error('无对应数据', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            return $this->error('参数错误：id', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 确认付款
     * @param string/array wat_num 结算单号
     * @param string remarks 备注内容
     * @param string image 申请图片
     * @param int pay_type 付款类型 2:速电;5:蓝城;6:个人
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 18:17
     * |---------------------------------------------------------------------------------
    */
    public function confirmPayment(Request $request){
        $input = $request->all();
        $session = $request->get("session_token");
        $checkKey = CommonService::checkKey(['wat_num','pay_type'],$input);
        if($checkKey['code'] != 1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);
        }
        $wat_num = $input['wat_num'];
        $remark = '确认付款:';
        $remarks = $input['remarks']??'无';
        if($remarks == ''){
            $remarks = '无';
        }
        $remarks = $remark.$remarks;
        if(is_array($wat_num)){
            foreach($wat_num as $k => $v){
                $return = ServiceCenterService::confirmPayment($v, $remarks, $input['image'], $input['pay_type'], $session, $request->ip());
                if($return['ErrorCode']!=1){
                    return $this->error($return['ErrorMessage'], $return['ErrorCode']);exit;
                }
            }
            return $this->success('操作成功');
        }else {
            $return = ServiceCenterService::confirmPayment($wat_num, $remarks, $input['image'], $input['pay_type'], $session, $request->ip());
            return $this->error($return['ErrorMessage'], $return['ErrorCode']);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 驳回审核
     * @param int/array id 结算账单数据id
     * @param string remarks 备注内容
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 20:31
     * |---------------------------------------------------------------------------------
    */
    public function dismissAudit ( Request $request ){
        $input = $request->all();
        $session = $request->get("session_token");
        $checkKey = CommonService::checkKey(['id', 'remarks'],$input);
        if($checkKey['code'] != 1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);
        }
        $id = $input['id'];
        if(is_array($id)){
            foreach($id as $k => $v){
                $return = ServiceCenterService::dismissAudit($v, $input['remarks'], $session, $request->ip());
                if($return['ErrorCode']!=1){
                    return $this->error($return['ErrorMessage'], $return['ErrorCode']);exit;
                }
            }
            return $this->success('操作成功');
        }else {
            $return = ServiceCenterService::dismissAudit($id, $input['remarks'], $session, $request->ip());
            return $this->error($return['ErrorMessage'], $return['ErrorCode']);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取可付款门店信息
     * @param int pay_type 付款类型 2:速电;5:蓝城;6:个人
     * @param string ser_name 服务中心名称
     * @param string accountname_all 账户名称
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 20:44
     * |---------------------------------------------------------------------------------
    */
    public function searchCanPayment ( Request $request ){
        $input = $request->all();
        $pay_type = $input['pay_type']??'0';
        if(!in_array($pay_type, [2,5,6,8,9,10])){
            return $this->error('参数错误：pay_type', ErrorInc::FAILED_PARAM);exit;
        }
        $return = ServiceCenterService::getCanDealStore($input);
        return $this->error($return['ErrorMessage'], $return['ErrorCode'],$return['Data']);exit;
    }

    /**|---------------------------------------------------------------------------------
     * @name 重置发票
     * @param int id 结算账单数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 21:21
     * |---------------------------------------------------------------------------------
    */
    public function ticket(Request $request){
        if( $request->filled('id') && $request->input('id') > 0 ) {
            $id = (int)$request->input('id');
            $wat_num = ServiceCenter::where('id', $id)->value('wat_num');
            if($wat_num) {
                $res = Db::table("invoice_money")->where("sc_id",$id)->first();
                if($res){
                    return $this->error('累计与预开票请联系技术协同处理', ErrorInc::REQUEST_FORBIDDEN);exit;
                }
                //$ass=[];
                $ass['whether_inv'] = 2;
                $ass['invoice_number'] = "";
                $ass['courier_number'] = "";
                $ass['invoice_pic'] = "";
                $some = ServiceCenter::where('id',$id)->update($ass);
                if($some){
                    $this->insertingLog("重置开票，",$wat_num,"重置开票，结算单号：".$wat_num,"服务中心账目管理",$request->ip(), $request->get('session_token')['admin_acc']);
                    return $this->success('操作成功');exit;
                }else{
                    return response()->json(['ErrorCode'=>4,'ErrorMessage'=>'操作失败','Data'=>'']);
                }
            }else{
                return $this->error('无对应数据', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            return $this->error('参数错误：id', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 审核订单
     * @param int/array id 结算账单数据id
     * @param string remarks 备注内容
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 22:00
     * |---------------------------------------------------------------------------------
    */
    public function auditzd (Request $request)
    {
        if (!$request->filled('id')) {
            return $this->error('缺少参数：id', ErrorInc::INVALID_PARAM, []);
        }
        $input = $request->only('id','wat_num','remarks');
        $session = $request->get("session_token");
        $id = $input['id'];
        $remarks = $input['remarks']??"";
        Db::beginTransaction();
        if(is_array($id)){
            foreach($id as $k => $v){
                $return = ServiceCenterService::auditzd($v, $input['remarks'], $session, $request->ip());
                if($return['ErrorCode']!=1){
                    DB::rollback();
                    return $this->error($return['ErrorMessage'], $return['ErrorCode']);exit;
                }
            }
            DB::commit();
            return $this->success('操作成功');
        }else {
            $return = ServiceCenterService::auditzd($id, $input['remarks'], $session, $request->ip());
            if($return['ErrorCode']!=1){
                DB::rollback();
            }else{
                DB::commit();
            }
            return $this->error($return['ErrorMessage'], $return['ErrorCode']);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取可审核处理
     * @param int pay_type 处理状态 7:待审核
     * @param int mouth_pay 结款类型月结周结零散五大区
     * @param string ser_name 服务中心名称
     * @param string accountname_all 账户名称
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/9 22:18
     * |---------------------------------------------------------------------------------
    */
    public function searchCanAuditzd ( Request $request ){
        if(!$request ->filled('mouth_pay')){
            return $this->error('缺少参数：mouth_pay', ErrorInc::INVALID_PARAM);exit;
        }
        $input = $request->all();
        $pay_type = $input['pay_type']??'7';
        if(!in_array($pay_type, [7])){
            return $this->error('参数错误：pay_type', ErrorInc::FAILED_PARAM);exit;
        }
        $return = ServiceCenterService::getCanDealStore($input);
        return $this->error($return['ErrorMessage'], $return['ErrorCode'],$return['Data']);exit;
    }

    /**|---------------------------------------------------------------------------------
     * @name 查看价格明细
     * @param int id 结算账单数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/10 11:46
     * |---------------------------------------------------------------------------------
    */
    public function searPrice ( Request $request ){
        $input = $request->all();
        if(!isset($input['id'])){
            return $this->error('缺少参数：id', ErrorInc::INVALID_PARAM);exit;
        }else{
            $res = ServiceCenMoney::where("svm_sid",$input['id'])->first();
            if($res){
                $data[0]['name'] = "账单金额";
                $data[0]['type'] = "0";
                $data[0]['price'] = $res['svm_allprice'];
                $data[1]['name'] = "补货金额";
                $data[1]['type'] = "1";
                $data[1]['price'] = $res['svm_deductprice'];
                $data[2]['name'] = "调整金额";
                $data[2]['type'] = "2";
                $data[2]['price'] = $res['svm_adjustprice'];
                return $this->success('操作成功',$data);exit;
            }else{
                $rea = ServiceCenter::where("id",$input['id'])->first();
                if($rea){
                    $poss['svm_sid'] = $input['id'];
                    $poss['svm_allprice'] = $rea['apply_for_money'];
                    $poss['svm_deductprice'] = '-'.$rea['deduct_money'];
                    $poss['svm_adjustprice'] = '0';
                    if($rea['pay_money']>0){
                        $poss['svm_actualprice'] = $rea['pay_money'];
                    }else{
                        $poss['svm_actualprice'] = $rea['apply_for_money']-$rea['deduct_money'];
                    }
                    $raa = ServiceCenMoney::insert($poss);
                    if($raa){
                        $data[0]['name'] = "账单金额";
                        $data[0]['type'] = "0";
                        $data[0]['price'] = $rea['apply_for_money'];
                        $data[1]['name'] = "补货金额";
                        $data[1]['type'] = "1";
                        $data[1]['price'] = $rea['deduct_money'];
                        $data[2]['name'] = "调整金额";
                        $data[2]['type'] = "2";
                        $data[2]['price'] = '0';
                        return $this->success('操作成功',$data);
                    }else{
                        return $this->error('数据异常', ErrorInc::MYSQL_FAILED);exit;
                    }
                }else{
                    return $this->error('无对应结算数据', ErrorInc::FAILED_PARAM);exit;
                }
            }
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 编辑金额
     * @param int id 结算账单数据id
     * @param string price 编辑金额
     * @param int type 金额类型
     * @param tring wat_num 结算单账号
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/10 14:02
     * |---------------------------------------------------------------------------------
    */
    public function editPrice ( Request $request ){
        $input = $request->all();
        if(!isset($input['id']) || !isset($input['price']) || !isset($input['type']) || !isset($input['wat_num'])){
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM);exit;
        }else{
            if(!in_array($input['type'],['1','2'])){
                return $this->error('金额类型异常', ErrorInc::FAILED_PARAM);exit;
            }else{
                $data = ServiceCenter::where("id",$input['id'])->select('buckle_point','ser_id')->first();
                $bl=1;
                if($data['buckle_point']>0) {
                    $bl = 1 - ($data['buckle_point'] / 100);
                }else{
                    $deduct = Admin::where('id',$data['ser_id'])->value('deduct');
                    $temp = explode(',',$deduct);
                    $kou = $temp[1]??0;
                    if($kou>0){
                        //$bl=1-(100-$kou)*100;
                        $bl = 1-($kou/100);
                    }
                }
                $rea = ServiceCenMoney::where("svm_sid",$input['id'])->first();
                $type = ['','svm_deductprice','svm_adjustprice'];
                $typename = ['','补货金额','调整金额'];
                $price = $rea[$type[$input['type']]];
                if($input['type'] == 1 && $input['price'] > 0){
                    $input['price'] = 0-$input['price'];
                }
                $rea[$type[$input['type']]] = $input['price'];
                $poss['svm_actualprice'] = $rea['svm_allprice']+$rea['svm_deductprice']+$rea['svm_adjustprice'];
                $poss[$type[$input['type']]] = $input['price'];
                $res = ServiceCenMoney::where("svm_sid",$input['id'])->update($poss);
                $posa['pay_money'] = $poss['svm_actualprice'];
                $posa['apply_for_deduct'] = $poss['svm_actualprice']*$bl;
                $posa['pay_money'] = $poss['svm_actualprice'];
                if($input['type'] == 1){
                    $posa['deduct_money'] = 0-$input['price'];
                }
                $reb = ServiceCenter::where("id",$input['id'])->update($posa);
                if($res && $reb){
                    $this->insertingLog("编辑金额，",$input['wat_num'],"编辑".$typename[$input['type']].":".$price."->".$input['price']."，结算单号号：".$input['wat_num'],"服务中心账目管理",$request->ip(), $request->get('session_token')['admin_acc']);
                    return $this->success('操作成功');exit;
                }else{
                    return $this->error('操作失败', ErrorInc::MYSQL_FAILED);
                    return response()->json(['Data'=>'','ErrorCode'=>'2','ErrorMessage'=>'操作失败']);
                }
            }
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 查看、修改、上传 凭证
     * @param int type 操作类型1:查看;2:修改;3:上传
     * @param string wat_num 结算单号
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/10 16:33
     * |---------------------------------------------------------------------------------
    */
    public function invoice(Request $request){
        $input = $request->all();
        $session = $request->get("session_token");
        $checkKey = CommonService::checkKey(['type', 'wat_num'],$input);
        if($checkKey['code'] != 1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);
        }
        if(in_array($input['type'], [1,2,3])) {
            switch ( $input['type'] ){
                case 1:
                    $result = ServiceCenterService::getCredentialsPic($input);
                    break;
                case 2:
                    $result = ServiceCenterService::updateCredentialsPic($input , $session , $request->ip());
                    break;
                case 3:
                    $result = ServiceCenterService::insertCredentialsPic($input , $session , $request->ip());
                    break;
            }
            return $this->error($result['ErrorMessage'], $result['ErrorCode'],$result['Data']);exit;
        }else{
            return $this->error('参数错误：type', ErrorInc::FAILED_PARAM, []);
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 操作开票信息
     * @param type_inv  1:正常开票;2:累计开票;3:后续开票
     * @param id        数据id(1)
     * @param inv_note  发票号(1)
     * @param inv_num   快递单号(1)
     * @param inv_pic   图片(1)
     *
     * @param type(type=3先去请求是否有发票信息)
     * @param id   数据id(2)
     * @param inv_money   发票金额(2)
     * @param pay_money  账单金额（2）
     * @param inv_note   发票号(2)累计剩余
     * @param inv_notes   后续发票号(2)新添加
     * @param inv_num   快递单号(2)
     * @param inv_pic   图片(2)
     *
     * @param id 数据id(3)
     * @param inv_note 发票号(3)
     * @param inv_num 快递单号(3)
     * @param send   是否结算 1:是；2:否(默认)
     * @param inv_ids 可选账单的id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/10 20:12
     * |---------------------------------------------------------------------------------
    */
    public function collecTickets(Request $request){
        $input = $request->all();
        $session = $request->get("session_token");
        $checkKey = CommonService::checkKey(['type', 'id'],$input);
        if($checkKey['code'] != 1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);
        }
        if(in_array($input['type'], [1,2,3])) {
            switch ( $input['type'] ){
                case 1:
                    $result = ServiceCenterService::operationInvoice($input , $session , $request->ip());
                    break;
                case 2:
                    $result = ServiceCenterService::getAccumulateInvoice($input);
                    break;
                case 3:
                    $result = ServiceCenterService::getAdvanceInvoice($input);
                    break;
            }
            return $this->error($result['ErrorMessage'], $result['ErrorCode'],$result['Data']);exit;
        }else{
            return $this->error('参数错误：type', ErrorInc::FAILED_PARAM, []);
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取结款方余票
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/13 17:02
     * |---------------------------------------------------------------------------------
    */
    public function searchRemaining ( Request $request ){
        $db = Db::table("invoice_money");
        $db = $db->leftjoin('admin_infor','admin_infor.admin_id','=','ser_id');
        $list = CommonService::getMysqlData($db, ['status'=>1],['accountname','account','opeaccline','residue_money']);
        if($list){
            return $this->success('操作成功',$list);exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 查看订单详情
     * @param int state     订单状态(搜索)
     * @param int ser_id       服务中心id
     * @param string order_num     平台单号
     * @param string list_id       派工单号
     * @param string wat_num       结算单号
     * @param int p_id          销售平台
     * @param string shr_name      客户姓名
     * @param string shr_phone     客户电话
     * @param page          页数
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/4 16:47
     * |---------------------------------------------------------------------------------
     */
    public function search ( Request $request ){
        $input = $request->all();
        $input['state'] = 0;
        $input['source_type'] = 1;
        $session = $request->get("session_token");
        $data = SettlementService::getList($input, $session);
        if($data['ErrorCode']!=1){
            return $data;
        }else {
            $list = $data['Data'];
            if ($list['list']) {
                return $this->success('获取成功', $list);
                exit;
            } else {
                return $this->error('暂无数据', ErrorInc::DATA_EMPTY, $list);
                exit;
            }
        }
    }

    /**
     * 获取发票信息和导出
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/3/15
     */
    public function InvoiceInfo(Request $request){
        $input = $request->all();
        $session = $request->get('session_token');
        $db =  DB::table('invoice_money');

        $where = [];
       $where['status'] = 1;
       if($request->filled('accountname')&&$input['accountname']!=''){
           $where['accountname_like'] = $input['accountname'];
       }
        $is_excel = $input['is_excel']??0;
        if ($is_excel == 1) {
            DB::connection()->enableQueryLog();#开启执行日志
        }
        $where = CommonService::jointWhere($where);
       $list = $db->whereRaw($where)->leftJoin('admin_infor', 'invoice_money.ser_id', '=', 'admin_infor.admin_id')->select('accountname','account','opeaccline','residue_money')->get();
        $sqls = DB::getQueryLog()[0];
       // dump($sqls);exit;
        if ($list) {
            if ($is_excel == 1) {
                $exceout = new ExceloutService();
                if(!$sqls){
                    return $this->error('暂无数据或请检查SQL日志是否打开', ErrorInc::MYSQL_FAILED);
                }
                $lists = $exceout->getSqls($sqls)['list'];
                if($lists){
                    $sql = $exceout->getSqls($sqls)['sqls'];
                    $con_name = '账目中心发票导出';//控制器名称
                    $action = 'InvoiceExcel';//控制器
                    $field_data = $exceout->gainFields($session['id'],$action);
                    if (empty($field_data)) {
                        return $this->error('您暂时无导出权限', ErrorInc::MYSQL_FAILED);
                    }
                    return $exceout->createPlan($lists,$sql,500,$action,$con_name,$session['id'],$session['admin_acc'],$session['company_id']);
                }
            }
            return $this->success('获取成功', $list);
            exit;
        } else {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
            exit;
        }

    }

}
