<?php
/**
 * 用户服务
 *
 * @author lixiaolin
 * @Date: 2021/4/2
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Services\OrderService;
use App\Services\UserService;
use Validator;
use DB;
use Illuminate\Support\Facades\Log;

class InterFaceService
{
    public static $instance;
    protected $secretKey = '';

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    public static function validateOrderStore($input)
    {
        $rules = [
            'order_no' => [
                'required',
                'regex:/^[0-9a-zA-Z\_\-]+$/',
                'unique:orders,order_num'
            ],
            'p_id' => 'required',
            'shr_name' => 'required',
            'shr_phone' => [
                'required',
                'regex:/^[1][1,2,3,4,5,6,7,8,9][0-9]{9}$|^[1][1,2,3,4,5,6,7,8,9][0-9]{9}-[0-9]{4}$|^0\d{2,3}-?\d{7,8}$/'
            ],
            'shr_sheng' => 'required',
            'shr_shi' => 'required',
            'shr_xian' => 'required',
            'shr_adress' => 'required',
            'goods' => 'required'
        ];
        $message = [
            'sys_bh.required' => '登录名不能为空',
            'sys_bh.unique' => '系统单号已存在',
            'skb_bh.required' => '平台单号不能为空',
            'skb_bh.regex' => '平台单号格式错误',
            'skb_bh.unique' => '平台单号已存在',
            'pt_id.required' => '请选择销售平台',
//            'order_time.required'=> '创建时间(下单时间)不能为空',
            'shr_name.required' => '收件人不能为空',
            'shr_phone.required' => '联系电话不能为空',
            'shr_phone.regex' => '手机号格式错误',
            'shr_sheng.required' => '请选择省',
            'shr_shi.required' => '请选择市',
            'shr_xian.required' => '请选择县',
            'shr_adress.required' => '详细地址不能为空',
            'goods.required' => '请选择商品',
            'pay_type.required' => '请选择支付类型',
        ];
        $Validator = Validator()->make($input, $rules, $message);
        if ($Validator->fails()) {
            return false;
            $error = CommonService::validatorToString($Validator);
            return $error;
        } else {
            return false;
        }
    }

    public static function verifyApiParam($input)
    {
        if ($input['signature']) {

        } else {

        }
    }

    public static function getDefaultUser()
    {
        $user = [];
        $user['id'] = 1;
        $user['admin_acc'] = '系统同步';
        $user['admin_name'] = '系统同步';
        $user['admin_groupnew'] = '1';
//        $user['']= '';

        return $user;
    }
}
