<?php

/**
 * 文件名称（处理图片）
 * 文件简单描述（对图片文件进行相应处理）
 * @author DouBin
 * @Date: 2021/9/10
 * @Time: 18:15
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use OSS\OssClient;
use OSS\Core\OssException;

class DealPicService extends Service{
    /**|---------------------------------------------------------------------------------
     * @name 添加图片
     * @param string $imge 图片文件base64
     * @param string $path 文件路径
     * @retrun /multitype:array
     * @author dou 2021/9/10 18:18
     * |---------------------------------------------------------------------------------
    */
    public static function addPic ( $imge , $path ){
        if (preg_match('/(?<=\/)[^\/]+(?=\;)/',$_POST['file'],$pregR)) $streamFileType ='.' .$pregR[0];//读取扩展名，如果你的程序仅限于画板上来的，那一定是png，这句可以直接streamFileType 赋值png
        preg_match('/(?<=base64,)[\S|\s]+/',$_POST['file'],$streamForW);
        $dir=rtrim($_POST['path'],'/');
        //$dir='./Feekimages/'.date('Ym');
        if(!is_dir($dir)){
            mkdir ($dir);
        }
        $streamFileType = $streamFileType??'jpg';
        $streamFilename=self::creact_url($dir,$streamFileType);
        if (file_put_contents($streamFilename['streamFilename'],base64_decode($streamForW[0]))){
            $file=$streamFilename['streamFilename'];
            $file = self::addOss($file, $dir);
            return $file;
        }else{
            return false;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 上传oss
     * @param string $file 本体图片文件路径
     * @param string $dir oss定义路径
     * @retrun /multitype:string
     * @author dou 2021/9/10 19:03
     * |---------------------------------------------------------------------------------
    */
    public static function addOss ( $file , $dir ){
        require_once 'aliyunoss/autoload.php';
        $accessKeyId = "LTAI4GAhRHWDjheUxeUQCE42";//去阿里云后台获取秘钥
        $accessKeySecret = "3SYbAgutMNDIHk5c7ELEn3aBig5fUV";//去阿里云后台获取秘钥
        $endpoint = "http://oss-cn-beijing.aliyuncs.com";//你的阿里云OSS地址
        $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
        try{
            $filename = uniqid().'1.jpeg';
            $bucket= "sdkb";//oss中的文件上传空间
            $object =  'test/'.$dir.'/'.$filename;//想要保存文件的名称
            $res=$ossClient->uploadFile($bucket,$object,$file);
            if($res['info']['url']!=''){
                $url=ltrim($file,"/");
                unlink($url);
                $file= "http://img.sudianwang.com/".$object;
            }
        }catch (OssException $e) {

        }
        return $file;
    }

    /**|---------------------------------------------------------------------------------
     * @name 生成图片本地文件路径
     * @param string $upPath 文件待存储位置
     * @param string $streamFileType 文件后缀名
     * @retrun /multitype:array
     * @author dou 2021/9/10 18:56
     * |---------------------------------------------------------------------------------
    */
    public static function creact_url($upPath,$streamFileType){
        $streamFileRand = date('YmdHis').rand(1000,9999);    //产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        //$upPath='./Feekimages/'.date('Ym');
        $streamFilename = $upPath."/".$streamFileRand .$streamFileType;

        if(file_exists($streamFilename)){
            self::creact_url($upPath,$streamFileType);
        }else{
            $data['streamFileRand']=$streamFileRand .$streamFileType;
            $data['streamFilename']=$streamFilename;
            return $data;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 删除图片
     * @param string $upPath 文件待存储位置
     * @retrun /multitype:array
     * @author dou 2021/9/10 19:25
     * |---------------------------------------------------------------------------------
    */
    public static function deletPic ( $upPath ){
        if(strstr($upPath,'http://img.sudianwang.com')){
            require_once("./aliyunoss/autoload.php");
            $accessKeyId = "LTAI4GAhRHWDjheUxeUQCE42";//去阿里云后台获取秘钥
            $accessKeySecret = "3SYbAgutMNDIHk5c7ELEn3aBig5fUV";//去阿里云后台获取秘钥
            $endpoint = "http://oss-cn-beijing.aliyuncs.com";//你的阿里云OSS地址
            $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
            try{
                $filename = uniqid().'.jpeg';
                $bucket= "sdkb";//oss中的文件上传空间
                $object = "SDKB".explode('SDKB', $upPath)[1];
                $res=$ossClient->uploadFile($bucket,$object);
            }catch (OssException $e) {

            }
        }else{
            $url=ltrim($upPath,"/");
            unlink($url);
        }
        return true;
    }
}
