<?php

namespace App\Http\Controllers\InstallPerson;

use App\Http\Controllers\Common\CommonController;
use App\Services\ExceloutService;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Excel;
use Validator;
use App\Models\InstallPerson;
use App\Models\Admin;
use App\Models\Certification;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use App\Http\Controllers\BaseController;
use App\Services\BmmcService;
use App\Services\RedisService;
/**
 * @name 安装技师管理
 * Class InstallPersonController
 * @package App\Http\Controllers\InstallPerson
 */
class InstallPersonController extends BaseController
{
	/**
	 * @name 列表页
     * @param check_code    检验码
     * @param install_name  安装人姓名
     * @param install_phone 安装人电话
     * @param verify_type   转账状态1:未验证; 2:等待管理确定; 3:已验证
     * @param page          页数
	 * @param Request $request
	 * @return \Illuminate\Http\JsonResponse|\BlueCity\Core\Controllers\mixed
	 * @author du 2021年7月16日上午15:41:24
	 */
    public function index (Request $request)
    {
	    $session = $request->get('session_token');
        $installperson = new InstallPerson();
        $company_name = $request->input('company_name',0);
        if ($request->input('Theshy') == 4){
            $installperson = $installperson->where('delet_y',1);
        }elseif ($request->input('Theshy') == 1){//未认证
            $installperson = $installperson->where('verify_type',1)->where('delet_y',1);
        }elseif ($request->input('Theshy') == 2){//待审核
            $installperson = $installperson->where('verify_type',2)->where('delet_y',1);
        }elseif ($request->input('Theshy') == 3){//已验证
            $installperson = $installperson->where('verify_type',3)->where('delet_y',1);
        } else {
            $installperson = $installperson->where('delet_y',1);
        }
        if ($request->filled('check_code')){//检验码
            $installperson = $installperson->where('check_code','like','%'.$request->input('check_code').'%');
        }
        if ($request->filled('install_name')){//安装人姓名
            $installperson = $installperson->where('install_name','like','%'.$request->input('install_name').'%');
        }
        if ($request->filled('install_phone')){//安装人电话
            $installperson = $installperson->where('install_phone','like','%'.$request->input('install_phone').'%');
        }
        if ($request->filled('company_name_id')){//服务中心id
            $installperson = $installperson->where('admin_id',$request->input('company_name_id'));
        }
        if ($session['admin_groupnew'] != 7) {
            $installperson->where('company_id', $session['company_id']);
        }
        $page_size = (int)$request->input('page_size',20);
        $page = (int)$request->input('page',1);
        if($page<1){
            $page = 1;
        }
       // $offset = ($page-1)*$page_size;
        $adminArr = Admin::where("admin_group",'2')->pluck('company_name','id')->toArray();
        if ($request->input('is_excel') == 1) {
            DB::connection()->enableQueryLog();#开启执行日志
        }

//        if ($session['admin_groupnew'] != 7){//管理员可以看全部
//            $installperson = $installperson->where('company_id',$session['company_id']);
//        }

        $paginate = $installperson->select('id','cd_ids','check_code','install_name','install_phone','install_remark','install_address','installation','install_is_type','create_time','admin_id','all_show','install_is_type','install_pid','company_id','delet_y','is_shman','affiliation')->orderBy('id','ASC')->paginate($page_size);
     	$list = self::dataToArray($paginate->items());

        //导出 start
        if ($request->input('is_excel') == 1) {
            $sqls = DB::getQueryLog()[1];//sql数组l
            $excel = new CommonController();
            return $excel->getExcelOut($request->input('Pri_id'), $sqls, $session);
        }
        //导出 end

        $count_qb = InstallPerson::count();//总数
        $count_wrz = InstallPerson::where('delet_y',1)->where('verify_type',1)->count();//未认证
        $count_dsh = InstallPerson::where('delet_y',1)->where('verify_type',2)->count();//待审核
        $count_yyz = InstallPerson::where('delet_y',1)->where('verify_type',3)->count();//已验证
        $count_xsq = InstallPerson::where('delet_y',3)->count();//新申请

        $data['show_Menu'] = [
            ['show_name'=>'全部','status'=>4,'show_num'=> $count_qb,'checked'=>true],
            ['show_name'=>'未认证','status'=>1,'show_num'=> $count_wrz],
            ['show_name'=>'待审核','status'=>2,'show_num'=>$count_dsh],
            ['show_name'=>'已验证','status'=>3,'show_num'=>$count_yyz],
            ['show_name'=>'新申请','status'=>5,'show_num'=>$count_xsq]
        ];
        $all_button = BmmcService::whereButton($request->input('token'),$request->input('Pri_id'));
        $export = BmmcService::getTopButton('addInstallPerson,export','', $all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮
        if ($list){
            foreach ($list as $k=>$v){
            	$button = [];
            	if ($v['install_pid'] == 0){
            	 	$button[] = 'installBranch';
                 }
                $button[] = 'editInstallPerson,lookPassword,delInstallPerson,resetPassword';
            	$button = BmmcService::getListButton($button,$all_button);
            	$list[$k]['button_one'] = $button['button_one']??[];
            	$list[$k]['button_two'] = $button['button_two']??[];
            	$list[$k]['button_three'] = $button['button_three']??[];
                if (isset($adminArr[$v['admin_id']])){
                    $list[$k]['company_name'] = $adminArr[$v['admin_id']];
                }else{
                    $list[$k]['company_name'] = "";
                }
            }
            $data['list'] = $list;
     		$data['page'] = [
     			'count' => $paginate->total(),
                'page'=>$paginate->currentPage(),
                'page_size'=>$page_size,
                'allPage'=>$paginate->lastPage()
     		];
           return $this->success('获取成功', $data);
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$data);exit;
        }
    }





    /**
     * @name 添加安装人
     * @param cd_ids         品类IDS以逗号隔开1,5,6
     * @param admin_id         所属服务商id
     * @param install_name     安装人姓名
     * @param install_phone    安装人电话
     * @param install_address  安装人地址
     * @param install_remark   安装备注
     * @param installation     安装费
     * @param is_shman         是否为店长 1：否；2：是
     * @param affiliation      从属类型 1:SD 2:VPE
     * @param lolatude_on      经纬度(,分隔)
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed|\Illuminate\Http\JsonResponse
     * @author du 2021年7月16日上午15:06:49
     */
    public function addInstallPerson (Request $request)
    {
        $input = $request->only('install_name','install_phone','admin_id','cd_ids','install_remark','installation','is_shman','affiliation','lolatude_on');

		$rules = [
				'admin_id' => 'required|',
				'cd_ids' => 'required|',
				'install_name' => 'required|string',
				'install_phone' => [
						'required',
						'regex:/^[1](([3][0-9])|([4][5-9])|([5][0-3,5-9])|([6][5,6])|([7][0-8])|([8][0-9])|([9][1,8,9]))[0-9]{8}$/'
				]
		];
		$message = [
				'admin_id.required' => "所属服务商id不能为空",
				'cd_ids.required' => "品类ID不能为空",
				'install_phone.required' => "电话不能为空",
				'install_phone.regex' => "电话号码格式错误"
		];
		$Validator = Validator::make ( $input, $rules, $message );

		if ($Validator->fails ()) {

			return $this->error ( $Validator->errors ()->first (), ErrorInc::INVALID_PARAM, [ ] );
			exit ();
		}


        $admin_id = $input['admin_id'];

        $exs =  InstallPerson::where('admin_id',$admin_id)->where('install_phone',$input['install_phone'])->value('id');
        if($exs){
        	return $this->error('该技师已存在', ErrorInc::REPEAT_SUBMIT, []);exit;
        }

       //获取CODE
       $arr['check_code'] = $this->getCheckCode($admin_id);
       if(!$arr['check_code']){
       	return $this->error('服务商不存在', ErrorInc::INVALID_PARAM, []);exit;
       }
        $is_shman = $input['is_shman']??'1';
        //is_shman = 2 表示添加技师
        if ($is_shman == 2) {
            //查看是否有店长，若存在，将原来的店长改为技师
            $exit_id = InstallPerson::where('admin_id',$admin_id)->where('is_shman',2)->value('id');
            InstallPerson::where('id',$exit_id)->update(['is_shman' => 1, 'install_pid' => 0]);
        } else {
            //查看是否有技师，没有，则将本次的添加的为店长
            $exit_id = InstallPerson::where('admin_id',$admin_id)->value('id');
            if (!$exit_id) {
                $is_shman = 2;
            }
        }
        $arr['cd_ids'] = $input['cd_ids'];
        $arr['install_name'] = $input['install_name'];
        $arr['install_phone'] = $input['install_phone'];
        $arr['install_address'] = $input['install_address']??'';
        $arr['install_remark'] = $input['install_remark']??'';
        $arr['installation'] = $input['installation']??0;
        $arr['admin_id'] = $admin_id;
        $arr['company_id'] = $request->get('session_token')['company_id'];
        $arr['is_shman']   = $is_shman;
        $arr['affiliation']   = $input['affiliation']??'1';
        $arr['install_password1'] = $arr['check_code'];
        $arr['install_password'] = md5($arr['check_code']);
        $arr['plate_num'] = $input['plate_num']??'';
        $insRes = InstallPerson::insert($arr);
        if ($insRes){
        	if(RedisService::redisGet('ipList'.$admin_id)){
        		$ipLists = $this->ipList($admin_id);
        		$ipList = json_encode($ipLists);
        		RedisService::redisSet('ipList'.$admin_id,$ipList);
        	}
            $this->insertingLog('添加，','',$input['install_name'],'技师管理',$request->ip(),$request->get('session_token')['admin_acc']);
            return $this->success('添加成功', []);exit;
        }else{
        	return $this->error('添加失败', ErrorInc::ELASTIC_FAILED);
        }
    }

    /**
     * @name 编辑安装人
     * @param type  请求类型 1:编辑展示; 2:编辑动作;
     * @param admin_id         所属服务商id
     * @param install_name     安装人姓名
     * @param install_phone    安装人电话
     * @param install_address  安装人地址
     * @param install_remark   安装备注
     * @param installation     安装费
     * @param is_shman         是否为店长 1：否；2：是
     * @param affiliation      从属类型 1:SD 2:VPE
     * @param all_show     是否显示全部订单1：否；2：是
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年7月19日上午10:06:00
     */
    public function editInstallPerson (Request $request)
    {
        if ($request->filled('id')&&$request->filled('type')){
            $id = intval($request->input('id'));
            if ($request->input('type') == '1'){
            	//修改展示
                $res = InstallPerson::where('id',$id)->select('id','check_code','install_name','install_phone','install_is_type','install_remark','install_address','installation','admin_id','cd_ids')->first();
                $company_name = Admin::where('id',$res['admin_id'])->value('company_name');
                $res['company_name'] = $company_name;
                if ($res){
                	return $this->success('获取成功', $res);exit;
                }else {
                	return $this->error('获取失败', ErrorInc::MYSQL_FAILED, []);exit;
                }
            }elseif ($request->input('type') == '2'){
            	$input = $request->only('install_name','install_phone','admin_id','cd_ids');
                $rules = [
                		'admin_id' => 'required|',
                		'cd_ids' => 'required|',
                		'install_name' => 'required|string',
                		'install_phone' => [
                				'required',
                				'regex:/^[1](([3][0-9])|([4][5-9])|([5][0-3,5-9])|([6][5,6])|([7][0-8])|([8][0-9])|([9][1,8,9]))[0-9]{8}$/'
                		]
                ];
                $message = [
                		'admin_id.required' => "所属服务商id不能为空",
                		'cd_ids.required' => "品类ID不能为空",
                		'install_phone.required' => "电话不能为空",
                		'install_phone.regex' => "电话号码格式错误"
                ];
                $Validator = Validator::make ( $input, $rules, $message );

                if ($Validator->fails ()) {

                	return $this->error ( $Validator->errors ()->first (), ErrorInc::INVALID_PARAM, [ ] );
                	exit ();
                }

                $admin_id = $input['admin_id'];

               /*  $exs =  InstallPerson::where('admin_id',$admin_id)->where('install_phone',$input['install_phone'])->value('id');
                if($exs){
                	return $this->error('该技师已存在', ErrorInc::REPEAT_SUBMIT, []);exit;
                } */


                $is_shman = $request->input('is_shman')??'1';
                if ($request->input('is_shman') == 2) {
                    //查看是否有店长，若存在，将原来的店长改为技师
                    $exit_id = InstallPerson::where('admin_id',$admin_id)->where('is_shman',2)->value('id');
                    InstallPerson::where('id',$exit_id)->update(['is_shman' => 1, 'install_pid' => 0]);
                } else {
                    //查看是否有技师，没有，则将本次的添加的为店长
                    $exit_id = InstallPerson::where('admin_id',$admin_id)->value('id');
                    if (!$exit_id) {
                        $is_shman = 2;
                    }
                }

                $arr['cd_ids'] = $input['cd_ids'];
                $arr['install_name'] = $input['install_name'];
                $arr['install_phone'] = $input['install_phone'];
                $arr['install_address'] = $request->input('install_address')??'';
                $arr['install_remark'] = $request->input('install_remark')??'';
                $arr['installation'] = $request->input('installation')??'40';
                $arr['install_is_type'] = $request->input('install_is_type')??'1';
//                $arr['company_id'] = $request->input('company_id')??0;
                $arr['is_shman']   = $is_shman;
                $arr['affiliation']   = $request->input('affiliation');
                $arr['plate_num'] = $input['plate_num']??'';

                $upRes = InstallPerson::where('id',$id)->update($arr);
                if ($upRes){

                	if(RedisService::redisGet('ipList'.$admin_id)){
                		$ipLists = $this->ipList($admin_id);
                		$ipList = json_encode($ipLists);
                		RedisService::redisSet('ipList'.$admin_id,$ipList);
                	}

                    $content = '编辑安装人员，技师id号'.$id;
                    $this->insertingLog('编辑，','',$content,'技师管理',$request->ip(),$request->get('session_token')['admin_acc']);
                    return $this->success('编辑成功', []);exit;
                }else {
                	return $this->error('编辑失败', ErrorInc::MYSQL_FAILED, []);
                }
            }
        }else{
        	return $this->error(' 参数错误', ErrorInc::INVALID_PARAM, []);exit;

        }
    }


    /**
     * @name 检测门店是否已绑定
     * @param install_id id号
     * @param id      服务商id
     * @param Request $request
     * @author du 2021年7月19日上午10:06:46
     */
    public function onCompany (Request $request)
    {
    	if (!$request->filled('id') && !$request->filled('install_id')){
    		$this->error(' 参数错误', ErrorInc::INVALID_PARAM, []);exit;
    	}
        $res = InstallPerson::whereRaw("id!='".$request->input('install_id')."' and company_id='".$request->input('id')."'")->select('id','check_code','install_name')->first();
        if($res){
            $data['install_name']=$res['install_name'];
            $data['check_code']=$res['check_code'];
            return $this->success('门店已绑定', $data);exit;
        }else{
        	return $this->success('门店可绑定', []);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取门店列表
     * @param id 服务中心id
     * @param install_id 数据id
     * @return \Illuminate\Http\JsonResponse

     * |---------------------------------------------------------------------------------
     */
/*     public function companyList (Request $request)
    {
        if ($request->filled('id') && !$request->filled('install_id')){
            $id = $request->input('id');
            $company_ids = InstallPerson::where('company_id','!=',0)->pluck('company_id');
            $companyname = Admin::where('id',$id)->select('children_id','owner')->first();//所属服务商信息
            $admin = New Admin();
            if($companyname['children_id']!=''){
                $company = $admin->whereRaw("id in (".$companyname['children_id'].",".$id.")")->select('id','company_name')->get();
            }else{
                $company = $admin->where('id',$id)->select('id','company_name')->get();
            }
            if($company){
            	return $this->success('获取成功', $company);

            }else{
            	return $this->error('该服务商无下属门店', ErrorInc::DATA_EMPTY,[]);exit;
            }
        }elseif($request->filled('id') && $request->filled('install_id')){
            $install_id = $request->input('install_id');
            $id = $request->input('id');
            $company_ids = InstallPerson::whereRaw("id!='".$install_id."' and company_id='".$id."'")->pluck('company_id');

            $companyname = Admin::where('id',$id)->select('children_id','owner')->first();//所属服务商信息
            $admin = New Admin();
            if ($company_ids){
                $admin = $admin->whereNotIn('id',$company_ids);
            }
            if($companyname['children_id']!=''){
                $company = $admin->whereRaw("id in (".$companyname['children_id'].",".$id.")")->select('id','company_name')->get();
            }else{
                $company = $admin->where('id',$id)->select('id','company_name')->get();
            }
            if($company){
                return $this->success('获取成功', $company);
            }else{
               return $this->error('该服务商无下属门店', ErrorInc::DATA_EMPTY,[]);exit;
            }
        }

    } */


    /**
     * @name 查看密码
     * @param id 技师id号
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年7月19日下午1:37:46
     */
    public function lookPassword (Request $request)
    {
        if ($request->filled('id')){
            $id = intval($request->input('id'));
            $res = InstallPerson::where('id',$id)->select('id','check_code','install_name','install_phone','install_password1')->first();
            if ($res){
            	return $this->success('获取成功',$res);exit;
            }else{
            	return $this->error('暂无数据', ErrorInc::DATA_EMPTY,[]);exit;
            }
        }else{
        	return $this->error('参数错误', ErrorInc::INVALID_PARAM, []);exit;
        }
    }



    /**|---------------------------------------------------------------------------------
     * @name 显示全部订单
     * @param id 安装人id号
     * @param type 是否显示全部订单 1:否;2:是;
     * @return \Illuminate\Http\JsonResponse

     * |---------------------------------------------------------------------------------
     */
/*     public function allShow (Request $request)
    {
        if ($request->has('id')){
            $id = $request->input('id');
            $poss['all_show'] = $request->input('type');
            InstallPerson::where('id',$id)->update($poss);
        }else {
           return $this->error('参数错误', ErrorInc::INVALID_PARAM, []);exit;
        }
    }
 */


    /**
     * @name 删除安装人员
     * @param id 安装人id号
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年7月27日下午5:21:42
     */
    public function delInstallPerson (Request $request)
    {
        if ($request->filled('id')){
            $id = intval($request->input('id'));
            $info = InstallPerson::where('id',$id)->first();
            $delRes = InstallPerson::where('id',$id)->update(['delet_y'=>2]);
            if ($delRes){
                $content = $info['install_name'].'('.$info['check_code'].')';
                //日志
                $this->insertingLog('删除，','',$content,'安装人员管理',$request->ip(),$request->get('session_token')['admin_acc']);
                return $this->success('删除成功', []);exit;
            }else{
            	return $this->error('删除失败', ErrorInc::MYSQL_FAILED, []);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::INVALID_PARAM, []);exit;
        }
    }


    /**
     * @name  重置密码
     * @param id  数据id
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年7月19日下午1:42:03
     */
    public function resetPassword (Request $request)
    {
        if ($request->filled('id')){
            $id = intval($request->input('id'));
            $check_code = InstallPerson::where('id',$id)->value('check_code');
            if ($check_code){
                $info['install_password'] = md5($check_code);
                $info['install_password1'] = $check_code;
                $result = InstallPerson::where('id',$id)->update($info);
                if ($result){
                	return $this->success('重置成功', []);
                    exit;
                }else{
                	return $this->error('重置失败', ErrorInc::MYSQL_FAILED, $check_code);
                    exit;
                }
            }else{
            	return $this->error('无此用户', ErrorInc::DATA_EMPTY, []);
                exit;
            }
        }else{
           return $this->error('参数错误', ErrorInc::INVALID_PARAM, []);exit;

        }
    }

    /**
     * @name  添加下属技师
     * @param install_name    姓名
     * @param install_phone   电话
     * @param install_remark  备注
     * @param install_address 地址
     * @param install_is_type 1:启用;2:停用
     * @param cd_ids 品类ID 逗号隔开的
     * @param Request $request
     * @throws ApiException
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年7月19日下午2:31:07
     */
    public function installBranch (Request $request)
    {
        $input = $request->only('id','install_name','install_phone','cd_ids','install_remark','install_address','install_is_type');
        if (!$request->filled('id')){
            return $this->error('参数错误', ErrorInc::INVALID_PARAM, []);exit;
        }
        $rules = [
        		'cd_ids'  =>  'required|',
            	'install_name'  =>  'required|',
        		'install_phone' =>[
        				'required',
        				'regex:/^[1](([3][0-9])|([4][5-9])|([5][0-3,5-9])|([6][5,6])|([7][0-8])|([8][0-9])|([9][1,8,9]))[0-9]{8}$/'
            ]
        ];
        $message = [
        		'cd_ids.required'  =>  "品类ID不能为空",
            	'install_name.required'  =>  "姓名不能为空",
           	 	'install_phone.required' =>  "电话不能为空",
            	'install_phone.regex'    =>  "电话号码格式错误",
        ];

        $Validator = Validator::make($input,$rules,$message);

        if($Validator->fails()){
        	 return $this->error($Validator->errors()->first(), ErrorInc::INVALID_PARAM, []);exit;
        }

        $install = InstallPerson::where('id',$input['id'])->select('admin_id','install_pid')->first();

        $exs =  InstallPerson::where('admin_id',$install['admin_id'])->where('install_phone',$input['install_phone'])->value('id');
        if($exs){
        	return $this->error('该技师已存在', ErrorInc::REPEAT_SUBMIT, []);exit;
        }

        $arr['cd_ids'] = $input['cd_ids'];
        $arr['install_name']  = $input['install_name'];
        $arr['install_phone'] = $input['install_phone'];
        $arr['install_remark'] = $input['install_remark']??'';
        $arr['install_address'] = $input['install_address']??'';
        $arr['admin_id'] = $install['admin_id'];
        $arr['install_is_type'] = $input['install_is_type']?? 1;//停用/启用 默认启用
        $arr['install_pid'] = $install['install_pid'] . ',' . $input['id'];//父类id
        $arr['company_id'] = $install['admin_id'];
        $arr['create_time'] = date("Y-m-d H:i:s");

        $arr['installation'] = $request->input('installation')??'40';

        //生成技师工号
        //获取CODE
        $arr['check_code'] = $this->getCheckCode($install['admin_id']);
        if(!$arr['check_code']){
        	return $this->error('服务商不存在', ErrorInc::INVALID_PARAM, []);exit;
        }

        $arr['install_password'] = md5($arr['check_code']);
        $arr['install_password1'] = $arr['check_code'];
        //执行添加操作
        $res = InstallPerson::insert($arr);
        if ($res){
        	if(RedisService::redisGet('ipList'.$install['admin_id'])){
        		$ipLists = $this->ipList($install['admin_id']);
        		$ipList = json_encode($ipLists);
        		RedisService::redisSet('ipList'.$install['admin_id'],$ipList);
        	}
        	return $this->success('添加成功', []);exit;

        } else {
        	return $this->error('添加失败', ErrorInc::MYSQL_FAILED, []);exit;
        }
    }

    /**
     * 获取搜索技师列表
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年7月16日下午4:53:33
     */
    public function ipSearchList(Request $request){
    	if(!$request->filled('serId')){
    		return $this->error('参数错误', ErrorInc::INVALID_PARAM, []);exit;
    	}
    	$serId = $request->input('serId');
     	if(RedisService::redisGet('ipList'.$serId)){
     		//echo 1;
     		$ipList = RedisService::redisGet('ipList'.$serId);
     		if($ipList){
     			return $this->success('获取成功', $ipList);
     		}else{
     			return $this->error('暂无数据', ErrorInc::DATA_EMPTY, []);
     		}
     	}else{
     		//echo 2;
     		$ipLists = $this->ipList($serId);
     		$ipList = json_encode($ipLists);
     		RedisService::redisSet('ipList'.$serId,$ipList);
     		if($ipLists){
     			return $this->success('获取成功',$ipLists);
     		}else{
     			return $this->error('暂无数据', ErrorInc::DATA_EMPTY, []);
     		}

     	}
     }

    /**
     * 从数据库中获取全部技师
     * @return array
     * @author du 2021年7月16日下午4:34:22
     */
    public function ipList($serId){
    	$ipList = InstallPerson::where('delet_y',1)->where('admin_id',$serId)->select('id','check_code','install_name')->get();
    	return $ipList;
    }

    /**
     * 获取code值
     * @param unknown $serId
     * @return \BlueCity\Core\Controllers\mixed|string
     * @author du 2021年7月19日下午3:26:01
     */
    public function getCheckCode($serId){
        $certification_num = Certification::where('ser_id',$serId)->value('certification_num');
        if(!$certification_num){
            return false;
        }
    	$check_code = InstallPerson::whereRaw("admin_id='".$serId."' and check_code>10000000 and check_code<1000000000 and check_code like '".$certification_num."%'")->orderBy('check_code','DESC')->limit('1')->value("check_code");
    	$length = strlen($check_code);
    	if(in_array($length,[8,9])){
    		$num = rand(5,99);
    		$che = $check_code+$num;
    		$bin = strpos($che,"4");
    		if($bin){
    			$code = str_replace("4",'5',$che);
    		}else{
    			$code = $che;
    		}
    	}else{
    		$check_code = InstallPerson::whereRaw("check_code like '".$certification_num."%'")->orderBy('check_code','DESC')->limit('1')->value("check_code");
            $length = strlen($check_code);
            if(in_array($length,[8,9])){
                $num = rand(5,99);
                $che = $check_code+$num;
                $bin = strpos($che,"4");
                if($bin){
                    $code = str_replace("4",'5',$che);
                }else{
                    $code = $che;
                }
            }else {
                $code = $certification_num . "1001";
            }

    	}

    	return $code;
    }

    /**|---------------------------------------------------------------------------------
     * @name  通过考试
     * @param id  数据id
     * @return \Illuminate\Http\JsonResponse

     * |---------------------------------------------------------------------------------
     */
/*     public function setExams (Request $request)
    {
        if ($request->filled('id')) {
            $exit = DB::table('install_tolist')->where('lts_installid',$request->input('id'))->first();
            if ($exit) {
                return response()->json(['Data' => '', 'ErrorCode' => 4, 'ErrorMessage' => '该技师已通过考试，无需重复提交']);
                exit;
            }
            $result = DB::table('install_tolist')->insert([
                'lts_topic'     => '厂家提供',
                'lts_installid' => $request->input('id'),
                'lts_time'      => date('Y-m-d H:i:s'),
                'lts_num'       => 10,
                'lts_type'      => 1,
                'lts_ip'        => $request->ip(),
            ]);

            if ($result) {
                return response()->json(['ErrorCode' => 1, 'ErrorMessage' => '操作成功']);
                exit;
            } else {
                return response()->json(['ErrorCode' => 2, 'ErrorMessage' => '操作失败']);
                exit;
            }
        } else {
            throw new ApiException('参数错误');
        }
    } */

}
