<?php

namespace App\Http\Controllers\Common;
use App\Http\Controllers\BaseController;
use App\Services\CommonService;
use App\Services\PjBrandsService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use App\Models\GoodsBrand;
use Validator;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\BmmcService;
//use Illuminate\Support\Facades\Redis;
use App\Services\RedisService;
/**
 * @name 品牌管理
 * Class GoodsBrandController
 * @package App\Http\Controllers\Common
 */
class GoodsBrandController extends BaseController
{
	/**
	 * @name 列表页
	 * @param Request $request
	 * @author du 2021年7月19日下午6:00:55
	 */
    public function index (Request $request)
    {
        $page_size = $request->input('page_size',10);
        $page = $request->input('page',1);
        if($page<1){
        	$page = 1;
        }
        $paginate = new GoodsBrand();
        $paginate = $paginate->where("company_id",$request->get('session_token')['company_id']);
        $paginate = $paginate->OrderBy('sord','ASC')->paginate($page_size);
        $list = self::dataToArray($paginate->items());

        $all_button = BmmcService::whereButton($request->input('token'),$request->input('Pri_id'));
        $export = BmmcService::getTopButton('addGoodsBrand','', $all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮
        if ($list){

        	foreach ($list as $k=>$v){

        		$button = [];
        		if ($v['del_flag'] == 1){
        			$button[] = 'editGoodsBrandDelFlag';
        		}elseif($v['del_flag'] == 2){
        			$button[] = 'editGoodsBrandDelFlagQ';
        		}
        		$button[] = 'editGoodsBrand';
        		$button = BmmcService::getListButton($button,$all_button);

        		$list[$k]['button_one'] = $button['button_one']??[];
        		$list[$k]['button_two'] = $button['button_two']??[];
        		$list[$k]['button_three'] = $button['button_three']??[];
        	}
        	//返回数据
        	$data['list'] = $list;
        	$data['page'] = [
        		'count' => $paginate->total(),
                'page'=>$paginate->currentPage(),
                'page_size'=>$page_size,
                'allPage'=>$paginate->lastPage()
        	];
        	return $this->success('获取成功', $data);
        }else{
        	return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$data);
        }
    }

    /**
     * @name 添加品牌
     * @param brand_name 品牌名称
     * @param sord       首字母
     * @param brand_remark  公司名称备注
     * @param brand_dress  公司地址
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed|\Illuminate\Http\JsonResponse
     * @author du 2021年7月20日上午8:34:03
     */
    public function addGoodsBrand (Request $request)
    {
        $input = $request->only('brand_name','sord','brand_remark','brand_dress');
        $session = $request->get('session_token');
        $ip = $request->ip();
        $return = PjBrandsService::addGoodsBrand($input, $session, $ip);
        return $this->error($return['ErrorMessage'], $return['ErrorCode'], []);
    }

    /**
     * @name 编辑品牌
     * @param id           品牌id号
     * @param brand_name   品牌名称
     * @param sord         首字符排序
     * @param brand_remark 备注公司名称
     * @param brand_dress  厂址
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年7月20日上午9:19:40
     */
    public function editGoodsBrand (Request $request)
    {
        if(!$request->filled('id')){
        	return $this->error(' 参数错误', ErrorInc::INVALID_PARAM, []);exit;
        }

        $id = intval($request->input('id'));

        if($request->input('type') == '1'){ //修改展示
        	$res = GoodsBrand::where('id',$id)->first();
        	if($res){
        		return $this->success('获取成功', $res);exit;
        	}else{
        		return $this->error('暂无数据', ErrorInc::DATA_EMPTY, []);exit;
        	}
        }elseif($request->input('type') == '2'){
        	//编辑

	        $input = $request->only('brand_name','sord','brand_remark','brand_dress');
	        $rules = [
	        		'brand_name' => 'required|',
	        		'sord' => 'required|',
	        		'brand_remark' => 'required|string',
	        ];
	        $message = [
	        		'brand_name.required' => "品牌名称不能为空",
	        		'sord.required' => "首字母不能为空",
	        		'brand_remark.required' => "备注公司名称不能为空",
	        ];
	        $Validator = Validator::make ( $input, $rules, $message );
	        if ($Validator->fails ()) {
	        	return $this->error ( $Validator->errors ()->first (), ErrorInc::INVALID_PARAM,[]);
	        	exit();
	        }
        	$brand_name = $input['brand_name'];
        	$sord = $input['sord'];
        	$brand_remark = $input['brand_remark'];
        	$brand_dress =$input['brand_dress']??'';
        	$info = GoodsBrand::where('id',$id)->first();
        	$search = GoodsBrand::where('brand_name',$input['brand_name'])->where('id','!=',$id)->where('company_id',$request->get('session_token')['company_id'])->value('id');
        	if($search){
        		return $this->error('该商品品牌已存在', ErrorInc::REPEAT_SUBMIT, []);exit;
        	}
        	$upres = GoodsBrand::where('id',$id)->update(['brand_name'=>$brand_name,'sord'=>$sord,'brand_remark'=>$brand_remark,'brand_dress'=>$brand_dress]);
        	if($upres){
        		//更新redis内容
        		$gbLists = PjBrandsService::gbList();
        		$gbList = json_encode($gbLists);
        		RedisService::redisSet('gbList',$gbList);

        		$content = $info['brand_name'].'-'.$info['sord'].'-'.$info['brand_remark'].'-'.$info['brand_dress'].'->'.$brand_name.'-'.$sord.'-'.$brand_remark.'-'.$brand_dress;
        		$this->insertingLog('编辑，','',$content,'品牌管理',$request->ip(),$request->get('session_token')['admin_acc']);
        		return $this->success('编辑成功', []);exit;
        	}else{
        		return $this->error('编辑失败', ErrorInc::MYSQL_FAILED, []);exit;
        	}
        }else{
        	return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);
        }

    }

    /**
     * @name 品牌停用启用
     * @param id 品牌id号
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年7月20日上午10:18:43
     */
    public function editGoodsBrandDelFlag (Request $request)
    {
    	if(!$request->filled('id')){
     		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
     	}
     	$id = intval($request->input('id'));

     	$del_flag = GoodsBrand::where('id',$id)->value('del_flag');

     	if ($del_flag == 1){
     		$poss['del_flag'] = 2;
     	}elseif ($del_flag == 2){
     		$poss['del_flag'] = 1;
     	}
     	$res = GoodsBrand::where('id',$id)->update($poss);
     	if($res){
            $gbLists = PjBrandsService::gbList();
            $gbList = json_encode($gbLists);
            RedisService::redisSet('gbList',$gbList);
     		$this->insertingLog('编辑品牌开关','',$id,'品牌管理',$request->ip(),$request->get('session_token')['admin_acc']);
     		return $this->success('操作成功', []);
     	}else{
     		return $this->error('操作失败', ErrorInc::MYSQL_FAILED, []);
     	}

    }


    /**
     * 获取品牌列表
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年7月20日下午3:28:11
     */
    public function gbSearchList(Request $request){
        $session = Request()->get('session_token');//用户信息
    	if(RedisService::redisGet('gbList')){
    		//echo 1;
    		$gbList = RedisService::redisGet('gbList');
            $gbList = CommonService::arrayFilterFieldValue($gbList,[['company_id'=>$session['company_id']]]);
    		return $this->success('获取成功',$gbList);
    		//return $cdList;
    	}else{
    		//echo 2;
    		$gbLists = PjBrandsService::gbList();
    		$gbList = json_encode($gbLists);
    		RedisService::redisSet('gbList',$gbList);
            $gbLists = CommonService::arrayFilterFieldValue($gbLists,[['company_id'=>$session['company_id']]]);
    		return $this->success('获取成功',$gbLists);
    	}
//        if(RedisService::redisGet('gbList')){
//            //echo 1;
//            $gbList = RedisService::redisGet('gbList');
//            return $this->success('获取成功',$gbList);
//            //return $cdList;
//        }else{
//            //echo 2;
//            $gbLists = PjBrandsService::gbList();
//            $gbList = json_encode($gbLists);
//            RedisService::redisSet('gbList',$gbList);
//            return $this->success('获取成功',$gbLists);
//        }
    }


}
