<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GhPrice extends Model
{
    protected $table ='gh_price';
    protected $guarded = [];
    public $timestamps=false;
    
    /**
	 * 添加日志
	 * @param [type] $user_id   操作人id
	 * @param [type] $ip        ip地址
	 * @param [type] $content   说明
	 * @param [type] $czlx      操作流程
	 * @param [type] $model_name模块名称
	 */
    public static function add_log($user_name,$ip,$content,$czlx,$model_name){
		// $admin_name=Db::connection('mysql_two')->table('admin')->where('id',$user_id)->value('admin_acc');
		$data=[];
		$data['czrz_name']=$user_name;
		$data['czrz_czlx']=$czlx;
		$data['czrz_ip']=$ip;
		$data['czrz_czsj']=date('Y-m-d H:i:s');
		$data['czrz_czxq']=$content;
		$data['test_data']=$model_name;
		Db::connection('mysql_two')->table('czrz')->insert($data);
    }

     /**
     * [uploadBase64Img 上传base64图片]
     * @param  [type] $stream [base64数据]          //base64 图片流
     * @param  [type] $url    路径 存放哪一个文件夹下  例如 /Uploads/pictures  必须有前面的反斜杠
     * @return [type]         [上传成功返回图片路径，失败返回false]
     */
    static function uploadBase64Img($stream,$url)
    {
        if(strlen($stream)<200){
            //如果 图片小于 200位 则应该是链接，判断是否链接中有 传输过来的 $url 有则返回 否则继续走下一步。
            
            if(!empty(strpos($stream,$url)) || strpos($stream,$url) == 0){
                return $stream;
            }
        }

        if(stristr($stream,'data:image')){
            $stream  = $stream;
        }else{
            $stream="data:image/png;base64,".$stream;
        }

        //获取扩展名和文件名
        if (preg_match('/(?<=\/)[^\/]+(?=\;)/', $stream, $pregR)) $streamFileType = '.' . $pregR[0];

        $streamFileRand = time() . rand(11,99);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）

        $pathName = base_path().$url."/";//获取上传图片路径
        
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName,0775,true);
            chmod($pathName,0775);
        }
        $streamFilename = $pathName . $streamFileRand . $streamFileType;//上传到服务器图片路径

        //处理base64文本，用正则把第一个base64,之前的部分砍掉
        preg_match('/(?<=base64,)[\S|\s]+/', $stream, $streamForW);
        if (file_put_contents($streamFilename, base64_decode($streamForW[0])) === false) {
            throw new Exception("上传文件失败");
        } else {
            // 返回路径
            $filePath =$url."/". $streamFileRand . $streamFileType;
            return $filePath;
        }
    }
}
