<?php

/**
|--------------------------------------------------------------------------
 * 平台账单核销
|--------------------------------------------------------------------------
| 平台账单核销
 * @author DouBin
 * @Date: 2022/06/16
 * @Time: 上午 11:00
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use App\Models\OrderMsg;
use App\Models\PtOrder;
use App\Models\PtPhistory;
use App\Models\SettlementThree;
use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Service\Service;
use DB;
use Illuminate\Database\Eloquent\Model;

class PtPhistoryService extends Service{

    /**|---------------------------------------------------------------------------------
     * @name 订单列表
     * @param array $session 用户信息
     * @param array $input 请求数据
     * @retrun /multitype:array
     * @author dou 2022/6/16 21:16
     * |---------------------------------------------------------------------------------
    */
    public static function getList ( $input , $session ){
        if(isset($input['ph_odnum'])){//搜索平台单号
            $where['ph_odnum_rlike'] = $input['ph_odnum'];
        }if(isset($input['state'])){//搜索状态
            $where['ph_state'] = $input['state'];
            if(in_array($input['state'],[5,15])){
                $Db = new PtPhistory();
            }else{
                $Db = new PtOrder();
            }
        }else{
            $Db = new PtOrder();
            $where['ph_state'] = 1;
        }if(isset($input['ph_mounth'])){//搜索账单周期
            $where['ph_mounth'] = $input['ph_mounth'];
        }if(isset($input['ph_pid'])){//搜索账单周期
            $where['ph_pid'] = $input['ph_pid'];
        }if(isset($input['ph_stype'])){//查询异常单类型
            $where['ph_stype'] = $input['ph_stype'];
        }
        $where = CommonService::jointWhere($where);
        $page_size = $input['page_size']??10;
        $paginate = $Db->whereRaw($where)->paginate($page_size);
        $data['show_Menu'] = [
//            ['show_name'=>"全部",'status'=>'0','show_num'=>'--'],
            ['show_name'=>"未处理",'status'=>'1','show_num'=>'--'],
            ['show_name'=>"异常单",'status'=>'5','show_num'=>'--'],
            ['show_name'=>"已核销",'status'=>'15','show_num'=>'--'],
            ['show_name'=>"多次下单",'status'=>'10','show_num'=>'--']
        ];
        $all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
        $export = BmmcService::getTopButton('','deal,getBland,uploadExcelImport',$all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮
        $data['phstype'] = self::getStypeName();//异常单类型
        $list = CommonService::dataToArray($paginate->items());
        if($list){
            $list = self::getButtonDatas($all_button, $list);
            $data['list'] = $list;
            $data['page'] = [
                'count' => $paginate->total(),
                'page'=>$paginate->currentPage(),
                'page_size'=>$page_size,
                'allPage'=>$paginate->lastPage()
            ];
        }else{
            $data['list'] = [];
        }
        return $data;

    }
    /**|---------------------------------------------------------------------------------
     * 获取按钮和数据
     * @param array $all_button
     * @param array $list
     * @return string
     * @author dou 2022/6/7 18:59
     * |---------------------------------------------------------------------------------
     */
    public static function getButtonDatas($all_button,$list){
        $stateName = self::getStateName(true);
        $typeName = self::getTypeName(true);
        $stypeName = self::getStypeName(true);
        foreach ($list as $k => $v){
            $button = [];
            $list[$k]['statename'] = $stateName[$v['ph_state']]??'未定义';
            $list[$k]['typeName'] = $typeName[$v['ph_type']]??'未定义';
            $list[$k]['stypeName'] = $stypeName[$v['ph_stype']]??'未定义';
            if($v['ph_state'] == '5') {
                $button[] = 'dealOne';
            }
            $button = BmmcService::getListButton($button,$all_button);
            $list[$k]['button_one'] = $button['button_one']??[];
            $list[$k]['button_two'] = $button['button_two']??[];
            $list[$k]['button_three'] = $button['button_three']??[];
        }
        return $list;
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取状态名称
     * @param string $type 数据展示类型
     * @retrun /multitype:array
     * @author dou 2022/6/16 21:28
     * |---------------------------------------------------------------------------------
    */
    public static function getStateName ( $type = false ){
        $data = [['type'=>1,'name'=>'未处理'],['type'=>5,'name'=>'异常单'],['type'=>10,'name'=>'多次下单'],['type'=>15,'name'=>'已核销']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取数据类型
     * @param string $type 数据展示类型
     * @retrun /multitype:array
     * @author dou 2022/6/16 21:28
     * |---------------------------------------------------------------------------------
     */
    public static function getTypeName ( $type = false ){
        $data = [['type'=>1,'name'=>'结款单'],['type'=>2,'name'=>'退款单']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取异常单类型
     * @param string $type 数据展示类型
     * @retrun /multitype:array
     * @author dou 2022/6/16 21:28
     * |---------------------------------------------------------------------------------
     */
        public static function getStypeName ( $type = false ){
            $data = [['type'=>1,'name'=>'已撤销'],['type'=>2,'name'=>'金额错误'],['type'=>3,'name'=>'未匹配单号'],['type'=>4,'name'=>'未完成'],['type'=>5,'name'=>'未撤销']];
            if($type){
                $data = array_column($data, 'name','type');
            }
            return $data;
        }
    /**|---------------------------------------------------------------------------------
     * @name 核销未处理数据
     * @param string $ph_state 数据状态
     * @retrun /multitype:array
     * @author dou 2022/6/16 15:03
     * |---------------------------------------------------------------------------------
    */
    public static function dealPtOrder ( $ph_state ){
        $data = PtPhistoryService::getPtOrderBy(['ph_state' => $ph_state], 'first',[],['ph_id'=>'asc']);
        if($data){
            $ph_id = $data['ph_id'];
            unset($data['ph_id']);
            $list = PtPhistoryService::getDataBy(['ph_odnum'=>$data['ph_odnum']], 'get');
            if($list){
                //核销表已查询到数据处理逻辑
                $ph_type = array_column($list, 'ph_type');
                if(in_array($data['ph_type'], $ph_type)){
                    $res = PtOrder::where("ph_id",$ph_id)->update(['ph_state'=>10,'ph_updatetime'=>date('Y-m-d H:i:s')]);
                    if($res){
                        return ["Data"=>'', "ErrorCode"=>1, "ErrorMessage"=>'操作成功'];
                    }else{
                        return ["Data"=>'', "ErrorCode"=>ErrorInc::MYSQL_FAILED, "ErrorMessage"=>'操作失败1'];
                    }
                }else{
                    $data['js_order'] = '';
                    $data['ph_cost'] = 0;
                    $sysprice = self::getSysPrice($data['ph_odnum']);
                    $data['ph_sysprice'] = $sysprice['orderCost'];
                    if($data['ph_type'] == 1){
                        $data['ph_checkprice'] = $data['ph_price'] + $list[0]['ph_price'];
                        if($sysprice['code'] == 2) {
                            $orderCost = self::getOrderCost($data['ph_odnum']);
                            $data['js_order'] = $orderCost['wat_num'];
                            $data['ph_cost'] = $orderCost['all_price'];
                        }
                        $data['ph_state'] = 15;
                        DB::beginTransaction(); //开启事务
                        $res = self::addData($data);
                        $rea = PtOrder::where("ph_id",$ph_id)->update(['ph_state'=>15,'ph_updatetime'=>date('Y-m-d H:i:s')]);
                        if($list[0]['ph_state'] == '15'){
                            SettlementThree::where("order_num",$data['ph_odnum'])->save(["is_verify"=>2]);
                        }
                        if($res && $rea){
                            DB::commit();//执行
                            return ["Data"=>'', "ErrorCode"=>1, "ErrorMessage"=>'操作成功'];
                        }else{
                            DB::rollback();//回滚
                            return ["Data"=>'', "ErrorCode"=>ErrorInc::MYSQL_FAILED, "ErrorMessage"=>'操作失败2'];
                        }
                    }else{
                        $data['ph_price'] = 0-$data['ph_price'];
                        $data['ph_checkprice'] = 0;
                        $data['ph_sysprice'] = 0;
                        $orderCost = self::getOrderCost($data['ph_odnum']);
                        if($orderCost['order_status'] !=50 && $orderCost['order_status'] != 55){
                            $data['ph_state'] = 5;
                            $data['ph_stype'] = 5;
                        }else{
                            $data['ph_state'] = 15;
                            $data['js_order'] = $orderCost['wat_num'];
                            $data['ph_cost'] = $orderCost['all_price'];
                            $data['ph_checkprice'] = 0-$orderCost['all_price'];
                        }
                        if($data['code']==1){
                            $data['ph_stype'] = 3;
                        }
                        DB::beginTransaction(); //开启事务
                        $res = self::addData($data);
                        $rea = PtOrder::where("ph_id",$ph_id)->update(['ph_state'=>15,'ph_updatetime'=>date('Y-m-d H:i:s')]);
                        if($data['ph_state'] == '15'){
                            SettlementThree::where("order_num",$data['ph_odnum'])->save(["is_verify"=>2]);
                        }
                        $ph_checkprice = $list[0]['ph_price']+$data['ph_price'];
                        $ree = PtPhistory::where('ph_id',$list[0]['ph_id'])->update(['ph_checkprice'=>$ph_checkprice,'ph_state'=>15,'ph_updatetime'=>date("Y-m-d H:i:s")]);
                        if($res && $rea && $ree){
                            DB::commit();//执行
                            return ["Data"=>'', "ErrorCode"=>1, "ErrorMessage"=>'操作成功'];
                        }else{
                            DB::rollback();//回滚
                            return ["Data"=>'', "ErrorCode"=>ErrorInc::MYSQL_FAILED, "ErrorMessage"=>'操作失败3'];
                        }
                    }
                }
            }else{
                //核销表未查询到数据处理逻辑
                $data['js_order'] = '';
                $data['ph_cost'] = 0;
                $sysprice = self::getSysPrice($data['ph_odnum']);
                $data['ph_sysprice'] = $sysprice['orderCost'];
                if($data['ph_type'] == 1){
                    if($sysprice['code'] == 2) {
                        $orderCost = self::getOrderCost($data['ph_odnum']);
                        $data['js_order'] = $orderCost['wat_num'];
                        $data['ph_cost'] = $orderCost['all_price'];
                        if($orderCost['order_status'] == 50 || $orderCost['order_status'] == 50) {
                            $data['ph_state'] = 5;
                            $data['ph_stype'] = 1;
                        }elseif($orderCost['order_status'] < 40 || ($orderCost['order_status'] == 40 && ($orderCost['wat_num']=='' || $orderCost['wat_num']==null))) {
                            $data['ph_state'] = 5;
                            $data['ph_stype'] = 4;
                        }else{
                            $data['ph_state'] = 15;
                            $data['ph_stype'] = 0;
                        }
                        if($data['ph_price']!=$data['ph_sysprice']) {
                            $data['ph_state'] = 5;
                            $data['ph_stype'] = 2;
                        }
                    }else{
                        $data['ph_state'] = 5;
                        $data['ph_stype'] = 3;
                    }
                    $data['ph_checkprice'] = $data['ph_price'] - $data['ph_cost'];
                    DB::beginTransaction(); //开启事务
                    $res = self::addData($data);
                    $rea = PtOrder::where("ph_id",$ph_id)->update(['ph_state'=>15,'ph_updatetime'=>date('Y-m-d H:i:s')]);
                    if($data['ph_state'] == '15'){
                        SettlementThree::where("order_num",$data['ph_odnum'])->save(["is_verify"=>2]);
                    }
                    if($res && $rea){
                        DB::commit();//执行
                        return ["Data"=>'', "ErrorCode"=>1, "ErrorMessage"=>'操作成功'];
                    }else{
                        DB::rollback();//回滚
                        return ["Data"=>'', "ErrorCode"=>ErrorInc::MYSQL_FAILED, "ErrorMessage"=>'操作失败2'];
                    }
                }else{
                    $data['ph_price'] = 0-$data['ph_price'];
                    $data['ph_checkprice'] = 0;
                    $data['ph_sysprice'] = 0;
                    $orderCost = self::getOrderCost($data['ph_odnum']);
                    if($orderCost['order_status'] !=50 && $orderCost['order_status'] != 55){
                        $data['ph_state'] = 5;
                        $data['ph_stype'] = 5;
                    }else{
                        $data['ph_state'] = 15;
                        $data['js_order'] = $orderCost['wat_num'];
                        $data['ph_cost'] = $orderCost['all_price'];
                        $data['ph_checkprice'] = 0-$orderCost['all_price'];
                    }
                    if($data['code']==1){
                        $data['ph_stype'] = 3;
                    }
                    $res = self::addData($data);
                    $rea = PtOrder::where("ph_id",$ph_id)->update(['ph_state'=>15,'ph_updatetime'=>date('Y-m-d H:i:s')]);
                    $ph_checkprice = $list[0]['ph_price']+$data['ph_price'];
                    $ree = PtPhistory::where('ph_id',$list[0]['ph_id'])->update(['ph_checkprice'=>$ph_checkprice,'ph_state'=>15,'ph_updatetime'=>date("Y-m-d H:i:s")]);
                    if($data['ph_state'] == '15'){
                        SettlementThree::where("order_num",$data['ph_odnum'])->save(["is_verify"=>2]);
                    }
                    if($res && $rea && $ree){
                        DB::commit();//执行
                        return ["Data"=>'', "ErrorCode"=>1, "ErrorMessage"=>'操作成功'];
                    }else{
                        DB::rollback();//回滚
                        return ["Data"=>'', "ErrorCode"=>ErrorInc::MYSQL_FAILED, "ErrorMessage"=>'操作失败3'];
                    }
                }
            }
        }else{
            return ["Data"=>'', "ErrorCode"=>ErrorInc::DATA_EMPTY, "ErrorMessage"=>'数据不存在'];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 核销异常单数据
     * @param string $ph_state 数据状态
     * @param string $ph_id 数据编号
     * @retrun /multitype:array
     * @author dou 2022/6/16 20:15
     * |---------------------------------------------------------------------------------
    */
    public static function dealPtPhistory ( $ph_state,$ph_id = ''){
        if($ph_id == ''){
            $data = self::getDataBy(['ph_state' => $ph_state], 'first',[],['ph_id'=>'asc']);
        }else{
            $data = self::getDataBy(['ph_id' => $ph_id], 'first',[]);
        }
        if($data){
            $list = PtPhistoryService::getDataBy(['ph_odnum'=>$data['ph_odnum'],'ph_id_noteq'=>$data['ph_id']], 'first');
            if($list){
                //核销表已查询到数据处理逻辑
                $sysprice = self::getSysPrice($data['ph_odnum']);
                $data['ph_sysprice'] = $sysprice['orderCost'];
                if($data['ph_type'] == 1){
                    $data['ph_checkprice'] = $data['ph_price'] + $list['ph_price'];
                    if($sysprice['code'] == 2) {
                        $orderCost = self::getOrderCost($data['ph_odnum']);
                        $data['js_order'] = $orderCost['wat_num'];
                        $data['ph_cost'] = $orderCost['all_price'];
                    }
                    $data['ph_state'] = 15;
                    $data['ph_updatetime'] = date("Y-m-d H:i:s");
                    DB::beginTransaction(); //开启事务
                    $res = PtPhistory::where('ph_id',$data['ph_id'])->update($data);
                    if($list['ph_state'] == '15'){
                        SettlementThree::where("order_num",$data['ph_odnum'])->save(["is_verify"=>2]);
                    }
                    if($res){
                        DB::commit();//执行
                        return ["Data"=>'', "ErrorCode"=>1, "ErrorMessage"=>'操作成功'];
                    }else{
                        DB::rollback();//回滚
                        return ["Data"=>'', "ErrorCode"=>ErrorInc::MYSQL_FAILED, "ErrorMessage"=>'操作失败2'];
                    }
                }else{
                    $orderCost = self::getOrderCost($data['ph_odnum']);
                    if($orderCost['order_status'] !=50 && $orderCost['order_status'] != 55){
                        $data['ph_state'] = 5;
                        $data['ph_stype'] = 5;
                    }else{
                        $data['ph_state'] = 15;
                        $data['js_order'] = $orderCost['wat_num'];
                        $data['ph_cost'] = $orderCost['all_price'];
                        $data['ph_checkprice'] = 0-$orderCost['all_price'];
                    }
                    if($data['code']==1){
                        $data['ph_stype'] = 3;
                    }
                    $data['ph_updatetime'] = date("Y-m-d H:i:s");
                    DB::beginTransaction(); //开启事务
                    $res = PtPhistory::where('ph_id',$data['ph_id'])->update($data);

                    $ph_checkprice = $list[0]['ph_price']+$data['ph_price'];
                    $ree = PtPhistory::where('ph_id',$list['ph_id'])->update(['ph_checkprice'=>$ph_checkprice,'ph_state'=>15,'ph_updatetime'=>date("Y-m-d H:i:s")]);
                    if($data['ph_state'] == '15'){
                        SettlementThree::where("order_num",$data['ph_odnum'])->save(["is_verify"=>2]);
                    }
                    if($res && $ree){
                        DB::commit();//执行
                        return ["Data"=>'', "ErrorCode"=>1, "ErrorMessage"=>'操作成功'];
                    }else{
                        DB::rollback();//回滚
                        return ["Data"=>'', "ErrorCode"=>ErrorInc::MYSQL_FAILED, "ErrorMessage"=>'操作失败3'];
                    }
                }
            }else{
                //核销表未查询到数据处理逻辑
                $sysprice = self::getSysPrice($data['ph_odnum']);
                $data['ph_sysprice'] = $sysprice['orderCost'];
                if($data['ph_type'] == 1){
                    if($sysprice['code'] == 2) {
                        $orderCost = self::getOrderCost($data['ph_odnum']);
                        $data['js_order'] = $orderCost['wat_num'];
                        $data['ph_cost'] = $orderCost['all_price'];
                        if($orderCost['order_status'] == 50 || $orderCost['order_status'] == 50) {
                            $data['ph_state'] = 5;
                            $data['ph_stype'] = 1;
                        }elseif($orderCost['order_status'] < 40 || ($orderCost['order_status'] == 40 && ($orderCost['wat_num']=='' || $orderCost['wat_num']==null))) {
                            $data['ph_state'] = 5;
                            $data['ph_stype'] = 4;
                        }else{
                            $data['ph_state'] = 15;
                            $data['ph_stype'] = 0;
                        }
                        if($data['ph_price']!=$data['ph_sysprice']) {
                            $data['ph_state'] = 5;
                            $data['ph_stype'] = 2;
                        }
                    }else{
                        $data['ph_state'] = 5;
                        $data['ph_stype'] = 3;
                    }
                    $data['ph_checkprice'] = $data['ph_price'] - $data['ph_cost'];
                    $data['ph_updatetime'] = date("Y-m-d H:i:s");
                    DB::beginTransaction(); //开启事务
                    $res = PtPhistory::where('ph_id',$data['ph_id'])->update($data);
                    if($data['ph_state'] == '15'){
                        SettlementThree::where("order_num",$data['ph_odnum'])->save(["is_verify"=>2]);
                    }
                    if($res){
                        DB::commit();//执行
                        return ["Data"=>'', "ErrorCode"=>1, "ErrorMessage"=>'操作成功'];
                    }else{
                        DB::rollback();//回滚
                        return ["Data"=>'', "ErrorCode"=>ErrorInc::MYSQL_FAILED, "ErrorMessage"=>'操作失败2'];
                    }
                }else{
                    $orderCost = self::getOrderCost($data['ph_odnum']);
                    if($orderCost['order_status'] !=50 && $orderCost['order_status'] != 55){
                        $data['ph_state'] = 5;
                        $data['ph_stype'] = 5;
                    }else{
                        $data['ph_state'] = 15;
                        $data['js_order'] = $orderCost['wat_num'];
                        $data['ph_cost'] = $orderCost['all_price'];
                        $data['ph_checkprice'] = 0-$orderCost['all_price'];
                    }
                    if($data['code']==1){
                        $data['ph_stype'] = 3;
                    }
                    $data['ph_updatetime'] = date("Y-m-d H:i:s");
                    DB::beginTransaction(); //开启事务
                    $res = PtPhistory::where('ph_id',$data['ph_id'])->update($data);
                    $ph_checkprice = $list[0]['ph_price']+$data['ph_price'];
                    $ree = PtPhistory::where('ph_id',$list['ph_id'])->update(['ph_checkprice'=>$ph_checkprice,'ph_state'=>15,'ph_updatetime'=>date("Y-m-d H:i:s")]);
                    if($data['ph_state'] == '15'){
                        SettlementThree::where("order_num",$data['ph_odnum'])->save(["is_verify"=>2]);
                    }
                    if($res && $ree){
                        DB::commit();//执行
                        return ["Data"=>'', "ErrorCode"=>1, "ErrorMessage"=>'操作成功'];
                    }else{
                        DB::rollback();//回滚
                        return ["Data"=>'', "ErrorCode"=>ErrorInc::MYSQL_FAILED, "ErrorMessage"=>'操作失败3'];
                    }
                }
            }
        }else{
            return ["Data"=>'', "ErrorCode"=>ErrorInc::DATA_EMPTY, "ErrorMessage"=>'数据不存在'];
        }

    }

    /**|---------------------------------------------------------------------------------
     * @name 获取订单金额
     * @param string $ph_odnum 订单单号
     * @retrun /multitype:array
     * @author dou 2022/6/16 16:21
     * |---------------------------------------------------------------------------------
    */
    public static function getSysPrice ( $ph_odnum ){
        $data['code'] = 1;
        $orderCost = 0;
        $sys_num = OrderService::getOrderBy('order_num',$ph_odnum,['sys_num','p_id']);
        if($sys_num) {
            $data['code'] = 2;
            $order_msg = OrderService::getOrderMsgBy('sys_num', $sys_num['sys_num'], ['goods_id', 'goods_service', 'goods_num']);
            foreach ($order_msg as $k => $v) {
                if ($v['goods_service'] != 3) {
                    $price = DB::table('pt_prices')->where("pp_pid", $sys_num['p_id'])->where("pp_gid", $v['goods_id'])->where("pp_delet", 1)->where("pp_startime", '<', date("Y-m-d"))->orderBy("pp_startime", 'desc')->value('pp_price');
                    if ($price) {
                        $price = $price * $v['goods_num'];
                        $orderCost = $orderCost + $price;
                    }
                }
            }
        }
        $data['orderCost'] = $orderCost;
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取结算情况
     * @param string $ph_odnum 订单单号
     * @retrun /multitype:array
     * @author dou 2022/6/16 16:53
     * |---------------------------------------------------------------------------------
    */
    public static function getOrderCost ( $ph_odnum ){
        $order_status = OrderService::getOrderBy('order_num',$ph_odnum,['order_status']);
        $data['code'] = 1;
        $data['order_status'] = '';
        $data['wat_num'] = '';
        $data['all_price'] = '';
        if($order_status) {
            $data['order_status'] = $order_status;
            $data['code'] = 2;
            if (in_array($order_status, ['40', '55'])) {
                $wat_num['wat_num'] = '';
                $wat_num1['wat_num_isnull'] = '';
                $where['wat1_next_level'] = $wat_num;
                $where['wat2_next_level'] = $wat_num1;
                $settmentlist = SettlementService::getSettlementList(['order_num' => $ph_odnum, 'wat_num_searchor' => $where], ['all_price', 'wat_num']);
                if ($settmentlist) {
                    $watnum = array_column($settmentlist, 'wat_num');
                    $watnum = array_unique($watnum);
                    $watnum = implode(',', $watnum);
                    $data['wat_num'] = $watnum;
                    $all_price = array_column($settmentlist, 'all_price');
                    $data['all_price'] = array_sum($all_price);
                }
            }
        }
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 添加核销数据
     * @param string $ph_pid 平台id
     * @param string $ph_odnum 订单单号
     * @param string $ph_type 订单类型1：结款单2退款单
     * @param string $ph_state 订单类型1未处理5异常单10多次回传15已核销
     * @param string $ph_creactime 回传时间
     * @param string $ph_craectid 操作人
     * @param string $ph_craector 操作人
     * @param string $ph_price 订单价格
     * @param string $ph_checkprice 核销金额差
     * @param string $js_order 结算单号
     * @param string $ph_goods 商品信息
     * @param string $ph_mounth 账期时间
     * @param string $ph_sysprice 订单系统价格
     * @param string $ph_cost 订单成本
     * @param string $ph_stype 异常单类型 1已撤销2金额错误3未匹配单号4未完成
     * @param string $ph_centent 手动核销备注
     * @retrun /multitype:array
     * @author dou 2022/6/16 15:58
     * |---------------------------------------------------------------------------------
    */
    public static function addData ( $data ){
        $poss['ph_pid'] = $data['ph_pid'];
        $poss['ph_odnum'] = $data['ph_odnum'];
        $poss['ph_type'] = $data['ph_type'];
        $poss['ph_state'] = $data['ph_state'];
        $poss['ph_creactime'] = $data['ph_creactime'];
        $poss['ph_craectid'] = $data['ph_craectid'];
        $poss['ph_craector'] = $data['ph_craector'];
        $poss['ph_price'] = $data['ph_price'];
        $poss['ph_checkprice'] = $data['ph_checkprice'];
        $poss['js_order'] = $data['js_order'];
        $poss['ph_goods'] = $data['ph_goods'];
        $poss['ph_mounth'] = $data['ph_mounth'];
        $poss['ph_sysprice'] = $data['ph_sysprice'];
        $poss['ph_cost'] = $data['ph_cost'];
        $poss['ph_stype'] = $data['ph_stype']??0;
        $poss['ph_centent'] = $data['ph_centent']??'';
        $res = PtPhistory::insert($poss);
        return $res;
    }

    /**|---------------------------------------------------------------------------------
     * @name 指定条件查询核销表数据
     * @param array $params 查询条件
     * @param array $type 查询类型
     * @param array $params 查询条件
     * @retrun /multitype:array
     * @author dou 2022/6/16 11:05
     * |---------------------------------------------------------------------------------
    */
    public static function getDataBy ( $params , $type , $select = [] ){
        $db = new PtPhistory();
        if($type == 'first' && count($select) == 1){
            $type = 'value';
        }
        $list = CommonService::getMysqlData($db, $params,$select,[],$type);
        return $list;
    }
    /**|---------------------------------------------------------------------------------
     * @name 指定条件查询回传表数据
     * @param array $params 查询条件
     * @param array $type 查询类型
     * @param array $params 查询条件
     * @retrun /multitype:array
     * @author dou 2022/6/16 11:05
     * |---------------------------------------------------------------------------------
     */
    public static function getPtOrderBy ( $params , $type , $select = [] , $orderby = [] ){
        $db = new PtOrder();
        if($type == 'first' && count($select) == 1){
            $type = 'value';
        }
        $list = CommonService::getMysqlData($db, $params,$select,$orderby,$type);
        return $list;
    }

}
