<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DownloadsRecords extends Model
{
    /**
     * 关联到模型的数据表
     *
     * @var string
     */
    protected $table = 'downloads_records';
    protected $primaryKey = 'id';
    protected $guarded = [];
    /**
     * 可以被批量赋值的属性.
     *
     * @var array
     */
    protected $fillable = ['uid', 'file_id', 'download_time'];
    public $attributeNames = [
        'id'=>'编号',
        'file_id'=>'文件ID',
        'uid'=>'下载人ID',
        'download_time'=>'下载时间'
    ];

    protected $needPri = [];
    /**
     * 表明模型是否应该被打上时间戳
     *
     * @var bool
     */
    //public $timestamps = false;
    /**
     * 模型日期列的存储格式
     *
     * @var string
     */
    //protected $dateFormat = 'U';

    /**
     * The connection name for the models.
     *
     * @var integer $id
     * @var bool $includeSub
     *
     * @return mixed
     */
    //protected $connection = 'connection-name';’

    public function fileInfo() {
        return $this->belongsTo('App/Models/Downloads', 'id', 'file_id');
    }
}
