<?php
/**
 * 用户服务
 *
 * @author lixiaolin
 * @Date: 2021/4/2
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\User;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;

class UserService extends Service
{
    public static $instance;
    private $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new User();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    public function create(array $input)
    {
        $userArr['skb_xm'] = $input['shr_phone'];
        $userArr['shr_name'] =$this->restrict($input['shr_name']);
        $userArr['shr_phone'] = $input['shr_phone'];
        $userArr['shr_sheng'] = $input['shr_sheng'];
        $userArr['shr_shi'] = $input['shr_shi'];
        $userArr['shr_xian'] = $input['shr_xian'];
        $userArr['shr_adress'] =$this->restrict($input['shr_adress']);
        $userArr['shr_other'] = $input['shr_other'];
        $userArr['sys_num'] = $input['sys_bh'];
        $userArr['create_time'] = date('Y-m-d H:i:s');
        $customer_id = User::insertGetId($userArr);

        return $customer_id;
    }

    public static function getByPhone($phone) {
        $user = User::where('shr_phone', $phone)
            ->first();
        if ($user) {
            return $user;
        } else {
            return false;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 根据指定条件获取
     * @param string $key 查询键
     * @param string $value 查询值
     * @param array $select 待查询参数
     * @retrun /multitype:array
     * @author dou 2021/11/5 17:02
     * |---------------------------------------------------------------------------------
    */
    public static function getUserBy($key, $value, $select = [] , $type = 'get' )
    {
        $db = new User();
        if($key == 'id'){
            $type = 'first';
        }
        if(count($select) == 1 && $type == 'first'){
            $type = 'value';
        }
        $list = CommonService::getMysqlData($db,[$key=>$value],$select,[],$type);
        return $list;
    }
}
