<?php

namespace App\Http\Middleware;

use Closure;
use DB;
use Illuminate\Support\Facades\Crypt;

class WebLogin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(!$request->exists('api_token')){
            return response()->json(["ErrorCode"=>300,'ErrorMessage'=>'api_token失效：检索码01，请重新登录！','data'=>'']);
        }
        if(!$request->exists('session_company_id')){
            return response()->json(["ErrorCode"=>300,'ErrorMessage'=>'api_token失效：检索码05，请重新登录！','data'=>'']);
        }
        if(!$request->exists('session_install_id')){
            return response()->json(["ErrorCode"=>300,'ErrorMessage'=>'api_token失效：检索码06，请重新登录！','data'=>'']);
        }
        $request['api_token_old'] = $request['api_token'];
        // 解密api_token，如果不是系统生成的token会解密失败
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["ErrorCode"=>300,'ErrorMessage'=>'api_token失效：检索码02，请重新登录！','data'=>'']);
        }

        // 拿到token获取登录表信息
        $login_web = DB::table('login_web')
                        ->where('api_token','=',$api_token)
                        ->select('lowe_last_login','api_token','company_id','install_id','admin_id','user_type','install_name')
                        ->first();
        if(empty($login_web)){
            return response()->json(["ErrorCode"=>300,'ErrorMessage'=>'api_token失效：检索码03，请重新登录！','data'=>'']);
        }

        // 当前时间
        $hours = time();
        // 如果最后登录时间小于当前时间,说明登陆过期
        if($login_web['lowe_last_login'] < $hours){
            return response()->json(["ErrorCode"=>300, 'ErrorMessage'=>'登陆过期，请重新登录', 'data'=>'']);
        }
        if($request['session_company_id'] !=$login_web['company_id'] || $request['session_install_id'] !=$login_web['install_id']){
            return response()->json(["ErrorCode"=>300,'ErrorMessage'=>'api_token失效：检索码04，请重新登录！','data'=>'']);
        }
        $now_time = $hours + 10*60*60;
        if ($now_time > $login_web['lowe_last_login']) {
            // 每隔2个小时更新一次，降低更新次数，如果登录时间超过2个小时在操作就当前时间加12小时
            DB::table('login_web')->where('api_token','=',$api_token)->update(['lowe_last_login'=>$hours + 12*60*60]);
        }
        $request['api_token'] = $api_token;//赋值解密后的token值
        $session['user_type'] = $login_web['user_type'];//用户账号类型
        $session['company_id'] = $login_web['company_id'];//公司id
        $session['install_id'] = $login_web['install_id'];//操作人id
        $session['admin_id'] = $login_web['admin_id'];//所属服务商id
        $session['install_name'] = $login_web['install_name'];//操作人信息
        $request['session'] = $session;
        return $next($request);
    }
}
