<?php

namespace App\Http\Controllers\Api\MobileWeb;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Validators\Api\MobileWeb\OrderListValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\Api\MobileWeb\OrderListService;

// 移动端-工单列表
class OrderListController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 4;

    public function __construct()
    {
        $this->dataValidator = new OrderListValidator();
    }

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::index($request->all(), $this->show_count,1);
        return $return_data;
    }

    // 接单
    public function receiving(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->receivingStartValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $input = $request->all();
        if($input['type']==1){
            $return_data = OrderListService::getPerson($request->all());
        }
        if($input['type']==2) {
            $error_message = $this->dataValidator->receivingValidator($request->all());
            if ($error_message) {
                return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
            }
            $return_data = OrderListService::receiving($request->all(),$request->ip());
        }
        return response()->json($return_data);
    }

    // 拒单
    public function refuse(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->refuseValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::refuse($request->all(),$request->ip());
        return response()->json($return_data);
    }

    //预约安装
    public function contact ( Request $request ){
        // 验证数据
        $error_message = $this->dataValidator->contactValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::contact($request->all(),$request->ip());
        return response()->json($return_data);
    }

    //改派
    public function transferOfOrder ( Request $request ){
        // 验证数据
        $error_message = $this->dataValidator->transferOfOrderStartValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $input = $request->all();
        if($input['type']==1){
            $return_data = OrderListService::getPerson($request->all(),$input['old_install_id']);
        }
        if($input['type']==2) {
            $error_message = $this->dataValidator->transferOfOrderValidator($request->all());
            if ($error_message) {
                return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
            }
            $return_data = OrderListService::transferOfOrder($request->all(),$request->ip());
        }
        return response()->json($return_data);
    }

    //出发
    public function lineStart ( Request $request ){
        $error_message = $this->dataValidator->lineValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $return_data = OrderListService::lineStart($request->all(),$request->ip());
        return response()->json($return_data);
    }

    //抵达
    public function lineArrive ( Request $request ){
        $error_message = $this->dataValidator->lineValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $return_data = OrderListService::lineArrive($request->all(),$request->ip());
        return response()->json($return_data);
    }

    //开始安装
    public function startInstall ( Request $request ){
        $error_message = $this->dataValidator->lineValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $return_data = OrderListService::startInstall($request->all(),$request->ip());
        return response()->json($return_data);
    }

    // 详情
    public function info(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::info($request->all());
        return response()->json($return_data);
    }

    //上传图片
    public function addPic ( Request $request ){
        // 验证数据
        $error_message = $this->dataValidator->addPicValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::addPic($request,$request->ip());
        return response()->json($return_data);
    }
    //删除图片
    public function deletPic ( Request $request ){
        // 验证数据
        $error_message = $this->dataValidator->deletPicValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::deletPic($request->all(),$request->ip());
        return response()->json($return_data);
    }
    // 检验
    public function inspect(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->startInstallValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::inspect($request->all());
        return response()->json($return_data);
    }

    // 安装反馈
    public function installFeedback(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->installFeedbackValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::installFeedback($request->all(),$request->ip());
        return response()->json($return_data);
    }

    // 获取反馈信息
    public function getFeedback(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->startInstallValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::getFeedback($request->all());
        return response()->json($return_data);
    }

    // 获取技师
    public function getInstallPerson(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::getInstallPerson($request->all());
        return response()->json($return_data);
    }

    // 获取标签
    public function getLabel(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::getLabel($request->all());
        return response()->json($return_data);
    }

    // 获取操作记录
    public function operatingRecord(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->operatingRecordValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::operatingRecord($request->all());
        return response()->json($return_data);
    }

    // 图片反馈
    public function imageFeedback(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->imageFeedbackValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::imageFeedback($request->all());
        return response()->json($return_data);
    }

    // 车牌反馈
    public function LicenseFeedback(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->LicenseFeedbackValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = OrderListService::LicenseFeedback($request->all());
        return response()->json($return_data);
    }
}
