<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDownloadsRecordsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('downloads_records', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('uid')->comment('下载者UID');
            $table->integer('file_id')->comment('文件ID');
            $table->dateTime('download_time')->comment('下载时间');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('downloads_records');
    }
}
