<?php

namespace App\Http\Requests\Validators\Api\MobileWeb;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class TechnicianValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return false;
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'install_id.integer' => '参数错误',
            'install_id.min' => '参数错误',
            'admin_id.required' => '参数错误',
            'admin_id.integer' => '参数错误',
            'admin_id.min' => '参数错误',
            'install_name.required' => '请输入姓名',
            'install_name.max' => '参数错误',
            'install_phone.required' => '请输入联系电话',
            'install_phone.max' => '参数错误',
            'install_year.required' => '请选择入职时间',
            'install_year.max' => '参数错误',
            'install_is_type.required' => '请选择是否启用',
            'install_is_type.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'install_name' => 'required|string|max:50',
            'install_phone' => 'required|string|max:50',
            'install_year' => 'required|string|max:50',
            'install_is_type' => [
                'required',
                Rule::in([1, 2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 修改密码验证器
    public function changePasswordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'install_id.integer' => '参数错误',
            'install_id.min' => '参数错误',
            'admin_id.required' => '参数错误',
            'admin_id.integer' => '参数错误',
            'admin_id.min' => '参数错误',
            'password.required' => '请输入原密码',
            'new_password.required' => '请输入新密码',
            'new_password.regex' => '密码格式错误',
            'new_password_affirm.required' => '请输入确认密码',
            'new_password_affirm.same' => '两次密码不一致',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'password' => 'required',
            'new_password' => [
                'required',
                'regex:/^[a-zA-Z\d_]{8,}$/', //正则验证密码格式
            ],
            // 与密码数据保持一致
            'new_password_affirm' => 'required|same:new_password',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑展示验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'install_id.integer' => '参数错误',
            'install_id.min' => '参数错误',
            'admin_id.required' => '参数错误',
            'admin_id.integer' => '参数错误',
            'admin_id.min' => '参数错误',
            'edit_install_id.required' => '请输入技师id',
            'edit_install_id.integer' => '参数错误',
            'edit_install_id.min' => '参数错误',
            'type.required' => '请输入类型',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'edit_install_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in([1, 2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    public function deleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'install_id.integer' => '参数错误',
            'install_id.min' => '参数错误',
            'admin_id.required' => '参数错误',
            'admin_id.integer' => '参数错误',
            'admin_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
