<?php
namespace App\Http\Controllers\DatasBase;
use App\Http\Controllers\BaseController;
use App\Services\BmmcService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use DB;
class CarcorrectController extends BaseController
{
    /**|---------------------------------------------------------------------------------
     * @name 纠错列表
     * @param state 1：全部；2：未处理；3：已处理；
     * @param creactime 提交时间
     * @param car_brand 车辆品牌
     * @param car_series 车辆系列
     * @param car_model 车辆型号
     * @param car_config 车辆配置
     * @param car_year 车辆年款
     * @param page 页码
     * @return \Illuminate\Http\JsonResponse
     * @author dou <2020/01/16>
     * |---------------------------------------------------------------------------------
     */
    public function index (Request $request)
    {
        if (!in_array($request->input('state'),[1,2,3,4])){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
        $table = DB::table('car_correct');
         //$table = $table->where('cor_way',1);
        $count = DB::table('car_correct')->selectRaw("cor_way,count('cor_id') as num")->where('cor_state','1')->groupBy('cor_way')->get()->toArray();
        foreach ($count as $k => $v){
            switch ($v['cor_way']){
                case 1;
                    $jcwcl = $v['num'];
                    break;
                case 2;
                    $tjwcl = $v['num'];
                    break;
            }
        }
        $data['show_Menu'] = [
            ['show_name'=>"全部",'status'=>'1','show_num'=>"--"],
            ['show_name'=>"纠错未处理",'status'=>'2','show_num'=>$jcwcl??0],
            ['show_name'=>"添加未处理",'status'=>'3','show_num'=>$tjwcl??0],
            ['show_name'=>"已处理",'status'=>'4','show_num'=>"--"],
        ];
        if ($request->input('state') == 2){//纠错未处理
            $table = $table->where('cor_state',1)->where('cor_way',1);
        }elseif ($request->input('state') == 3) {//添加未处理
            $table = $table->where('cor_state',1)->where('cor_way',2);
        }elseif ($request->input('state') == 4){//已处理
            $table = $table->whereIn('cor_state',[5,10,15]);
        }
        if($request->filled('creactime')){//经手人员
            $creatData = $request->input('creactime');
            $start_time = explode(' ',$creatData[0])[0];
            $end_time = explode(' ',$creatData[1])[0];
            $time_arr[0] = date("Y-m-d 00:00:00",strtotime($start_time));
            $time_arr[1] = date("Y-m-d 23:59:59",strtotime($end_time));

            $table = $table->whereBetween('cor_creactime',$time_arr);
        }
        $tables = $table;
        $count = $tables->count();
        $page_size = (int)$request->input('page_size',10);
        $page = (int)$request->input('page',1);
        if($page<1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;
        $list = $table->orderBy('cor_creactime','DESC')->offset($offset)->limit($page_size)->get();
        $all_button = BmmcService::whereButton($request->input('token'),$request->input('Pri_id'));
        $export = BmmcService::getTopButton('','',$all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮

        $good_brand = DB::table('pj_goods')->pluck('brand_name','pg_id')->toArray();
        if(!$list->isEmpty()){
            $list = $list->toArray();

            foreach ($list as $k=>$v){
                $buttonData = [];
                if ($v['cor_state'] == 1){
                    $buttonData[] = 'audit';
                }
                $button = BmmcService::getListButton($buttonData,$all_button);
                $list[$k]['button_one'] = $button['button_one']??[];
                $list[$k]['button_two'] = $button['button_two']??[];
                $list[$k]['button_three'] = $button['button_three']??[];
                if ($v['cor_state'] == 1){
                    $list[$k]['stauas_name'] = "新提交";
                }elseif ($v['cor_state'] == 5){
                    $list[$k]['stauas_name'] = "已审核";
                }elseif ($v['cor_state'] == 10){
                    $list[$k]['stauas_name'] = "已驳回";
                }elseif ($v['cor_state'] == 15){
                    $list[$k]['stauas_name'] = "已过度";
                }
                if (isset($good_brand[$v['cor_pgid']])) {
                    $list[$k]['good_brand'] = $good_brand[$v['cor_pgid']];
                } else {
                    $list[$k]['good_brand'] = '';
                }
                if($list[$k]['cor_pic']!='') {
                    $list[$k]['cor_pic'] = $this->picurl($list[$k]['cor_pic']);
                }
            }
            $data['list'] = $list;
            $data['count'] = [
                'page' => $page,
                'page_size' => $page_size,
                'allPage' => ceil($count/$page_size),
                'count' => $count,
            ];
            return $this->success('获取成功',$data);exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$data);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 审核/驳回
     * @param type 1：审核；2：驳回；
     * @param good_id 商品id
     * @param good_brand 商品品牌
     * @param good_name 商品名称
     * @param cor_pgid 原商品id
     * @param cor_good 原商品
     * @param cor_id 数据id
     * @param cor_cid 匹配数据id
     * @param cor_cpid 车辆id
     * @return \Illuminate\Http\JsonResponse
     * @author dou <2020/01/17>
     * |---------------------------------------------------------------------------------
     */
    public function audit(Request $request){
        if($request->filled('type') && $request->filled('cor_id')){
            $id = DB::table('car_correct')->where('cor_id',$request->input('cor_id'))->where('cor_state','1')->value('cor_id');
            if(empty($id)){
                return $this->error('数据已被处理', ErrorInc::MYSQL_FAILED);exit;
            }
            if($request->input('type')=='1'){
                if(!$request->filled('good_id') || !$request->filled('good_brand') || !$request->filled('good_name') || !$request->filled('cor_pgid') || !$request->filled('cor_cpid')){
                    return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
                }else{
                    $pp['cb_pid'] = $request->input('cor_cpid');
                    $pp['cb_pgid'] = $request->input('good_id');
                    $pp['cb_creacter'] = $request->get('session_token')['admin_acc'];
                    $pp['cb_creactime'] = date("Y-m-d H:i:s");
                    if(!$request->filled('cor_cid')){
                        $res = DB::table('car_bml')->where('cb_pid',$request->input('cor_cpid'))->where('cb_pgid',$request->input('good_id'))->value('cb_id');
                        if(empty($res)) {
                            $cor_id = DB::table('car_bml')->where('cb_pid', $request->input('cor_cpid'))->where('cb_pgid', $request->input('cor_pgid'))->value('cb_id');
                            if (empty($cor_id)) {
                                $res = DB::table('car_bml')->insertGetId($pp);
                            } else {
                                $pp['cb_type'] = 1;
                                $res = DB::table('car_bml')->where('cb_id', $cor_id)->update($pp);
                            }
                        }
                    }else{
                        $pp['cb_type'] = 1;
                        $res = DB::table('car_bml')->where('cb_id',$request->input('cor_cid'))->update($pp);
                        if(empty($res)){
                            $res = DB::table('car_bml')->where('cb_pid',$request->input('cor_cpid'))->where('cb_pgid',$request->input('good_id'))->value('cb_id');
                        }
                    }
                    if(empty($res)){
                        return $this->error('操作失败1', ErrorInc::MYSQL_FAILED);exit;
                    }
                    $goodid = DB::table('car_bml')->where('cb_pid',$request->input('cor_cpid'))->get(['cb_pgid'])->toArray();
                    if(empty($goodid)){
                        return $this->error('数据异常', ErrorInc::MYSQL_FAILED);exit;
                    }else{
                        $goodids= array();
                        foreach( $goodid as $ka => $va ){
                            $goodids[] = $va['cb_pgid'];
                        }
                        unset($goodid);
                        $good = DB::table('pj_goods')->whereIn('pg_id',$goodids)->get(['pg_id','brand_name','pg_series','version'])->toArray();
                        unset($goodids);
                        $poss['cs_varta'] = "";
                        $poss['cs_fengf'] = "";
                        $poss['cs_luot'] = "";
                        $poss['cs_tangq'] = "";
                        $poss['cs_tongy'] = "";
                        $poss['cs_lish'] = "";
                        $poss['cs_derf'] = "";
                        $poss['cs_acdk'] = "";
                        $poss['cs_boshi'] = "";
                        if(!empty($good)){
                            foreach( $good as $ke => $ve){
                                if($ve['brand_name']=='瓦尔塔'){
                                    $goodname = $this->pjname($ve['pg_series'],$ve['version']);
                                    if($poss['cs_varta']!=''){
                                        $poss['cs_varta'] .= ":x:".$ve['pg_id']."::".$goodname;
                                    }else{
                                        $poss['cs_varta'] = $ve['pg_id']."::".$goodname;
                                    }
                                }
                                if($ve['brand_name']=='风帆'){
                                    $goodname=$this->pjname($ve['pg_series'],$ve['version']);
                                    if($poss['cs_fengf']!=''){
                                        $poss['cs_fengf'] .= ":x:".$ve['pg_id']."::".$goodname;
                                    }else{
                                        $poss['cs_fengf'] = $ve['pg_id']."::".$goodname;
                                    }
                                }
                                if($ve['brand_name']=='骆驼'){
                                    $goodname=$this->pjname($ve['pg_series'],$ve['version']);
                                    if($poss['cs_luot']!=''){
                                        $poss['cs_luot'] .= ":x:".$ve['pg_id']."::".$goodname;
                                    }else{
                                        $poss['cs_luot'] = $ve['pg_id']."::".$goodname;
                                    }
                                }
                                if($ve['brand_name']=='汤浅'){
                                    $goodname=$this->pjname($ve['pg_series'],$ve['version']);
                                    if($poss['cs_tangq']!=''){
                                        $poss['cs_tangq'] .= ":x:".$ve['pg_id']."::".$goodname;
                                    }else{
                                        $poss['cs_tangq'] = $ve['pg_id']."::".$goodname;
                                    }
                                }
                                if($ve['brand_name']=='统一'){
                                    $goodname=$this->pjname($ve['pg_series'],$ve['version']);
                                    if($poss['cs_tongy']!=''){
                                        $poss['cs_tongy'] .= ":x:".$ve['pg_id']."::".$goodname;
                                    }else{
                                        $poss['cs_tongy'] = $ve['pg_id']."::".$goodname;
                                    }
                                }
                                if($ve['brand_name']=='理士'){
                                    $goodname=$this->pjname($ve['pg_series'],$ve['version']);
                                    if($poss['cs_lish']!=''){
                                        $poss['cs_lish'] .= ":x:".$ve['pg_id']."::".$goodname;
                                    }else{
                                        $poss['cs_lish'] = $ve['pg_id']."::".$goodname;
                                    }
                                }
                                if($ve['brand_name']=='德尔福'){
                                    $goodname = $this->pjname($ve['pg_series'],$ve['version']);
                                    if($poss['cs_derf']!=''){
                                        $poss['cs_derf'] .= ":x:".$ve['pg_id']."::".$goodname;
                                    }else{
                                        $poss['cs_derf'] = $ve['pg_id']."::".$goodname;
                                    }
                                }
                                if($ve['brand_name']=='AC德科'){
                                    $goodname = $this->pjname($ve['pg_series'],$ve['version']);
                                    if($poss['cs_acdk']!=''){
                                        $poss['cs_acdk'] .= ":x:".$ve['pg_id']."::".$goodname;
                                    }else{
                                        $poss['cs_acdk'] = $ve['pg_id']."::".$goodname;
                                    }
                                }
                                if($ve['brand_name']=='博世'){
                                    $goodname = $this->pjname($ve['pg_series'],$ve['version']);
                                    if($poss['cs_boshi']!=''){
                                        $poss['cs_boshi'].=":x:".$ve['pg_id']."::".$goodname;
                                    }else{
                                        $poss['cs_boshi']=$ve['pg_id']."::".$goodname;
                                    }
                                }
                            }
                            //DB::connection()->enableQueryLog();#开启执行日志
                            $rea = DB::table('car_searchnew')->where('cs_id',$request->input('cor_cpid'))->update($poss);
                            //print_r(DB::getQueryLog()); //获取查询语句、参数和执行时间
                            if($rea){
                                $posa['cor_state'] = '5';
                                $pose['cor_state'] = '15';
                                DB::table('car_correct')->where('cor_id',$request->input('cor_id'))->update($posa);
                                DB::table('car_correct')->where('cor_cpid',$request->input('cor_cpid'))->where('cor_pgid',$request->input('cor_pgid'))->where('cor_id','!=',$request->input('cor_id'))->where('cor_state','1')->update($pose);
                                $this->insertingLog('审核，', '', '数据编号' . $request->input('cor_id').":".$request->input('cor_good')."->".$request->input('good_name'), '车型纠错审核', $request->ip(), $request->get('session_token')['admin_acc']);
                                return $this->success('操作成功');exit;
                            } else {
                                return $this->error('操作失败2', ErrorInc::MYSQL_FAILED);exit;
                            }
                        }else{
                            return $this->error('数据异常', ErrorInc::MYSQL_FAILED);exit;
                        }
                    }
                }
            }else{
                $pose['cor_state'] = '10';
                $res = DB::table('car_correct')->where('cor_id',$request->input('cor_id'))->update($pose);
                if(!empty($res)) {
                    $this->insertingLog('驳回，', '', '数据编号' . $request->input('cor_id'), '车型纠错审核', $request->ip(), $request->get('session_token')['admin_acc']);
                    return $this->success('操作成功');exit;
                } else {
                    return $this->error('操作失败3', ErrorInc::MYSQL_FAILED);exit;
                }
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }


    public function pjname ( $pg_series,$version){
        if($pg_series==''){
            $name = $version;
        }else{
            $name = $pg_series."-".$version;
        }
        return $name;
    }
}
