<?php

/**
 * Pj品牌服务类[我还有点没明白为啥不把车品、商品品牌、pj品牌放一起，然后对品牌分个类]
 *
 * @author lixiaolin
 * @Date: 2021/7/23
 * @Time: 18:56
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Http\Controllers\BaseController;
use App\Models\GoodsBrand;
use Validator;
use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class PjBrandsService extends Service
{
    //private static $instance;
    private $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new GoodsBrand();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 获取pj品牌数据
     *
     * @param array $brandIDs 可操作品牌id组
     * @param sting $key
     *
     * @return mixed $data
     */
    public static function getAll( $brandIDs = [] , $key = '' ) {
        $data = [];
	    if(!is_array($brandIDs)){
		    return $data;
	    }
        $brandList = RedisService::redisGet('gbList');
	    if($brandList){
	        if(count($brandList[0])<3){
                $brandList = false;
            }
        }
        if ($brandList) {
	        $data = CommonService::filterIds($brandIDs,$brandList,'id');
        } else {
            $brandData = self::gbList();
            $data = CommonService::filterIds($brandIDs,$brandData,'id');
            RedisService::redisSet('gbList', $brandData);
        }
		if($key){
			$data = CommonService::jointArrayKey($data,$key);
		}
        return $data;
    }
    /**
     * 获取品牌图片
     *
     * @param sting $key //输出键
     * @return mixed $data
     */
    public static function getAllPic( $key = '' ) {
	    $goodpic = [];
        $brand01['cd_id'] = '1';
	    $brand01['id'] = '2';
	    $brand01['name'] = '瓦尔塔';
	    $brand01['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_01.jpg";
		$goodpic[] = $brand01;
        $brand02['cd_id'] = '1';
	    $brand02['id'] = '4';
		$brand02['name'] = '风帆';
		$brand02['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_02.jpg";
		$goodpic[] = $brand02;
        $brand03['cd_id'] = '1';
		$brand03['id'] = '9';
		$brand03['name'] = '汤浅';
		$brand03['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_03.jpg";
		$goodpic[] = $brand03;
        $brand04['cd_id'] = '1';
		$brand04['id'] = '3';
		$brand04['name'] = '统一';
		$brand04['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_04.jpg";
		$goodpic[] = $brand04;
        $brand05['cd_id'] = '1';
		$brand05['id'] = '6';
		$brand05['name'] = '骆驼';
		$brand05['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_05.jpg";
		$goodpic[] = $brand05;
        $brand06['cd_id'] = '1';
		$brand06['id'] = '12';
		$brand06['name'] = '理士';
		$brand06['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_06.jpg";
		$goodpic[] = $brand06;
        $brand07['cd_id'] = '1';
		$brand07['id'] = '5';
		$brand07['name'] = '德尔福';
		$brand07['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_07.jpg";
		$goodpic[] = $brand07;
        $brand08['cd_id'] = '1';
		$brand08['id'] = '1';
		$brand08['name'] = '博世';
		$brand08['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_08.jpg";
		$goodpic[] = $brand08;
        $brand09['cd_id'] = '3';
        $brand09['id'] = '0';
        $brand09['name'] = '车膜';
        $brand09['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_Cm.jpg";
        $goodpic[] = $brand09;
        $brand10['cd_id'] = '1';
        $brand10['id'] = '22';
        $brand10['name'] = '冠军';
        $brand10['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_09.jpg";
        $goodpic[] = $brand10;
        $brand11['cd_id'] = '1';
        $brand11['id'] = '24';
        $brand11['name'] = '统力';
        $brand11['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_10.jpg";
        $goodpic[] = $brand11;
        $brand12['cd_id'] = '1';
        $brand12['id'] = '23';
        $brand12['name'] = '泰达';
        $brand12['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_11.jpg";
        $goodpic[] = $brand12;
        $brand13['cd_id'] = '1';
        $brand13['id'] = '16';
        $brand13['name'] = '红冠';
        $brand13['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_12.jpg";
        $goodpic[] = $brand13;
        $brand14['cd_id'] = '0';
        $brand14['id'] = '0';
        $brand14['name'] = 'logo';
        $brand14['path'] = "http://zptz.bluearp.com/Brand_log/brand_logo_img_logo.jpg";
        $goodpic[] = $brand14;
		if($key){
			$goodpic = CommonService::jointArrayKey($goodpic,$key);
		}
        return $goodpic;
    }
    /**
     * 获取某个brand
     *
     * @param int $ID
     *
     * @return mixed
     */
    public static function getByID(int $ID) {
        $data = [];
        $brandList = RedisService::redisGet('gbList');
        if ($brandList) {
	        $brandList = $brandList;
            foreach ($brandList as $key=>$val) {
                if ($val['id'] = $ID) {
                    return $val;
                }
            }
        } else {
            $brandData = self::gbList();
            foreach ($brandData as $key=>$val) {
                if ($val['id'] = $ID) {
                    $data = $val;
                }
            }
            RedisService::redisSet('gbList', $brandData);
        }

        return $data;
    }

    public static function dataList() {
        $brand = self::getAll();
        $attribute = [];
        foreach($brand as $k => $v){
            $data['id'] = $v['id'];
            $data['attribute'] = $v['brand_name'].'代理';
            $attribute[] = $data;
        }
        return $attribute;
    }

    /**|---------------------------------------------------------------------------------
     * @name 添加品牌
     * @param array $input 请求数据
     * @param array $session 操作人信息
     * @param string $ip 操作设备ip
     * @retrun /multitype:array
     * @author dou 2022/2/28 18:40
     * |---------------------------------------------------------------------------------
    */
    public static function addGoodsBrand ( $input , $session , $ip ){
        $rules = [
            'brand_name' => 'required|',
            'sord' => 'required|',
            'brand_remark' => 'required|string',
        ];
        $message = [
            'brand_name.required' => "品牌名称不能为空",
            'sord.required' => "首字母不能为空",
            'brand_remark.required' => "备注公司名称不能为空",
        ];
        $Validator = Validator::make ( $input, $rules, $message );
        if ($Validator->fails ()) {
            return ['Data' => [], 'ErrorMessage' => $Validator->errors ()->first (), 'ErrorCode' => ErrorInc::INVALID_PARAM];
        }

        $search_g = GoodsBrand::where('brand_name',$input['brand_name'])->where('company_id',$session['company_id'])->value('id');
        $zp_id = $input['zp_id']??0;
        if($search_g){
            if($zp_id>0){
                GoodsBrand::where('id',$search_g)->update(['zp_id'=>$zp_id]);
                return ['Data' => $search_g, 'ErrorMessage' => '添加成功', 'ErrorCode' => 1];
            }else {
                return ['Data' => [], 'ErrorMessage' => '该商品品牌已存在', 'ErrorCode' => ErrorInc::REPEAT_SUBMIT];
            }
        }
        $ins = GoodsBrand::insertGetId(['brand_name'=>$input['brand_name'],'sord'=>$input['sord'],'brand_remark'=>$input['brand_remark']??'','brand_dress'=>$input['brand_dress']??'','zp_id'=>$zp_id,'company_id'=>$session['company_id']]);
        if($ins){
            //更新redis内容
            $gbLists = self::gbList();
            $gbList = json_encode($gbLists);
            RedisService::redisSet('gbList',$gbList);

            $content = '品牌名称：'.$input['brand_name'];
            $BaseController = new BaseController();
            $BaseController->insertingLog('添加，','',$content,'品牌管理',$ip,$session['admin_acc']);//备注
            return ['Data' => $ins, 'ErrorMessage' => '添加成功', 'ErrorCode' => 1];
        }else{
            return ['Data' => [], 'ErrorMessage' => '添加失败', 'ErrorCode' => ErrorInc::MYSQL_FAILED];
        }
    }

    /**
     * 所有品牌数据
     * @return array
     * @author du 2021年7月20日下午3:16:43
     */
    public static function gbList(){
        $db = new GoodsBrand();
        $data = CommonService::getMysqlData($db, ['del_flag'=>1],['id','brand_name','zp_id','company_id'],['id'=>'DESC']);
        return $data;
    }
}
