<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SettlementThree extends Model
{
    protected $table = 'settlement_three';
    // 拒绝添加的字段
    protected $guarded = [];
    public $timestamps = false;

    public function settlementlist(){
        return $this->hasOne(SettlementList::class,'id','pgid')->select('id','all_price','list_service_type','subsidy_money');
    }

    public function user(){
        return $this->hasOne(User::class,'id','customer_id')->select('id','shr_name','shr_phone');
    }
    public function ordermsg(){
        return $this->hasOne(OrderMsg::class,'id','msg_id')->select('id','goods_name','goods_num','goods_id');
    }
    public function pt(){
        return $this->hasOne(Pt::class,'id','p_id')->select('id','pt_name');
    }
    public function admin(){
        return $this->hasOne(Admin::class,'id','ser_id')->select('id','admin_name');
    }
    public function orders(){
        return $this->hasOne(Orders::class,'sys_num','sys_num')->select('sys_num','new_customer_id');
    }
}
