<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class OrderAddRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'sys_bh' => 'required',
            'ser_type' => 'required',
            'skb_bh' => 'required',
            'pt_id' => 'required',
            'order_time' => 'required',
            'shr_name' => 'required',
            'shr_phone' => 'required|integer',
            'shr_sheng' => 'required|integer',
            'shr_shi' => 'required|integer',
            'shr_xian' => 'required|integer',
            'shr_adress' => 'required',
            'goods' => 'required',
        ];
    }

    public function messages()
    {
        $message = [
            'sys_bh.required' => '参数错误',
            'ser_type.required' => '请选择服务类型',
            'skb_bh.required' => '平台单号不能为空',
            'pt_id.required' => '请选择销售平台',
            'order_time.required' => '创建时间(下单时间)不能为空',
            'shr_name.required' => '收件人不能为空',
            'shr_phone.required' => '联系电话不能为空',
            'shr_sheng.required' => '请选择省',
            'shr_shi.required' => '请选择市',
            'shr_xian.required' => '请选择县',
            'shr_adress.required' => '详细地址不能为空',
            'goods.required' => '请选择商品',
        ];
        return $message;
    }

}
