<?php

namespace App\Http\Controllers\ExcelInfo;
use App\Http\Controllers\BaseController;
use App\Exceptions\ApiException;
use App\Services\ExcelpermissService;
use Illuminate\Http\Request;
use App\Models\ExcelPermiss;
use App\ExcelTemp\ExcelTemp;
use BlueCity\Core\Inc\ErrorInc;

class ExcelpermissController extends BaseController
{
	use ExcelTemp;

    /**
     * @name  列表页
     * @param action_name  控制器名
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function index (Request $request)
    {
        $input = $request->all();
        $session = $request->get('session_token');
        $list = ExcelpermissService::getList($input,$session);
        if($list['list']){
            return $this->success('获取成功', $list); exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
        }
    }

    /**
     * @name  添加
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelAdd (Request $request)
    {
        if ($request->filled(['action_name','action_value','adg_data'])) {
            $input = $request->only('action_name','action_value','adg_data','admin_id');
            $exist = ExcelPermiss::where('adg_admin',$input['admin_id'])->where('adg_action',$input['action_value'])->value('adg_id');
            if (!empty($exist)) {
                return $this->error('该权限已添加,请勿重复添加', ErrorInc::MYSQL_FAILED);exit;
            }
            $res = ExcelPermiss::insert([
                'adg_admin' => $input['admin_id'],
                'adg_action' => $input['action_value'],
                'adg_acname' => $input['action_name'],
                'adg_data'   => json_encode($input['adg_data'],JSON_UNESCAPED_UNICODE,2),
                'adg_type'   => 1,
                'company_id' => $request->get('session_token')['company_id'],
            ]);
            if ($res) {
            	$this->insertingLog("导出权限，",$input['action_value'],"导出权限添加".$input['action_name'],"导出权限",$request->ip(), $request->get('session_token')['admin_acc']);//日志
                return $this->success('添加成功');exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**
     * @name  编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelEdit (Request $request)
    {
        if ($request->filled('adg_id')) {
            $adg_id = intval($request->input('adg_id'));
            $input = $request->only('action_name','action_value','adg_data','admin_id');
            $exist = ExcelPermiss::where('adg_admin',$input['admin_id'])->where('adg_action',$input['action_value'])->where('adg_id','!=',$adg_id)->where('adg_type',1)->value('adg_id');
            if (!empty($exist)) {
                return $this->error('该权限已添加,请勿重复添加', ErrorInc::MYSQL_FAILED);exit;
            }
            $res = ExcelPermiss::where('adg_id',$adg_id)->update([
                'adg_admin' => $input['admin_id'],
                'adg_action' => $input['action_value'],
                'adg_acname' => $input['action_name'],
                'adg_data'   => json_encode($input['adg_data'], JSON_UNESCAPED_UNICODE),
                'adg_type'   => 1,
            ]);
            if ($res) {
                $this->insertingLog("导出权限，",$input['action_value'],"导出权限编辑".$input['action_name'],"导出权限",$request->ip(), $request->get('session_token')['admin_acc']);//日志
                return $this->success('编辑成功');exit;
            } else {
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }


    /**
     * @name  删除
     * @param adg_id  数据id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelDel (Request $request)
    {
        if ($request->filled('adg_id')) {
            $res = ExcelPermiss::where('adg_id',$request->input('adg_id'))->delete();
            if ($res) {
            	$this->insertingLog("导出权限，",$request->input('adg_id'),"导出权限删除ID".$request->input('adg_id'),"导出权限",$request->ip(), $request->get('session_token')['admin_acc']);//日志
                return $this->success('删除成功');exit;
            } else {
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**
     * @name  获取 控制器名称
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelActions ()
    {
        $data['list'] = $this->getActions();
        return $this->success('获取成功',$data);exit;
    }

    /**
     * @name  获取字段
     * @param action_value  控制器
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelFields (Request $request)
    {
        if ($request->filled('action_value')) {
            $action_value = $request->input('action_value');
            $data['list'] = $this->getField($action_value);
            return $this->success('获取成功',$data);exit;
        }
    }


}
