<?php

namespace App\Http\Controllers\Api\MobileWeb;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Validators\Api\MobileWeb\AftersaleOrderValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\Api\MobileWeb\AftersaleOrderService;
use App\Services\DealPicService;

// 移动端-售后单
class AftersaleOrderController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    public function __construct()
    {
        $this->dataValidator = new AftersaleOrderValidator();
    }

    /**
     * 售后列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function index(Request $request) {
        // 验证数据
        $error_message = $this->dataValidator->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = AftersaleOrderService::index($request->all(), $this->show_count,1);
        return response()->json($return_data);
    }

    /**
     * 售后立即处理
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function handle_ive(Request $request) {
        // 验证数据
        $error_message = $this->dataValidator->handle_iveValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $data = $request->all();
        $data['ip'] = $request->ip();
        $return_data = AftersaleOrderService::handle_ive($data);
        return response()->json($return_data);
    }

    /**
     * 日常反馈
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function dailyFeedback(Request $request) {
        // 验证数据
        $error_message = $this->dataValidator->dailyFeedbackValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $data = $request->all();
        $data['ip'] = $request->ip();
        $return_data = AftersaleOrderService::dailyFeedback($data);
        return response()->json($return_data);
    }

    /**
     * 申请完成
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function quality (Request $request) {
        // 验证数据
        $error_message = $this->dataValidator->dailyFeedbackValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $data = $request->all();
        $data['ip'] = $request->ip();
        $return_data = AftersaleOrderService::quality($data);
        return response()->json($return_data);
    }

    /**
     * 上传图片
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-12
     * @param  Request          $request [description]
     */
    public function upload(Request $request)
    {
        $session = $request['session'];
        // if (empty($request['file'])) {
        //     return response()->json(['ErrorCode' => 2, 'ErrorMessage' => '请上传文件', 'Data' => []]);
        // }
        $request['path'] = './afterSale/'.date('Ym');
        $return_data = DealPicService::upload($request);
        if ($return_data['code'] == 200) {
            return response()->json(['ErrorCode' => 1, 'ErrorMessage' => '上传成功', 'Data' => $return_data['data']]);
        } else {
            return response()->json(['ErrorCode' => 2, 'ErrorMessage' => $return_data['msg'], 'Data' => '']);
        }
    }

    /**
     * 详情
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function info (Request $request) {
        // 验证数据
        $error_message = $this->dataValidator->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $data = $request->all();
        $data['ip'] = $request->ip();
        $return_data = AftersaleOrderService::info($data);
        return response()->json($return_data);
    }
}
