<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use App\Models\GateWay;
use App\Http\Requests\GateWayRequest;
use phpDocumentor\Reflection\Types\Integer;
use App\Services\GateService;
use BlueCity\Core\Controllers\CoreController;
use function GuzzleHttp\Promise\all;

class GateWayController extends CoreController
{
    protected $dataFields = ['app_id', 'secret', 'company_id', 'app_auth'];
    /**
     * @api {get} /api/admin/gateway 鉴权管理
     * @apiGroup 鉴权管理
     * @apiName 鉴权管理列表
     * @apiVersion 1.0.0
     *
     * @apiDescription 接口描述
     *
     * @apiParam {String} keyword  关键字
     *
     * @apiSuccess {Number} error    状态码，0：请求成功
     * @apiSuccess {String} msg   提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":0,"message":"","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":5001,"message":"接口异常"}
     *
     */
    public function index(Request $request)
    {
        $gateWayService = new GateService();

        $keyWord = $request->input('keyword');
        $condition = [];

        if ($keyWord != '')
        {
            $condition[] = ['title', $keyWord];
        }
        $query = GateWay::orderBy('id', 'desc');
        if (!empty($query))
        {
            $query->where($condition);
        }
        $list = $query
            ->paginate(10);

        return Response()->json([]);
    }

    /**
     * @api {post} /api/admin/gateway 添加
     * @apiGroup 鉴权管理
     * @apiName 添加
     * @apiVersion 1.0.0
     *
     * @apiDescription 接口描述
     *
     * @apiParam {String} title  名称
     *
     * @apiSuccess {Number} error    状态码，0：请求成功
     * @apiSuccess {String} msg   提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":0,"message":"","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":5001,"message":"接口异常"}
     */
    public function store(GateWayRequest $request)
    {
        $data = $request->all();

        $gateWayService = new GateService();
        $res = $gateWayService->create($data);
        if ($res) {
            return $this->success('成功');
        } else {
            return $this->error('失败');
        }
    }

    public function show(int $gateWayID)
    {
        $gateWayService = new GateService();
        $gateWay = $gateWayService->find($gateWayID);
        if ($gateWay) {
            return $this->success('返回成功',['entity'=>$gateWay]);
        } else {
            return $this->success('未查到数据', ErrorInc::DATA_EMPTY);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $gateWayID
     * @return mixed
     */
    public function edit( int $gateWayID)
    {
        $gateWayService = new GateService();
        $gateWay = $gateWayService->find($gateWayID);
        if ($gateWay) {
            return $this->success('返回成功',['entity'=>$gateWay]);
        } else {
            return $this->success('未查到数据', ErrorInc::DATA_EMPTY);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  GateWayRequest  $request
     * @param  GateWay  $gateWay
     *
     * @return mixed
     */
    public function update(GateWayRequest $request, GateWay $gateWay)
    {
        $data['title'] = $request->input('title');
        $data['url'] = $request->input('url') ?? '';

        $gateWayService = new GateService();
        $res = $gateWayService->update($data);
        if ($res)
        {
            return $this->success('成功');
        } else {
            return $this->error('失败');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  integer  $id 要禁用的id
     *
     * @return mixed
     */
    public function destroy(Integer $id)
    {
        $gateWayService = new GateService();
        $gateWay = $gateWayService->find($id);
        if ($gateWay->id >0 )
        {
            $gateWayService->setDisabled($id);

            return $this->success('删除成功');
        } else {
            return $this->error('该内容不存在', ErrorInc::DATA_EMPTY);
        }
    }
}
