<?php
namespace App\Http\Controllers\Common;
use App\Http\Controllers\BaseController;
use App\Models\ServiceMode;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use App\Services\BmmcService;
use App\Services\RedisService;
//通用方法控制器
class ServiceModeController extends BaseController
{

    /**
     * 列表
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/12/3
     */
     public function index(Request $request){
     	$page_size = (int)$request->input('page_size',20);
     	$page = (int)$request->input('page',1);
     	if($page<1){
     		$page = 1;
     	}
     	$smode = new ServiceMode();
         if($request->filled('sm_name')){
             $smode = $smode->where('sm_name','like','%'.$request->input('sm_name').'%');
         }
     	$paginate = $smode->orderBy('sm_id','ASC')->paginate($page_size);
     	$list = self::dataToArray($paginate->items());
     	$all_button = BmmcService::whereButton($request->input('token'),$request->input('Pri_id'));
//print_r($all_button);
     	$export = BmmcService::getTopButton('addMode','', $all_button);
     	//print_r($export);
     	$data['button_top'] = $export['button_top']??[];//顶部按钮
     	$data['button_search'] = $export['button_search']??[];//搜索栏按钮

     	if ($list){

     		foreach ($list as $k=>$v){
     			$button = [];
     			 if ($v['sm_delflag'] == 1){
                	$button[] = "editModeDelfalg";
                }elseif($v['sm_delflag'] == 2){
                	$button[] = "editModeDelfalgQ";
                }
                $button[] = "editMode";
     			$button = BmmcService::getListButton($button,$all_button);

     			$list[$k]['button_one'] = $button['button_one']??[];
     			$list[$k]['button_two'] = $button['button_two']??[];
     			$list[$k]['button_three'] = $button['button_three']??[];
     		}
     		//返回数据
     		$data['list'] = $list;
     		$data['page'] = [
     			'count' => $paginate->total(),
                'page'=>$paginate->currentPage(),
                'page_size'=>$page_size,
                'allPage'=>$paginate->lastPage()
     		];
     		return $this->success('获取成功', $data);
     	}else{
     		return $this->error('暂无数据', ErrorInc::DATA_EMPTY, $data);
     	}
     }


    /**
     * 添加
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/12/3
     */
     public function addMode(Request $request){
     	$parameter = $request->only('sm_name','sm_remark');
     	$checkKey = CommonService::checkKey(['sm_name'],$parameter);
     	if($checkKey['code']!=1){
     		return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);exit;
     	}

     	$sm_name = trim($parameter['sm_name']);

     	$exists = ServiceMode::where('sm_name',$sm_name)->value('sm_id');

     	if($exists){
     		return $this->error('已存在请重新填写', ErrorInc::MYSQL_FAILED, []);
     	}
     	if($request->filled('sm_remark')){
     		$dataArr['sm_remark'] = $parameter['sm_remark'];
     	}
     	$dataArr['sm_adminid'] = $request->get('session_token')['id'];
     	$dataArr['sm_creactime'] = date("Y-m-d H:i:s");
         $dataArr['sm_name'] = $parameter['sm_name'];

         $res = ServiceMode::insert($dataArr);
     	if($res){
     		//更新redis内容
     		$smLists = $this->smList();
     		$smList = json_encode($smLists);
     		RedisService::redisSet('smList',$smList);

     		$this->insertingLog('添加服务方式，','',$sm_name,'服务方式管理',$request->ip(),$request->get('session_token')['admin_acc']);
     		return $this->success('添加成功', []);
     	}else{
     		return $this->error('添加失败', ErrorInc::MYSQL_FAILED, []);
     	}
     }

    /**
     * 编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/12/3
     */
     public function editMode(Request $request){
     	$parameter = $request->only('id','sm_name','sm_remark');
     	$checkKey = CommonService::checkKey(['id','sm_name'],$parameter);
     	if($checkKey['code']!=1){
     		return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);exit;
     	}
     	$id = $request->input('id');
     	$sm_name = trim($request->input('sm_name'));
     	$exists = ServiceMode::where('sm_name',$sm_name)->where('sm_id','!=',$id)->value('sm_id');
     	if($exists){
     		return $this->error('已存在请重新填写', ErrorInc::MYSQL_FAILED, []);
     	}
     	$dataArr['sm_remark'] = $request->input('sm_remark');
     	$dataArr['sm_name'] = $sm_name;
     	$dataArr['sm_adminid'] = $request->get('session_token')['id'];
        $dataArr['sm_updatetime'] = date("Y-m-d H:i:s");
     	$res = ServiceMode::where('sm_id',$id)->update($dataArr);
     	if($res){
     		//更新redis内容
     		$smLists = $this->smList();
     		$smList = json_encode($smLists);
     		RedisService::redisSet('smList',$smList);
     		$this->insertingLog('编辑服务方式，','',$sm_name,'服务方式管理',$request->ip(),$request->get('session_token')['admin_acc']);
     		return $this->success('编辑成功', []);
     	}else{
     		return $this->error('编辑失败', ErrorInc::MYSQL_FAILED, []);
     	}

     }

    /**
     *  编辑启用停用
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/12/3
     */
     public function editModeDelfalg(Request $request){
     	if(!$request->filled('id')){
     		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
     	}
     	$id = intval($request->input('id'));

     	$del_flag = ServiceMode::where('sm_id',$id)->value('sm_delflag');

     	if ($del_flag == 1){
     		$poss['sm_delflag'] = 2;
     	}elseif ($del_flag == 2){
     		$poss['sm_delflag'] = 1;
     	}
     	$res = ServiceMode::where('sm_id',$id)->update($poss);
     	if($res){
     		$this->insertingLog('编辑服务方式开关','',$id,'服务方式管理',$request->ip(),$request->get('session_token')['admin_acc']);
     		return $this->success('操作成功', []);
     	}else{
     		return $this->error('操作失败', ErrorInc::MYSQL_FAILED, []);
     	}
     }



    /**
     * 所有服务方式数据
     * @return array
     * @author du
     * @date 2021/12/3
     */
     public function smList(){
     	$data = ServiceMode::where('sm_delflag',1)->orderBy('sm_id','asc')->get();
     	return $data;
     }


}
