<?php

namespace App\Services;
use App\Models\JdBound;
use App\Models\Orders;
use App\Models\User;
use BlueCity\Core\Service\Service;
use DB;



class JdBoundService extends Service
{
    /**
     * 获取详细内容
     * @param string $key 查询键
     * @param string $value 查询值
     * @param array $select 待查询参数
     * @param array $type 查询类型
     * @return
     * @author du 2021年8月20日上午9:03:06
     */
    public static function getInfoBy($key, $value, $select = [] , $type = 'get')
    {
    	$db = new JdBound();
    	if(in_array($key, ['id','sku_id'])) {
            $type = 'first';
        }
    	if($type == 'first') {
            if (count($select) == 1) {
                $type = 'value';
            }
        }
    	$list = CommonService::getMysqlData($db,[$key=>$value],$select,[],$type);
    	return $list;
    }

  /**
   * 添加
   * @param  $sku_id
   * @param  $jd_goodn
   * @param  $pt_id
   * @param  $goods_id
   * @param  $is_long
   * @param  $goods_number
   * @param  $goods_name
   * @return
   * @author du 2021年8月19日上午10:27:02
   */
    public static function createjdBound($sku_id,$jd_goodn,$pt_id,$goods_id,$is_long,$goods_number,$goods_name,$company_id){
		$poss['sku_id'] = $sku_id;
		$poss['jd_goodn'] = $jd_goodn;
		$poss['pt_id'] = $pt_id;
		$poss['goods_id'] = $goods_id;
		$poss['is_long'] = $is_long;
		$poss['goods_number'] = $goods_number;
		$poss['goods_name'] = $goods_name;
        $poss['company_id'] = $company_id;
		$res = Db::table('jd_bound')->insert($poss);
    	return $res;
    }


    /**
     * 获取列表
     * @param array $input
     * @param array $session
     * @return Ambigous <multitype:, unknown, multitype:unknown NULL >
     * @author du 2021年8月20日下午3:39:38
     */
    public static function getList($input,$session){
    	$where = [];
    	$Db = JdBound::leftjoin('pj_goods','pj_goods.pg_id','=','jd_bound.goods_id')->join('pt','jd_bound.pt_id','=','pt.id');

    	$where['1'] = 1;
        if ($session['admin_groupnew'] != 7) {//管理员可以看全部
            $where['gone_jd_bound.company_id'] = $session['company_id'];
        }
        if(isset($input['sku_id'])){
            $where['sku_id_like'] = $input['sku_id'];
        }
        //平台ID
        if(isset($input['pt_id'])){
            $where['pt_id'] = $input['pt_id'];
        }
        //京东商品名称
        if(isset($input['jd_goodn'])){
            $where['jd_goodn_like'] = trim($input['jd_goodn']);
        }
        //商品品牌
        if(isset($input['brand_name'])){
            $where['brand_name'] = trim($input['brand_name']);
        }
         //商品型号
        if(isset($input['version'])){
            $where['version_like'] = trim($input['version']);
        }

    	$where = CommonService::jointWhere($where);
    	$page_size = $input['page_size']??10;
    	//DB::connection()->enableQueryLog();#开启执行日志
    	$paginate = $Db->whereRaw($where)->select("jd_bound.id AS id","sku_id","jd_goodn","is_long","brand_name","pg_series","version","general_version","national_version","pt.pt_name AS pt_name")->orderBy('jd_bound.id','asc')->paginate($page_size);
    	//print_r(DB::getQueryLog());

    	$all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
    	$export = BmmcService::getTopButton('addBound','',$all_button);
    	$data['button_top'] = $export['button_top']??[];//顶部按钮
    	$data['button_search'] = $export['button_search']??[];//搜索栏按钮
    	$list = CommonService::dataToArray($paginate->items());
    	if($list){
    		$list = JdBoundService::getButtonDatas($all_button, $list);
    		$data['list'] = $list;
    		$data['page'] = [
    				'count' => $paginate->total(),
    				'page'=>$paginate->currentPage(),
    				'page_size'=>$page_size,
    				'allPage'=>$paginate->lastPage()
    		];
    	}else{
    		$data['list'] = [];
    	}
    	return $data;
    }
    /**
     * 获取按钮和数据
     * @param array $all_button
     * @param array $list
     * @return string
     * @author du 2021年8月20日下午4:40:48
     */
    public static function getButtonDatas($all_button,$list){

    	foreach ($list as $k => $v){
            $buttonData = [];
            if($v['pg_series']==''){
                $list[$k]['sd_name'] = $v['brand_name']."-".$v['version'];
            }else{
                $list[$k]['sd_name'] = $v['brand_name']."-".$v['pg_series']."-".$v['version'];
            }
    		$buttonData[] = 'editBound,deleteBound';
    		$button = BmmcService::getListButton($buttonData,$all_button);

    		$list[$k]['button_one'] = $button['button_one']??[];
    		$list[$k]['button_two'] = $button['button_two']??[];
    		$list[$k]['button_three'] = $button['button_three']??[];
    	}
    	return $list;
    }

    /**
     * @param $jd_order
     * @param $sys_bh
     * @param $goods_name
     * @param $cost_amou
     * @param $session
     * @return mixed
     * @author du 2021年8月20日上午9:40:48
     */
    public static function addOrderInfo ($jd_order,$sys_bh,$goods_name,$cost_amou,$session,$reaa=''){
        $userArr['shr_name'] = $jd_order['fullname'];
        if($jd_order['telephone']){
            $shr_phone = $jd_order['telephone'];
        }else{
            $shr_phone = $jd_order['mobile'];
        }
        $userArr['shr_phone'] = $shr_phone;
        $userArr['shr_sheng'] = $jd_order['province'];
        $userArr['shr_shi'] = $jd_order['city'];
        $userArr['shr_xian'] = $jd_order['county'];
        $userArr['shr_adress'] = $jd_order['full_address'];
        $userArr['sys_num'] = $sys_bh;
        $userArr['create_time'] = date('Y-m-d H:i:s');
        $customer_id = User::insertGetId($userArr);
        //添加订单
        $data['goods_name'] = $goods_name;//商品名称
        $data['p_id'] = $jd_order['pt_id'];//平台id
        $data['order_num'] = $jd_order['order_id'];//平台编号
        $data['order_time'] = $jd_order['order_start_time'];//date('Y-m-d H:i:s');//下单时间
        $data['sys_num'] = $sys_bh;//系统编号
        $data['customer_id'] = $customer_id;//客户信息
        $data['new_customer_id'] = $customer_id;//安装联系人
        $data['order_account'] = $cost_amou;//订单金额
        $data['new_money'] = $cost_amou;//实收
        $data['handled_by'] = $session['admin_name'];//创建人
        $data['admin_id'] = $session['id'];//创建人id
        $data['ser_type'] = 1;//服务类型
        $data['order_status'] = 10;//默认为可派单
        if($reaa){
            $data['kef_id'] = $reaa['kf_id'];
        }
        $newOrderId = Orders::insertGetId($data);
        if($newOrderId){
            return $newOrderId;
        }else{
            return false;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 查询绑定信息
     * @param string $key 查询键
     * @param string/array $value 查询值
     * @param array $select 待查询参数
     * @param string $type 查询类型
     * @retrun /multitype:array
     * @author dou 2021/9/27 20:14
     * |---------------------------------------------------------------------------------
     */
    public static function getBoundBy ( $key , $value , $select , $type = 'get' ){
        $db = DB::table('tm_bound');
        if(is_array($value)){
            $key .= '_searchin';
        }
        if($type =='first' && count($select) == 1){
            $type = 'value';
        }
        $list = CommonService::getMysqlData($db,[$key=>$value],$select,[],$type);
        return $list;
    }

}
