<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Region extends Model
{
    //区域表
    protected $table="region";
    protected $guarded=[];
    public $timestamps=false;


    /**|---------------------------------------------------------------------------------
     * 获取省
     * @return mixed
     * |---------------------------------------------------------------------------------
     */
    public function get_sheng ()
    {
        $data = self::where('reg_level',1)->select('reg_id as are_sheng','reg_name','reg_num','reg_blnum')->get()->toArray();
        return $data;
    }



    /**|---------------------------------------------------------------------------------
     * 获取市
     * @param $param
     * @return bool
     * |---------------------------------------------------------------------------------
     */
    public function get_shi ($param)
    {
        if (is_numeric($param['are_sheng'])) {
            $are_sheng = $param['are_sheng'];
            $reg_num = self::where('reg_id',$are_sheng)->value('reg_num');
            $data = self::where('reg_level',2)->where('reg_blnum',$reg_num)
                ->select('reg_id as are_shi','reg_name','reg_num','reg_blnum')
                ->get()->toArray();
            return $data;
        } else {
            return false;
        }
    }


    /**|---------------------------------------------------------------------------------
     * 获取县
     * @param $param
     * @return bool
     * |---------------------------------------------------------------------------------
     */
    public function get_xian ($param)
    {
        if (is_numeric($param['are_shi'])) {
            $are_shi = $param['are_shi'];
            $reg_num = self::where('reg_id',$are_shi)->value('reg_num');
            $data = self::where('reg_level',3)->where('reg_blnum',$reg_num)
                ->select('reg_id as are_xian','reg_name','reg_num','reg_blnum')
                ->get()->toArray();
            return $data;
        } else {
            return false;
        }
    }

}
