<?php
/**
 * 文件名称（数据统计）
 * 文件简单描述（用于进行数据统计分析）
 * @author DouBin
 * @Date: 2024/10/15
 * @Time: 17:34
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Http\Controllers\DatasBase;
use App\Http\Controllers\BaseController;
use App\Services\CommonService;
use App\Services\DataStatisticsService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use DB;
use Excel;


/**
 * @name 自动派单绑定服务商
 * Class BservissController
 * @package App\Http\Controllers\Admin
 */
class DataStatisticsController extends BaseController
{
    /**|---------------------------------------------------------------------------------
     * @name 数据首页
     * @param string
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/10/15 17:37
     * |---------------------------------------------------------------------------------
    */
    public function index ( Request $request ){
        $session = $request->get("session_token");
        $input = $request->all();
        $checkKey = CommonService::checkKey(['method','time_start','search_type'],$input);
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);
        }
        if(!in_array($input['search_type'],['week','month'])){
            return $this->error('查询类型错误',ErrorInc::INVALID_PARAM,$input);
        }
        $api=['getSerStatistics','getSerStatisticsDetail'];
        if(!in_array($input['method'],$api)){
            return $this->error('接口不参数异常',ErrorInc::INVALID_PARAM,$input);
        }else {
            $api = (string)$input['method'];
            $data = DataStatisticsService::$api($session,$input);
            return $this->success('操作成功
            ',$data);
        }
    }
}
