<?php

namespace App\Http\Requests\Validators\Api\MobileWeb;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 移动端-售后单列表
class AftersaleOrderValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return false;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'status.required' => '请输入售后单状态',
            'status.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'status' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function handle_iveValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'id.required' => '请选择售后单id',
            'id.integer' => '参数错误',
            'quality_content.required' => '请输入处理内容',
            'quality_content.max' => '参数错误',
            'appoint_time.required' => '请选择预约时间',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'id' => 'required|integer|min:1',
            'quality_content' => 'required|string|max:50',
            'appoint_time' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 日常反馈验证器
    public function dailyFeedbackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'id.required' => '请选择售后单id',
            'id.integer' => '参数错误',
            'remark.required' => '请输入反馈内容',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'id' => 'required|integer|min:1',
            'remark' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 列表验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'id.required' => '请输入售后单id',
            'id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 接单验证器入口
    public function receivingStartValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '请输入请求类型',
            'type.in' => '参数错误',
            'id.required' => '请输入工单id',
            'id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [//类型1强制登录2不登录
                'required',
                Rule::in(['1', '2']),
            ],
            'id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    // 接单验证器
    public function receivingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'receive_install_id.required' => '请选择安装人员',
            'receive_install_id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'receive_install_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 拒单验证器
    public function refuseValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'id.required' => '请输入服务工单id',
            'id.integer' => '参数错误',
            'stauas.required' => '订单状态错误',
            'stauas.integer' => '参数错误',
            'refuseType.required' => '未选择拒单方式',
            'refuseType.integer' => '参数错误',
            'remarks.required' => '请输入拒单备注',
            'remarks.max' => '拒单备注长度超出限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'id' => 'required|integer|min:1',
            'stauas' => 'required|integer|min:1',
            'refuseType' => 'required|integer|min:1',
            'remarks' => 'required|string|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    // 预约验证器
    public function contactValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'id.required' => '请输入服务工单id',
            'id.integer' => '参数错误',
            'day_time.required' => '请填写预约时间',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'id' => 'required|integer|min:1',
            'day_time' => 'required|string|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 开始安装验证器
    public function startInstallValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'id.required' => '请输入服务工单id',
            'id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 安装反馈验证器
    public function installFeedbackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'id.required' => '请输入服务工单id',
            'type.required' => '请选择完成类型',
            // 'template_data.required' => '请输入图片相关数据',
            // 'license_plate.required' => '请输入车牌号',
            // 'license_plate.max' => '长度超出限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'id' => 'required|integer|min:1',
            'type' => 'required|integer|min:1',
            // 'template_data' => 'required',
            // 'license_plate' => 'required|string|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 操作记录验证器
    public function operatingRecordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'serial_number.required' => '请输入单号',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'serial_number' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 反馈安装图片验证器
    public function imageFeedbackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'image_url.required' => '参数错误',
            'image_id.required' => '参数错误',
            'image_type.required' => '参数错误',
            'id.required' => '请输入服务工单id',
            'id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'image_url' => 'required|min:1',
            'image_type' => 'required|min:1',
            'image_id' => 'required|min:1',
            'id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }


    // 反馈车牌车架号验证器
    public function LicenseFeedbackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'install_id.required' => '参数错误',
            'admin_id.required' => '参数错误',
            'gd_id.required' => '参数错误',
            'id.required' => '请输入服务工单id',
            'id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'install_id' => 'required|integer|min:1',
            'admin_id' => 'required|integer|min:1',
            'gd_id' => 'required|integer|min:1',
            'id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
