<?php

namespace App\Http\Controllers\Orders;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Common\CommonController;
use App\Models\OrderAfterDetai;
use App\Models\OrderAftertrack;
use App\Models\Orders;
use App\Models\SyncStores;
use App\Models\User;
use App\OtherModels\SmsRecord;
use App\Services\AfterSaleService;
use App\Services\CategoryService;
use App\Services\EventGiftService;
use App\Services\ExceloutService;
use App\Services\FunctionsService;
use App\Services\GoodsService;
use App\Services\LabtypeService;
use App\Services\PlatformService;
use App\Services\RecycleOrderService;
use App\Services\RefundService;
use App\Services\SendGoodsService;
use App\Services\SmsService;
use App\Services\UserService;
use BlueCity\Data\Service\ZhiPei\OrderService as zhiPeiOrder;
use Faker\Provider\es_ES\Color;
use Illuminate\Http\Request;
use DB;
use App\Services\OrderService;//订单服务
use App\Services\CommonService;//通用服务
use App\Services\AftersaleOrderService;//售后服务
use BlueCity\Core\Inc\ErrorInc;
use App\Models\Aftersale;
use App\Models\OrderAfter;
use App\Models\Afterclass;
use App\Models\Afterreminder;
Use App\Models\OrderList;
Use App\Models\InstallPerson;
Use App\Models\Admin;
Use App\Models\FeedSales;
Use App\Services\ValidationService;


class AftersaleOrderController extends BaseController
{
    /**|---------------------------------------------------------------------------------
     * @name 列表页
     * @param state 0：全部；1：未处理；10：处理中；15：客服介入；30：审核中；40：已完成；50：已撤销
     * @param sys_num 系统单号
     * @param order_num 平台单号
     * @param after_num 售后单号
     * @param p_id 平台id
     * @param ser_id 服务商id
     * @param shr_name 客户姓名
     * @param shr_phone 客户电话
     * @param shr_sheng 省
     * @param shr_shi   市
     * @param day_type 数据分类(number)
     * @param lock_time 追踪时间
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function index ( Request $request ){
        if (!$request->filled('state')) {
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);
        }
        $input = $request->all();
        if(!in_array($input['state'],[0,1,2,10,15,30,40,50,3])){
	        return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);
        }
    	$list = AftersaleOrderService::getList($input,$request->get('session_token'));

        //导出 start
        if ($input['is_excel'] == 1) {
            $sqls = $list['sqls'];
            //dd($sqls);
            $excel = new CommonController();
            return $excel->getExcelOut($input['Pri_id'], $sqls, $request->get('session_token'));
        }
        unset($list['sqls']);
        //导出 end

        //车膜导出 start
     /*   if ($input['is_excel'] == 2) {
            $sql2 = $list['sql2'];
            $lists = DB::select($sql2);
            if($lists){
                $exceout = new ExceloutService();
                $con_name = '售后车膜导出';//控制器名称
                $action = 'AftersaleOrderCarfilms';//控制器
                $field_data = $exceout->gainFields($request->get('session_token')['id'], $action);
                if (empty($field_data)) {
                    return $this->error('您暂时无导出权限', ErrorInc::MYSQL_FAILED);
                }
                return $exceout->createPlan($lists,$sql2,200,$action,$con_name,$request->get('session_token')['id'],$request->get('session_token')['admin_acc']);
            }else{
                return $this->error('暂无数据', ErrorInc::MYSQL_FAILED);
            }


        }*/
        //车膜导出 end

    	if($list['list']){
	    	return $this->success('获取成功', $list); exit;
    	}else{
	    	return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
    	}
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取列表异步信息
     * @param data 请求数据
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/8/11 16:33
     * |---------------------------------------------------------------------------------
     */
    public function sysOtherInfor ( Request $request ){
        if($request->filled('data')) {
            $data = $request->input('data');
            $sys_num = [];
            $order_num = [];
            $after_num = [];
            foreach($data as $k => $v){
                $sys_num[] = $v['sys_num'];
                $order_num[] = $v['order_num'];
                $after_num[] = $v['after_num'];
            }
            $noteRes = CommonService::orderRemarks($sys_num,'orders_id',$request->get('session_token')['admin_groupnew'],$request->input('Login_id'));//获取备注信息
            /*---------------------------获取售后类型（标签）开始----------------------------------*/
            $db = new Aftersale();
            $afs_granid = LabtypeService::getLable('lt_parent_id','207');
            $afs_granid = array_column($afs_granid, 'sety_id');
            $afs_granid [] = 207;
            $labs = CommonService::getMysqlData($db, ['afs_granid_searchin'=>$afs_granid,'afs_order_searchin'=>$order_num],['afs_order','afs_type']);//获取订单添加的售后类型标签
            if($labs) {
                $sety_id = array_column($labs, 'afs_type');
                $labs = CommonService::jointArrayKey($labs, 'afs_order', '2');
                $after_lable = LabtypeService::labelList();
                $after_lable = CommonService::arrayFilterFieldValue($after_lable, array(array('sety_id' => $sety_id)));
                if($after_lable) {
                    $after_lable = CommonService::jointArrayKey($after_lable, 'sety_id');
                }else{
                    $after_lable = [];
                }
            }else{
                $after_lable = [];
            }
            $return = [];
            foreach($data as $k => $v){
                $return[$v['after_num']]['mess'] = $noteRes[$v['sys_num']]??[];
                $return[$v['after_num']]['mess'] = $noteRes[$v['sys_num']]??[];
                if(isset($labs[$v['order_num']])){
                    $set_names = [];
                    foreach( $labs[$v['order_num']] as $key => $value ){
                        if(isset($after_lable[$value['afs_type']])){
                            $set_names[] = $after_lable[$value['afs_type']]['sety_name'];
                        }
                    }
                    $return[$v['after_num']]['set_names'] = $set_names;
                }else{
                    $return[$v['after_num']]['set_names'] = [];
                }
            }

            if(!empty($return)){
                return $this->success('成功', $return); exit;
            } else {
                return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
            }
            /*---------------------------获取售后类型（标签）结束----------------------------------*/
        }else{
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name  获取分类统计
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function getclassFly (Request $request)
    {
        $admin_pt_id = $request->get('session_token')['admin_pt_id'];
        $pt_id = explode(',',trim($admin_pt_id,','));
        $Afterclass = new Afterclass();
        $Arr = CommonService::getMysqlData($Afterclass, ['state'=>1],['class_name','id','category']);
      //  DB::connection()->enableQueryLog();
        $AfterArr = OrderAfter::whereIn('p_id',$pt_id)->where('status',10)->selectRaw("count(id) as classify,data_type,category")->groupBy('data_type')->get();
      // print_r(DB::getQueryLog());
        if ($Arr) {
//            $ClassArr = $ClassArr->toArray();
//            if ($ClassArr) {
//                foreach ($ClassArr as $k => $v) {
//                    $Arr[$k]['id'] = $k;
//                    $Arr[$k]['class_name'] = $v;
//                }
//            }
            array_unshift($Arr,['id'=>0,'class_name'=>"未分类"]);
            foreach ($Arr as $kv => $vv) {
                $Raa[$vv['id']]['lib'] = $vv['id'];
                $Raa[$vv['id']]['class_name'] = $vv['class_name'];
                $Raa[$vv['id']]['category'] = $vv['category'];
                $Raa[$vv['id']]['num'] = 0;
            }
            $raa['aaasa'] = $Raa;
            if (!$AfterArr->isEmpty()) {
                $AfterArr = $AfterArr->toArray();
                // print_r($AfterArr);
                foreach ($AfterArr as $ks => $vs) {
                    $info[$vs['data_type']]['classify'] = $vs['classify'];
                    $info[$vs['data_type']]['category'] = $vs['category']; //订单类型 2021-12-31 du add
                    //$info[$vs['data_type']]['cd_name'] = CategoryService::getNameByCdId($vs['category']);//订单类型 2021-12-31 du add
                }
                $catArr = [];
                foreach ($info as $key => $value) {
                    if (isset($Raa[$key])) {
                        $Raa[$key]['num'] = $value['classify'];
                        if($key>0) {
                            $Raa[$key]['category'] = $value['category'];
                        }
                        $catArr[] = $value['category'];
                    }
                }
            }
            foreach($Raa as $k => $v){
                if($v['lib']=='0'){
                    $raa['show'][0] = $v;
                }
            }

/*foreach ($Raa as $kk =>$vvv){
    $raa['list'][$kk] = $vvv[''];

}*/

            $aa = CommonService::resetListKey($Raa);

            $raa['list'] = $aa;
            if (is_array($catArr)) {

                $catArrus = array_unique($catArr);
                $raa['aaa'] = $catArrus;
                foreach ($catArrus as $kcat => $vcat) {
                    $catArru[$kcat]['cd_name'] = CategoryService::getNameByCdId($vcat);
                    $catArru[$kcat]['category'] = $vcat;
                }
                $raa['cd_info'] = CommonService::resetListKey($catArru);
            }else{
                $raa['cd_info'] = [];
            }

            return $this->success('成功', $raa); exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name  售后催单
     * @param id 数据id
     * @param type 1:展示信息 2：执行催单
     * @param note_content 备注内容
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function AfterReminder (Request $request)
    {
        if (!$request->filled('id')||!$request->filled('type')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
        $id = $request->input('id');
        if($request->input('type')==1){
            $after_num = OrderAfter::where('id', $id)->value('after_num');
            $res = Afterreminder::where("after_num",$after_num)->orderBy('created_at','DESC')->select('creater','created_at')->get()->toarray();
            if ($res) {
                return $this->success('获取成功', $res); exit;
            } else {
                return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            $orderaft = OrderAfter::where('id',$id)->first();
            $sys_num = $orderaft['sys_num'];
            $session = $request->get('session_token');
            $note_content = $request->input('note_content');

            $time = Afterreminder::where('order_num', $orderaft['order_num'])->orderBy('created_at','DESC')->value('created_at');
            //return $time;
            if (isset($time) && $time) {
                if ((strtotime(date("Y-m-d H:i:s"))-strtotime($time)) < 900) {
                    return $this->error('15分钟内不可重复催单，请稍后操作', ErrorInc::REQUEST_FORBIDDEN);exit;
                }
            }

            if ($request->filled('note_content')){
                $rest = CommonService::accMe($sys_num,"售后催单",$note_content,'',1,$session['admin_groupnew'],$session['admin_acc'],$session['id']);

                if ($rest){
                    $res = OrderAfter::where('id',$id)->update(['trigyn'=>2]);
                    OrderAfter::where('id',$id)->increment('reminder_num',1);
                }else {
                    return $this->error('备注添加失败', ErrorInc::MYSQL_FAILED);exit;
                }
            }

            $poss['order_num']   =   $orderaft['order_num'];
            $poss['after_num']   =   $orderaft['after_num'];
            $poss['ser_id']      =   $orderaft['ser_id'];
            $poss['p_id']        =   $orderaft['p_id'];
            $poss['created_at']  =   date("Y-m-d H:i:s");
            $poss['creater']  =   $session['admin_acc'];

            //售后催单记录表
            $res = DB::table('after_reminder')->insert($poss);

            if ($res){
                $weixin['shr_name'] = $orderaft['shr_name'];
                $weixin['shr_phone'] =  $orderaft['shr_phone'];
                $weixin['serial_number'] = $orderaft['serial_number'];
                $weixin['ser_id'] = $orderaft['deal_serid'];
                $weixin['centent'] = $note_content;
                CommonService::requestPost('http://weixin.sudianwang.com/index.php/BindingAccount/urgedAfterPush', $weixin);
                $this->insertingLog("售后催单，",$sys_num,"单号：".$sys_num,"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功'); exit;
            }else {
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name  售后移交
     * @param id 数据id
     * @param deal_admin 服务商id
     * @param admin_name 服务商名称
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function AfterTransfer (Request $request)
    {
        if ($request->filled('id') && $request->filled('deal_admin') && $request->filled('admin_name')){
            $Input = $request->only('id','deal_admin','admin_name');
            $session = $request->get('session_token');
            $info = OrderAfter::where('id',$Input['id'])->select('sys_num','order_num','serial_number')->first();
            if ($request->filled('note_content')){
                $content = $request->input('note_content');
                $rest = CommonService::accMe($info['sys_num'],"售后移交","【售后】售后移交，".$content,$info['serial_number'],'1',$session['admin_groupnew'],$session['admin_acc'],$session['id']);
                if (!$rest){
                    return $this->error('备注添加失败', ErrorInc::MYSQL_FAILED);exit;

                }
            }
            $res = OrderAfter::where('id',$Input['id'])->update(['deal_serid'=>$Input['deal_admin']]);
            if ($res){
                $this->insertingLog("售后移交，",$info['sys_num'],"售后移交：".$Input['admin_name'],"售后列表",$request->ip(),$session['admin_acc']);
                return $this->success('操作成功'); exit;
            }else{
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 驳回申请质保
     * @param id id号
     * @param sys_num 系统单号
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function quality_bohuis (Request $request)
    {
        if ($request->filled('id') && $request->filled('sys_num')){
            if (!$request->filled('quality_content')){
                return $this->error('备注内容不能为空', ErrorInc::INVALID_PARAM, []);exit;
            }
            $Input = $request->only('id','sys_num','quality_content');
            $session = $request->get('session_token');
            $serial_number = OrderList::where('sys_num',$Input['sys_num'])->select('serial_number','ser_id')->first();
            try{
                Db::beginTransaction();
                $rest = CommonService::accMe($Input['sys_num'],"售后订单","【售后】驳回完成申请，".$Input['quality_content'],$serial_number['serial_number'],'1',$session['admin_groupnew'],$session['admin_acc'],$session['id']);
                if($rest){
                    $get['deal_time'] = date("Y-m-d H:i:s");
                    $get['status'] = 10;
                    $get['deal_admin'] = $session['admin_acc'];
                    $result = OrderAfter::where('id',$Input['id'])->update($get);
                    if($result){
                        $after_num=OrderAfter::where('id',$Input['id'])->select('after_num','p_id')->first();
                        $get['after_num'] = $after_num['after_num'];


                        $this->insertingLog("驳回申请质保，",$Input['sys_num'],"订单","售后订单",$request->ip(),$session['admin_acc']);//日志
                        DB::commit();
                        return $this->success('操作成功');exit;
                    }else{
                        DB::rollback();
                        return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
                    }
                }else{
                    DB::rollback();
                    return $this->error('添加备注失败', ErrorInc::MYSQL_FAILED);exit;
                }
            }catch(\Exception $e){
                DB::rollback();
                return $this->error($e->getMessage(), ErrorInc::SERVER_FAILED);exit;
            }

        }else{
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);exit;
        }

    }
    /**|---------------------------------------------------------------------------------
     * @name 撤销售后
     * @param id              id号
     * @param sys_num         系统单号
     * @param quality_content 备注内容
     * @param status          订单状态
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function quality_complete (Request $request)
    {
        if (!$request->filled('id') || !$request->filled('sys_num')){
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);exit;
        }

        if (!$request->filled('quality_content')){
            return $this->error('备注不能为空', ErrorInc::INVALID_PARAM, []);exit;
        }
        $Input = $request->only('id','sys_num','quality_content','status');
        $session = $request->get('session_token');
        $get_id = OrderAfter::where('id',$Input['id'])->value("get_id");//$status
        $orderArr = Orders::where('sys_num',$Input['sys_num'])->select('order_num')->first();
        /*if($status=='1' || $status=='10'){
        }else{
            return response()->json(['Data'=>'','ErrorMessage'=>'操作失败，该订单状态不正确','ErrorCode'=>5]);exit;
        }*/
        Db::beginTransaction();
        $rest = CommonService::accMe($Input['sys_num'],"售后订单","撤销售后，".$Input['quality_content'],'','1',$session['admin_groupnew'],$session['admin_acc'],$session['id']);

        if($rest){
            $get['deal_time'] = date("Y-m-d H:i:s");
            $get['status'] = 50;
            $get['trigyn'] = 1;
            $get['deal_admin'] = $session['admin_acc'];
            if($get_id < 1){
                $get['get_id'] = $session['id'];
                $get['get_time'] = date("Y-m-d H:i:s");
            }
            $result = OrderAfter::where('id',$Input['id'])->update($get);

            if($result){
                $after_num=OrderAfter::where('id',$Input['id'])->select('after_num','p_id')->first();
                $get['after_num'] = $after_num['after_num'];

                /*if(($status=='30' && $Input['status']=='10')){
                    $list = DB::table("feedsales")->where('gl_id',$Input['id'])->value("feedback_pic")->get();
                    if(!$list->isEmpty()){
                        $list = $list->toArray();
                        foreach( $list as $k => $v ){
                            unlink(ltrim($v["feedback_pic"],"/"));
                        }
                        DB::table("feedsales")->where('gl_id',$Input['id'])->delete();
                    }
                }*/
                DB::commit();
                $this->operatingTime($Input['sys_num'],"撤销售后",date("Y-m-d H:i:s"),$orderArr['order_num'],$session['admin_acc']);//订单操作时间
                $this->insertingLog("撤销售后，",$Input['sys_num'],"订单","售后订单",$request->ip(),$session['admin_acc']);//日志
                return $this->success('操作成功');exit;
            }else{
                DB::rollBack();
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            DB::rollBack();
            return $this->error('添加备注失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 申请售后完成
     * @param id id号
     * @param sys_num 系统单号
     * @param quality_content 备注内容
     * @param file base64文件数组
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function quality (Request $request)
    {
        if (!$request->filled('id') || !$request->filled('sys_num')){
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);exit;
        }
        if (!$request->filled('quality_content')){
            return $this->error('备注不能为空', ErrorInc::INVALID_PARAM, []);exit;
        }
        /*if (!$request->filled('file') && $request->input('file') != []){
            return response()->json(['Data'=>'','ErrorMessage'=>'图片必须上传','ErrorCode'=>8]);exit;
        }*/
        $Input = $request->only('id','sys_num','quality_content','file');
        $session = $request->get('session_token');
        $Olaf = OrderAfter::where('id',$Input['id'])->first();
        $serial_number = OrderList::where('sys_num',$Input['sys_num'])->value('serial_number');
        if($Olaf['status']==1 || $Olaf['status']==10 || $Olaf['status']==15){
        }else{
            return $this->error('操作失败，该单状态不正确', ErrorInc::REQUEST_FORBIDDEN, []);exit;
        }
        Db::beginTransaction();
        $rest = CommonService::accMe($Input['sys_num'],"售后订单","【售后】申请完成，".$Input['quality_content'],$serial_number,'2',$session['admin_groupnew'],$session['admin_acc'],$session['id']);
        if($rest){
            if ($request->filled('file') && $request->input('file') != []){
                $company_name = Admin::where('id',$Olaf['deal_serid'])->value("company_name");
                $inst = InstallPerson::where('admin_id',$Olaf['deal_serid'])->first();//安装人员
                $sql = 'INSERT INTO gone_feedsales (`type`,`gl_id`,`install_name`,`install_phone`,`install_time`,`admin_id`,`company_name`,`feedback_status`,`sys_num`,`is_type`,`feedback_pic`) VALUES';
                $num = 0;
                foreach($Input['file'] as $key=>$val){
                    $num = $num + 1;
                        $sql .= "('".$num."','".$Input['id']."','".$inst['install_name']."','".$inst['install_phone']."','".date("Y-m-d H:i:s")."','".$Olaf['deal_serid']."','".$company_name."','2','".$Olaf['after_num']."','2','".$val."'),";
                }
                $sql = substr($sql,0,strlen($sql) - 1);
                DB::insert($sql);
            }

            $get['deal_time'] = date("Y-m-d H:i:s");
            $get['status'] = '30';
            $get['trigyn'] = '1';
            if($Olaf['get_id'] < 1){
                $get['get_id'] = $session['id'];
                $get['get_time'] = date("Y-m-d H:i:s");
            }
            $result = OrderAfter::where('id',$Input['id'])->update($get);
            if($result){
                $after_num = OrderAfter::where('id',$Input['id'])->select('after_num','p_id')->first();
                $get['after_num'] = $after_num['after_num'];

                DB::commit();
                $this->operatingTime($Input['sys_num'],'申请质保完成时间',date("Y-m-d H:i:s"),$Olaf['order_num'],$session['admin_acc']);//订单操作时间
                $this->insertingLog("申请质保完成，",$Input['sys_num'],"订单(".$serial_number.")","派工单列表",$request->ip(),$session['admin_acc']);//日志
                return $this->success('操作成功');exit;
            }else{
                DB::rollBack();
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;            }
        }else{
            DB::rollBack();
            return $this->error('添加备注失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name  审核
     * @param id              id号
     * @param sys_num         系统单号
     * @param quality_content 备注内容
     * @param sety_id         标签id
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function finish_quality (Request $request)
    {
        if ($request->filled(['id','sys_num'])){
            $input = $request->only('id','quality_content','sety_id','labs');
            $lister = OrderAfter::where('id',$request->input('id'))->first();
            $status = $lister['status'];
            if ($status == 1){
                return $this->error('该订单状态不正确', ErrorInc::REQUEST_FORBIDDEN, []);exit;
            }
            if($status == 10 && (!$request->filled('quailty_content') || $request->input('quailty_content') == '')){
                return $this->error('处理中售后单审核请填写备注', ErrorInc::FAILED_PARAM, []);exit;
            }
            /*if($input['status']=='50' || $input['status']=='40'){
                $arr['stauas']='40';
                $arris['order_status']='40';
                $res = OrderList::where('serial_number',$lister['serial_number'])->update($arr);
                $rea = Orders::where('sys_num',$lister['sys_num'])->update($arris);
            }*/
            $session = $request->get('session_token');
            if ($request->filled('quality_content')){
                $rest = CommonService::accMe($lister['sys_num'],"售后订单",$input['quality_content'],$lister['serial_number'],1,$session['admin_groupnew'],$session['admin_acc'],$session['id']);
                if (!$rest){
                    return $this->error('添加备注失败', ErrorInc::MYSQL_FAILED);exit;
                }
            }
            if ($request->filled('file') && $request->input('file') != []){
                $company_name = Admin::where('id',$lister['deal_serid'])->value("company_name");
                $inst = InstallPerson::where('admin_id',$lister['deal_serid'])->first();//安装人员
                $sql = 'INSERT INTO gone_feedsales (`type`,`gl_id`,`install_name`,`install_phone`,`install_time`,`admin_id`,`company_name`,`feedback_status`,`sys_num`,`is_type`,`feedback_pic`) VALUES';
                $num = 0;
                foreach($input['file'] as $key=>$val){
                    $num = $num + 1;
                    $sql .= "('".$num."','".$input['id']."','".$inst['install_name']."','".$inst['install_phone']."','".date("Y-m-d H:i:s")."','".$lister['deal_serid']."','".$company_name."','2','".$lister['after_num']."','2','".$val."'),";
                }
                $sql = substr($sql,0,strlen($sql) - 1);
                DB::insert($sql);
            }
            $get['deal_time'] = date("Y-m-d H:i:s");
            $get['status'] = 40;
            $get['deal_admin'] = $session['admin_acc'];
            if($lister['get_id'] < 1){
                $get['get_id'] = $session['id'];
                $get['get_time'] = date("Y-m-d H:i:s");
            }
            Db::beginTransaction();
            $result = OrderAfter::where('id',$input['id'])->update($get);
            /*Aftersale::insert([
                'afs_order'     =>  $lister['after_num'],
                'afs_serial'    =>  $lister['serial_number'],
                'afs_sales'     =>  1,
                'afs_type'      =>  $input['sety_id'],
                'afs_pid'       =>  $lister['p_id'],
                'afs_serid'     =>  $lister['ser_id'],
                'afs_creactime' =>  date("Y-m-d H:i:s"),
                'asf_time'      =>  date("Y-m-d H:i:s"),
                'afs_day'       =>  date("Y-m-d H:i:s"),
                'afs_statues'   =>  1,
                'afs_creacter'  =>  $session['admin_acc'],
                'afs_dealer'    =>  $session['admin_acc'],
                'afs_paid'      =>  209,
                'afs_granid'    =>  207,
            ]);*/
            $labs = $input['labs']??[];//标签数组
            if($labs) {
                $result = AfterSaleService::insertData($labs, $lister, $session, $input['quality_content']);
            }else{
                $result = true;
            }
            if ($result){
                //$after_num=OrderAfter::where('id',$Input['id'])->select('after_num','p_id')->first();
                $get['after_num'] = $lister['after_num'];


              /*  if ($request->input('type') == 2) {
                    $pt_info = PlatformService::getPtBy('id', $lister['p_id'],['pt_name','sms_name','sms_password','signature']);
                    $sms_content = "尊敬的客户您好，您的售后服务申请长时间未确认方案。如您仍有其它问题可再次联系店铺在线客服或拨打全国售后服务热线400-077-3321，如若已处理完毕，请忽略此信息，给您带来不便敬请谅解，感谢您的支持！";
                    $input = $request->only('phone');
                    $type = $request->input('type');
                    if($pt_info && $pt_info['sms_password']!='') {
                        if($pt_info['sms_name']=='zptzadmin'){
                            if( $pt_info['signature'] !='' && $pt_info['signature'] !=null ){
                                $sms_content="【".$pt_info['signature']."】".$sms_content;
                            }else{
                                $sms_content="【".$pt_info['pt_name']."】".$sms_content;
                            }
                        }
                        CommonService::senSms($input['phone'],$sms_content,'',$pt_info['sms_name'],$pt_info['sms_password'],$request->get('session_token')['admin_acc']);
                    }else{
                        CommonService::senSms($input['phone'], $sms_content, $type, '', '', $request->get('session_token')['admin_acc']);
                    }
//                    $data['sms_content'] = $sms_content;
//                    $data['customer_phone'] = $input['phone'];
//                    $data['created_at'] = date("Y-m-d H:i:s");
//                    $data['sms_creater'] = $request->get('session_token')['admin_acc'];
//                    $data['type'] = $type;
//                    Db::table('sms_record')->insert($data);
                }*/

                DB::commit();
                $this->insertingLog("完成申请售后，",$lister['sys_num'],"完成申请售后","售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');exit;
            }else{
                DB::rollBack();
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            DB::rollBack();
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 查看售后图片
     * @param id id号
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function lookpics (Request $request){
        if ($request->filled('id')){
            $list = AftersaleOrderService::lookpics($request->input('id'));
            if($list){
                foreach ($list as $k=>$v){
                    if ($v['feedback_pic']){
                        $list[$k]['feedback_pic'] = $this->picurl($v['feedback_pic']);
                    }
                }
                return $this->success('操作成功',$list);exit;
            }else{
                return $this->error('暂无反馈图片', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 订单处理
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function handle_ive (Request $request)
    {
        if ($request->filled('sys_num') && $request->filled('quality_content') && $request->filled('id')){
            $session = $request->get('session_token');
            $Input = $request->only('sys_num','quality_content','id');
            $order_num = OrderAfter::where('id',$Input['id'])->value("order_num");
            $status = OrderAfter::where('id',$Input['id'])->value('status');
            if ($status !=1){
                return $this->error('该订单状态不正确', ErrorInc::REQUEST_FORBIDDEN, []);exit;
            }
            $feek_time = date('Y-m-d',strtotime("+1day")).' 17:30:00'; //明天下午5:30时间
            $info['feek_time'] = $feek_time;
            $info['status'] = 10;         //改为处理中
            $info['day_time'] = $request->input('appoint_time');
            $res = OrderAfter::where('id',$Input['id'])->update($info);
            if ($res){
                $after_num = OrderAfter::where('id',$Input['id'])->select('after_num','p_id','shr_phone')->first();
                $info['after_num'] = $after_num['after_num'];

                $rest = CommonService::accMe($Input['sys_num'],'售后列表',$Input['quality_content'],$Input['sys_num'],1,$session['admin_groupnew'],$session['admin_acc'],$session['id']);
                if ($rest){
                  //  $sms_content = "尊敬的客户您好，您的售后服务申请已创建成功。售后师傅会尽快与您联系，在商品保修期内，如确认商品性能故障会为您免费上门换新，若非商品性能故障需要支付50元上门服务费，如有疑问请联系店铺客服或者拨打全国售后服务热线400-077-3321，谢谢！";
                   // $type = 'DianPingPaw';
                    //$phone = $after_num['shr_phone'];
                   // CommonService::senSms($phone,$sms_content,$type);
//                    $data['sms_content'] = $sms_content;
//                    $data['customer_phone'] = $phone;
//                    $data['created_at'] = date("Y-m-d H:i:s");
//                    $data['sms_creater'] = $request->get('session_token')['admin_acc'];
//                    $data['type'] = $type;
//                    Db::table('sms_record')->insert($data);
                    $this->insertingLog("订单处理，",$Input['sys_num'],"订单处理","售后列表",$request->ip(), $request->get('session_token')['admin_acc']);

                    //修改领取人
                    $get_id = OrderAfter::where('id',$Input['id'])->value('get_id');
                    if(!$get_id){
                        OrderAfter::where('id',$Input['id'])->update(['get_id'=>$session['id'],'get_time'=>date("Y-m-d H:i:s")]);
                    }

                    return $this->success('操作成功');exit;
                }else{
                    return $this->error('添加备注失败', ErrorInc::MYSQL_FAILED);exit;
                }
            }else{
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);exit;
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 追踪时间
     * @param id
     * @param look_time 追踪时间
     * @param trigyn 是否推送 1:不推送；2：推送
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function looktime_sumb (Request $request)
    {
        if ($request->filled('id')&&$request->filled('trigyn')){
            if (!$request->filled('look_time')){
                return $this->error('追踪时间不能为空', ErrorInc::INVALID_PARAM, []);exit;
            }
            $order_after = OrderAfter::where('id',$request->input('id'))->first();
            DB::beginTransaction();
            $data['look_time'] = $request->input('look_time');
            $data['trigyn'] = $request->input('trigyn');
            $data['look_type'] = 2;
            $res = OrderAfter::where('id',$request->input('id'))->update($data);
            OrderAftertrack::where("oat_afid",$request->input('id'))->where("oat_state",1)->update(['oat_state'=>2,'oat_dealid'=>$request->get('session_token')['id'],'oat_dealor'=>$request->get('session_token')['admin_acc'],'oat_dealtime'=>date("Y-m-d H:i:s"),'oat_dealcentent'=>'订单追踪时间替换']);
            $poss['oat_afid'] = $request->input('id');
            $poss['oat_afnum'] = $order_after['after_num'];
            $poss['oat_ordernum'] = $order_after['order_num'];
            $poss['oat_sysnum'] = $order_after['sys_num'];
            $poss['oat_looktime'] = $request->input('look_time');
            $poss['oat_creatime'] = date("Y-m-d H:i:s");
            $poss['oat_state'] = 1;
            $poss['oat_creactid'] = $request->get('session_token')['id'];
            $poss['oat_creactor'] = $request->get('session_token')['admin_acc'];
            $poss['oat_state'] = 1;
            $rea = OrderAftertrack::insert($poss);
            if($res && $rea){
                DB::commit();
                $this->insertingLog("追踪时间",$order_after['sys_num'],"订单追踪，时间：".$request->input('looktime')."，单号：".$order_after['sys_num'],"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');exit;
            }else{
                DB::rollBack();
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 售后追踪列表
     * @param string oat_afnum 售后单号
     * @param string oat_ordernum 订单单号
     * @param string state 数据状态
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2022/6/19 23:00
     * |---------------------------------------------------------------------------------
    */
    public function searchAftertrack ( Request $request ){
        if($request->filled('state')){
            $input = $request->all();
            $session = $request->get('session_token');
            if(in_array($input['state'], [0,1,2,3])){
                $list = AftersaleOrderService::searchAftertrack( $input , $session );
                if($list['list']){
                    return $this->success('获取成功', $list); exit;
                }else{
                    return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
                }
            }else{
                return $this->error('查询状态错误', ErrorInc::INVALID_PARAM, []);exit;
            }
        }else{
            return $this->error('缺少参数', ErrorInc::FAILED_PARAM, []);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 处理追踪订单
     * @param int oat_id 追踪数据id
     * @param int oat_afid 订单数据id
     * @param string sys_num 系统单号
     * @param string dealcentent 处理备注
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2022/6/20 11:02
     * |---------------------------------------------------------------------------------
    */
    public function dealAftertrack ( Request $request ){
        $input = $request->only('oat_id','oat_afid','sys_num','dealcentent');
        $checkKey = CommonService::checkKey(['oat_afid','sys_num','dealcentent'],$input);
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::FAILED_PARAM, []);
        }else{
            DB::beginTransaction();
            $rea = OrderAfter::where("id",$input['oat_afid'])->update(['look_type'=>1]);
            $session = $request->get('session_token');
            $res = OrderAftertrack::where('oat_afid',$input['oat_afid'])->where('oat_state',1)->update(['oat_state'=>3,'oat_dealid'=>$session['id'],'oat_dealor'=>$session['admin_acc'],'oat_dealtime'=>date("Y-m-d H:i:s"),'oat_dealcentent'=>$input['dealcentent']]);
            if($res && $rea){
                DB::commit();
                $this->insertingLog("处理追踪",$input['sys_num'],"处理追踪，单号：".$input['sys_num'],"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');
            }else{
                DB::rollBack();
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);
            }
            exit;
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取设定分类
     * @param page 页码
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function setclassify (Request $request)
    {
        $page_size = (int)$request->input('page_size',10);
        $page = (int)$request->input('page',1);
        if($page<1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;
        $count = Afterclass::count();
        $list = Afterclass::offset($offset)->limit($page_size)->get();
        $data['page'] = [
            'page' => $page,
            'allPage' => ceil($count/$page_size),
            'page_size' => $page_size,
            'count' => $count,
        ];
        if (!$list->isEmpty()){
            $data['list'] = $list->toArray();
            foreach ($data['list'] as $k=>$v) {
                $data['list'][$k]['cd_name'] = CategoryService::getNameByCdId($v['category']);//订单类型 2021-12-31 du add
            }

            return $this->success('获取成功',$data);exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 添加分类
     * @param class_name 分类名称
     * @param state 1:启用  2:停用
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function addclassify (Request $request)
    {
        if ($request->filled('class_name') && $request->filled('state') && $request->filled('category')){
            $data['class_name'] = $request->input('class_name');
            $classname = Afterclass::where('class_name',$request->input('class_name'))->first();
            if ($classname){
                return $this->error('操作失败', ErrorInc::REPEAT_SUBMIT);exit;
            }
            $data['state'] = $request->input('state');
            $data['category'] = intval($request->input('category'));//服务单类型 2021-12-30 du add
            $data['create_time'] = date('Y-m-d H:i:s',time());
            $res = Afterclass::insert($data);
            if($res){
                $this->insertingLog("添加分类，","","添加分类：".$request->input('class_name'),"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');exit;
            }else{
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);exit;
        }
    }


    /**|---------------------------------------------------------------------------------
     * @name 启用、关闭分类
     * @param id
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function edit_classify(Request $request)
    {
        if ($request->filled('id')){
            $state = Afterclass::where('id',$request->input('id'))->value('state');
            if ($state == 1){
                $arr['state'] = 2;
                $str = "关闭分类";
            }elseif($state == 2){
                $arr['state'] = 1;
                $str = "启用分类";
            }
            $PDD = Afterclass::where('id',$request->input('id'))->update($arr);
            if($PDD){
                $this->insertingLog($str,"","操作：".$str,"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功-'.$str);exit;
            }else{
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('缺少参数', ErrorInc::INVALID_PARAM, []);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name  售后分类
     * @param type  1:获取分类标签；2:提交
     * @param id 数据id
     * @param data_type 标签id
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function afterClassify (Request $request)
    {
        if ($request->filled('id')){
            if ($request->input('type') == 1){
                $res = Afterclass::where('state',1)->where('category',intval($request->input('category')))->select('id','class_name','category')->get();
                if (!$res->isEmpty()){
                    $data_type = OrderAfter::where('id',$request->input('id'))->value("data_type");
                    $data['list'] = $res->toArray();
                    if(!empty($data_type)){
                        $data['data_type'] = $data_type;
                    }else{
                        $data['data_type'] = 0;
                    }
                    return $this->success('获取成功',$data);exit;
                }
            }else{
                if ($request->filled('data_type')){
                    $Input = $request->only('id','data_type','sys_num');
                    $res = OrderAfter::where('id',$Input['id'])->update(['data_type'=>$Input['data_type']]);
                    if ($res){
                        $this->insertingLog("设置分类，",$Input['sys_num'],"设置分类：".$Input['data_type'],"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                        return $this->success('操作成功');exit;
                    }else{
                        return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
                    }
                }else{
                    return $this->error('请选择标签', ErrorInc::INVALID_PARAM);exit;
                }
            }
        }else{
            return $this->error('参数错误', ErrorInc::INVALID_PARAM);exit;
        }
    }



    /**|---------------------------------------------------------------------------------
     * @name  售后推送
     * @param id 数据id
     * @param sys_num 系统单号
     * @param note_content  备注内容(必传)
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function afterPush(Request $request)
    {
        if (!$request->filled('id') || !$request->filled('sys_num')){
            return $this->error('参数错误', ErrorInc::INVALID_PARAM);exit;
        }
        if ($request->filled('note_content')){
            $id = $request->input('id');
            $session = $request->get('session_token');
            $sys_num = $request->input('sys_num');
            $note_content = $request->input('note_content');
            $rest = CommonService::accMe($sys_num,"售后列表",$note_content,'',1,$session['admin_groupnew'],$session['admin_acc'],$session['id']);
            if ($rest){
                $res = OrderAfter::where('id',$id)->update(['trigyn'=>2]);
                if ($res){
                    $this->insertingLog("售后推送，",$sys_num,"售后推送：".$note_content,"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                    return $this->success('操作成功');exit;
                }else {
                    return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
                }
            }else {
                return $this->error('备注添加失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else {
            return $this->error('备注内容不能为空', ErrorInc::INVALID_PARAM);exit;
        }
    }



    /**|---------------------------------------------------------------------------------
     * @name  申请协助（未出理，处理中）
     * @param id 数据id
     * @param content 备注内容
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function apply_acc (Request $request)
    {
        if ($request->filled('id')){
            $id = intval($request->input('id'));
            $session = $request->get('session_token');
            $res = OrderAfter::where('id',$id)->select('sys_num')->first();
            $info = OrderAfter::where('id',$id)->update(['deal_type'=>2]);//deal_type 是否需协助：1无，2需要
            if ($request->input('content')){
                $content = $request->input('content');
                $rest = CommonService::accMe($res['sys_num'],"售后列表",$content,'',1,$session['admin_groupnew'],$session['admin_acc'],$session['id']);
                if (!$rest){
                    Route::post('apply_acc','AftersaleOrderController@apply_acc');//申请协助
                }
            }
            if ($info){
                $this->insertingLog("申请协助",$res['sys_num'],"申请协助，单号：".$res['sys_num'],"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');exit;
            }else{
                Return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            $this->error('参数错误',ErrorInc::FAILED_PARAM);
        }

    }

    /**|---------------------------------------------------------------------------------
     * @name  查看凭证
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function view_voucher(Request $request)
    {
        if ($request->filled('id')){
            $id = $request->input('id');
            $pic = FeedSales::where('gl_id',$id)->select('feedback_pic','type')->get()->toArray();//->where('type',1000)
            $sound = FeedSales::where('gl_id',$id)->where('type',1001)->select('feedback_pic')->first();
            if ($pic){
                $picArr = [];
                foreach ($pic as $ks => $vs){
                    if($vs['type']==1000){
                        $picArr[] = $this->picurl($vs['feedback_pic']);
                    }else{
                        $picElse[] = $this->picurl($vs['feedback_pic']);
                    }
                }
                $data['pic'] = $picArr;
                $data['picElse'] = $picElse;
            }else{
                $data['pic'] = "";
                $data['picElse'] = "";
            }
            if ($sound){
                $data['sound'] = $this->picurl($sound['feedback_pic']);
            } else{
                $data['sound'] = "";
            }
            if (($data['pic'] != "") || ($data['sound'] !="")){
                return $this->success('操作成功',$data);exit;
            }else{
                return $this->error('无数据', ErrorInc::DATA_EMPTY);exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::INVALID_PARAM);exit;
        }
    }



    /**|---------------------------------------------------------------------------------
     * @name  预约时间
     * @param id 数据id
     * @param day_time 时间 （年月日时分秒）
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function appointTime (Request $request)
    {
        if ($request->filled('id')&&$request->filled('day_time')) {
            $appoint_time = $request->input('day_time');
            $res = OrderAfter::where('id',$request->input('id'))->update([
                'day_time'=> $appoint_time
            ]);
            if ($res) {
                $this->insertingLog("预约时间",$request->input('sys_num'),"申预约时间：".$appoint_time,"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');exit;
            } else {
                Return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::INVALID_PARAM);exit;
        }
    }



    /**|---------------------------------------------------------------------------------
     * @name  获取标签
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function getLab (Request $request)
    {
        $res = SetmoneyType::where('lt_parent_id',209)->select('sety_id',
            'sety_name')->get()->toArray();
        if ($res) {
            $data['list'] = $res;
            return $this->success('操作成功',$data);exit;
        }else{
            Return $this->error('暂无数据', ErrorInc::MYSQL_FAILED);exit;
        }

    }

    /**|---------------------------------------------------------------------------------
     * @name  申诉编辑
     * @param id          数据ID
     * @param apply_type  申诉类型 1未分类，2工商投诉，3纠纷单，4投诉单，5赔偿单
     * @return \Illuminate\Http\JsonResponse
     *|---------------------------------------------------------------------------------
     */
    public function setApplyType (Request $request)
    {
        if ($request->filled('id')) {
            if ($request->filled('apply_type') && in_array($request->input('apply_type'), ['1', '2', '3', '4', '5'])) {
                $id = intval($request->input('id'));
                $result = OrderAfter::where('id', $id)->update(['apply_type' => $request->input('apply_type')]);
                if ($result) {
                    $this->insertingLog("申诉编辑",$request->input('sys_num'),"申诉类型：".$request->input('apply_type'),"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
                    return $this->success('操作成功');exit;
                } else {
                    Return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
                }
            }else{
                return $this->error('参数错误', ErrorInc::FAILED_PARAM);
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name  客服介入
     * @param order_num  平台单号
     * @param note_content    备注内容
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function Customer(Request $request){
        if (!$request->filled('id')||!$request->filled('order_num')||!$request->filled('sys_num')||!$request->filled('note_content')||!$request->filled('serial_number')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM); exit;
        }
        $order_num = $request->input('order_num');
        $sys_num = $request->input('sys_num');
        $note_content = $request->input('note_content');
        $serial_number = $request->input('serial_number');
        $status['status'] = 15;
        $res = OrderAfter::where('id',$request->input('id'))->update($status);
        if($res){
            $rest = CommonService::accMe($sys_num, "售后列表", $note_content, $serial_number, 1,$request->get('session_token')['admin_groupnew'], $request->get('session_token')['admin_acc'],$request->get('session_token')['id']);
            $this->insertingLog("客服介入",$sys_num,"申请介入：".$note_content,"售后列表",$request->ip(), $request->get('session_token')['admin_acc']);
            return $this->success('操作成功');exit;
        }else{
            Return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name  返回处理中
     * @param order_num  平台单号
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
    public function returnHandle(Request $request){
        if(!$request->filled('order_num')||!$request->filled('sys_num')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM); exit;
        }
        $order_num = $request->input('order_num');
        $sys_num = $request->input('sys_num');
        $status['status'] = 10;
        $res = OrderAfter::where('order_num',$order_num)->update($status);
        if($res){
            $this->insertingLog("返回处理中" ,$sys_num, "返回处理中"."(".$order_num.")","售后列表",$request->ip(),$request->get('session_token')['admin_acc']);
            return $this->success('操作成功');exit;
        }else{
            Return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取车膜售后信息
     * @param int id 售后数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/11/4 19:53
     * |---------------------------------------------------------------------------------
    */
    public function beforDealAfter ( Request $request ){
        if(!$request->filled('id')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM); exit;
        }
        $id = $request->input('id');
        $after = OrderAfter::where('id',$request->input('id'))->first();
        if($after) {
            $db = new OrderAfterDetai();
            $afterdetail = CommonService::getMysqlData($db, ['oad_afid' => $id]);
            if ($afterdetail) {
                $picdetail = AftersaleOrderService::lookpics($id);
                $picdetail = CommonService::jointArrayKey($picdetail, 'child_id', 2);
                $data['carinfo'] = CommonService::getUserCar($after['sys_num'],true);
                $data['detailCheck'] = array_column($afterdetail, 'oad_partid');
                foreach ($afterdetail as $k => $v) {
                    if($v['oad_dealtype'] != ''){
                        $afterdetail[$k]['oad_dealtype'] = (int)$v['oad_dealtype'];
                    }
                    if($v['oad_dealptype'] != ''){
                        $afterdetail[$k]['oad_dealptype'] = (int)$v['oad_dealptype'];
                    }
//                    if($v['oad_dealtype'] == ''){
//                        $afterdetail[$k]['oad_dealtype'] = [];
//                    }else{
//                        $oad_dealtype = explode(',', $v['oad_dealtype']);
//                        $ealtype = [];
//                        foreach($oad_dealtype as $ka => $va){
//                            $ealtype[] = (int)$va;
//                        }
//                        $afterdetail[$k]['oad_dealtype'] = $ealtype;
//                    }
//                    if($v['oad_dealptype'] == ''){
//                        $afterdetail[$k]['oad_dealptype'] = [];
//                    }else{
//                        $oad_dealptype = explode(',', $v['oad_dealptype']);
//                        $ealptype = [];
//                        foreach($oad_dealptype as $ka => $va){
//                            $ealptype[] = (int)$va;
//                        }
//                        $afterdetail[$k]['oad_dealptype'] = $ealptype;
//                    }
                    $afterdetail[$k]['pic'] = $picdetail[$v['oad_id']] ?? [];
                }
                $data['list'] = $afterdetail;
                $new_customer_id = OrderService::getOrderBy('order_num', $after['order_num'],['new_customer_id']);
                $data['user'] = UserService::getUserBy('id',$new_customer_id,['id','shr_name','shr_phone','shr_sheng','shr_shi','shr_xian','shr_adress']);
                $data['dealState'] = AftersaleOrderService::getDealState();
                $pgNumber = AftersaleOrderService::pgNumber('',$after['order_num']);
                foreach($pgNumber as $k => $v){
                    if($k == 'derail') {
                        $count = count($v);
                        $count = $count-1;
                        if (in_array(1, $data['detailCheck'])) {
                            $aa[] = $v[$count];
                            $v = $aa;
                        } else {
                            unset($v[$count]);
                            $v = CommonService::resetListKey($v);
                        }
                    }
                    $data[$k] = $v;
                }
                return $this->success('操作成功', $data);
            } else {
                return $this->error('无数据', ErrorInc::DATA_EMPTY);
                exit;
            }
        }else{
            return $this->error('无对应售后数据', ErrorInc::DATA_EMPTY);
            exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取售后对应订单处理记录（回收记录，退款记录，礼品记录，发货记录）
     * @param int id 售后数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/11/5 15:06
     * |---------------------------------------------------------------------------------
    */
    public function getAfterRecord ( Request $request ){
        if(!$request->filled('id')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM); exit;
        }
        $after = OrderAfter::where('id',$request->input('id'))->first();
        if($after) {
            $data['recycleOrder'] = RecycleOrderService::getDetailByOrder($after['order_num']);
            $data['refund'] = RefundService::getDetailByOrder($after['order_num']);
            $data['eventgift'] = EventGiftService::getDetailByOrder($after['order_num']);
            $data['sendGood'] = SendGoodsService::getDetailByOrder($after['order_num']);
            return $this->success('操作成功',$data);
        }else{
            return $this->error('无对应售后数据', ErrorInc::DATA_EMPTY);
            exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取车膜补货默认商品
     * @param string sys_num 系统单号
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/11/10 20:47
     * |---------------------------------------------------------------------------------
    */
    public function getSolarFilmGoods ( Request $request ){
        if(!$request->filled('sys_num')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM); exit;
        }
        $goodid = OrderService::getOrderMsgBy('sys_num', $request->input('sys_num'),['goods_id']);
        if($goodid){
            $good = GoodsService::getSolarFilmGoods(array_column($goodid, 'goods_id'));
            return $this->success('操作成功',$good);
        }else{
            return $this->error('无对应数据', ErrorInc::DATA_EMPTY);
            exit;
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 处理车膜售后
     * @param int after_id 售后数据id
     * @param array after_derail 售后详情数据
     * @param int partid 位置编号
     * @param string partname 位置名称
     * @param string installstate 安装状态
     * @param int type 申请标签
     * @param int typepid 父类标签id
     * @param string content 申请备注
     * @param int dealtype 处理标签
     * @param int recycle 是否回收
     * @param string dealcontent 处理备注
     * @param array carinfo 车型信息
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/11/5 9:46
     * |---------------------------------------------------------------------------------
    */
    public function dealSolarFilmDetail ( Request $request ){
        $input = $request->all();
        $session = $request->get("session_token");
        $ip = $request->ip();
        $checkKey=CommonService::checkKey(['after_id','after_derail'],$input);
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }
        $after = OrderAfter::where('id',$request->input('after_id'))->first();
        if($after['status']==10){
            $rea = true;
        }else {
            $poss['status'] = 10;
            $rea = OrderAfter::where('id', $request->input('after_id'))->update($poss);
            if(!$rea){
                return $this->error('操作失败5', ErrorInc::MYSQL_FAILED);
                exit;
            }
        }
        if($after) {
            $carinfo = $request->input('carinfo');
            $car_infor = $carinfo['car_infor']??'';
            $letMe = CommonService::addUserCar($after['sys_num'], $carinfo['car_make'], $carinfo['car_line'], $carinfo['car_model'], $carinfo['car_id'],$car_infor);
            DB::beginTransaction();
            /*--------------------------------------处理售后详情部分开始------------------------------------------*/
            $dealDetail = AftersaleOrderService::dealSolarFilmDetail($input, $session, $ip);
            $OrderAfterDetai = new OrderAfterDetai();
            $oad_dealtype = CommonService::getMysqlData($OrderAfterDetai, ['oad_afid'=>$request->input('after_id')],['oad_dealtype']);
            $oad_dealtype = array_column($oad_dealtype, 'oad_dealtype');
            $oad_dealtype = array_unique($oad_dealtype);
            $num1 = array_search('',$oad_dealtype);
            $num2 = array_search('null',$oad_dealtype);
            if($num1!==false){
                unset($oad_dealtype[$num1]);
            }
            if($num2!==false){
                unset($oad_dealtype[$num2]);
            }
            if($oad_dealtype){
                $oad_dealtype = CommonService::resetListKey($oad_dealtype);
                $rea = OrderAfter::where('id', $request->input('after_id'))->update(['deal_lable'=>implode(',', $oad_dealtype)]);
            }
            if (!$dealDetail['code']) {
                DB::rollBack();
                return $this->error($dealDetail['msg'], $dealDetail['data']);
                exit;
            } else {
                /*-----------------------------------验证并添加新的申请标签开始----------------------------------------*/
                if($dealDetail['data']) {
                    $orderinfo['order_num'] = $after['order_num'];
                    $orderinfo['serial_number'] = $after['serial_number'];
                    $orderinfo['p_id'] = $after['p_id'];
                    $orderinfo['ser_id'] = $after['ser_id'];
                    $sle = AfterSaleService::insertData($dealDetail['data'], $orderinfo, $session);
                    if (!$sle) {
                        DB::rollBack();
                        return $this->error('操作失败5', ErrorInc::MYSQL_FAILED);
                        exit;
                    }
                }
                /*-----------------------------------验证并添加新的申请标签结束--------------------------------------------*/
            }
            /*--------------------------------------处理售后详情部分结束--------------------------------------------------*/
            /*---------------------------------------验证并新增售后处理开始-----------------------------------------------*/
            if($request->filled('dealState')) {
                /*-----------------------------------------验证并添加礼品开始--------------------------------------------*/
                if (in_array(1, $input['dealState'])) {
                    if (!$request->filled('giftdata')) {
                        return $this->error('缺少礼品信息参数', ErrorInc::FAILED_PARAM);
                        exit;
                    } else {
                        $request->merge($request->input('giftdata'));
                        $giftAdd = EventGiftService::giftAdd($request);
                        if ($giftAdd['ErrorCode'] != '1') {
                            DB::rollBack();
                            return $giftAdd;
                        }
                    }
                }
                /*-----------------------------------------验证并添加礼品结束--------------------------------------------*/
                /*-----------------------------------------验证并添加回收单开始------------------------------------------*/
                if (in_array(4, $input['dealState']) && $request->filled('refunddata')) {
                    $allprice = $request->input('refunddata')['allprice'];
                    $apply_type = $request->input('refunddata')['apply_type'];
                    $goods_state = $request->input('refunddata')['goods_state'];
                }else{
                    $apply_type = 0;
                    $allprice = 0;
                    $goods_state = 0;
                }
                $recycle_id = 0;
                $recycle_num = '';
                if (in_array(2, $input['dealState'])) {
                    if (!$request->filled('recycledata')) {
                        return $this->error('缺少回收信息参数', ErrorInc::FAILED_PARAM);
                        exit;
                    } else {
                        $request->merge($request->input('recycledata'));
                        $recycledata = $request->all();
                        $recycledata['apply_type'] = $apply_type;
                        $recycledata['goods_state'] = $goods_state;
                        $recycledata['allprice'] = $allprice;
                        $recycledata['after_id'] = $input['after_id'];

                       // $recycledata['ro_reason'] = $input['ro_reason']??1;// 2022-3-1 新增 回收原因：1换货回收 2退款回收  等于2时必须填写退款单


                        if(isset($recycledata['courier_number']) && $recycledata['courier_number']!='') {
                            $recycle_type = $recycledata['recycle_type'];
                        }else{
                            $recycle_type = 0;
                        }
                        $returnRecy = RecycleOrderService::creactRecycle($recycledata, $session, $ip);
                        if ($returnRecy['ErrorCode'] != '1') {
                            DB::rollBack();
                            return $returnRecy;
                        }
                        $recycle_id = $returnRecy['Data']['id'];
                        $recycle_num = $returnRecy['Data']['recycle_num'];
                    }
                }else{
                    $recycle_type = 0;
                }
                /*-----------------------------------------验证并添加回收单结束-------------------------------------------*/
                /*-----------------------------------------验证并添加发货单开始------------------------------------------*/
                $send_id = 0;
                $warehouse_num = '';
                if (in_array(3, $input['dealState'])) {
                    if (!$request->filled('senddata')) {
                        return $this->error('缺少发货信息参数', ErrorInc::FAILED_PARAM);
                        exit;
                    } else {
                        $request->merge($request->input('senddata'));
                        $source['source'] = '2';
                        $source['recycle_id'] = $recycle_id;
                        $request->merge($source);
                        $returnsend = SendGoodsService::sendGoods($request,true);
                        if ($returnsend['ErrorCode'] != '1') {
                            if($recycle_id>0 && ($recycle_type==2 || $recycle_type==3)){
                                $res = \BlueCity\Data\Service\ZhiPei\OrderService::retrieveCancel($recycle_num);
                                $data = json_encode($recycle_num).'---'.json_encode($res);
                                CommonService::addLog('通知库发驳回回收', $data, $input['recycle_num'],'warehouse-recycle');
                            }
                            DB::rollBack();
                            return $returnsend;
                            exit;
                        }
                        $send_id = $returnsend['Data']['id'];
                        $warehouse_num = $returnsend['Data']['warehouse_num'];
                    }
                }
                /*-----------------------------------------验证并添加发货单结束-------------------------------------------*/
                /*-----------------------------------------验证并添加退款单开始------------------------------------------*/
                if (in_array(4, $input['dealState'])) {
                    if (!$request->filled('refunddata')) {
                        return $this->error('缺少退款信息参数', ErrorInc::FAILED_PARAM);
                        exit;
                    } else {
                        $request->merge($request->input('refunddata'));
                        $input = $request->all();
                        if(!$request->filled('apply_type')){
                            DB::rollBack();
                            return $this->error('缺少退款申请类型', ErrorInc::FAILED_PARAM);exit;
                        }
                        $order = OrderService::getOrderBy('sys_num', $input['sys_num'],['ser_id', 'order_num', 'order_status','store_type','create_time','new_customer_id','category']);
                        foreach($order as $k => $v){
                            $input[$k] = $v;
                        }
                        $session = $request->get("session_token");
                        $ip = $request->ip();
                        $userArr = CommonService::getUser('id', $order['new_customer_id']);
                        $input['recycle_type'] = $recycle_type;
                        $input['recycle_id'] = $recycle_id;
                        $applyType = RefundService::getRefundApplyType(true);
                        $note_content = '退款：（'.$applyType[$input['apply_type']].'）'.$input['content'];
                        $input['note_content'] = $note_content;
                        $return = OrderService::lockByRefund($input, $session ,$userArr);
                        if($return['ErrorCode']!='1'){
                            if($recycle_id>0 && $recycle_type==2){
                                $res = zhiPeiOrder::retrieveCancel($recycle_num);
                                $data = json_encode($recycle_num).'---'.json_encode($res);
                                CommonService::addLog('通知库发驳回回收', $data, $input['recycle_num'],'warehouse-recycle');
                            }
                            if($send_id>0 && $warehouse_num!=''){
                                $zres = zhiPeiOrder::cancelShipping($warehouse_num);//发货取消
                                CommonService::addLog('同步发货取消', json_encode($zres), $warehouse_num,'SendGoods');
                            }
                            DB::rollBack();
                            return  $return;
                        }
                        $rest = CommonService::accMe($input['sys_num'], '订单管理', $note_content, '', '', $session['admin_groupnew'], $session['admin_acc'], $session['id']);
                        $this->insertingLog('退款,', $input['sys_num'], "订单" . $input['order_num'].'退款', '订单管理', $ip, $session['admin_acc']);//日志
                    }
                }
                /*-----------------------------------------验证并添加退款单结束-------------------------------------------*/
            }
            /*-------------------------------------------验证并新增售后处理开始-------------------------------------------*/
            /*--------------------------------------------验证售后完成情况开始--------------------------------------------*/
            $afterDetai = OrderAfterDetai::where('oad_afid',$input['after_id'])->where("oad_state",1)->first();
//            if($after['status']==10){
//                $rea = true;
//            }else {
//                $poss['status'] = 10;
//                $rea = OrderAfter::where('id', $request->input('after_id'))->update($poss);
//            }
            if(!$rea){
                DB::rollBack();
                return $this->error('操作失败4', ErrorInc::MYSQL_FAILED);
                exit;
            }
            $this->insertingLog('处理售后', $input['sys_num'], '处理售后（'.$input['after_num'].'）', '售后列表', $ip, $session['admin_acc']);
            /*------------------------------------验证售后完成情况结束--------------------------------------------*/
            DB::commit();
            $detail = OrderAfterDetai::where('oad_afid',$request->input('after_id'))->whereRaw("oad_dealtype is not null")->where("oad_dealtype",'!=','')->select('oad_dealtype','oad_dealptype')->get();
            if($detail) {
                $detail = CommonService::dataToArray($detail);
                $oad_dealtype = array_column($detail, 'oad_dealtype');
                $oad_dealptype = array_column($detail, 'oad_dealptype');
                $deal_lable = array_merge($oad_dealtype,$oad_dealptype);
                $deal_lable = array_unique($deal_lable);
                $deal_lable = implode(',', $deal_lable);
                OrderAfter::where('id', $request->input('after_id'))->update(['deal_lable' => $deal_lable]);
            }
            return $this->success('操作成功');exit;
        }else{
            return $this->error('无对应售后数据', ErrorInc::DATA_EMPTY);
            exit;
        }
    }


    /**
     * 用户领取
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/12/23
     */
    public function getId(Request $request){
        $id = intval($request->input('id'));
        $rea = OrderAfter::where('id',$id)->value('sys_num');
        if(!$rea){
            return $this->error('无对应售后数据', ErrorInc::DATA_EMPTY);
            exit;
        }
        $session = $request->get("session_token");
        $ip = $request->ip();
        $datet = date("Y-m-d H:i:s");
        $res = OrderAfter::where('id',$id)->update(['get_id'=>$session['id'],'get_time'=>$datet]);
        if(!$res){
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);
            exit;
        }else{
            $this->insertingLog('领取售后', $rea, '领取人ID（'.$session["id"].'）', '售后列表', $ip, $session['admin_acc']);
            return $this->success('操作成功');exit;
        }
    }

    /**
     * 移交领取人
     * @param Request $request
     * @author du
     * @date 2022/1/22
     */
    public function moveGetId(Request $request){
        if(!$request->filled('new_get_id')||!$request->filled('id')){
            return $this->error('参数错误，缺少领取人或数据ID', ErrorInc::INVALID_PARAM);exit;
        }
        $admin_groupnew = $request->get('session_token')['admin_groupnew'];
        $id = intval($request->input('id'));
        $input = $request->all();
        if($admin_groupnew==7){
            $admin_id = intval($input['get_id']);
        }else{
            $admin_id = $request->get('session_token')['id'];
        }
        $new_get_id = intval($input['new_get_id']);

        $ret = OrderAfter::where('id',$id)->first();
        if(empty($ret)){
            return $this->error('不存在', ErrorInc::MYSQL_FAILED);exit;
        }

        if($ret['get_id']!=$admin_id){
            return $this->error('当前领取人异常', ErrorInc::MYSQL_FAILED);exit;
        }
        $datet = date("Y-m-d H:i:s");
        $res = OrderAfter::where('id',$id)->where('get_id',$admin_id)->update(['get_id'=>$new_get_id,'get_time'=>$datet]);
        if($res){
            $this->insertingLog('领取移交', $ret['sys_num'], '领取人ID:'.$admin_id.'移交给ID:'.$new_get_id, '售后列表', $request->ip(), $request->get('session_token')['admin_acc']);
            return $this->success('系统单号：'.$ret['sys_num'].'  更新成功');
        }else{
            return $this->error('更新失败', ErrorInc::MYSQL_FAILED);exit;
        }

    }


    /**
     * @name 便捷售后
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/1/5
     */
    public function fastAfterOrder(Request $request){
        DB::beginTransaction();
        $data = AftersaleOrderService::addAfter($request->all(),$request->get('session_token'),$request->ip());
        if($data['code']) {
            DB::commit();
            $this->operatingTime($data['data']['serserial_number'], '申请质保时间', date("Y-m-d H:i:s"), $data['data']['order_num'], $request->get('session_token')['admin_acc']);//订单操作时间
            $this->insertingLog('申请质保，', $data['data']['sys_num'], '订单' . $data['data']['sys_num'], '订单管理', $request->ip(), $request->get('session_token')['admin_acc']);//日志
            return $this->success($data['msg']);
        }else{
            DB::rollBack();
            return $this->error($data['msg'], $data['data']);exit;
        }

    }

    /**|------------------------------------------------------------------
     * @name 获取申请售后的必要参数
     * @param order_num 平台单号
     * @return \Illuminate\Http\JsonResponse
     * |-------------------------------------------------------------------
     */
    public function pgNumber(Request $request)
    {
        if(!$request->filled('order_num')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);
        }else{
            $status = AftersaleOrderService::getOrderAfterStatusName();
            $list = OrderAfter::where('order_num',$request->input('order_num'))->select('create_time','status','deal_admin')->get()->toarray();
            foreach ($list as $k =>$v){
                $list[$k]['status_name'] = $status[$v['status']];
            }
            $data = AftersaleOrderService::pgNumber('',$request->input('order_num'));

            if($data){
                $data['list'] = $list;
                $data['sys_num'] = OrderService::getOrderBy('order_num', $request->input('order_num'),['sys_num']);
                return $this->success('成功', $data); exit;
            }else{
                return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
            }
        }
    }

    /**
     * @name 获取图文
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/1/5
     */
    public function  getImgContent(Request $request){
        if(!$request->filled('afid')||(intval($request->input('afid'))<=0)){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
        $id = intval($request->input('afid'));
       /* $res = DB::table('order_after_content')->where('afid',$id)->value('id');
        if(!$res){
            return $this->error('数据不存在', ErrorInc::MYSQL_FAILED);exit;
        }*/
        $ret = AftersaleOrderService::getImgContent($id);
        if($ret){
            return $this->success('获取成功', $ret); exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }

    /**
     * @name 编辑图文
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/1/5
     */
    public function editImgContent(Request $request){
        if(!$request->filled('content')||!$request->filled('afid')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
        $afid = intval($request->input('afid'));
        $res = DB::table('order_after_content')->where('afid',$afid)->value('id');
        $arr['content'] = $request->input('content');
        if(!$res){
            $arr['afid'] = $afid;
            $arr['update_name'] = $request->get('session_token')['admin_acc'];
            $arr['create_time'] = date("Y-m-d H:i:s");
            $arr['create_name'] = $request->get('session_token')['admin_acc'];
            $arr['update_time'] = date("Y-m-d H:i:s");
            $ret = DB::table('order_after_content')->insert($arr);
        }else{
            if(empty($arr['content'])||$arr['content']==''){
                return $this->error('内容不能为空', ErrorInc::DATA_EMPTY);exit;
            }
            $arr['update_time'] = date('Y-m-d H:i:s');
            $arr['update_name'] = $request->get('session_token')['admin_acc'];
            $ret = DB::table('order_after_content')->where('afid',$afid)->update($arr);
        }

        if($ret){
            //$this->insertingLog('修改图文', $order_number, $content, '售后管理', $request->ip(), $arr['update_name']);
            return $this->success('操作成功', $ret); exit;
        }else{
            return $this->error('操作失败', ErrorInc::DATA_EMPTY);exit;
        }
    }


    /**
     * @param Request $request
     * @return array|string|string[]
     * @author du
     * @date 2022/2/11
     */
    public function sendSmsAfterModel(Request $request){
        $input = $request->all();
        $session = $request->get("session_token");
        $ret = CommonService::sendMsgCommonModel($input, $session);
        return $ret;
    }


}
