define({ "api": [
  {
    "type": "get",
    "url": "/api/service/contracts",
    "title": "签约管理",
    "group": "contracts",
    "name": "服务商签约",
    "version": "1.0.0",
    "description": "<p>管理服务商与平台的签约流程，根据条件查询</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "keyword",
            "description": "<p>公司名称</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "serviceType",
            "description": "<p>含服务类型</p>"
          },
          {
            "group": "Parameter",
            "type": "array",
            "optional": false,
            "field": "serviceItem",
            "description": "<p>含服务项目</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ContractsController.php",
    "groupTitle": "contracts"
  },
  {
    "type": "get",
    "url": "/api/service/contracts/{id}/approved",
    "title": "签约审核",
    "group": "contracts",
    "name": "服务商签约",
    "version": "1.0.0",
    "description": "<p>接口描述</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>合同ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "comment",
            "description": "<p>审核描述</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ContractsController.php",
    "groupTitle": "contracts"
  },
  {
    "type": "get",
    "url": "/api/service/contracts/{id}/reject",
    "title": "签约驳回",
    "group": "contracts",
    "name": "服务商签约",
    "version": "1.0.0",
    "description": "<p>签约内容或时间有误，管理员驳回</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>合同ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "comment",
            "description": "<p>驳回原因</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ContractsController.php",
    "groupTitle": "contracts"
  },
  {
    "type": "get",
    "url": "/api/service/contracts/{id}/renewal",
    "title": "合同续约",
    "group": "contracts",
    "name": "服务商签约",
    "version": "1.0.0",
    "description": "<p>平台与服务商继续延长合同期限</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>合同ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "comment",
            "description": "<p>续约描述原因</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "expires",
            "description": "<p>续约时间</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ContractsController.php",
    "groupTitle": "contracts"
  },
  {
    "type": "get",
    "url": "/api/service/contracts/{id}/discharge",
    "title": "解除合同",
    "group": "contracts",
    "name": "服务商签约",
    "version": "1.0.0",
    "description": "<p>平台与服务方解除合同的操作</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>合同ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "comment",
            "description": "<p>解除原因</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ContractsController.php",
    "groupTitle": "contracts"
  },
  {
    "type": "put",
    "url": "/api/helps/answer/{id}",
    "title": "保存答案修改内容",
    "group": "faq",
    "name": "FAQ管理",
    "version": "1.0.0",
    "description": "<p>保存答案修改内容到数据库</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "p_id",
            "description": "<p>平台id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "dt_id",
            "description": "<p>分类id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "d_id",
            "description": "<p>问题id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "answer",
            "description": "<p>答案</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "dc_status",
            "description": "<p>状态 1:正常 2:隐藏</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "dc_sord",
            "description": "<p>是否推荐 0:不推荐 1:推荐</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Helps/AnswerController.php",
    "groupTitle": "faq"
  },
  {
    "type": "put",
    "url": "/api/helps/answer/{id}",
    "title": "保存答案修改内容",
    "group": "faq",
    "name": "FAQ管理",
    "version": "1.0.0",
    "description": "<p>保存答案修改内容到数据库</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "dc_id",
            "description": "<p>答案id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "answer",
            "description": "<p>答案</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "dc_status",
            "description": "<p>状态 1:正常; 2:隐藏</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "dc_sord",
            "description": "<p>是否推荐 0:不推荐 1:推荐</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Helps/AnswerController.php",
    "groupTitle": "faq"
  },
  {
    "type": "delete",
    "url": "/api/helps/answer/{id}",
    "title": "删除答案",
    "group": "faq",
    "name": "FAQ管理",
    "version": "1.0.0",
    "description": "<p>删除指定答案</p>",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Helps/AnswerController.php",
    "groupTitle": "faq"
  },
  {
    "type": "get",
    "url": "/api/helps/subject/create",
    "title": "问题管理列表",
    "group": "faq",
    "name": "FAQ管理",
    "version": "1.0.0",
    "description": "<p>问题及答案添加界面内容</p>",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Helps/SubjectsController.php",
    "groupTitle": "faq"
  },
  {
    "type": "get",
    "url": "/api/helps/subject/create",
    "title": "问题添加界面数据",
    "group": "faq",
    "name": "FAQ管理",
    "version": "1.0.0",
    "description": "<p>问题及答案添加界面内容</p>",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Helps/SubjectsController.php",
    "groupTitle": "faq"
  },
  {
    "type": "post",
    "url": "/api/helps/subject",
    "title": "问题及答案保存",
    "group": "faq",
    "name": "FAQ管理",
    "version": "1.0.0",
    "description": "<p>保存问题及答案数据到数据库</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dt_id",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_title",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_name",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_content",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_status",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_keywords",
            "description": "<p>参数说明</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Helps/SubjectsController.php",
    "groupTitle": "faq"
  },
  {
    "type": "get",
    "url": "/api/helps/subject/{id}",
    "title": "问题修改",
    "group": "faq",
    "name": "FAQ管理",
    "version": "1.0.0",
    "description": "<p>问题修改界面数据信息</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dt_id",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_title",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_name",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_content",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_status",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_keywords",
            "description": "<p>参数说明</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Helps/SubjectsController.php",
    "groupTitle": "faq"
  },
  {
    "type": "put",
    "url": "/api/helps/subject/{id}",
    "title": "问题及答案保存",
    "group": "faq",
    "name": "FAQ管理",
    "version": "1.0.0",
    "description": "<p>保存问题及答案数据到数据库</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dt_id",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_title",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_name",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_content",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_status",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_keywords",
            "description": "<p>参数说明</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Helps/SubjectsController.php",
    "groupTitle": "faq"
  },
  {
    "type": "post",
    "url": "/api/helps/subject/appendAnswer",
    "title": "追加答案",
    "group": "faq",
    "name": "FAQ管理",
    "version": "1.0.0",
    "description": "<p>追加答案到问题里</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dt_id",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_title",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_name",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_content",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_status",
            "description": "<p>参数说明</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "d_keywords",
            "description": "<p>参数说明</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Helps/SubjectsController.php",
    "groupTitle": "faq"
  },
  {
    "type": "delete",
    "url": "/api/helps/subject/{id}",
    "title": "删除问题",
    "group": "faq",
    "name": "FAQ管理",
    "version": "1.0.0",
    "description": "<p>删除指定的问题</p>",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Helps/SubjectsController.php",
    "groupTitle": "faq"
  },
  {
    "type": "post",
    "url": "/api/service/supplierPrice/delete",
    "title": "供货价删除",
    "group": "供货价管理",
    "name": "供货价删除",
    "version": "1.0.0",
    "description": "<p>供货价删除</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>数据id</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SupplierPriceController.php",
    "groupTitle": "供货价管理"
  },
  {
    "type": "post",
    "url": "/api/service/supplierPrice/update",
    "title": "保存供货价",
    "group": "供货价管理",
    "name": "保存供货价",
    "version": "1.0.0",
    "description": "<p>保存供货价</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>id</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "goods_id_new",
            "description": "<p>商品id</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "ser_id_new",
            "description": "<p>服务商id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "supply_price_new",
            "description": "<p>供货价</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "remark_new",
            "description": "<p>备注</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SupplierPriceController.php",
    "groupTitle": "供货价管理"
  },
  {
    "type": "post",
    "url": "/api/service/supplierPrice/edit",
    "title": "修改供货价",
    "group": "供货价管理",
    "name": "修改供货价",
    "version": "1.0.0",
    "description": "<p>修改供货价</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>id</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SupplierPriceController.php",
    "groupTitle": "供货价管理"
  },
  {
    "type": "post",
    "url": "/api/service/supplierPrice",
    "title": "列表页",
    "group": "供货价管理",
    "name": "列表页",
    "version": "1.0.0",
    "description": "<p>供货价列表页</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "version",
            "description": "<p>商品编号</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "brand_name",
            "description": "<p>商品品牌</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "gh_price_name",
            "description": "<p>价格名</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "company_id",
            "description": "<p>服务商id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "create_time",
            "description": "<p>开始时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "end_time",
            "description": "<p>结束时间</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SupplierPriceController.php",
    "groupTitle": "供货价管理"
  },
  {
    "type": "post",
    "url": "/api/service/supplierPrice/create",
    "title": "添加供货价",
    "group": "供货价管理",
    "name": "添加供货价",
    "version": "1.0.0",
    "description": "<p>供货价列表添加供货价</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "goods_id",
            "description": "<p>商品id</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "ser_id",
            "description": "<p>服务商id</p>"
          },
          {
            "group": "Parameter",
            "type": "float",
            "optional": false,
            "field": "supply_price",
            "description": "<p>供货价</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "remark",
            "description": "<p>备注</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SupplierPriceController.php",
    "groupTitle": "供货价管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceNum/edit",
    "title": "修改界面",
    "group": "发票号管理",
    "name": "修改界面",
    "version": "1.0.0",
    "description": "<p>修改界面</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "number",
            "description": "<p>发票号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"成功\",\n        \"Data\": \"速电\"\n        }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"无此票号\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceNumController.php",
    "groupTitle": "发票号管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceNum",
    "title": "列表页",
    "group": "发票号管理",
    "name": "列表页",
    "version": "1.0.0",
    "description": "<p>列表页</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>平台ID</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "state",
            "description": "<p>使用状态 1:未使用; 2:已使用</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_order",
            "description": "<p>发票号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "start_time",
            "description": "<p>开始时间</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "end_time",
            "description": "<p>结束时间</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "sys_num",
            "description": "<p>系统单号</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "is_del",
            "description": "<p>是否作废 1:已作废;2:未作废</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "company",
            "description": "<p>公司 0:不限;5:蓝城;2:速电;6:个人</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page_size",
            "description": "<p>页大小</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page",
            "description": "<p>页码</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"errorCode\": 1,\n        \"errorMessage\": \"成功\",\n        \"data\": {\n        \"page\": {//页码数据\n        \"page\": 1,    //当前页码\n        \"page_size\": 20,//每页显示条数\n        \"count\": 479     //总条数\n        },\n        count_arr:{\n        qb:5,     //全部\n        wsy:1,   //未使用\n        ysy:2,   //已使用\n        }\n        \"list\": [\n        {\n        \"id\": 1456,                           //id\n        \"invoice_order\": 87756685,            //发票号\n        \"create_admin\": \"亢静保\",              //添加人\n        \"create_time\": \"2019-05-15 13:07:51\", //添加时间\n        \"sys_num\": \"260069315926959143\",      //关联订单号\n        \"status\": 2,                          //1未使用  2已使用\n        \"is_del\": 1,                          //1正常   2已作废\n        \"sys_company\": 5,                     //忽略\n        \"company\": \"蓝城\"                     //对应公司\n        }\n        ]\n        }\n        }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceNumController.php",
    "groupTitle": "发票号管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceNum/handleInvoice",
    "title": "处理",
    "group": "发票号管理",
    "name": "处理",
    "version": "1.0.0",
    "description": "<p>处理</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>数据id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "type",
            "description": "<p>1:恢复  2:作废</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"操作成功\",\n        \"Data\":''\n        ]\n        }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceNumController.php",
    "groupTitle": "发票号管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceNum/store",
    "title": "添加",
    "group": "发票号管理",
    "name": "添加",
    "version": "1.0.0",
    "description": "<p>添加</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "company",
            "description": "<p>5:蓝城;2:速电;6:个人</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "num_start",
            "description": "<p>开始发票号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "num_end",
            "description": "<p>结束发票号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"添加成功\",\n        \"Data\":''\n        ]\n        }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceNumController.php",
    "groupTitle": "发票号管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceNum/update",
    "title": "编辑",
    "group": "发票号管理",
    "name": "编辑",
    "version": "1.0.0",
    "description": "<p>编辑</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "company",
            "description": "<p>5:蓝城;2:速电;6:个人</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "number",
            "description": "<p>发票号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"操作成功\",\n        \"Data\":''\n        ]\n        }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceNumController.php",
    "groupTitle": "发票号管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceTable",
    "title": "列表",
    "group": "发票管理",
    "name": "列表",
    "version": "1.0.0",
    "description": "<p>平台管理列表</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "state",
            "description": "<p>状态；1：全部；2：待开发票；3：已开发票；4：已发快递</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "status",
            "description": "<p>筛选状态；1：不限；2：代开发票；3：已开发票；4：已发快递</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_order",
            "description": "<p>发票号</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "order_num",
            "description": "<p>订单号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_header",
            "description": "<p>发票台头</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "invoice_project",
            "description": "<p>发票项目</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "start_time",
            "description": "<p>开始时间</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "end_time",
            "description": "<p>结束时间</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page_size",
            "description": "<p>页大小</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page",
            "description": "<p>页码</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n           \"error_code\": 0,\n           \"data\": {\n           \"show_num\": {\n           \"dkfp\": 2,//待开发票\n           \"ykfp\": \"0\",//已开发票\n           \"kdh\": \"0\",//快递号\n           \"fph\": \"0\"//发票号\n           },\n           \"list\": [\n           {\n           \"id\": 1,\n           \"invoice_header\": \"忘机\",//发票台头\n           \"invoice_project\": \"蓄电池\",//发票项目\n           \"invoice_value\": \"1433.00\",//发票金额\n           \"invoice_order\": \"\",//发票号\n           \"invoice_time\": \"\",//开票时间\n           \"content\": \"\",//开票备注\n           \"is_invoice\": 1,//状态:1新发票10已开发票20已发快递30已取消'\n           \"order_num\": \"ZC201807250519271369\",//平台编号\n           \"creator\": \"\",//创建人\n           \"create_time\": \"2018-07-25 17:19:27\",//创建时间\n           \"invoice_type\": 2,//发票类型；1：增票；2：普票\n           \"invoice_kd\": null,//快递单号\n           \"invoice_urgency\": 1,//紧急状态；1：普通；10：加急\n           \"invoice_pid\": null,//平台id\n           \"client_name\": \"忘机\",//客户姓名\n           \"client_tel\": \"17606122918\",//客户电话\n           \"client_addr\": \"北京 北京市 东城区 南海诸岛\",//客户地址\n           \"tax_num\": null,//税号\n           \"company_addr\": null,//公司地址\n           \"company_tel\": null,//公司电话\n           \"bank\": null,//开户行\n           \"bank_num\": null,//账号\n           \"mkinvoice_type\": \"个人\",//开票类型；1：公司；2：个人\n           \"invoice_pic\": null,//图片\n           \"p_name\": \"\"//平台名称\n           },\n           ....\n           ]\n           }\n           }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceTableController.php",
    "groupTitle": "发票管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceTable/delete",
    "title": "删除发票",
    "group": "发票管理",
    "name": "删除发票",
    "version": "1.0.0",
    "description": "<p>删除发票</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>id号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n      \"error_code\": 0,\n      \"ErrorMessage\":\"成功\",\n      \"data\": []\n      }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"删除失败\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceTableController.php",
    "groupTitle": "发票管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceTable/edit",
    "title": "发票修改界面",
    "group": "发票管理",
    "name": "发票修改界面",
    "version": "1.0.0",
    "description": "<p>发票修改界面</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>发票编号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n      \"error_code\": 0,\n      \"data\": {\n      \"uid\": \"1\",\n      \"username\": \"12154545\",\n      \"name\": \"吴系挂\",\n      \"groupid\": 2 ,\n      \"reg_time\": \"1436864169\",\n      \"last_login_time\": \"0\",\n      }\n      }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceTableController.php",
    "groupTitle": "发票管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceTable/checkNumber",
    "title": "发票修验证",
    "group": "发票管理",
    "name": "发票修验证",
    "version": "1.0.0",
    "description": "<p>发票修验证</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "order_num",
            "description": "<p>平台单号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n      \"error_code\": 0,\n      \"ErrorMessage\":\"验证成功\",\n      \"data\": []\n      }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"平台单号不能为空\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceTableController.php",
    "groupTitle": "发票管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceTable/Urgency",
    "title": "发票加急",
    "group": "发票管理",
    "name": "发票加急",
    "version": "1.0.0",
    "description": "<p>发票加急</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>id号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n      \"error_code\": 0,\n      \"ErrorMessage\":\"操作成功\",\n      \"data\": []\n      }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"操作成功\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceTableController.php",
    "groupTitle": "发票管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceTable/restentry",
    "title": "发票重置",
    "group": "发票管理",
    "name": "发票重置",
    "version": "1.0.0",
    "description": "<p>平台管理列表</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>发票编号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n       \"ErrorCode\": 1,\n       \"Data\":'',\n       \"ErrorMessage\":\"操作成功\"\n\n       }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceTableController.php",
    "groupTitle": "发票管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceTable/store",
    "title": "添加发票",
    "group": "发票管理",
    "name": "添加发票",
    "version": "1.0.0",
    "description": "<p>添加发票</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "invoice_pid",
            "description": "<p>平台id</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "client_name",
            "description": "<p>客户姓名</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "client_tel",
            "description": "<p>客户电话</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "client_addr",
            "description": "<p>客户地址</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_header",
            "description": "<p>发票台头</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_project",
            "description": "<p>发票项目</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "invoice_type",
            "description": "<p>发票类型</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "mkinvoice_type",
            "description": "<p>开票类型</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_value",
            "description": "<p>发票金额</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "order_num",
            "description": "<p>平台单号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "tax_num",
            "description": "<p>税号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "company_addr",
            "description": "<p>公司地址</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "company_tel",
            "description": "<p>公司电话</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "bank",
            "description": "<p>开户行</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "bank_num",
            "description": "<p>账号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "content",
            "description": "<p>开票备注</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "pay_type",
            "description": "<p>付款账号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_order",
            "description": "<p>发票号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_time",
            "description": "<p>开票时间</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_kd",
            "description": "<p>快递单号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_pic",
            "description": "<p>发票图片</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n  \"error_code\": 0,\n  \"ErrorMessage\":\"成功\",\n  \"data\": []\n  }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"平台单号不能为空\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceTableController.php",
    "groupTitle": "发票管理"
  },
  {
    "type": "post",
    "url": "/api/Financial/invoiceTable/EditEntry",
    "title": "编辑发票",
    "group": "发票管理",
    "name": "编辑发票",
    "version": "1.0.0",
    "description": "<p>编辑发票</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>id号</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "invoice_pid",
            "description": "<p>平台id</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "client_name",
            "description": "<p>客户姓名</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "client_tel",
            "description": "<p>客户电话</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "client_addr",
            "description": "<p>客户地址</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_header",
            "description": "<p>发票台头</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_project",
            "description": "<p>发票项目</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "invoice_type",
            "description": "<p>发票类型</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "mkinvoice_type",
            "description": "<p>开票类型</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_value",
            "description": "<p>发票金额</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "order_num",
            "description": "<p>平台单号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "tax_num",
            "description": "<p>税号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "company_addr",
            "description": "<p>公司地址</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "company_tel",
            "description": "<p>公司电话</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "bank",
            "description": "<p>开户行</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "bank_num",
            "description": "<p>账号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "content",
            "description": "<p>开票备注</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "pay_type",
            "description": "<p>付款账号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_order",
            "description": "<p>发票号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_time",
            "description": "<p>开票时间</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_kd",
            "description": "<p>快递单号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "invoice_pic",
            "description": "<p>发票图片</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n      \"error_code\": 0,\n      \"ErrorMessage\":\"成功\",\n      \"data\": []\n      }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"平台单号不能为空\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Financial/InvoiceTableController.php",
    "groupTitle": "发票管理"
  },
  {
    "type": "post",
    "url": "/api/service/setMoneyType",
    "title": "列表页",
    "group": "奖惩金额",
    "name": "列表页",
    "version": "1.0.0",
    "description": "<p>接口描述</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "type_name",
            "description": "<p>类别名称</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page_size",
            "description": "<p>页大小</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page",
            "description": "<p>页码</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>token</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"成功\",\n        \"data\": {\n        \"page\": {//页码数据\n        \"page\": 1,    //当前页码\n        \"page_size\": 20,//每页显示条数\n        \"count\": 479     //总条数\n        },\n        \"list\": [ //数据\n        {\n        \"sety_id\": 19,           //id\n        \"sety_name\": \"结算补贴\",  //类别名称\n        \"sety_price\": \"1\"        //价格\n        }\n        ]\n        }\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SetMoneyTypeController.php",
    "groupTitle": "奖惩金额"
  },
  {
    "type": "post",
    "url": "/api/service/setMoneyType/delete",
    "title": "删除奖惩金额",
    "group": "奖惩金额",
    "name": "删除奖惩金额",
    "version": "1.0.0",
    "description": "<p>删除奖惩金额</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>数据ID</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"删除成功\",\n        \"data\":''\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SetMoneyTypeController.php",
    "groupTitle": "奖惩金额"
  },
  {
    "type": "post",
    "url": "/api/service/setMoneyType/store",
    "title": "添加奖惩金额",
    "group": "奖惩金额",
    "name": "添加奖惩金额",
    "version": "1.0.0",
    "description": "<p>新增</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "sety_name",
            "description": "<p>类别名称</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "sety_price",
            "description": "<p>奖惩金额</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>token</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"添加成功\",\n        \"data\":''\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SetMoneyTypeController.php",
    "groupTitle": "奖惩金额"
  },
  {
    "type": "post",
    "url": "/api/service/setMoneyType/update",
    "title": "编辑奖惩金额",
    "group": "奖惩金额",
    "name": "编辑奖惩金额",
    "version": "1.0.0",
    "description": "<p>新增</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>数据ID</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "sety_name",
            "description": "<p>类别名称</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "sety_price",
            "description": "<p>奖惩金额</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>token</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"添加成功\",\n        \"data\":''\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SetMoneyTypeController.php",
    "groupTitle": "奖惩金额"
  },
  {
    "type": "post",
    "url": "/api/service/subsidy",
    "title": "列表页",
    "group": "对服务商补贴管理",
    "name": "列表页",
    "version": "1.0.0",
    "description": "<p>供货价列表页</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "order_time",
            "description": "<p>时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "brand_name",
            "description": "<p>品牌名称</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "goods_name",
            "description": "<p>商品名称</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SubsidyController.php",
    "groupTitle": "对服务商补贴管理"
  },
  {
    "type": "post",
    "url": "/api/service/subsidy/update",
    "title": "修改",
    "group": "对服务商补贴管理（铅价补贴）",
    "name": "修改",
    "version": "1.0.0",
    "description": "<p>对服务商补贴新增</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "id",
            "description": "<p>id号</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "ld_price",
            "description": "<p>补贴价格(type3)</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "ld_type",
            "description": "<p>19 淡季活动价补贴，14 结算补贴 \t19</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "ld_release",
            "description": "<p>1 开启 2 未开启</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SubsidyController.php",
    "groupTitle": "对服务商补贴管理（铅价补贴）"
  },
  {
    "type": "post",
    "url": "/api/service/subsidy/delete",
    "title": "删除补贴",
    "group": "对服务商补贴管理（铅价补贴）",
    "name": "删除补贴",
    "version": "1.0.0",
    "description": "<p>对服务商补贴新增</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "id",
            "description": "<p>id号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SubsidyController.php",
    "groupTitle": "对服务商补贴管理（铅价补贴）"
  },
  {
    "type": "post",
    "url": "/api/service/subsidy/switchAll",
    "title": "开启和关闭全部功能",
    "group": "对服务商补贴管理（铅价补贴）",
    "name": "开启和关闭全部功能",
    "version": "1.0.0",
    "description": "<p>开启和关闭全部功能</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "id",
            "description": "<p>id号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SubsidyController.php",
    "groupTitle": "对服务商补贴管理（铅价补贴）"
  },
  {
    "type": "post",
    "url": "/api/service/subsidy/Switch",
    "title": "开启补贴或关闭补贴",
    "group": "对服务商补贴管理（铅价补贴）",
    "name": "开启补贴或关闭补贴",
    "version": "1.0.0",
    "description": "<p>对服务商补贴关闭或者开启</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "id",
            "description": "<p>id号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SubsidyController.php",
    "groupTitle": "对服务商补贴管理（铅价补贴）"
  },
  {
    "type": "post",
    "url": "/api/service/subsidy/store",
    "title": "新增",
    "group": "对服务商补贴管理（铅价补贴）",
    "name": "新增",
    "version": "1.0.0",
    "description": "<p>对服务商补贴新增</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pg_id",
            "description": "<p>商品id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "ld_price",
            "description": "<p>补贴价格(type3)</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "brand_name",
            "description": "<p>品牌名称(type3)</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "chomodel",
            "description": "<p>电瓶型号框显示的内容(type3)</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "ld_type",
            "description": "<p>19 淡季活动价补贴，14 结算补贴 \t19</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "ld_release",
            "description": "<p>1 开启 2 未开启</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/SubsidyController.php",
    "groupTitle": "对服务商补贴管理（铅价补贴）"
  },
  {
    "type": "post",
    "url": "/api/platform/platformPrice/update",
    "title": "保存编辑平台价格",
    "group": "平台价格",
    "name": "保存编辑平台价格",
    "version": "1.0.0",
    "description": "<p>平台价格 &gt;&gt; 编辑平台价格</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>id</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pri_price",
            "description": "<p>金额</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "pri_name",
            "description": "<p>销售名称</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"编辑成功\",\n        \"data\":[]\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformPriceController.php",
    "groupTitle": "平台价格"
  },
  {
    "type": "delete",
    "url": "/api/platform/platformPrice/setptprice",
    "title": "停用启用",
    "group": "平台价格",
    "name": "停用启用",
    "version": "1.0.0",
    "description": "<p>平台价格 &gt;&gt; 停用启用</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pri_id",
            "description": "<p>id</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "type",
            "description": "<p>启用1 停用2</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformPriceController.php",
    "groupTitle": "平台价格"
  },
  {
    "type": "post",
    "url": "/api/platform/platformPrice",
    "title": "列表页",
    "group": "平台价格",
    "name": "列表页",
    "version": "1.0.0",
    "description": "<p>平台价格 &gt;&gt; 列表页</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pt_id",
            "description": "<p>平台id</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "brand_name",
            "description": "<p>品牌名称</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "version",
            "description": "<p>商品型号</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page_size",
            "description": "<p>页大小</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page",
            "description": "<p>页码</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>token</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "Pri_id",
            "description": "<p>页码权限码</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"errorCode\": 1,\n        \"errorMessage\": \"成功\",\n        \"data\": {\n        \"page\": {//页码数据\n        \"page\": 1,    //当前页码\n        \"page_size\": 20,//每页显示条数\n        \"count\": 479     //总条数\n        },\n        \"list\": [  //数据\n        {\n        \"pri_id\": 1,  //id\n        \"pri_price\": \"421\",  //价格\n        \"pri_peo\": \"窦斌\",  //添加人\n        \"pri_ptid\": 67,    //平台id 忽略\n        \"pri_pgid\": 196,   //商品id  忽略\n        \"brand_name\": \"瓦尔塔\",  //商品品牌\n        \"pg_series\": \"蓝标-55415\", //型号\n        \"version\": \"55415\"          //通用名称\n        \"pt_name\": \"畅通车友会\",     //平台名称\n        \"pri_name\": null,           //销售名称\n        \"national_version\": \"\"      //国际价格\n        \"pri_show\": 1              //1  展示  2 隐藏  或则  1 启用  2停用\n        }\n        ]\n        }\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformPriceController.php",
    "groupTitle": "平台价格"
  },
  {
    "type": "post",
    "url": "/api/platform/platformPrice/delete",
    "title": "删除平台价格",
    "group": "平台价格",
    "name": "删除平台价格",
    "version": "1.0.0",
    "description": "<p>平台价格 &gt;&gt; 删除平台价格</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>id</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"删除成功\",\n        \"data\":''\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformPriceController.php",
    "groupTitle": "平台价格"
  },
  {
    "type": "post",
    "url": "/api/platform/platformPrice/store",
    "title": "添加平台价格",
    "group": "平台价格",
    "name": "添加平台价格",
    "version": "1.0.0",
    "description": "<p>平台价格 &gt;&gt; 添加平台价格</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pt_id",
            "description": "<p>平台id</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "goods_id",
            "description": "<p>商品id</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "brand_name",
            "description": "<p>品牌名称</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pri_price",
            "description": "<p>金额</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "pri_name",
            "description": "<p>销售名称</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"添加成功\",\n        \"data\":[]\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformPriceController.php",
    "groupTitle": "平台价格"
  },
  {
    "type": "post",
    "url": "/api/platform/platformPrice/edit",
    "title": "编辑平台价格",
    "group": "平台价格",
    "name": "编辑平台价格",
    "version": "1.0.0",
    "description": "<p>平台价格 &gt;&gt; 编辑平台价格</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>id</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"errorCode\": 1,\n        \"errorMessage\": \"获取成功\",\n        \"data\": {\n        \"pri_id\": 1098,  //id\n        \"pri_price\": \"1000\", //金额\n        \"brand_name\": \"瓦尔塔\", //品牌\n        \"pg_series\": \"蓝标\",    //忽略\n        \"version\": \"55530\",     //忽略\n        \"pt_name\": \"畅通车友会\", //平台\n        \"pri_name\": \"测试数据\",  //销售名称\n        \"type\": \"瓦尔塔-蓝标-55530\"  //商品名称\n        }\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformPriceController.php",
    "groupTitle": "平台价格"
  },
  {
    "type": "post",
    "url": "/api/service/salePrice/create",
    "title": "平台卖价保存",
    "group": "平台卖价管理",
    "name": "平台卖价保存",
    "version": "1.0.0",
    "description": "<p>平台卖价保存到数据库</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>数据id</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "type",
            "description": "<p>公开状态</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Admin/SalesPriceController.php",
    "groupTitle": "平台卖价管理"
  },
  {
    "type": "post",
    "url": "/api/service/salePrice",
    "title": "平台卖价列表",
    "group": "平台卖价管理",
    "name": "平台卖价列表",
    "version": "1.0.0",
    "description": "<p>平台卖价列表</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "id",
            "description": "<p>数据id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "type",
            "description": "<p>商品品牌</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "pt_id",
            "description": "<p>价格名</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "goods_id",
            "description": "<p>服务商id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "brand_name",
            "description": "<p>开始时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "pg_series",
            "description": "<p>结束时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "state",
            "description": "<p>结束时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "order_time",
            "description": "<p>结束时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "order_num",
            "description": "<p>结束时间</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page_size",
            "description": "<p>页大小</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page",
            "description": "<p>页码</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>token</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "Pri_id",
            "description": "<p>页码权限码</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Admin/SalesPriceController.php",
    "groupTitle": "平台卖价管理"
  },
  {
    "type": "post",
    "url": "/api/service/activity/AdvanceEnd",
    "title": "提前结束活动",
    "group": "平台活动支持",
    "name": "提前结束活动",
    "version": "1.0.0",
    "description": "<p>服务商活动管理-查看</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "sup_id",
            "description": "<p>数据id</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"操作成功\",\n        \"data\":''\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ActivityController.php",
    "groupTitle": "平台活动支持"
  },
  {
    "type": "post",
    "url": "/api/service/activity/show",
    "title": "服务商活动管理-查看",
    "group": "平台活动支持",
    "name": "服务商活动管理",
    "version": "1.0.0",
    "description": "<p>服务商活动管理-查看</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>数据id</p>"
          }
        ]
      }
    },
    "error": {
      "fields": {
        "Error 4xx": [
          {
            "group": "Error 4xx",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Error 4xx",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Error 4xx",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"Data\":[\"ser_data\" => [], \"goods_data\" => []],\"ErrorCode\":1,\"ErrorMessage\":\"成功\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ActivityController.php",
    "groupTitle": "平台活动支持"
  },
  {
    "type": "post",
    "url": "/api/service/activity",
    "title": "服务商活动管理-列表页",
    "group": "平台活动支持",
    "name": "服务商活动管理-列表页",
    "version": "1.0.0",
    "description": "<p>服务商活动管理-列表页</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "brand_name",
            "description": "<p>品牌名称</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page",
            "description": "<p>页码</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page_size",
            "description": "<p>页容量</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>token</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "Pri_id",
            "description": "<p>页码权限码</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Request-Example",
          "content": "{\n\"brand_name\":\"AC德科\",\n\"page\":1,\n\"page_size\":10,\n\"token\":\"c961a3c4a3bb91d3d5151c100eb2ffb6\",\n\"Pri_id\":329\n}",
          "type": "json"
        }
      ]
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"errorCode\": 1,\n        \"errorMessage\": \"成功\",\n        \"data\": {\n        \"page\": {//页码数据\n        \"page\": 1,    //当前页码\n        \"page_size\": 20,//每页显示条数\n        \"count\": 479     //总条数\n        },\n        \"list\": [ //数据列表\n        {\n        \"sup_id\": 4,             //id\n        \"sup_brname\": \"瓦尔塔\",  //品牌\n        \"sup_price\": 12,        // 补贴价格\n        \"sup_startime\": \"2016-11-04 17:59:41\", //开始时间\n        \"sup_endtime\": \"2016-11-05 17:59:44\",  //结束时间\n        \"sup_creacer\": \"窦斌\",                 //添加人\n        \"sup_num\": \"S20161103055947735\",       //活动编号\n        \"type\": 3             // 1 未开始  2 已开始  3 已结束\n        }\n        ]\n        }\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ActivityController.php",
    "groupTitle": "平台活动支持"
  },
  {
    "type": "delete",
    "url": "/api/service/activity/delete",
    "title": "服务商活动管理-删除",
    "group": "平台活动支持",
    "name": "服务商活动管理-删除",
    "version": "1.0.0",
    "description": "<p>服务商活动管理-删除</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>数据id</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"Data\":\"\",\"ErrorCode\":1,\"ErrorMessage\":\"删除成功\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ActivityController.php",
    "groupTitle": "平台活动支持"
  },
  {
    "type": "post",
    "url": "/api/service/activity/store",
    "title": "服务商活动管理-添加",
    "group": "平台活动支持",
    "name": "服务商活动管理-添加",
    "version": "1.0.0",
    "description": "<p>服务商活动管理-添加</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "ser_id",
            "description": "<p>已选择服务中心id</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "sup_type",
            "description": "<p>1:全部型号; 2:部分型号</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "goods_id",
            "description": "<p>商品id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "sup_startime",
            "description": "<p>开始时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "sup_endtime",
            "description": "<p>结束时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "sup_price",
            "description": "<p>金额</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "sup_brname",
            "description": "<p>品牌名称</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"添加成功\",\n        \"data\":''\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ActivityController.php",
    "groupTitle": "平台活动支持"
  },
  {
    "type": "post",
    "url": "/api/service/activity/update",
    "title": "服务商活动管理-添加",
    "group": "平台活动支持",
    "name": "服务商活动管理-添加",
    "version": "1.0.0",
    "description": "<p>服务商活动管理-添加</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "id",
            "description": "<p>数据id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "ser_id",
            "description": "<p>服务商id (array or string)</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "goods_id",
            "description": "<p>商品id(array or string)</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "sup_startime",
            "description": "<p>开始时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "sup_endtime",
            "description": "<p>结束时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "sup_price",
            "description": "<p>金额</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "sup_brname",
            "description": "<p>品牌名称</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"Data\":\"\",\"ErrorCode\":1,\"ErrorMessage\":\"修改成功\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ActivityController.php",
    "groupTitle": "平台活动支持"
  },
  {
    "type": "post",
    "url": "/api/service/activity//edit",
    "title": "服务商活动管理-编辑",
    "group": "平台活动支持",
    "name": "服务商活动管理-编辑",
    "version": "1.0.0",
    "description": "<p>服务商活动管理-编辑</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>数据id</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "int",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "array",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"成功\",\n        \"data\": {\n        \"sup_data\": {   //参数\n        \"sup_id\": 6,     //id\n        \"sup_serid\": \"621\",  //忽略\n        \"sup_type\": \"1\",     //  1 全部型号   2 部分型号\n        \"sup_brname\": \"瓦尔塔\",  //品牌\n        \"sup_price\": 25,        //价格\n        \"sup_startime\": \"2019-10-11 15:30:25\", //开始时间\n        \"sup_endtime\": \"2020-05-11 15:30:25\"   //结束时间\n        },\n        \"ser_data\": [ //已选的服务中心\n        {\n        \"id\": 621,    //服务中心id\n        \"company_name\": \"北京-瓦尔塔-雷锋\" //服务中心名称\n        }\n        ],\n        \"brand_data\": [  //品牌列表\n        {\n        \"brand_name\": \"AC德科\", //品牌名称\n        \"type\": 1               //1 代表 没有选择   2 代表 选中\n        },\n        {\n        \"brand_name\": \"瓦尔塔\",\n        \"type\": 2\n        }\n        ]\n        \"goods_data\": [   //商品列表\n        {\n        \"pg_id\": 196,              //商品id\n        \"type\": 1,                 //1 代表 没有选择   2 代表 选中\n        \"good_name\": \"蓝标-55415\"  //商品名称\n        }\n        ]\n        }\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ActivityController.php",
    "groupTitle": "平台活动支持"
  },
  {
    "type": "post",
    "url": "/api/service/activity/create",
    "title": "添加界面参数",
    "group": "平台活动支持",
    "name": "添加界面参数",
    "version": "1.0.0",
    "description": "<p>服务商活动管理-添加界面参数</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "ser_name",
            "description": "<p>服务中心名称</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "ser_id",
            "description": "<p>已选择服务中心id(可以是数组也可以是逗号分隔的字符串)</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"errorCode\": 1,\n        \"errorMessage\": \"返回成功\",\n        \"data\": [    //服务中心列表\n        {\n        \"id\": 612,                           //id\n        \"company_name\": \"系统演示门店(北京）\"  //服务中心名称\n        }\n        ]\n        }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ActivityController.php",
    "groupTitle": "平台活动支持"
  },
  {
    "type": "post",
    "url": "/api/platform/platform/update",
    "title": "平台修改保存",
    "group": "平台管理",
    "name": "平台修改保存",
    "version": "1.0.0",
    "description": "<p>平台修改保存</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>要修改的平台ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "pt_name",
            "description": "<p>平台名称</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "type",
            "description": "<p>类型</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pt_zt",
            "description": "<p>状态 1:启用;2:停用</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "three_pd",
            "description": "<p>平台类型0:自家;1:第三方</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "p_paytype",
            "description": "<p>开票公司</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "bus_type",
            "description": "<p>业务类型</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "sord",
            "description": "<p>别名</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pt_other",
            "description": "<p>备注</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "model_id",
            "description": ""
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "p_oname",
            "description": "<p>首字母</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformController.php",
    "groupTitle": "平台管理"
  },
  {
    "type": "post",
    "url": "/api/platform/platform/edit",
    "title": "平台修改界面接口",
    "group": "平台管理",
    "name": "平台修改界面接口",
    "version": "1.0.0",
    "description": "<p>平台修改界面接口</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>平台ID</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformController.php",
    "groupTitle": "平台管理"
  },
  {
    "type": "post",
    "url": "/api/platform/platform/delete",
    "title": "平台删除",
    "group": "平台管理",
    "name": "平台删除",
    "version": "1.0.0",
    "description": "<p>平台删除</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>平台ID</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformController.php",
    "groupTitle": "平台管理"
  },
  {
    "type": "post",
    "url": "/api/platform/platform",
    "title": "平台添加",
    "group": "平台管理",
    "name": "平台添加",
    "version": "1.0.0",
    "description": "<p>平台添加</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "pt_name",
            "description": "<p>平台名称</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "type",
            "description": "<p>类型</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pt_zt",
            "description": "<p>状态 1:启用;2:停用</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "three_pd",
            "description": "<p>平台类型0:自家;1:第三方</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "p_paytype",
            "description": "<p>开票公司</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "bus_type",
            "description": "<p>业务类型</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "sord",
            "description": "<p>别名</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pt_other",
            "description": "<p>备注</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "model_id",
            "description": ""
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "p_oname",
            "description": "<p>首字母</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformController.php",
    "groupTitle": "平台管理"
  },
  {
    "type": "post",
    "url": "/api/platform/platform/create",
    "title": "平台添加界面接口",
    "group": "平台管理",
    "name": "平台添加界面接口",
    "version": "1.0.0",
    "description": "<p>平台添加界面接口</p>",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformController.php",
    "groupTitle": "平台管理"
  },
  {
    "type": "post",
    "url": "/api/platform/platform",
    "title": "平台管理列表",
    "group": "平台管理",
    "name": "平台管理列表",
    "version": "1.0.0",
    "description": "<p>平台管理列表</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "pt_name",
            "description": "<p>平台名称搜索</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "type",
            "description": "<p>类型搜索</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "pt_zt",
            "description": "<p>状态 1:启用;2:停用</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "three_pd",
            "description": "<p>0:自家;1:第三方</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "p_paytype",
            "description": "<p>开票公司</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "bus_type",
            "description": "<p>业务类型</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page_size",
            "description": "<p>页大小</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page",
            "description": "<p>页码</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Platform/PlatformController.php",
    "groupTitle": "平台管理"
  },
  {
    "type": "post",
    "url": "/api/service/serviceProvider",
    "title": "列表页",
    "group": "服务商管理",
    "name": "列表页",
    "version": "1.0.0",
    "description": "<p>派单系统服务商管理，服务商是为系统提供最终服务的单位，最终工单将派发到服务商手里</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>授权token</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page",
            "description": "<p>页码</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page_size",
            "description": "<p>每页数量</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "type",
            "description": "<p>结算方式 1：公司；2：个人</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "unified",
            "description": "<p>统一价格 1：是；2：否</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "company_name",
            "description": "<p>公司名称（搜索）</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "reward",
            "description": "<p>奖罚设置1.开启2.关闭</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "enable",
            "description": "<p>账号状态（搜索）；1：开启；2：关闭</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\":\"成功\",\n        \"data\": {\n        \"list\": [\n        {\n        \"id\": 41,\n        \"admin_acc\": \"ceshi-李帅\",\n        \"admin_name\": \"ceshi-李帅\",\n        \"admin_group\": 7,\n        \"type\": null,\n        \"invoice\": \"3\",\n        \"company_name\": \"李帅测试冶炼厂\",\n        \"ptid\": \"0\",\n        \"enable\": \"启用\",//账号状态\n        \"is_sord\": 1,\n        \"reward\": \"关闭\",//奖惩设置\n        \"phone\": \"13811333238\",\n        \"accountname\": \"\",\n        \"account\": null,\n        \"opeaccline\": null,\n        \"certification_num\": null,//门店代码\n        \"ser_varcode\": null,\n        \"bmmc_name\": \"系统管理员\"//所属部门\n        \"unified\": \"非统一价格\",//是否统一价格\n        \"brand_name\": \"康师傅\",\n        \"ser_varcode\": \"服务商瓦尔塔编号\",\n        \"ser_yycode\": \"用友系统编号\",\n        \"mouth_pay\":\"月结\"\n        },\n        ...\n        ],\n        \"page\": {\n        \"page\": 1,//页码\n        \"page_size\": 2,//每页数量\n        \"count\": 379,//总数\n        \"allPage\": 190//总页数\n        }\n        }\n        }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ServiceProviderController.php",
    "groupTitle": "服务商管理"
  },
  {
    "type": "post",
    "url": "/api/service/serviceProvider/store",
    "title": "新增服务商",
    "group": "服务商管理",
    "name": "新增服务商",
    "version": "1.0.0",
    "description": "<p>服务商添加到数据库</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>授权token</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_acc",
            "description": "<p>登录名</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_password",
            "description": "<p>密码</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "enable",
            "description": "<p>账号状态；1：启用；2：停用</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_name",
            "description": "<p>、用户名</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "phone",
            "description": "<p>手机号</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "type",
            "description": "<p>结算对象；1：公司；2：个人</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "qq",
            "description": "<p>QQ号码</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "ad_brand",
            "description": "<p>经营品牌</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "agent_brand",
            "description": "<p>代理品牌</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "ad_project",
            "description": "<p>经营项目</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "ad_urgent[]",
            "description": "<p>特殊订单类型；10：加急；20：夜间</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "lidao",
            "description": "<p>是否为力道门店；1：普通；2：力道</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "children_id",
            "description": "<p>否 \tstring \t力道下属服务商(id以逗号分隔)，为力道门店时必选</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "service_name",
            "description": "<p>公司名称</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "company_name",
            "description": "<p>服务中心名称</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_dressi",
            "description": "<p>绑定门店地址</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_county",
            "description": "<p>所属城市</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_zuob",
            "description": "<p>坐标</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "account",
            "description": "<p>账号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "accountname",
            "description": "<p>账户名</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "opeaccline",
            "description": "<p>开户行</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "is_ice",
            "description": "<p>发票 1：是；2：否</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "invoice",
            "description": "<p>1:专票；2：普票</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "fdeduct",
            "description": "<p>发票税点</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "deduct",
            "description": "<p>发票扣点</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_province",
            "description": "<p>服务区域省</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_city",
            "description": "<p>服务区域市</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "sheng[]",
            "description": "<p>[ad_sheng] 省</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"获取成功\",\n        \"data\": {\n        \"ad_brand\": [//品牌\n        {\n        \"id\": 1,\n        \"brand_name\": \"博世\"\n        },\n        {\n        \"id\": 2,\n        \"brand_name\": \"瓦尔塔\"\n        },\n        ...\n        ],\n        \"ad_project\": {//经营项目\n        \"1\": \"蓄电池更换\",\n        \"2\": \"轮胎更换\",\n        \"3\": \"汽车救援\",\n        \"4\": \"汽车保养\",\n        \"5\": \"汽车保险\",\n        \"6\": \"其他\"\n        }\n        }\n        }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ServiceProviderController.php",
    "groupTitle": "服务商管理"
  },
  {
    "type": "post",
    "url": "/api/service/serviceProvider/update",
    "title": "更新服务商信息",
    "group": "服务商管理",
    "name": "更新服务商信息",
    "version": "1.0.0",
    "description": "<p>接口描述</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "id",
            "description": "<p>id号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>授权token</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_acc",
            "description": "<p>登录名</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_password",
            "description": "<p>密码</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "enable",
            "description": "<p>账号状态；1：启用；2：停用</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_name",
            "description": "<p>、用户名</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "phone",
            "description": "<p>手机号</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "type",
            "description": "<p>结算对象；1：公司；2：个人</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "qq",
            "description": "<p>QQ号码</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "ad_brand",
            "description": "<p>经营品牌</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "agent_brand",
            "description": "<p>代理品牌</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "ad_project",
            "description": "<p>经营项目</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "ad_urgent[]",
            "description": "<p>特殊订单类型；10：加急；20：夜间</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "lidao",
            "description": "<p>是否为力道门店；1：普通；2：力道</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "children_id",
            "description": "<p>否 \tstring \t力道下属服务商(id以逗号分隔)，为力道门店时必选</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "service_name",
            "description": "<p>公司名称</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "company_name",
            "description": "<p>服务中心名称</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_dressi",
            "description": "<p>绑定门店地址</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_county",
            "description": "<p>所属城市</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_zuob",
            "description": "<p>坐标</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "account",
            "description": "<p>账号</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "accountname",
            "description": "<p>账户名</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "opeaccline",
            "description": "<p>开户行</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "is_ice",
            "description": "<p>发票 1：是；2：否</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "invoice",
            "description": "<p>1:专票；2：普票</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "fdeduct",
            "description": "<p>发票税点</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "deduct",
            "description": "<p>发票扣点</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_province",
            "description": "<p>服务区域省</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "admin_city",
            "description": "<p>服务区域市</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "sheng[]",
            "description": "<p>[ad_sheng] 省</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n   \"Data\": \"\",\n   \"ErrorMessage\": \"编辑成功\",\n   \"ErrorCode\": 1\n   }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ServiceProviderController.php",
    "groupTitle": "服务商管理"
  },
  {
    "type": "post",
    "url": "/api/service/serviceProvider/delete",
    "title": "服务商删除",
    "group": "服务商管理",
    "name": "服务商删除",
    "version": "1.0.0",
    "description": "<p>派单系统服务商删除，软删除设置隐藏属性</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>指定要删除的id</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ServiceProviderController.php",
    "groupTitle": "服务商管理"
  },
  {
    "type": "post",
    "url": "/api/service/serviceProvider/search",
    "title": "服务商名称搜索",
    "group": "服务商管理",
    "name": "服务商名称搜索",
    "version": "1.0.0",
    "description": "<p>服务商名称搜索，没有关键字，按实用度列出前十位，有关键字列出关键字前十位</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "keywords",
            "description": "<p>搜索关键字</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>授权token</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ServiceProviderController.php",
    "groupTitle": "服务商管理"
  },
  {
    "type": "post",
    "url": "/api/service/serviceProvider/export",
    "title": "服务商导出",
    "group": "服务商管理",
    "name": "服务商导出",
    "version": "1.0.0",
    "description": "<p>派单系统服务商资料导出，这里只负责文件生成部分，下载文件转到 downloadController</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>授权token</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page",
            "description": "<p>页码</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "page_size",
            "description": "<p>每页数量</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "type",
            "description": "<p>结算方式 1：公司；2：个人</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "unified",
            "description": "<p>统一价格 1：是；2：否</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "company_name",
            "description": "<p>公司名称（搜索）</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "reward",
            "description": "<p>奖罚设置1.开启2.关闭</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "enable",
            "description": "<p>账号状态（搜索）；1：开启；2：关闭</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[\"file_id\":1]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ServiceProviderController.php",
    "groupTitle": "服务商管理"
  },
  {
    "type": "post",
    "url": "/api/service/serviceProvider/create",
    "title": "服务商添加界面",
    "group": "服务商管理",
    "name": "服务商添加界面",
    "version": "1.0.0",
    "description": "<p>服务商添加界面需要的数据</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "token",
            "description": "<p>授权token</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n        \"ErrorCode\": 1,\n        \"ErrorMessage\": \"获取成功\",\n        \"data\": {\n        \"ad_brand\": [//品牌\n        {\n        \"id\": 1,\n        \"brand_name\": \"博世\"\n        },\n        {\n        \"id\": 2,\n        \"brand_name\": \"瓦尔塔\"\n        },\n        ...\n        ],\n        \"ad_project\": {\n        \"1\": \"蓄电池更换\",\n        \"2\": \"轮胎更换\",\n        \"3\": \"汽车救援\",\n        \"4\": \"汽车保养\",\n        \"5\": \"汽车保险\",\n        \"6\": \"其他\"\n        }\n        }\n        }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ServiceProviderController.php",
    "groupTitle": "服务商管理"
  },
  {
    "type": "post",
    "url": "/api/service/serviceProvider/bindRadius",
    "title": "绑定区域",
    "group": "服务商管理",
    "name": "绑定区域",
    "version": "1.0.0",
    "description": "<p>派单系统为某个服务商绑定可服务区域</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "secretKey",
            "description": "<p>地址信息</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "type",
            "description": "<p>城市</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>城市</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ServiceProviderController.php",
    "groupTitle": "服务商管理"
  },
  {
    "type": "post",
    "url": "/api/service/serviceProvider/edit",
    "title": "编辑服务商界面",
    "group": "服务商管理",
    "name": "编辑服务商界面",
    "version": "1.0.0",
    "description": "<p>接口描述</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "id",
            "description": "<p>id号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n       \"Data\": \"\",\n       \"ErrorMessage\": \"编辑成功\",\n       \"ErrorCode\": 1\n       }",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ServiceProviderController.php",
    "groupTitle": "服务商管理"
  },
  {
    "type": "post",
    "url": "/api/service/serviceProvider/jingwei",
    "title": "获取经纬度",
    "group": "服务商管理",
    "name": "获取经纬度",
    "version": "1.0.0",
    "description": "<p>派单系统获取某个地址的经纬度</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "address",
            "description": "<p>地址信息</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "city",
            "description": "<p>城市</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"ErrorCode\":5001,\"ErrorMessage\":\"接口异常\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Service/ServiceProviderController.php",
    "groupTitle": "服务商管理"
  },
  {
    "type": "post",
    "url": "/api/orders/aftercust/export",
    "title": "下载提示",
    "group": "电话沟通",
    "name": "下载提示",
    "version": "1.0.0",
    "description": "<p>下载提示</p>",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n       \"Data\": {\n       \"file_id\": 1220},\n       \"ErrorCode\": 1,\n       \"ErrorMessage\": \"文件下载生成成功\"\n       }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Orders/AfterCustController.php",
    "groupTitle": "电话沟通"
  },
  {
    "type": "post",
    "url": "/api/orders/aftercust/downloadFields",
    "title": "下载选项",
    "group": "电话沟通",
    "name": "下载选项",
    "version": "1.0.0",
    "description": "<p>下载选项</p>",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n   \"Data\": {\n   \"afc_id\": \"【编号】\",\n   \"afc_sys\": \"【系统单号】\",\n   \"afc_order\": \"【平台单号】\",\n   \"afc_serial\": \"【派工单号】\",\n   \"pt_name\": \"【平台名称】\",\n   \"afc_ordertime\": \"【订单创建时间】\",\n   \"afc_goodname\": \"【商品名称】\",\n   \"afc_price\": \"【商品单价】\",\n   \"afc_num\": \"【商品数量】\",\n   \"afc_creacter\": \"【创建人】\",\n   \"afc_creactime\": \"【创建时间】\",\n   \"invoice\": \"【发票类型】\",\n   \"kd_no\": \"【快递单号】\",\n   \"shr_name\": \"【客户姓名】\",\n   \"shr_phone\": \"【客户电话】\",\n   \"shr_adree\": \"【客户地址】\"\n   },\n   \"ErrorCode\": 1,\n   \"ErrorMessage\": \"获取成功\"\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Orders/AfterCustController.php",
    "groupTitle": "电话沟通"
  },
  {
    "type": "get",
    "url": "/api/orders/aftercust/Deals",
    "title": "列表页",
    "group": "电话沟通",
    "name": "列表页",
    "version": "1.0.0",
    "description": "<p>列表页</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "afs_state",
            "description": "<p>电话沟通状态</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "shr_name",
            "description": "<p>客户姓名</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "afs_order",
            "description": "<p>平台单号</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "start_time",
            "description": "<p>开始时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "end_time",
            "description": "<p>结束时间</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "page",
            "description": "<p>页码</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "page_size",
            "description": "<p>每页条数</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\n    \"Data\": {\n    \"page\": {\n    \"totalPage\": 1957,\n    \"count\": 19563,\n    \"page\": 0,\n    \"page_size\": 10\n    },\n    \"list\": [\n    {\n    \"afc_id\": 19565,\n    \"afc_sys\": \"L20210812155120659\",\n    \"afc_order\": \"L20210812155120659\",\n    \"afc_serial\": null,\n    \"afc_pid\": 137,\n    \"afc_ordertime\": \"2021-08-12 15:52:22\",\n    \"afc_gid\": 761,\n    \"afc_price\": \"100.00\",\n    \"afc_num\": 1,\n    \"afc_user\": 702784,\n    \"afc_serid\": 0,\n    \"afc_creactime\": \"2021-08-12 15:55:55\",\n    \"afc_creacter\": \"WQJ\",\n    \"afc_dealtime\": null,\n    \"afc_dealer\": null,\n    \"afc_state\": 1,\n    \"afc_creactid\": 1475,\n    \"afc_dealid\": null,\n    \"afc_centent\": \"测试\",\n    \"afc_goodname\": \"AC德科-GW6666\",\n    \"afc_code\": null,\n    \"afc_orderstatus\": 10,\n    \"afc_update\": null,\n    \"afc_dealcenent\": null,\n    \"afc_refund\": 2,\n    \"duration\": null,\n    \"afc_type\": 1,\n    \"id\": 19565,\n    \"admin_acc\": null,\n    \"admin_password\": null,\n    \"admin_group\": null,\n    \"perso_nal\": null,\n    \"admin_pic\": null,\n    \"admin_name\": null,\n    \"company_name\": null,\n    \"ptid\": null,\n    \"admin_pt_id\": null,\n    \"type\": null,\n    \"invoice\": null,\n    \"deduct\": null,\n    \"mouth_pay\": null,\n    \"unified\": null,\n    \"all_show\": null,\n    \"reward\": null,\n    \"is_sord\": null,\n    \"enable\": null,\n    \"ad_urgent\": null,\n    \"ad_brand\": null,\n    \"ad_project\": null,\n    \"ad_paper\": null,\n    \"children_id\": null,\n    \"is_lidao\": null,\n    \"owner\": null,\n    \"attribute\": null,\n    \"ad_alias\": null,\n    \"agent_brand\": null,\n    \"admin_groupnew\": null,\n    \"token\": null,\n    \"phone_type\": null,\n    \"sord\": \"B\",\n    \"pt_name\": \"本地测试\",\n    \"pt_zt\": 1,\n    \"pt_other\": null,\n    \"model_id\": 0,\n    \"three_pd\": 0,\n    \"code\": null,\n    \"p_oname\": null,\n    \"p_paytype\": 1,\n    \"bus_type\": 1,\n    \"is_bx\": 1,\n    \"skb_xm\": \"13810601569\",\n    \"shr_name\": \"王二\",\n    \"shr_phone\": \"13810601569\",\n    \"shr_sheng\": \"北京\",\n    \"shr_shi\": \"北京市\",\n    \"shr_xian\": \"海淀区\",\n    \"shr_adress\": \"测试小区\",\n    \"shr_stype\": 0,\n    \"shr_youbian\": null,\n    \"car_make\": null,\n    \"car_line\": null,\n    \"car_model\": null,\n    \"car_id\": 0,\n    \"user_email\": null,\n    \"sys_num\": \"L20210812155120659\",\n    \"shr_other\": null,\n    \"create_time\": \"2021-08-12 15:52:22\",\n    \"shr_type\": 1,\n    \"car_plate\": null,\n    \"car_vin\": null,\n    \"button_one\": [],\n    \"button_two\": [],\n    \"button_three\": [],\n    \"type_name\": null,\n    \"afc_state_name\": null,\n    \"status\": null,\n    \"reminder_num\": 0\n    }],\n    \"showMenu\": [\n    {\n    \"show_name\": \"未处理\",\n    \"show_num\": 10\n    },\n    {\n    \"show_name\": \"需跟进\",\n    \"show_num\": 5\n    },\n    {\n    \"show_name\": \"待审核\",\n    \"show_num\": 22\n    },\n    {\n    \"show_name\": \"已完成\",\n    \"show_num\": \"--\"\n    }\n    ],\n    \"button_top\": [],\n    \"button_search\": [],\n    \"button_export\": []\n    },\n    \"ErrorCode\": 1,\n    \"ErrorMessage\": \"获取成功\"\n    }",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Orders/AfterCustController.php",
    "groupTitle": "电话沟通"
  },
  {
    "type": "post",
    "url": "/api/orders/aftercust/Deals",
    "title": "处理订单",
    "group": "电话沟通",
    "name": "处理订单",
    "version": "1.0.0",
    "description": "<p>处理订单</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "afs_id",
            "description": "<p>数据id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "deal_type",
            "description": "<p>1：未处理；2：需跟进；3：待审核</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "afc_sys",
            "description": "<p>系统单号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Orders/AfterCustController.php",
    "groupTitle": "电话沟通"
  },
  {
    "type": "post",
    "url": "/api/orders/aftercust/updatecl",
    "title": "更新处理",
    "group": "电话沟通",
    "name": "更新处理",
    "version": "1.0.0",
    "description": "<p>更新处理</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "sys_num",
            "description": "<p>系统单号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Orders/AfterCustController.php",
    "groupTitle": "电话沟通"
  },
  {
    "type": "post",
    "url": "/api/orders/aftercust/updatedata",
    "title": "更新状态",
    "group": "电话沟通",
    "name": "更新状态",
    "version": "1.0.0",
    "description": "<p>更新状态</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "type",
            "description": "<p>1：暂停</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "time",
            "description": "<p>时间</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Orders/AfterCustController.php",
    "groupTitle": "电话沟通"
  },
  {
    "type": "post",
    "url": "/api/orders/aftercust/Audits",
    "title": "订单审核",
    "group": "电话沟通",
    "name": "订单审核",
    "version": "1.0.0",
    "description": "<p>订单审核</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "afc_id",
            "description": "<p>id号</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "audits_type",
            "description": "<p>审核状态</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "afc_centent",
            "description": "<p>备注内容</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Orders/AfterCustController.php",
    "groupTitle": "电话沟通"
  },
  {
    "type": "post",
    "url": "/api/orders/aftercust/refundprocc",
    "title": "退款处理",
    "group": "电话沟通",
    "name": "退款处理",
    "version": "1.0.0",
    "description": "<p>退款处理</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": false,
            "field": "id",
            "description": "<p>数据id</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "afc_order",
            "description": "<p>平台单号</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "content",
            "description": "<p>备注内容</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "ErrorCode",
            "description": "<p>状态码，1：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ErrorMessage",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"ErrorCode\":1,\"ErrorMessage\":\"\",\"Data\":[]}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Orders/AfterCustController.php",
    "groupTitle": "电话沟通"
  },
  {
    "type": "post",
    "url": "/api/interface/order/show",
    "title": "单个订单获取接口",
    "group": "第三方订单接口",
    "name": "单个订单获取接口",
    "version": "1.0.0",
    "description": "<p>根据订单NO获取单个订单信息</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "$order_no",
            "description": "<p>订单系统编号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"code\":0,\"message\":\"\",\"data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Api/OrdersController.php",
    "groupTitle": "第三方订单接口"
  },
  {
    "type": "post",
    "url": "/api/interface/order/state",
    "title": "告诉订单已发货",
    "group": "第三方订单接口",
    "name": "告诉订单已发货",
    "version": "1.0.0",
    "description": "<p>根据订单NO修改订单已发货状态</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "$order_no",
            "description": "<p>订单系统编号</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "$shipping_code",
            "description": "<p>快递标识</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "$shipping_no",
            "description": "<p>快递单号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"code\":0,\"message\":\"\",\"data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Api/OrdersController.php",
    "groupTitle": "第三方订单接口"
  },
  {
    "type": "post",
    "url": "/api/interface/order/update",
    "title": "订单修改",
    "group": "第三方订单接口",
    "name": "订单修改",
    "version": "1.0.0",
    "description": "<p>根据订单NO修改订单</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "$order_no",
            "description": "<p>订单系统编号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"code\":0,\"message\":\"\",\"data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Api/OrdersController.php",
    "groupTitle": "第三方订单接口"
  },
  {
    "type": "post",
    "url": "/api/interface/order/state",
    "title": "订单修改状态",
    "group": "第三方订单接口",
    "name": "订单修改状态",
    "version": "1.0.0",
    "description": "<p>根据订单NO修改订单状态</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "$order_no",
            "description": "<p>订单系统编号</p>"
          },
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "$state",
            "description": "<p>订单系统编号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"code\":0,\"message\":\"\",\"data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Api/OrdersController.php",
    "groupTitle": "第三方订单接口"
  },
  {
    "type": "post",
    "url": "/api/interface/order/shippingCancel",
    "title": "订单发货取消",
    "group": "第三方订单接口",
    "name": "订单发货取消",
    "version": "1.0.0",
    "description": "<p>根据订单NO修改订单已发货状态取消</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "$order_no",
            "description": "<p>订单系统编号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"code\":0,\"message\":\"\",\"data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Api/OrdersController.php",
    "groupTitle": "第三方订单接口"
  },
  {
    "type": "post",
    "url": "/api/interface/order/cancel",
    "title": "订单取消接口",
    "group": "第三方订单接口",
    "name": "订单取消接口",
    "version": "1.0.0",
    "description": "<p>根据订单NO取消订单</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "$order_no",
            "description": "<p>订单系统编号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"code\":0,\"message\":\"\",\"data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Api/OrdersController.php",
    "groupTitle": "第三方订单接口"
  },
  {
    "type": "post",
    "url": "/api/interface/order/show",
    "title": "订单已回收接口",
    "group": "第三方订单接口",
    "name": "订单已回收接口",
    "version": "1.0.0",
    "description": "<p>根据订单NO通知速电系统该订单已回收</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "$order_no",
            "description": "<p>订单系统编号</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"code\":0,\"message\":\"\",\"data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Api/OrdersController.php",
    "groupTitle": "第三方订单接口"
  },
  {
    "type": "post",
    "url": "/api/interface/order/store",
    "title": "订单新增",
    "group": "第三方订单接口",
    "name": "订单新增",
    "version": "1.0.0",
    "description": "<p>订单新增，如果已经存在则更新订单信息为最新数据</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "order_no",
            "description": "<p>订单系统编号</p>"
          },
          {
            "group": "Parameter",
            "type": "array",
            "optional": false,
            "field": "goods",
            "description": "<p>订单商品</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"code\":0,\"message\":\"\",\"data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Api/OrdersController.php",
    "groupTitle": "第三方订单接口"
  },
  {
    "type": "post",
    "url": "/api/admin/gateway",
    "title": "添加",
    "group": "鉴权管理",
    "name": "添加",
    "version": "1.0.0",
    "description": "<p>接口描述</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "title",
            "description": "<p>名称</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"code\":0,\"message\":\"\",\"data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Admin/GateWayController.php",
    "groupTitle": "鉴权管理"
  },
  {
    "type": "get",
    "url": "/api/admin/gateway",
    "title": "鉴权管理",
    "group": "鉴权管理",
    "name": "鉴权管理列表",
    "version": "1.0.0",
    "description": "<p>接口描述</p>",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "keyword",
            "description": "<p>关键字</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "error",
            "description": "<p>状态码，0：请求成功</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "msg",
            "description": "<p>提示信息</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>返回数据</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "{\"code\":0,\"message\":\"\",\"data\":[]}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Error-Response:",
          "content": "{\"code\":5001,\"message\":\"接口异常\"}",
          "type": "json"
        }
      ]
    },
    "filename": "app/Http/Controllers/Admin/GateWayController.php",
    "groupTitle": "鉴权管理"
  }
] });
