<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGateWayTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gate_way', function (Blueprint $table) {
            $table->increments('app_id');
            $table->string('app_key', 50)->unique()->comment('权限key');
            $table->string('app_secret', 30)->comment('权限秘钥');
            $table->integer('com_id')->comment('单位ID');
            $table->tinyInteger('enabled')->comment('是否开启[0关闭,1开启]');
            $table->string('com_name', 30)->comment('单位名称[冗余]');

            $table->index('com_id');
            $table->index('app_key');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gate_way');
    }
}
