<?php

/**
|--------------------------------------------------------------------------
 * 接口参数校验
|--------------------------------------------------------------------------
| 接口sigin校验服务
 * @author doubin
 * @Date: 2021/8/9
 * @Time: 20:16
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;

class ValidationService extends Service{
    /**|---------------------------------------------------------------------------------
     * @name 验证sign
     * @param $seccode sign参数
     * @param $type type验证签名类型
     * @return \Illuminate\Http\JsonResponse
     * @author dou <2020/8/24 15:31>
     * |---------------------------------------------------------------------------------
     */
    function valitest($seccode,$type){
        if($type==2){
            $sign=$seccode['sign'];
            unset($seccode['sign']);
            $res=$this->getSign($seccode,'apipggoods');
            if($res==$sign){
                $data['code']=1;
                $data['msg']='签名正确';
                return $data;
            }else{
                $data['code']=2;
                $data['msg']='签名错误';
                return $data;
            }
        }else{
            $data['code']=2;
            $data['msg']='签名错误';
            return $data;
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 生成sign
     * @param $params 数据
     * @return \Illuminate\Http\JsonResponse
     * @author dou <2021/04/27 15:31>
     * |---------------------------------------------------------------------------------
     */
    public function creactSign ( $params ){
        $res=$this->getSign($params,'apipggoods');
        return $res;
    }
    /**
     * 将参数拼接为url: key=value&key=value
     * @param   $params
     * @return  string
     */
    function getSign($params,$privateKey ){
        ksort($params);
        $content = '';
        if( !empty($params) ){
            $array = array();
            foreach( $params as $key => $value ){
                $array[] = $key.'='.$value;
            }
            $content = implode("&",$array);
        }

        $content = $content.$privateKey;
        $string= hash("sha256",$content,false);

        return $string;
    }
    /**|---------------------------------------------------------------------------------
     * @name 验证函数
     * @param $check 需要校验参数
     * @param $parameter 传输参数
     * @return \Illuminate\Http\JsonResponse
     * @author Dou <2021/04/25>
     * |---------------------------------------------------------------------------------
     */
    public function checkKey ( $check,$parameter ){
        $flag['code']=1;
        $flag['data']=[];
        $paramet=[];
        foreach( $parameter as $k => $v ){
            $paramet[]=$k;
        }
        foreach( $check as $k => $v ){
            if(!in_array($v,$paramet)){
                $flag['code']=2;
                $flag['data'][]=$v;
            }
        }
        return $flag;
    }
}
