<?php
/**
 * 同步门店信息
 * 同步门店接口惭怍
 * @author DouBin
 * @Date: 2021/08/31
 * @Time: 11:31
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;

class SysMzStoresService extends Service{
    /**|---------------------------------------------------------------------------------
     * @name 读取请求链接
     * @retrun /multitype:array
     * @author dou 2022-11-17 017 上午 10:31:49
     * |---------------------------------------------------------------------------------
    */
    public static function returnUrl ( $type ){
        if($_SERVER["HTTP_HOST"]=='zptz.bluearp.com'){
            $url = 'http://xm.bluearp.com/index.php/api/';
        }else{
            $url = 'http://xmtest.bluearp.com/index.php/api/';
        }
        switch ( $type ){
            case 'orderUrl':
                return $url.'v1/zptzSystemOrders/importOrders';//订单推送
                break;
            case 'recycleOrder':
                return $url.'v1/zptzSystemOrders/recycleOrder';//回收订单
                break;
            case 'opinionOrder':
                return $url.'v1/zptzSystemOrders/opinionOrder';//回收订单
                break;
            case 'editSd':
                return config('radiurl.editSd');//改单
                break;
            case 'sdReminder':
                return config('radiurl.sdReminder');//催单
                break;
            case 'lockUrl':
                return $url.'v1/zptzSystemOrders/orderLock';//回收订单
                break;
            case 'importBillOrders':
                return config('radiurl.importBillOrders');//同步账单
                break;
            case 'opinionAfterOrder':
                return config('radiurl.opinionAfterOrder');//审核售后
                break;
            case 'reject':
                return config('radiurl.reject');//管理员驳回到商家确认
                break;
            case 'importAfterOrders':
                return config('radiurl.importAfterOrders');//同步售后
                break;
            case 'searchShop':
                return $url.'v1/zptzSystemShop/searchShop';//订单推送
                break;
            case 'correlation':
                return $url.'v1/zptzSystemShop/correlation';//订单推送
                break;
            default:
                return false;
                break;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 读取token
     * @param array $time 请求时间
     * @retrun /multitype:array
     * @author dou 2022-11-17 017 上午 10:34:41
     * |---------------------------------------------------------------------------------
    */
    public static function getToken ( $time ){
        if($_SERVER["HTTP_HOST"]=='zptz.bluearp.com'){
            return md5(md5($time . 'DE65D6230ECA6ED9D9912158B043E6F7'));
        }else{
            return md5(md5($time . 'DE65D6230ECA6ED9D9912158B043E6F7'));
        }
    }

   /**|---------------------------------------------------------------------------------
    * @name 同步通知门店
    * @param array $pop 请求参数
    * @param string $type 请求类型
    * @retrun /multitype:array
    * @author dou 2021/8/31 11:32
    * |---------------------------------------------------------------------------------
   */
    public static function sysStore ( $pop , $type ){
        $url = self::returnUrl($type);
        if(!$url){
            return ['ErrorCode' => ErrorInc::FAILED_PARAM, 'ErrorMessage' => '链接类型错误'];
        }else {
            $data = '';
            $time = date("Y-m-d H:i:s");
            $pop['time'] = $time;
            $pop['token'] = self::getToken($time);
            $pop = CommonService::ToUrlencode($pop);
            $pop=urldecode(json_encode($pop));
            $resp = CommonService::requestPost($url, $pop);
            $data .= $pop."--".$url.'--'.$resp;
            CommonService::addLog($type, $data, '','sysMzStore');
            $resps = json_decode($resp, true);
            if (isset($resps['code'])) {
                if ($resps['code'] != 200) {
                    return ['ErrorCode' => ErrorInc::TRANSFER_FAILED, 'ErrorMessage' => $resps['msg'] . ",code:" . $resps['code']];
                }else{
                    return ['ErrorCode' => 1, 'ErrorMessage' => $resps['msg'],'Data'=>$resps['data']];
                }
            } else {
                return ['ErrorCode' => ErrorInc::TRANSFER_FAILED, 'ErrorMessage' => $resp];
            }
            return ['ErrorCode' => 1];
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 请求链接
     * @param string $type 请求类型
     * @retrun /multitype:string
     * @author dou 2021/8/31 11:35
     * |---------------------------------------------------------------------------------
    */
    public static function returnUrls ( $type ){
         switch ( $type ){
             case 'orderUrl':
                 return config('radiurl.orderUrl');//订单推送
                break;
             case 'recycleOrder':
                 return config('radiurl.recycleOrder');//同步拒单回收
                 break;
             case 'opinionOrder':
                 return config('radiurl.opinionOrder');//驳回/审核订单
                 break;
             case 'editSd':
                 return config('radiurl.editSd');//改单
                 break;
             case 'sdReminder':
                 return config('radiurl.sdReminder');//催单
                 break;
             case 'lockUrl':
                 return config('radiurl.lockUrl');//订单锁定/解除锁定
                 break;
             case 'importBillOrders':
                 return config('radiurl.importBillOrders');//同步账单
                 break;
             case 'opinionAfterOrder':
                 return config('radiurl.opinionAfterOrder');//审核售后
                 break;
             case 'reject':
                 return config('radiurl.reject');//管理员驳回到商家确认
                 break;
             case 'importAfterOrders':
                 return config('radiurl.importAfterOrders');//同步售后
                 break;
             default:
                 return false;
                 break;
         }
    }
}
