<?php

/**
 * 文件名称（第三方账目管理）
 * 文件简单描述（处理第三方金额汇款）
 * @author DouBin
 * @Date: 2021/9/15
 * @Time: 13:54
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use App\Models\PtThree;
use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Service\Service;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class PtThreeService extends Service{
    /**|---------------------------------------------------------------------------------
     * @name 获取列表信息
     * @param array $input 请求参数
     * @param array $session 操作人信息
     * @retrun /multitype:array
     * @author dou 2021/9/15 13:55
     * |---------------------------------------------------------------------------------
    */
    public static function getList ( $input , $session ){
        $page_size = $input['page_size']??10;
        $where = [];
        if(!in_array($input['status'], [1,2,3])){
            return ['Data' => [], 'ErrorMessage' => '参数错误status', 'ErrorCode' => ErrorInc::FAILED_PARAM];
        }
        $status = self::getStatusWhere($input['status'] , $session);//获取状态查询条件
        foreach( $status as $k => $v ){
            $where[$k] = $v;
        }
        if($session['admin_groupnew']!=7){
            $where['company_id'] = $session['company_id'];
        }
        if(isset($input['wat_num']) && $input['wat_num']!='' ){
            $where['wat_num_like'] = $input['wat_num'];
        }if(isset($input['apply_for_name']) && $input['apply_for_name']!='' ){
            $where['apply_for_name'] = $input['apply_for_name'];
        }if(isset($input['pt_name']) && $input['pt_name']!='' ){
            $where['pt_id'] = $input['pt_name'];
        }
        $where = CommonService::jointWhere($where);
        $db = new PtThree();
        $data['showcount'] = self::getStatusBar($session);//获取操作权限可展示订单状态栏
        $db = $db->whereRaw($where);
        if(isset($input['orderBy'])){
            foreach($input['orderBy'] as $k => $v){
                $db = $db->orderBy($k,$v);
            }
        }else{
            $db = $db->orderBy('apply_for_time','ASC');
        }
        $paginate = $db->paginate($page_size);
        $all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
        $export = BmmcService::getTopButton('export','',$all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮
        $list = CommonService::dataToArray($paginate->items());
        if($list) {
            $data['list'] = self::jointListData($input, $session, $list, $all_button);//获取列表信息明细说明
        }else{
            $data['list'] = [];
        }
        $data['page'] = [
            'count' => $paginate->total(),
            'page' => $paginate->currentPage(),
            'page_size' => $page_size,
            'allPage' => $paginate->lastPage()
        ];
        return ['Data' => $data, 'ErrorMessage' => '操作成功', 'ErrorCode' => 1];
    }

    /**|---------------------------------------------------------------------------------
     * @name 状态查询条件
     * @param array $session 操作人信息
     * @param string $status 查询状态
     * @retrun /multitype:array
     * @author dou 2021/9/15 14:08
     * |---------------------------------------------------------------------------------
    */
    public static function getStatusWhere ( $status , $session ){
        $where['type'] = $status;
        return $where;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取操作的状态栏信息
     * @param array $session 操作人信息
     * @param int $type 是否展示数量信息1是
     * @retrun /multitype:array
     * @author dou 2021/9/14 13:37
     * |---------------------------------------------------------------------------------
     */
    public static function getStatusBar ( $session , $type = ''){
        $bmmc_pids = BmmcService::searchPids($session['admin_groupnew']);
        if(in_array('104',$bmmc_pids)){
        }else{
            $showcount = [
                ['show_name'=>"待收",'shownum'=>'--','status'=>1],
                ['show_name'=>"待付",'shownum'=>'--','status'=>2],
                ['show_name'=>"已完成",'shownum'=>'--','status'=>3],
            ];
        }
        if( $type == '1'){
            foreach( $showcount as $k => $v ){
                $showcount[$k]['shownum'] = self::getStatusNum($v['status'],$session);
            }
        }
        return $showcount;
    }

    /**|---------------------------------------------------------------------------------
     * 拼接列表数据
     * @param string $session 用户信息
     * @param array $input 请求数据
     * @param array $list 订单数据
     * @param array $all_button 按钮信息
     * @retrun /multitype:array
     * @author dou 2021/9/15 16:19
     * |---------------------------------------------------------------------------------
    */
    public static function jointListData ( $input , $session , $list , $all_button ){
        foreach($list as $k => $v){
            /*----------------------------------------------获取列表按钮开始--------------------------------------------*/
            $buttonData = [];
            $buttonData[] = "addRemarks,lookDetail";
            if ($v['type'] == 1 || $v['type'] == 2){
                $buttonData[] = "confirmPayment,returnSettle";
            }
            if($v['type'] == 3){
                $buttonData[] = "editVoucher";
            }
            $button = BmmcService::getListButton($buttonData,$all_button);
            $list[$k]['button_one'] = $button['button_one']??[];
            $list[$k]['button_two'] = $button['button_two']??[];
            $list[$k]['button_three'] = $button['button_three']??[];
            /*----------------------------------------------获取列表按钮结束--------------------------------------------*/
        }
        return $list;
    }
}
