<?php

/**
 * 协商价管理
 *
 * @author lixiaolin
 * @Date: 2021/4/2
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\Negotiated;
use App\Models\Pt;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;
use DB;

class NegotiateService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new Negotiated();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    public function search($param, $columns = array('*'), $page = 1, $pageSize = 20,$session='')
    {
        $offset = ($page - 1) * $pageSize;
        $negotiated = $this->modelMain;
        $where = [];
        $order_num = $param['order_num'];
        if ($param['type']) {
            $where[] = ['state', '=', $param['type']-1];
        }

        if ($param['order_num']) {
            $where[] = ['order_num', 'like', $param['order_num'] . "%"];
        }
        if ($param['p_id']) {
            $where[] = ['p_id', '=', $param['p_id']];
        }

        if ($param['shr_phone']) {
            $where[] = ['shr_phone', 'like', $param['shr_phone'] . "%"];
        }

        if ($param['shr_name']) {
            $where[] = ['shr_name', 'like', $param['shr_name'] . "%"];
        }

        if ($param['ser_id']) {
            $where[] = ['ser_id', '=', $param['ser_id']];
        }

        if ($param['creatDate']) {
            $param['creatDate'][1] = date("Y-m-d", strtotime($param['creatDate'][1] . " +1 day"));
            $negotiated = $negotiated->whereBetween('created_at', $param['creatDate']);
        }

        if ($session['admin_groupnew'] != 7){//管理员可以看全部
            $negotiated = $negotiated->where('company_id',$session['company_id']);
        }

        $negotiated = $negotiated->where($where);
        //总条数
        $count = $negotiated->count();

        //列表数据
        $totalPage = ceil($count / $pageSize);
        $where1 = [];
        $where1[1] = 1;

        if ($session['admin_groupnew'] != 7) {//管理员可以看全部
            $where1['company_id'] = $session['company_id'];
        }
        $where1 = CommonService::jointWhere($where1);

        $list = $negotiated->offset($offset)
            ->whereRaw($where1)
            ->limit($pageSize)
            ->orderBy('created_at', 'ASC')
            ->get();
        $wcl = Negotiated::where('state', 0)->whereRaw($where1)->count();

        $data['show_Menu'] = [
            ['show_name' => "未处理", 'status' =>1,'show_num' => $wcl ?? 0],
            ['show_name' => "已处理", 'status' =>2,'show_num' => "--"],
            ['show_name' => "已拒绝", 'status' =>3,'show_num' => "--"],
        ];

        $data['list'] = $list;
        $data['page'] = [
            'page' => $page,
            'totalPage' => $totalPage,
            'page_size' => $pageSize,
            'count' => $count
        ];

        return $data;
    }

    public function formatPageContent($token, $priID, $data, $login_id = '')
    {
        $all_button = BmmcService::wherebutton($token, $priID );
        $addPt = BmmcService::getTopButton('sync_state', '', $all_button);
        $data['button_top'] = $addPt['button_top'] ?? [];//顶部按钮
        $data['button_search'] = $addPt['button_search'] ?? [];//搜索栏按钮
        $list = $data['list'];
        $ptArr = Pt::pluck('pt_name', 'id')->toArray();
            if (!$list->isEmpty()) {
            $list = $list->toArray();
            $orderstatus = OrderService::getOrderStatusName();
            $statName = self::getStateName();
            foreach ($list as $k => $v) {
                $list[$k]['order_status_name'] = $orderstatus[$v['order_status']]??'未设定';

                if (empty($v['supply_price'])) {
                    $list[$k]['supply_price'] = 0;
                }
                if (!$v['company_name']) {
                    $list[$k]['company_name'] = "暂无";
                }
                $list[$k]['state_name'] = $statName[$v['state']]??'未设定';
                if (isset($ptArr[$v['p_id']])) {
                    $list[$k]['pt_name'] = $ptArr[$v['p_id']];
                }
                /*------------------------------------------按钮处理开始---------------------------------------------*/
                $buttonData = [];
                $buttonData[] = 'remark';
                if ($v['state'] == 0) {
                    $buttonData[] = 'negotiated_deal,negotiated_delete';
                }
                $button = BmmcService::getListButton($buttonData,$all_button);
                $list[$k]['button_one'] = $button['button_one'] ?? [];
                $list[$k]['button_two'] = $button['button_two'] ?? [];
                $list[$k]['button_three'] = $button['button_three'] ?? [];
                /*------------------------------------------按钮处理结束---------------------------------------------*/
            }

            $data['list'] = $list;
        }else{
            $data['list'] = [];
        }


        return $data;
    }


    public static function createOne()
    {

    }

    public static function getOne($id)
    {
        return Negotiated::find($id);
    }

    public static function setApprove($id, $approved = 2)
    {
//        $data = Negotiated::find($id);
//        if (!$data) {
//            return false;
//        }
        return Negotiated::where('id', $id)->update(['state'=>$approved]);
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取状态名称
     * @retrun /multitype:array
     * @author dou 2021/10/21 17:05
     * |---------------------------------------------------------------------------------
    */
    public static function getStateName()
    {
        $data = array("0"=>'未处理','1'=>'已处理','2'=>'已拒绝');
        return $data;
    }
}
