<?php

/**
 * 奖惩金额管理
 *
 * @author lixiaolin
 * @Date: 2021/7/23
 * @Time: 18:56
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Inc\CacheInc;
use App\Models\SetmoneyType;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class MoneyTypesService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new SetmoneyType();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function search($param, $columns = array('*'), $page = 1, $pageSize = 20)
    {
        $Db = SetmoneyType::where('sety_type', '1');
        if ($param["type_name"]) {
            $Db = $Db->where('sety_name', 'like', '%' . $param['type_name'] . '%');
        }

        $count = $Db->count();

        $totalPage = ceil($count / $pageSize);
        if ($pageSize > 0) {
            $offset = ($page - 1) * $pageSize;

            $list = $Db->select('sety_id', 'sety_name', 'sety_price')
                ->offset($offset)
                ->limit($pageSize)
                ->orderBy('sety_id', 'desc')
                ->get();
        } else {
            $list = $Db->select('sety_id', 'sety_name', 'sety_price')
                ->orderBy('sety_id', 'desc')
                ->get();
        }
        $result = [];
        $result['page'] = ['totalPage' => $totalPage, 'count' => $count, 'page' => $page, 'page_size' => $pageSize];
        $result['list'] = $list;
        return $result;
    }

    public function formatPageContent($token, $priID, $data)
    {
        $list = $data['list'];

        $all_button = BmmcService::wherebutton($token, $priID);
        $addPt = BmmcService::getTopButton('addSetymoneyType', '', $all_button);
        $data['button_top'] = $addPt['button_top'] ?? [];//顶部按钮
        $data['button_search'] = $addPt['button_search'] ?? [];//搜索栏按钮
        if (!$list->isEmpty()) {
            $list = $list->toArray();
            foreach ($list as $key => $val) {
                $button = BmmcService::getListButton(['editSetymoneyType'], $all_button);//提前结束
                $list[$key]['button_one'] = $button['button_one'] ?? [];
                $list[$key]['button_two'] = $button['button_two'] ?? [];
                $list[$key]['button_three'] = $button['button_three'] ?? [];
            }

            $data['list'] = $list;
        }

        return $data;
    }


    /**
     * 获取pj品牌数据
     *
     * @param array $typeIDs
     *
     * @return mixed $data
     */
    public static function getAll(array $typeIDs = [])
    {
        $data = [];
        $cacheExist = Cache::has('money_types');
        if ($cacheExist) { //防止缓存穿透
            $itemList = Cache::get('money_types');
            foreach ($itemList as $key => $val) {
                if ($typeIDs && in_array($val['id'], $typeIDs)) {
                    $data[$val['id']] = $val;
                }
            }
        } else {
            $itemList = [];
            $itemData = (new SetmoneyType())
                ->select('sety_id', 'sety_name', 'sety_price')
                ->get()
                ->toArray();
            foreach ($itemData as $key => $val) {
                if ($typeIDs && in_array($val['id'], $typeIDs)) {
                    $data[$val['id']] = $val;
                }
                $itemList[$val['id']] = $val;
            }
            Cache::set('money_types', $itemList, CacheInc::CACHE_TIME + rand(0, 10)); //防止缓存雪崩
        }

        return !empty($typeIDs) ? $data : $itemList;
    }

    /**
     * 获取某个brand
     *
     * @param int $ID
     *
     * @return mixed
     */
    public static function getByID(int $ID)
    {
        $cacheExist = Cache::has('money_types');
        $data = [];
        if ($cacheExist) { //防止缓存穿透
            $itemList = Cache::get('money_types');
            foreach ($itemList as $key => $val) {
                if ($val['id'] = $ID) {
                    return $val;
                }
            }
        } else {
            $itemList = [];
            $itemData = (new SetmoneyType())
                ->select('sety_id', 'sety_name', 'sety_price')
                ->get()
                ->toArray();
            foreach ($itemData as $key => $val) {
                if ($val['id'] = $ID) {
                    $data = $val;
                }
                $itemList[$val['id']] = $val;
            }
            Cache::set('money_types', $itemList, CacheInc::CACHE_TIME + rand(0, 10)); //防止缓存雪崩
        }

        return $data;
    }

    public static function checkExist(array $condition) {
        $condition[] = ['sety_type', '=', 1];

        return SetmoneyType::where($condition)->exists();
    }

}
