<?php

/**
 * 标签管理
 * 标签管理基础操作
 * @author DouBin
 * @Date: 2021/07/28
 * @Time: 下午16:07
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\SetmoneyType;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;

class LabtypeService extends Service
{
    public  static $instance;
    public  $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new SetmoneyType();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }
	/**|--------------------------------------------------------------------
     * @name 获取部门标签
     * @param string $admin_group 用户信息
     * @return \Illuminate\Http\JsonResponse
     * |--------------------------------------------------------------------
     */
    public static function getBmmcLab ( $admin_group )
    {
	    $sety_id = SetmoneyType::where('sety_type','3')->whereRaw("FIND_IN_SET(".$admin_group.",lt_group)")->pluck('sety_id');
	    $sety_id = json_decode(json_encode($sety_id),true);
    	$list = LabtypeService::labelList();
        $where[] = array('sety_type'=>3);
        $list = CommonService::arrayFilterFieldValue($list,$where);
    	$all = array_column($list, 'sety_id');
    	$list = LabtypeService::labelTree();
        $list = CommonService::arrayFilterFieldValue($list,$where);
       	$data['list'] = $list;
       	$data['all'] = $all;
       	$data['part'] = $sety_id;
    	return $data;
    }
    /**|--------------------------------------------------------------------
     * @name 获取标签列表
     * @return \Illuminate\Http\JsonResponse
     * |--------------------------------------------------------------------
     */
     public static function labelList ( ){
	    $data = RedisService::redisGet('labelList');
	    if(!$data){
		    $data = LabtypeService::getMysqlLable('labelList');
	    }
	    return $data;

     }
     /**|--------------------------------------------------------------------
     * @name 获取标签列表
     * @return \Illuminate\Http\JsonResponse
     * |--------------------------------------------------------------------
     */
     public static function labelTree ( ){
	    $data = RedisService::redisGet('labelTree');
	    if(!$data){
		    $data = LabtypeService::getMysqlLable('labelTree');
	    }
	    return $data;

     }
     /**|--------------------------------------------------------------------
     * @name 获取标签列表
     * @return \Illuminate\Http\JsonResponse
     * |--------------------------------------------------------------------
     */
     public static function labelListTree ( ){
	    $data = RedisService::redisGet('labelListTree');
	    if(!$data){
		    $data = LabtypeService::getMysqlLable('labelListTree');
	    }
	    return $data;

     }
     /**|--------------------------------------------------------------------
     * @name 从数据库获取标签
     * @param string $key 获取数据类型
     * @return \Illuminate\Http\JsonResponse
     * |--------------------------------------------------------------------
     */
     public static function getMysqlLable ( $key )
     {
	    $data = [];
     	$list = SetmoneyType::select('cd_id','sety_id','sety_name','sety_creacter','sety_time','sety_price','lt_type','lt_group','lt_ids','lt_statues','lt_parent_id','sety_type','lt_score')->where('lt_statues',1)->get()->toArray();
     	$data['labelListTree'] = LabtypeService::getsTree($list,0,2);
     	$data['labelTree'] = LabtypeService::getsTree($list);
     	$data['labelList'] = $list;
     	RedisService::redisSet('labelList' , $list);
     	RedisService::redisSet('labelListTree' , LabtypeService::getsTree($list,0,2));
     	RedisService::redisSet('labelTree' , LabtypeService::getsTree($list));
     	return $data[$key];
     }
    /**|--------------------------------------------------------------------
     * @name 获取指定父类下标签
     * @param int $key 查询键
     * @param int $value 查询值
     * @param int $group 操作人权限
     * @return \Illuminate\Http\JsonResponse
     * |--------------------------------------------------------------------
     */
     public static function getLable ( $key , $value , $group = '', $lt_statues = ''){
	    $list = LabtypeService::labelList();
	    $where[] = array($key=>$value);
	    if($lt_statues){
            $where[] = array('lt_statues'=>$lt_statues);
        }
	    $list = CommonService::arrayFilterFieldValue($list,$where);
	    $data = [];
	    if($group){
	        foreach($list as $k => $v){
	            $lt_group = explode(',',$v['lt_group']);
	            if(in_array($group,$lt_group)) {
                    $data[] = $v;
                }
	        }
        }else{
            foreach($list as $k => $v){
                $data[] = $v;
            }
        }
     	return $data;
     }
    /**
     * 权限递归
     * @param array $lable  权限数据
     * @param array $parent_id  指定顶级
     * @param array $pitchon  选中标签
     * @param int $type  获取类型 1 搜索展示  2列表展示
     * @param array $show  不选中是否展示  true 展示  false 不展示
     * @param array $showall  可展示全部的上级标签 $show=false 时额为展示使用
     * @param string $parent_names  父类名称集合
     * @return array|mixed
     */
    public static function getsTree( $lable , $parent_id = 0 , $type = 1 ,$pitchon = [] , $show = true , $showall = [] , $parent_names = '' ){
        $tree = [];
        foreach ($lable as $k=>$v){
            if ($v['lt_parent_id'] == $parent_id){
                if($pitchon) {
                    if (in_array($v['sety_id'], $pitchon)) {
                        $v['pitchon'] = true;
                    }else{
                        $v['pitchon'] = false;
                    }
                }else{
                    $v['pitchon'] = false;
                }
                if($type == 2) {
                    $v['parent_names'] = $parent_names;
                    if($parent_names != '') {
                        $parent = $parent_names . '>' . $v['sety_name'];
                    }else{
                        $parent = $v['sety_name'];
                    }
                }else{
                    $parent = $parent_names;
                }
                if($show || (!$show && (in_array($v['sety_id'], $showall) || $v['pitchon']))) {
                    $v['children'] = LabtypeService::getsTree($lable, $v['sety_id'],$type,$pitchon,$show,$showall,$parent);
                }else{
                    $v['children'] = null;
                }
                if ($v['children'] == null){
                    if(isset($poss['children'])) {
                        unset($poss['children']);
                    }
                }else{
                	$poss['children'] = $v['children'];


                }
                $v['level'] = count(explode(',', $v['lt_ids']));
                if($type == 1) {
                    $poss['sety_id'] = $v['sety_id'];
                    $poss['sety_name'] = $v['sety_name'];
                    $poss['lt_parent_id'] = $v['lt_parent_id'];
                    $poss['lt_group'] = $v['lt_group'];
                    $poss['lt_type'] = $v['lt_type'];
                    $poss['pitchon'] = $v['pitchon'];
                    $poss['sety_type'] = $v['sety_type'];
                    $poss['level'] = $v['level'];
                }elseif($type == 3){
                    $poss['sety_id'] = $v['sety_id'];
                    $poss['sety_name'] = $v['sety_name'];
                    $poss['lt_parent_id'] = $v['lt_parent_id'];
                }else{
                    $poss = $v;
                }
                $tree[] = $poss;
            }
        }
        return $tree;
    }
    /**
     * 递归添加标签操作按钮
     * @param array $data  标签数据
     * @param array $button  按钮
     * @return array|mixed
     */
    public static function addButton ( $data , $button , $cdInfo){
	    $tree = [];
     	foreach( $data as $k => $v ){

     		$v['button_one'] = $button['button_one']??[];
            $v['button_two'] = $button['button_two']??[];
            $v['button_three'] = $button['button_three']??[];
             //品类名
            if($v['cd_id']){
            	$v['cd_name'] = $cdInfo[$v['cd_id']]['cd_pname']??'';
            }

            if ($v['lt_statues'] == 1){
                $v['lt_statues_name'] = "显示";
            }else{
                $v['lt_statues_name'] = "不显示";
            }
            if ($v['lt_type'] == 1){
                $v['lt_type_name'] = "需要处理";
            }else{
                $v['lt_type_name'] = "不需要处理";
            }
            if(isset($v['children'])){
	            $v['children'] = LabtypeService::addButton($v['children'],$button,$cdInfo);
            }
            $tree[] = $v;
     	}
     	return $tree;
    }
}
