<?php
/**
 * 类别服务
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use BlueCity\Core\Service\Service;
use App\Models\GoodsSeries;
use App\Models\InstallPerson;

class InstallPersonService extends Service{


	public static function getall($serId,$ids=[],$key='')
	{

		$data = [];
		if(!is_array($ids)){
			return $data;
		}
		$list = RedisService::redisGet('ipList'.$serId);
		if ($list) {
			$data = CommonService::filterIds($ids,$list,'id');
		} else {
			$brandData = InstallPerson::where('delet_y',1)->where('admin_id',$serId)->select('id','check_code','install_name')->get()->toarray();
			$data = CommonService::filterIds($ids,$brandData,'id');
			RedisService::redisSet('ipList'.$serId, $brandData);
		}
		if($key){
			$data = CommonService::jointArrayKey($data,$key);
		}
		return $data;

	}

	/**
	 * 获取一条技师信息
	 * @param int $id
	 * @return array
	 * @author du 2021年7月30日下午5:35:45
	 */
	public static function getInstallPersonById($id , $select = []){
	    $db = new InstallPerson();
	    if(!$select){
            $select = ['check_code','install_name','install_phone','bind','token','phone_type'];
        }
        $data = CommonService::getMysqlData($db, ['id'=>$id],$select,[],'first');
        return $data;

	}


}
