<?php

/**
|--------------------------------------------------------------------------
 * 权限服务类
|--------------------------------------------------------------------------
| 权限管理 所需的主要业务逻辑
 * @author doubin
 * @Date: 2021/8/12
 * @Time: 17:57
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;
use App\Models\Functions;

class FunctionsService extends Service{
    /**|---------------------------------------------------------------------------------
     * @name 获取权限名称
     * @param string $key 查询键
     * @param string $value 查询值
     * @param array $select 待查询参数
     * @retrun multitype:array
     * @author dou 2021/8/12 17:55
     * |---------------------------------------------------------------------------------
    */
    public static function getFunctionsBy ( $key , $value , $select){
        $db = new Functions();
        if($key == 'function_id'){
            $type = 'first';
        }else{
            $type = 'get';
        }
        if(!$select){
            $select = ['function_id','function_parent_id','function_parent_name','function_name','function_model','function_action'];
        }
        if(count($select) == 1){
            $type = 'value';
        }
        $list = CommonService::getMysqlData($db, [$key=>$value],$select,[],$type);
        return $list;
    }
}
