<?php

/**
|--------------------------------------------------------------------------
 * 对外接口交互服务
|--------------------------------------------------------------------------
| 对外接口信息推送逻辑
 * @author doubin
 * @Date: 2021/08/30
 * @Time: 10:00
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Factory\OrderFactory;
use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;
use DB;

class ForeignApiService extends Service{
    /**|---------------------------------------------------------------------------------
     * @name 派单同步第三方平台
     * @param array $orderinfo 订单信息
     * @param string $orderinfo -> order_num 订单单号
     * @param string $orderinfo -> p_id 平台id
     * @param int $type 操作类型 1.派单，20.接单，21.拒单，30反馈完成，50.撤销
     * @retrun /multitype:array
     * @author dou 2021/8/17 13:37
     * |---------------------------------------------------------------------------------
     */
    public static function sysPtThree ( $orderinfo , $type ){
        switch ( $orderinfo['p_id'] ){
            case 67:
                return ForeignApiService::sysYcbData($orderinfo, $type);
                break;
            case 70:
                return ForeignApiService::sysQccrData($orderinfo, $type);
                break;
            case 86:
                return ForeignApiService::sysLcbData($orderinfo, $type);
                break;
            case 102:
                return ForeignApiService::sysCtcyData($orderinfo, $type);
                break;
            default:
                return ['Data' => '', 'ErrorMessage' => '操作成功', 'ErrorCode' => 1];
                break;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 养车宝接口同步
     * @retrun /multitype:array
     * @author dou 2021/8/30 11:51
     * |---------------------------------------------------------------------------------
    */
    public static function sysYcbData ( $orderinfo , $type ){
        if(in_array($type, [1,30,50])) {
            $date = date("Y-m-d H:i:s");
            $sign = md5("sudian" . $orderinfo['order_num']);
            // $url='http://218.247.224.50/yangchebao-app-ws/ws/0.1/battery/deal/notify';//测试环境
            $url = 'http://app.yangchebao.com.cn/yangchebao-app-ws/ws/0.1/battery/deal/notify';//生产环境
            $ParArray = array("orderNumber" => $orderinfo['order_num'], "orderStatus" => ForeignApiService::returmYcbState($type), "serviceTime" => $date, "remarks" => "", "sign" => $sign);
            $ParArray = json_encode($ParArray);
            $header = array(
                'Content-Type: application/json',
            );
            $resp = CommonService::requestPost($url, $ParArray, $header);
            $obj = json_decode($resp, true);
            if ($obj['result'] == 'success') {
                return ['Data' => '', 'ErrorMessage' => '操作成功', 'ErrorCode' => 1];
            } else {
                return ['Data' => '', 'ErrorMessage' => '通知养车宝失败，请刷新核实！', 'ErrorCode' => ErrorInc::TRANSFER_FAILED];
            }
        }else{
            return ['Data' => '', 'ErrorMessage' => '状态操作无需同步', 'ErrorCode' => 1];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 养车宝数据状态
     * @param int $type 操作类型 1.派单，15.订单延期/预约，20.接单，21.拒单，30反馈完成，50.撤销
     * @retrun /multitype:array
     * @author dou 2021/8/30 10:21
     * |---------------------------------------------------------------------------------
    */
    public static function returmYcbState ( $type ){
        $state = ['1'=>'2','20'=>'','21'=>'','30'=>'3','50'=>'4'];
        $data['state'] = $state[$type];
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 汽车超人接口同步
     * @retrun /multitype:array
     * @author dou 2021/8/30 11:56
     * |---------------------------------------------------------------------------------
    */
    public static function sysQccrData ( $orderinfo , $type ){
        if(in_array($type, [1,30])) {
            // $url='http://testcs.qichechaoren.com/sdkb/fforder.jhtml';//测试环境
            $url = 'http://www.qccr.com/sdkb/fforder.jhtml';//生产环境
            $ParArray = array("sign" => "955e3c9f7c9d250e97dd55b329a1e223", "no" => $orderinfo['order_num'], "status" => ForeignApiService::returmQccrState($type));
            $ParArray = json_encode($ParArray);
            $Post_Data['param'] = $ParArray;
            $resp = CommonService::requestPost($url, $Post_Data);
            return ['Data' => '', 'ErrorMessage' => '操作成功', 'ErrorCode' => 1];
        }else{
            return ['Data' => '', 'ErrorMessage' => '状态操作无需同步', 'ErrorCode' => 1];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 汽车超人
     * @param int $type 操作类型 1.派单，15.订单延期/预约，20.接单，21.拒单，30反馈完成，50.撤销
     * @retrun /multitype:array
     * @author dou 2021/8/30 10:21
     * |---------------------------------------------------------------------------------
     */
    public static function returmQccrState ( $type ){
        $state = ['1'=>'1','20'=>'','21'=>'','30'=>'2','50'=>''];
        $data['state'] = $state[$type];
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 乐车邦
     * @retrun /multitype:array
     * @author dou 2021/8/30 13:56
     * |---------------------------------------------------------------------------------
    */
    public static function sysLcbData ( $orderinfo , $type ){
        if(in_array($type, [1,30,50])) {
            //$url='https://m3.lechebang.cn/gateway/open_api';//测试环境
            $url = 'https://m.lechebang.com/gateway/open_api';//生产环境
            $time = time();
            $sign = "apiName=lcb.renewalBatteryOrder.status.change&appCode=9001&orderNum=" . $orderinfo['order_num'] . "&processStatus=" . ForeignApiService::returmLcbState($type) . "&timestamp=" . $time . "Hc3hznL9DKbxzTtW7nrpVlam3CCAnpN0";
            $sign = md5($sign);
            $sign = strtoupper($sign);
            $ParArray = array("appCode" => "9001", "timestamp" => $time, "signMethod" => "md5", "apiName" => "lcb.renewalBatteryOrder.status.change", "sign" => $sign, "processStatus" => ForeignApiService::returmLcbState($type), "orderNum" => $orderinfo['order_num']);
            $ParArray = json_encode($ParArray);
            $resp = CommonService::requestPost($url, $ParArray);
            $obj = json_decode($resp, true);
            $possl['le_data'] = $ParArray . "-" . $resp;
            $possl['le_num'] = $orderinfo['order_num'];
            DB::table('lcb_erro')->insert($possl);
            if ($obj['statusCode'] == '200' || $obj['statusCode'] == '14022') {
                return ['Data' => '', 'ErrorMessage' => '操作成功', 'ErrorCode' => 1];
            } else {
                return ['Data' => '', 'ErrorMessage' => '通知乐车邦失败,请刷新核实！', 'ErrorCode' => ErrorInc::TRANSFER_FAILED];
            }
        }else{
            return ['Data' => '', 'ErrorMessage' => '状态操作无需同步', 'ErrorCode' => 1];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 乐车邦
     * @param int $type 操作类型 1.派单，15.订单延期/预约，20.接单，21.拒单，30反馈完成，50.撤销
     * @retrun /multitype:array
     * @author dou 2021/8/30 10:21
     * |---------------------------------------------------------------------------------
     */
    public static function returmLcbState ( $type ){
        $state = ['1'=>'3','20'=>'','21'=>'','30'=>'4','50'=>'5'];
        $data = $state[$type];
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 畅通车友
     * @retrun /multitype:array
     * @author dou 2021/8/30 11:56
     * |---------------------------------------------------------------------------------
     */
    public static function sysCtcyData ( $orderinfo , $type ){
        if(in_array($type, [1,30,50])) {
            //$url='http://dev.liyingtong.com/battery/statusCallBack';//测试环境
            //$url='http://mo2o.sudianwang.com/index.php/Ceshi/post';//测试环境
            $url = 'http://biz.liyingtong.com/battery/statusCallBack';//生产环境
            $ParArray = array("orderId" => $orderinfo['order_num'], "status" => ForeignApiService::returmCtcyState($type));
            $ParArrays = json_encode($ParArray);
            $resp = CommonService::requestForm($url, $ParArray);
            $obj = json_decode($resp, true);
            $possl['le_data'] = $ParArrays . "-" . $resp;
            $possl['le_num'] = $orderinfo['order_num'];
            DB::table('lcb_erro')->insert($possl);
            if ($obj['responseCode'] == '2000' || $obj['responseCode'] == '4000') {
                return ['Data' => '', 'ErrorMessage' => '操作成功', 'ErrorCode' => 1];
            } else {
                return ['Data' => '', 'ErrorMessage' => '通知畅通车友失败！请刷新核实！', 'ErrorCode' => ErrorInc::TRANSFER_FAILED];
            }
        }else{
            return ['Data' => '', 'ErrorMessage' => '状态操作无需同步', 'ErrorCode' => 1];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 畅通车友
     * @param int $type 操作类型 1.派单，15.订单延期/预约，20.接单，21.拒单，30反馈完成，50.撤销
     * @retrun /multitype:array
     * @author dou 2021/8/30 10:21
     * |---------------------------------------------------------------------------------
     */
    public static function returmCtcyState ( $type ){
        $state = ['1'=>'14','20'=>'','21'=>'','30'=>'4','50'=>'15'];
        $data['state'] = $state[$type];
        return $data;
    }
}
