<?php
/**
 * 文件名称（F6订单服务）
 * 文件简单描述（F6门店服务订单数据服务）
 * @author DouBin
 * @Date: 2022/2/11
 * @Time: 11:22
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use BlueCity\Core\Service\Service;
use DB;
use phpDocumentor\Reflection\PseudoTypes\True_;

class F6StoreOrderService extends Service
{
    /**|---------------------------------------------------------------------------------
     * @name 获取列表顶部状态
     * @param string $group 操作人权限
     * @param string $admin_pt_id 可操作平台信息
     * @param string $type 是否查询数据量1是
     * @retrun /multitype:array
     * @author dou 2022/2/11 11:25
     * |---------------------------------------------------------------------------------
    */
    public static function getResultStatusBar ( $type = '2' ){
//        $group = $session['admin_groupnew'];
//        $bmmc_pids=BmmcService::searchPids($group);
//        if(in_array('104',$bmmc_pids)){
//        }
        $showcount = [
            ['showname' => "全部", 'shownum' => '--','status'=>0],
            ['showname' => "新导入", 'shownum' => '--','status'=>1],
            ['showname' => "已同步", 'shownum' => '--','status'=>2],
            ['showname' => "异常单", 'shownum' => '--','status'=>3],
            ['showname' => "未匹配订单", 'shownum' => '--','status'=>5],
            ['showname' => "派单失败", 'shownum' => '--','status'=>6],
            ['showname' => "无对应门店", 'shownum' => '--','status'=>7],
            ['showname' => "已解决", 'shownum' => '--','status'=>4]
        ];
        if( $type == '1'){
            foreach( $showcount as $k => $v ){
                $showcount[$k]['shownum'] = self::getResultStatusNum($v['status']);
            }
        }
        return $showcount;
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取指定状态订单数量
     * @param string $status 状态栏参数
     * @retrun /multitype:array
     * @author dou 2022/2/11 11:32
     * |---------------------------------------------------------------------------------
    */
    public static function getResultStatusNum ( $status){
        if(in_array($status,[1,3,5,6,7])){
            $db = Db::table('f6store_order');
            $num = CommonService::getMysqlData($db,['result_state'=>$status],[],[],'count');
            $num = $num??'0';
            return $num;
        }else{
            return '--';
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取F6订单状态
     * @param string $type 获取类型
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2022/3/4 14:17
     * |---------------------------------------------------------------------------------
     */
    public static function getResultStateName ( $type = true){
        $data = [['type'=>1,'name'=>'新导入'],['type'=>2,'name'=>'已同步'],['type'=>3,'name'=>'异常单'],['type'=>4,'name'=>'已解决'],['type'=>5,'name'=>'未匹配到订单'],['type'=>6,'name'=>'派单失败'],['type'=>7,'name'=>'无对应门店']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }
}
