<?php
/**
 * 权限服务
 * 权限基础操作权限
 * @author DouBin
 * @Date: 2021/07/14
 * @Time: 下午13:50
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;
use App\Models\AdminToken;
use App\Models\Bmmc;
use Illuminate\Support\Facades\Redis;
use phpDocumentor\Reflection\Types\Integer;

class BmmcService extends Service{
   /**
     * 权限递归
     * @param array $arr  权限数据
     * @param array $parent_id  给定上级部门id
     * @return array|mixed
     */
    public static function getsTree($arr,$parent_id){
        $tree = [];
        foreach ($arr as $k=>$v){
            if ($v['function_parent_id'] == $parent_id){
                $v['function_children'] = BmmcService::getsTree($arr,$v['function_id']);
                if ($v['function_children'] == null){
                    unset($v['function_children']);
                }
                $tree[] = $v;
            }
        }
        return $tree;
    }

     /**
     * 部门递归
     * @param array $arr  权限数据
     * @param array $parent_id  给定上级部门id
     * @return array|mixed
     */
    public static function getTree($arr,$parent_id){
        $tree = [];
        foreach ($arr as $k=>$v){
            if ($v['bmmc_pid'] == $parent_id){
                $v['children'] = BmmcService::getTree($arr,$v['id']);
                $tree[] = $v;
            }
        }
        return $tree;
    }
     /**
     * 获取模块按钮信息
     * @param string $token  权限token
     * @param string $pri_id  模块id
     * @return array|mixed
     */
     public static function whereButton ($token,$pri_id,$Login_id = '')
    {
	    if($Login_id){
            $Login_id = 'Login'.$Login_id;
		    $tokeninfo = RedisService::redisGet($Login_id);
		    if($tokeninfo){
			    $at_perm = $tokeninfo['at_perm'];
		    }else{
			    $at_perm = BmmcService::buttonMysql($token);
		    }
        }else{
	        $at_perm = BmmcService::buttonMysql($token);
        }
        if (isset($at_perm[$pri_id])){
            $buttom = $at_perm[$pri_id];
            if ($buttom){
                return $buttom;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }
    /**
     * 数据库获取按钮群
     * @param string $token  权限token
     * @return array|mixed
     */
     public static function buttonMysql ( $token )
     {
     	$at_perm = AdminToken::where('at_token',$token)->first();
        $arr = json_decode($at_perm['at_perm'],true);
		$at_perm['at_perm'] = json_decode($at_perm['at_perm']);
    	//$at_perm['at_button'] = json_decode($at_perm['at_button']);
    	$at_perm['at_permissions'] = json_decode($at_perm['at_permissions']);
    	if($at_perm) {
            $Login_id = 'Login' . $at_perm['at_adminid'];
            $tokeninfo = RedisService::redisSet($Login_id, $at_perm);
        }
    	return $arr;
    }
    /**
     * 获取顶部按钮
     * @param string $topdata  顶部非搜索栏内容
     * @param string $searchdata  顶部搜索栏内容
     * @param array $all_button  可操作按钮
     * @return array|mixed
     */
     public static function getTopButton ( $topdata , $searchdata , $all_button)
     {
	    $data=[];
     	$data['button_top'] = BmmcService::getButton($topdata,$all_button,1);
     	$data['button_search'] = BmmcService::getButton($searchdata,$all_button,4);
     	return $data;
     }
     /**
     * 获取列表按钮
     * @param array $listdata  列表页需展示按钮
     * @param array $all_button  可操作按钮
     * @return array|mixed
     */
     public static function getListButton ( $listdata , $all_button)
     {
	    $button = BmmcService::getButton(implode(',',$listdata),$all_button,2);
        if ($button){
         	foreach ($button as $ki => $vi) {
                $sort[] = $vi['sort_order'];
            }
            array_multisort($sort, SORT_NUMERIC, SORT_DESC, $button);
            $data['button_one'][] = $button[0];
            if (count($button)==1){
                $data['button_two'] = [];
                $data['button_three'] = [];
            }elseif ((count($button)<=3) && (count($button)>1)){
                $data['button_two']=array_slice($button,1,2);
                $data['button_three'] = [];
            }else{
                $data['button_two'] = array_slice($button,1,2);
                $data['button_three'] = array_slice($button,3);
            }
            unset($button);

        }else{
            $data['button_one'] = [];
            $data['button_two'] = [];
            $data['button_three'] = [];
        }
        return $data;
     }
	/**
     * 获取对应位置按钮
     * @param array $my_button  需展示按钮
     * @param array $all_button  可操作按钮
     * @param string $type  按钮位置 type=1横排  type=2记录后
     * @return array|mixed
     */
    public static function getButton ( $my_button , $all_button , $type )
    {
        if ($my_button && $all_button){
            $my_button = explode(',',$my_button);
            $num=0;
            foreach ($all_button as $key=>$value){
                if(in_array($value['function_action'],$my_button) && ($value['function_position'] == $type)){
                    $button[]=$value;
                }
                $num++;
            }
            if (isset($button)){
                return $button;
            }else{
                return [];
            }
        }else{
	        return [];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取部门列表
     * @param array $admin_group 操作人权限
     * @param string $priId 操作模块id
     * @param string $type 返回数据类型 tree 树  list 列表
     * @return \Illuminate\Http\JsonResponse
     * @author dou
     * |---------------------------------------------------------------------------------
     */
    public static function getBmmc ( $session , $priId , $type = 'tree'){
        $admin_group = $session['admin_groupnew'];
        if($admin_group!='7'){
			if(in_array($priId,['78','139'])){
	        	$list = Bmmc::whereRaw("FIND_IN_SET ('".$admin_group."',bmmc_pids) ")->where('company_id',$session['company_id'])->orWhere('id',$admin_group)->select('id','bmmc_name','bmmc_pids','bmmc_level','bmmc_pid')->orderBy('id','ASC')->get();
	        	$parent_id = Bmmc::where('id',$admin_group)->value('bmmc_pid');
			}else{
	        	$list = Bmmc::whereRaw("FIND_IN_SET ('".$admin_group."',bmmc_pids) ")->where('company_id',$session['company_id'])->select('id','bmmc_name','bmmc_pids','bmmc_level','bmmc_pid')->orderBy('id','ASC')->get();
            	$parent_id = $admin_group;
			}
    	}else{
	    	$list = Bmmc::select('id','bmmc_name','bmmc_pids','bmmc_level','bmmc_pid')->orderBy('id','ASC')->get();
	    	$parent_id = 0;
    	}
        if (!$list->isEmpty()){
	        $list = $list->toArray();
	        if($type == 'tree'){
	            foreach ($list as $k=>$v){
	                $list[$k]['children'] = [];
	            }
	            $lists = BmmcService::getTree($list,$parent_id);
            }else{
	            $lists = $list;
            }

        }else{
	        return array('code'=>ErrorInc::DATA_EMPTY,'data'=>[],'暂无数据');
        }
        if ($lists){
	        return array('code'=>1,'data'=>$lists,'msg'=>'成功');
        }
    }
	/**|------------------------------------------------------------------
     * @name 获取上级权限id
     * @param $id 用户权限
     * @return \Illuminate\Http\JsonResponse
     * @author dou 2021年8月3日
     * |-------------------------------------------------------------------
     */
     public static function searchPids ( $id ){
     	$bmmc_pids= Bmmc::where('id',$id)->value('bmmc_pids');
     	$bmmc_pids=$bmmc_pids.','.$id;
     	$bmmc_pids=explode(',',$bmmc_pids);
     	return $bmmc_pids;
     }
}
