<?php


namespace App\Services;

use App\Inc\CacheInc;
use App\Models\Aftersale;
use App\Models\Czrz as ActionLog;
use App\Models\Note;
use App\Models\OrderAfter;
use BlueCity\Core\Service\ElasticSearchService;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class ActionLogService
{
    public static function getActionLogsIndex()
    {
        return 'actionlog';
    }

    public static function getIndex()
    {
        return 'actionlog';
    }

    public static function getLogsByEs($controller, $objectID, $action = '', $keywords = '')
    {
        $index = static::getLogsIndex();
        $where = $should = [];
        if (!empty($controller)) {
            $where[] = ['term' => ["controller" => $controller]];
        }

        if (!empty($action)) {
            $where[] = ['term' => ["action" => $action]];
        }
        if (!empty($objectID) && $objectID > 0) {
            $where[] = ['term' => ["object_id" => $objectID]];
        }
        if (!empty($keywords)) {
//            $should[] = ['match'=>["content"=> $keywords]];
//            $where[] = ['match'=>["content"=> ['query'=>$keywords, 'fuzziness'=>'auto', 'operator'=>'and']]];
//            $match = ['wildcard'=>["content"=> $keywords]];
//            $match = ['match'=>["content"=> ['query'=>$keywords, 'fuzziness'=>'auto', 'operator'=>'and']]];
//            $match = ['fuzzy'=>["content"=> $keywords]];
//            $match = ['fuzzy'=>["content"=> $keywords]];
        }
        $query = [
            'bool' => [
                'filter' => $where
            ]
        ];
        if (!empty($match)) {
            $query['bool']['must'] = $match;
        }

        if ($where) {
            $results = ElasticSearchService::search($index, $query);
            $products = $results;
        } else {
            $products = [];
        }

        return $products;
    }

    /**|---------------------------------------------------------------------------------
     * 写入日志
     * @param string $model 模块名称
     * @param string $actionType 动作类型
     * @param string $order_number 单号
     * @param string $content 内容
     * @param string $ip ip地址
     * @param string $admin_acc 用户名
     * @return int
     * @author he <2019-04-02>
     * |---------------------------------------------------------------------------------
     */
    public static function createActionLog($model, $actionType, $order_number, $content, $ip, $admin_acc)
    {
        $index = static::getLogsIndex();
        $data['czrz_name'] = $admin_acc . "(新)";//登录者
        $data['czrz_ip'] = $ip;//操作ip
        $data['czrz_czsj'] = date("Y-m-d H:i:s");//创建时间
        $data['test_data'] = $model;//操作模块名称
        $data['czrz_czlx'] = $actionType;//动作类型
        $data['czrz_czxq'] = $content;//操作内容
        $data['czrz_number'] = $order_number;//操作单号

        $res = ActionLog::insert($data); //添加操作日志
        if ($res) {
            $data['id'] = $res->id;

            $result = ElasticSearchService::put($index, $data);
            if (!$result) {
                return false;
            }
            return 1;
        } else {
            return 2;
        }
    }

    public static function getMethods()
    {
        return ["add" => '添加', "edit" => '修改', "delete" => '删除[禁用]', "approve" => '开启'];
    }

    public static function insertLog($type, $order_number, $content, $model, $ip, $admin_acc)
    {

        $data['czrz_name'] = $admin_acc . "(新)";//登录者
        $data['czrz_ip'] = $ip;//操作ip
        $data['czrz_czsj'] = date("Y-m-d H:i:s");//创建时间
        $data['test_data'] = $model;//操作模块名称
        $data['czrz_czlx'] = $type;//创建类型
        $data['czrz_czxq'] = $content;//操作内容
        $data['czrz_number'] = $order_number;//操作单号

        $res = DB::table('czrz')->insert($data); //添加操作日志
        if ($res) {
            return 1;
        } else {
            return 2;
        }
    }

    /**|---------------------------------------------------------------------------------
     * 售后日志
     * @param $msg_id
     * @param $goods_name
     * @param $is_action
     * @param $admin_acc
     * @return int
     * |---------------------------------------------------------------------------------
     */
    public function aftersale_log($msg_id, $goods_name, $is_action, $admin_acc)
    {
        $data['msg_id'] = $msg_id;
        $data['goods_name'] = $goods_name;
        $data['create_name'] = $admin_acc;
        $data['is_action'] = $is_action;
        $result = DB::table('order_log')->insert($data);
        if ($result) {
            return 1;
        } else {
            return 2;
        }
    }


    /**|----------------------------------------------------------------
     * @name 添加备注
     * @param $sys_num 系统单号
     * @param $note_type 备注类型
     * @param $note_content 备注内容
     * @param $send_num 派工单号
     * @param $public_state 安装点是否可见 1：可见；2：不可见
     * @param $admin_groupnew
     * @param $admin_acc
     * @param $id
     * @return string
     * @author Frostmourne <2019-04-02>
     * |-----------------------------------------------------------------
     */
    public function acc_me($sys_num, $note_type, $note_content, $send_num, $public_state, $admin_groupnew, $admin_acc, $id)
    {
        if ('' != $send_num) {
            $note_content = $note_content . "(" . $send_num . ")";
        }
        if (2 == $admin_groupnew) { //设置服务中心添加的备注为可见
            $data['public_state'] = 2;
        } else {
            if ($public_state) {
                $data['public_state'] = $public_state;
            }
        }
        $data['orders_id'] = $sys_num;
        $data['note_name'] = $admin_acc;
        $data['note_content'] = $note_content;
        $data['note_time'] = date("Y-m-d H:i:s");
        $data['note_type'] = $note_type;
        $data['note_adid'] = $id;//添加人id
        $data['note_group'] = $admin_groupnew;//备注类型
        $rest = Note::insert($data);
        if (strpos($note_type, "售后") >= 0) {
            $after_num = OrderAfter::where('sys_num', $sys_num)
                ->select('p_id', 'order_num')
                ->first();
            $data['order_num'] = $after_num['order_num'];

        }
        if ($rest) {
            return 1;
        } else {
            return 2;
        }
    }

}
